/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.shared;

import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public final class TemplateCallFactory {
    private static final MethodType SLOWPATH_TYPE = MethodType.methodType(CompiledTemplate.class, String.class, RenderContext.class, SoyRecord.class, SoyRecord.class);
    private static final MethodType SLOWPATH_FACTORY_TYPE = MethodType.methodType(CompiledTemplate.Factory.class, String.class, RenderContext.class);
    private static final MethodType NORMAL_CONSTRUCTOR = MethodType.methodType(Void.TYPE, SoyRecord.class, SoyRecord.class);

    private TemplateCallFactory() {
    }

    public static CallSite bootstrapFactoryLookup(MethodHandles.Lookup lookup, String name, MethodType type, String templateName) {
        ClassLoader callerClassLoader = lookup.lookupClass().getClassLoader();
        String className = Names.javaClassNameFromSoyTemplateName(templateName);
        try {
            Class<?> factoryClass = callerClassLoader.loadClass(className + "$Factory");
            MethodHandle getter = lookup.findStaticGetter(factoryClass, "INSTANCE", factoryClass);
            getter = MethodHandles.dropArguments(getter, 0, new Class[]{RenderContext.class});
            getter = getter.asType(type);
            return new ConstantCallSite(getter);
        }
        catch (IllegalAccessException | NoSuchFieldException nsme) {
            throw new AssertionError((Object)nsme);
        }
        catch (ClassNotFoundException nsme) {
            try {
                MethodHandle handle = lookup.findStatic(TemplateCallFactory.class, "slowPathFactory", SLOWPATH_FACTORY_TYPE);
                handle = MethodHandles.insertArguments(handle, 0, templateName);
                return new ConstantCallSite(handle);
            }
            catch (ReflectiveOperationException roe) {
                throw new AssertionError("impossible, can't find out slowPathFactory method", roe);
            }
        }
    }

    public static CallSite bootstrapConstruction(MethodHandles.Lookup lookup, String name, MethodType type, String templateName) {
        ClassLoader callerClassLoader = lookup.lookupClass().getClassLoader();
        String className = Names.javaClassNameFromSoyTemplateName(templateName);
        try {
            Class<?> templateClass = callerClassLoader.loadClass(className);
            MethodHandle handle = lookup.findConstructor(templateClass, NORMAL_CONSTRUCTOR);
            handle = MethodHandles.dropArguments(handle, 0, new Class[]{RenderContext.class});
            handle = handle.asType(type);
            return new ConstantCallSite(handle);
        }
        catch (IllegalAccessException | NoSuchMethodException nsme) {
            throw new AssertionError((Object)nsme);
        }
        catch (ClassNotFoundException nsme) {
            try {
                MethodHandle handle = lookup.findStatic(TemplateCallFactory.class, "slowPath", SLOWPATH_TYPE);
                handle = MethodHandles.insertArguments(handle, 0, templateName);
                return new ConstantCallSite(handle);
            }
            catch (ReflectiveOperationException roe) {
                throw new AssertionError("impossible, can't find our slowPath method", roe);
            }
        }
    }

    public static CompiledTemplate.Factory slowPathFactory(String templateName, RenderContext context) {
        return context.getTemplateFactory(templateName);
    }

    public static CompiledTemplate slowPath(String templateName, RenderContext context, SoyRecord params, SoyRecord ijParams) {
        return context.getTemplateFactory(templateName).create(params, ijParams);
    }
}

