/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.shared;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.CompiledTemplates;
import com.google.template.soy.jbcsrc.shared.MissingPluginInstanceException;
import com.google.template.soy.logging.SoyLogger;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.shared.SoyIdRenamingMap;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.ibm.icu.util.ULocale;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class RenderContext {
    private static final CompiledTemplate EMPTY_TEMPLATE = new CompiledTemplate(){

        @Override
        public RenderResult render(LoggingAdvisingAppendable appendable, RenderContext context) {
            return RenderResult.done();
        }

        @Override
        public SanitizedContent.ContentKind kind() {
            return SanitizedContent.ContentKind.TEXT;
        }
    };
    private final Predicate<String> activeDelPackageSelector;
    private final CompiledTemplates templates;
    private final SoyCssRenamingMap cssRenamingMap;
    private final SoyIdRenamingMap xidRenamingMap;
    private final ImmutableMap<String, Supplier<Object>> pluginInstances;
    private final ImmutableMap<String, SoyJavaPrintDirective> soyJavaDirectivesMap;
    private final SoyMsgBundle msgBundle;
    private final boolean debugSoyTemplateInfo;
    private final SoyLogger logger;

    private RenderContext(Builder builder) {
        this.activeDelPackageSelector = (Predicate)Preconditions.checkNotNull((Object)builder.activeDelPackageSelector);
        this.templates = (CompiledTemplates)Preconditions.checkNotNull((Object)builder.templates);
        this.cssRenamingMap = builder.cssRenamingMap;
        this.xidRenamingMap = builder.xidRenamingMap;
        this.soyJavaDirectivesMap = builder.soyJavaDirectivesMap;
        this.pluginInstances = builder.pluginInstances;
        this.msgBundle = builder.msgBundle;
        this.debugSoyTemplateInfo = builder.debugSoyTemplateInfo;
        this.logger = builder.logger;
    }

    @Nullable
    public ULocale getLocale() {
        return this.msgBundle.getLocale();
    }

    public ImmutableList<String> getAllRequiredCssNamespaces(String template) {
        return this.templates.getAllRequiredCssNamespaces(template, this.activeDelPackageSelector, false);
    }

    public BidiGlobalDir getBidiGlobalDir() {
        return BidiGlobalDir.forStaticIsRtl(this.msgBundle.isRtl());
    }

    public String renameCssSelector(String selector) {
        String string = this.cssRenamingMap.get(selector);
        return string == null ? selector : string;
    }

    public String renameXid(String id) {
        String string = this.xidRenamingMap.get(id);
        return string == null ? id + "_" : string;
    }

    public Object getPluginInstance(String name) {
        Supplier instanceSupplier = (Supplier)this.pluginInstances.get((Object)name);
        if (instanceSupplier == null) {
            throw new MissingPluginInstanceException(name, String.format("No plugin instance registered for function with name '%s'.", name));
        }
        return instanceSupplier.get();
    }

    public SoyJavaPrintDirective getPrintDirective(String name) {
        SoyJavaPrintDirective printDirective = (SoyJavaPrintDirective)this.soyJavaDirectivesMap.get((Object)name);
        if (printDirective == null) {
            throw new IllegalStateException("Failed to find Soy print directive with name '" + name + "'");
        }
        return printDirective;
    }

    public Function<String, String> getEscapingDirectiveAsFunction(String name) {
        SoyJavaPrintDirective printDirective = (SoyJavaPrintDirective)this.soyJavaDirectivesMap.get((Object)name);
        if (printDirective == null) {
            throw new IllegalStateException("Failed to find Soy print directive with name '" + name + "'");
        }
        if (!printDirective.getValidArgsSizes().contains(0)) {
            throw new IllegalStateException("Soy print directive with name '" + name + "' is not an escaping directive");
        }
        return input -> printDirective.applyForJava(StringData.forValue(input), (List<SoyValue>)ImmutableList.of()).stringValue();
    }

    public boolean getDebugSoyTemplateInfo() {
        return this.debugSoyTemplateInfo;
    }

    public boolean hasLogger() {
        return this.logger != SoyLogger.NO_OP;
    }

    public SoyLogger getLogger() {
        return this.logger;
    }

    public CompiledTemplate.Factory getTemplateFactory(String calleeName) {
        return this.templates.getTemplateFactory(calleeName);
    }

    public CompiledTemplate getDelTemplate(String calleeName, String variant, boolean allowEmpty, SoyRecord params, SoyRecord ij) {
        CompiledTemplate.Factory callee = this.templates.selectDelTemplate(calleeName, variant, this.activeDelPackageSelector);
        if (callee == null) {
            if (allowEmpty) {
                return EMPTY_TEMPLATE;
            }
            throw new IllegalArgumentException("Found no active impl for delegate call to \"" + calleeName + (variant.isEmpty() ? "" : ":" + variant) + "\" (and delcall does not set allowemptydefault=\"true\").");
        }
        return callee.create(params, ij);
    }

    public boolean usePrimaryMsgIfFallback(long msgId, long fallbackId) {
        return !this.msgBundle.getMsgParts(msgId).isEmpty() || this.msgBundle.getMsgParts(fallbackId).isEmpty();
    }

    public boolean usePrimaryOrAlternateIfFallback(long msgId, long alternateId, long fallbackId) {
        return !this.msgBundle.getMsgParts(msgId).isEmpty() || !this.msgBundle.getMsgParts(alternateId).isEmpty() || this.msgBundle.getMsgParts(fallbackId).isEmpty();
    }

    public boolean usePrimaryIfFallbackOrFallbackAlternate(long msgId, long fallbackId, long fallbackAlternateId) {
        return !this.msgBundle.getMsgParts(msgId).isEmpty() || this.msgBundle.getMsgParts(fallbackId).isEmpty() && this.msgBundle.getMsgParts(fallbackAlternateId).isEmpty();
    }

    public boolean usePrimaryOrAlternateIfFallbackOrFallbackAlternate(long msgId, long alternateId, long fallbackId, long fallbackAlternateId) {
        return !this.msgBundle.getMsgParts(msgId).isEmpty() || !this.msgBundle.getMsgParts(alternateId).isEmpty() || this.msgBundle.getMsgParts(fallbackId).isEmpty() && this.msgBundle.getMsgParts(fallbackAlternateId).isEmpty();
    }

    public ImmutableList<SoyMsgPart> getSoyMsgParts(long msgId, ImmutableList<SoyMsgPart> defaultMsgParts) {
        ImmutableList<SoyMsgPart> msgParts = this.msgBundle.getMsgParts(msgId);
        if (msgParts.isEmpty()) {
            return defaultMsgParts;
        }
        return msgParts;
    }

    public ImmutableList<SoyMsgPart> getSoyMsgPartsWithAlternateId(long msgId, ImmutableList<SoyMsgPart> defaultMsgParts, long alternateId) {
        ImmutableList<SoyMsgPart> msgParts = this.msgBundle.getMsgParts(msgId);
        if (msgParts.isEmpty()) {
            ImmutableList<SoyMsgPart> msgPartsByAlternateId = this.msgBundle.getMsgParts(alternateId);
            if (msgPartsByAlternateId.isEmpty()) {
                return defaultMsgParts;
            }
            return msgPartsByAlternateId;
        }
        return msgParts;
    }

    @VisibleForTesting
    public Builder toBuilder() {
        return new Builder().withActiveDelPackageSelector(this.activeDelPackageSelector).withPluginInstances((Map<String, Supplier<Object>>)this.pluginInstances).withSoyPrintDirectives((Map<String, ? extends SoyJavaPrintDirective>)this.soyJavaDirectivesMap).withCssRenamingMap(this.cssRenamingMap).withXidRenamingMap(this.xidRenamingMap).withMessageBundle(this.msgBundle).withCompiledTemplates(this.templates);
    }

    public static final class Builder {
        private CompiledTemplates templates;
        private Predicate<String> activeDelPackageSelector = arg -> false;
        private SoyCssRenamingMap cssRenamingMap = SoyCssRenamingMap.EMPTY;
        private SoyIdRenamingMap xidRenamingMap = SoyCssRenamingMap.EMPTY;
        private ImmutableMap<String, SoyJavaPrintDirective> soyJavaDirectivesMap = ImmutableMap.of();
        private ImmutableMap<String, Supplier<Object>> pluginInstances = ImmutableMap.of();
        private SoyMsgBundle msgBundle = SoyMsgBundle.EMPTY;
        private boolean debugSoyTemplateInfo = false;
        private SoyLogger logger;

        public Builder withCompiledTemplates(CompiledTemplates templates) {
            this.templates = (CompiledTemplates)Preconditions.checkNotNull((Object)templates);
            return this;
        }

        public Builder withActiveDelPackageSelector(Predicate<String> activeDelPackageSelector) {
            this.activeDelPackageSelector = (Predicate)Preconditions.checkNotNull(activeDelPackageSelector);
            return this;
        }

        public Builder withCssRenamingMap(SoyCssRenamingMap cssRenamingMap) {
            this.cssRenamingMap = (SoyCssRenamingMap)Preconditions.checkNotNull((Object)cssRenamingMap);
            return this;
        }

        public Builder withXidRenamingMap(SoyIdRenamingMap xidRenamingMap) {
            this.xidRenamingMap = (SoyIdRenamingMap)Preconditions.checkNotNull((Object)xidRenamingMap);
            return this;
        }

        public Builder withPluginInstances(Map<String, Supplier<Object>> pluginInstances) {
            this.pluginInstances = ImmutableMap.copyOf(pluginInstances);
            return this;
        }

        public Builder withSoyPrintDirectives(Map<String, ? extends SoyJavaPrintDirective> directives) {
            this.soyJavaDirectivesMap = ImmutableMap.copyOf(directives);
            return this;
        }

        public Builder withMessageBundle(SoyMsgBundle msgBundle) {
            this.msgBundle = (SoyMsgBundle)Preconditions.checkNotNull((Object)msgBundle);
            return this;
        }

        public Builder withDebugSoyTemplateInfo(boolean debugSoyTemplateInfo) {
            this.debugSoyTemplateInfo = debugSoyTemplateInfo;
            return this;
        }

        public Builder withLogger(SoyLogger logger) {
            this.logger = logger;
            return this;
        }

        public RenderContext build() {
            return new RenderContext(this);
        }
    }
}

