/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.html.types.SafeHtml;
import com.google.common.html.types.SafeScript;
import com.google.common.html.types.SafeStyleSheet;
import com.google.common.html.types.SafeUrl;
import com.google.common.html.types.TrustedResourceUrl;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.jbcsrc.api.SoySauce;
import com.google.template.soy.jbcsrc.api.SoySauceBuilder;
import com.google.template.soy.jbcsrc.api.StubbingCompiledTemplates;
import java.util.function.Predicate;

public final class StubbingSoySauce {
    public static SoySauce create(SoySauceBuilder preconfiguredBuilder, ImmutablePredicate<String> stubMatcher, StubFactory stubFactory) {
        Preconditions.checkNotNull(stubMatcher);
        Preconditions.checkNotNull((Object)stubFactory);
        return preconfiguredBuilder.withCustomCompiledTemplatesFactory((delTemplateNames, loader) -> StubbingCompiledTemplates.create(stubMatcher, stubFactory, (ImmutableSet<String>)delTemplateNames, loader)).build();
    }

    private StubbingSoySauce() {
    }

    @Immutable
    public static interface TemplateStub<T> {
        public T render(ImmutableMap<String, SoyValueProvider> var1);
    }

    @Immutable
    public static interface StubFactory {
        public TemplateStub<SafeHtml> createHtmlTemplate(String var1);

        public TemplateStub<SafeScript> createJsTemplate(String var1);

        public TemplateStub<SafeUrl> createUriTemplate(String var1);

        public TemplateStub<TrustedResourceUrl> createTrustedResourceUriTemplate(String var1);

        public TemplateStub<SanitizedContent> createAttributesTemplate(String var1);

        public TemplateStub<SafeStyleSheet> createCssTemplate(String var1);

        public TemplateStub<String> createTextTemplate(String var1);
    }

    @Immutable
    public static interface ImmutablePredicate<T>
    extends Predicate<T> {
    }
}

