/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.html.types.SafeHtml;
import com.google.common.html.types.SafeScript;
import com.google.common.html.types.SafeStyleSheet;
import com.google.common.html.types.SafeUrl;
import com.google.common.html.types.TrustedResourceUrl;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.api.StubbingSoySauce;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.CompiledTemplates;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.function.Function;

final class StubbingCompiledTemplates
extends CompiledTemplates {
    private final StubbingSoySauce.ImmutablePredicate<String> stubMatcher;
    private final StubbingSoySauce.StubFactory stubFactory;
    private final CompiledTemplates nonStubbingCompiledTemplates;

    static StubbingCompiledTemplates create(StubbingSoySauce.ImmutablePredicate<String> stubMatcher, StubbingSoySauce.StubFactory stubFactory, ImmutableSet<String> delTemplateNames, ClassLoader loader) {
        CompiledTemplates nonStubbingCompiledTemplates = new CompiledTemplates(delTemplateNames, loader);
        StubbingClassLoader stubbingClassLoader = new StubbingClassLoader(loader, stubMatcher, nonStubbingCompiledTemplates);
        return new StubbingCompiledTemplates(stubMatcher, stubFactory, delTemplateNames, stubbingClassLoader, nonStubbingCompiledTemplates);
    }

    private StubbingCompiledTemplates(StubbingSoySauce.ImmutablePredicate<String> stubMatcher, StubbingSoySauce.StubFactory stubFactory, ImmutableSet<String> delTemplateNames, ClassLoader stubbingClassLoader, CompiledTemplates nonStubbingCompiledTemplates) {
        super(delTemplateNames, stubbingClassLoader);
        this.stubMatcher = stubMatcher;
        this.stubFactory = stubFactory;
        this.nonStubbingCompiledTemplates = nonStubbingCompiledTemplates;
    }

    @Override
    public SanitizedContent.ContentKind getTemplateContentKind(String name) {
        return this.nonStubbingCompiledTemplates.getTemplateContentKind(name);
    }

    @Override
    public CompiledTemplate.Factory getTemplateFactory(String name) {
        SanitizedContent.ContentKind contentKind = this.getTemplateContentKind(name);
        if (!this.stubMatcher.test(name)) {
            return super.getTemplateFactory(name);
        }
        switch (contentKind) {
            case HTML: {
                return new Factory(contentKind, this.stubFactory.createHtmlTemplate(name), SafeHtml::getSafeHtmlString);
            }
            case JS: {
                return new Factory(contentKind, this.stubFactory.createJsTemplate(name), SafeScript::getSafeScriptString);
            }
            case URI: {
                return new Factory(contentKind, this.stubFactory.createUriTemplate(name), SafeUrl::getSafeUrlString);
            }
            case TRUSTED_RESOURCE_URI: {
                return new Factory(contentKind, this.stubFactory.createTrustedResourceUriTemplate(name), TrustedResourceUrl::getTrustedResourceUrlString);
            }
            case ATTRIBUTES: {
                return new Factory(contentKind, this.stubFactory.createAttributesTemplate(name), sanitizedContent -> {
                    Preconditions.checkState((sanitizedContent.getContentKind() == SanitizedContent.ContentKind.ATTRIBUTES ? 1 : 0) != 0, (Object)"The sanitized content returned from createAttributesTemplate() must have contentKind == ATTRIBUTES");
                    return sanitizedContent.toString();
                });
            }
            case CSS: {
                return new Factory(contentKind, this.stubFactory.createCssTemplate(name), SafeStyleSheet::getSafeStyleSheetString);
            }
            case TEXT: {
                return new Factory(contentKind, this.stubFactory.createTextTemplate(name), text -> text);
            }
        }
        throw new AssertionError((Object)("Unhandled content kind: " + (Object)((Object)contentKind)));
    }

    @Override
    protected CompiledTemplates.TemplateData getTemplateData(String name) {
        if (this.stubMatcher.test(name)) {
            return null;
        }
        return super.getTemplateData(name);
    }

    private static class StubbingClassLoader
    extends URLClassLoader {
        private final StubbingSoySauce.ImmutablePredicate<String> stubMatcher;
        private final CompiledTemplates nonStubbingCompiledTemplates;

        private StubbingClassLoader(ClassLoader backing, StubbingSoySauce.ImmutablePredicate<String> stubMatcher, CompiledTemplates nonStubbingCompiledTemplates) {
            super(StubbingClassLoader.getClassPathUrls(), backing);
            this.stubMatcher = stubMatcher;
            this.nonStubbingCompiledTemplates = nonStubbingCompiledTemplates;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (name.startsWith("com.google.template.soy.jbcsrc.gen.")) {
                String soyTemplateName = Names.soyTemplateNameFromJavaClassName(name);
                if (soyTemplateName.indexOf(36) != -1) {
                    soyTemplateName = soyTemplateName.substring(0, soyTemplateName.indexOf(36));
                }
                boolean isPrivateTemplate = false;
                try {
                    this.nonStubbingCompiledTemplates.getTemplateFactory(soyTemplateName);
                }
                catch (IllegalArgumentException thrownForPrivateTemplates) {
                    isPrivateTemplate = true;
                }
                if (!isPrivateTemplate && this.stubMatcher.test(soyTemplateName)) {
                    throw new ClassNotFoundException("Forcing invokedynamic to select the slowpath.");
                }
                Class<?> c = this.findLoadedClass(name);
                if (c == null) {
                    return super.findClass(name);
                }
                return c;
            }
            return super.loadClass(name);
        }

        private static URL[] parseJavaClassPath() {
            ImmutableList.Builder urls = ImmutableList.builder();
            for (String entry : Splitter.on((String)StandardSystemProperty.PATH_SEPARATOR.value()).split((CharSequence)StandardSystemProperty.JAVA_CLASS_PATH.value())) {
                try {
                    try {
                        urls.add((Object)new File(entry).toURI().toURL());
                    }
                    catch (SecurityException e) {
                        urls.add((Object)new URL("file", null, new File(entry).getAbsolutePath()));
                    }
                }
                catch (MalformedURLException e) {
                    throw new AssertionError("malformed class path entry: " + entry, e);
                }
            }
            return (URL[])urls.build().toArray((Object[])new URL[0]);
        }

        private static URL[] getClassPathUrls() {
            return StubbingClassLoader.class.getClassLoader() instanceof URLClassLoader ? ((URLClassLoader)StubbingClassLoader.class.getClassLoader()).getURLs() : StubbingClassLoader.parseJavaClassPath();
        }
    }

    private static class Factory<T>
    extends CompiledTemplate.Factory {
        private final SanitizedContent.ContentKind contentKind;
        private final StubbingSoySauce.TemplateStub<T> stub;
        private final ImmutableFunction<T, String> toStringFunction;

        private Factory(SanitizedContent.ContentKind contentKind, StubbingSoySauce.TemplateStub<T> stub, ImmutableFunction<T, String> toStringFunction) {
            this.contentKind = contentKind;
            this.stub = (StubbingSoySauce.TemplateStub)Preconditions.checkNotNull(stub);
            this.toStringFunction = toStringFunction;
        }

        @Override
        public CompiledTemplate create(final SoyRecord params, SoyRecord ij) {
            return new CompiledTemplate(){

                @Override
                public RenderResult render(LoggingAdvisingAppendable appendable, RenderContext context) throws IOException {
                    appendable.append((CharSequence)toStringFunction.apply(Preconditions.checkNotNull(stub.render(params.recordAsMap()))));
                    return RenderResult.done();
                }

                @Override
                public SanitizedContent.ContentKind kind() {
                    return contentKind;
                }
            };
        }
    }

    @Immutable
    private static interface ImmutableFunction<T, R>
    extends Function<T, R> {
    }
}

