/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.api;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyTemplate;
import com.google.template.soy.data.SoyTemplateData;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.BasicParamStore;
import com.google.template.soy.data.internal.ParamStore;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.jbcsrc.api.AdvisingAppendable;
import com.google.template.soy.jbcsrc.api.Continuations;
import com.google.template.soy.jbcsrc.api.OutputAppendable;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.api.SoySauce;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.CompiledTemplates;
import com.google.template.soy.jbcsrc.shared.LegacyFunctionAdapter;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import com.google.template.soy.logging.SoyLogger;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.shared.SoyIdRenamingMap;
import com.google.template.soy.shared.internal.SoyScopedData;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import java.io.IOException;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class SoySauceImpl
implements SoySauce {
    private final CompiledTemplates templates;
    private final SoyScopedData.Enterable apiCallScope;
    private final ImmutableMap<String, Supplier<Object>> pluginInstances;
    private final ImmutableMap<String, SoyJavaPrintDirective> printDirectives;

    public SoySauceImpl(CompiledTemplates templates, SoyScopedData.Enterable apiCallScope, ImmutableList<? extends SoyFunction> functions, ImmutableList<? extends SoyPrintDirective> printDirectives, ImmutableMap<String, Supplier<Object>> pluginInstances) {
        this.templates = (CompiledTemplates)Preconditions.checkNotNull((Object)templates);
        this.apiCallScope = (SoyScopedData.Enterable)Preconditions.checkNotNull((Object)apiCallScope);
        ImmutableMap.Builder pluginInstanceBuilder = ImmutableMap.builder();
        pluginInstanceBuilder.putAll(pluginInstances);
        for (SoyFunction fn : functions) {
            if (!(fn instanceof SoyJavaFunction)) continue;
            pluginInstanceBuilder.put((Object)fn.getName(), (Object)Suppliers.ofInstance((Object)new LegacyFunctionAdapter((SoyJavaFunction)fn)));
        }
        ImmutableMap.Builder soyJavaPrintDirectives = ImmutableMap.builder();
        for (SoyPrintDirective printDirective : printDirectives) {
            if (!(printDirective instanceof SoyJavaPrintDirective)) continue;
            soyJavaPrintDirectives.put((Object)printDirective.getName(), (Object)((SoyJavaPrintDirective)printDirective));
        }
        this.printDirectives = soyJavaPrintDirectives.build();
        this.pluginInstances = pluginInstanceBuilder.build();
    }

    public ImmutableSortedSet<String> getTransitiveIjParamsForTemplate(String templateName) {
        return this.templates.getTransitiveIjParamsForTemplate(templateName);
    }

    @Override
    public ImmutableList<String> getAllRequiredCssNamespaces(String templateName, Predicate<String> enabledDelpackages, boolean collectCssFromDelvariants) {
        return this.templates.getAllRequiredCssNamespaces(templateName, enabledDelpackages, collectCssFromDelvariants);
    }

    @Override
    public Boolean hasTemplate(String template) {
        try {
            this.templates.getTemplateFactory(template);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    @Override
    public RendererImpl renderTemplate(String template) {
        CompiledTemplate.Factory factory = this.templates.getTemplateFactory(template);
        return new RendererImpl(template, factory, this.templates.getTemplateContentKind(template), null);
    }

    @Override
    public RendererImpl newRenderer(SoyTemplate params) {
        String template = params.getTemplateName();
        CompiledTemplate.Factory factory = this.templates.getTemplateFactory(template);
        return new RendererImpl(template, factory, this.templates.getTemplateContentKind(template), params.getParamsAsMap());
    }

    private static SoySauce.WriteContinuation doRender(CompiledTemplate template, Scoper scoper, LoggingAdvisingAppendable out, RenderContext context) throws IOException {
        RenderResult result;
        try (SoyScopedData.InScope scope = scoper.enter();){
            result = template.render(out, context);
        }
        catch (Throwable t) {
            Names.rewriteStackTrace(t);
            Throwables.throwIfInstanceOf((Throwable)t, IOException.class);
            throw t;
        }
        if (result.isDone()) {
            return Continuations.done();
        }
        return new WriteContinuationImpl(result, scoper, context, out, template);
    }

    static /* synthetic */ ImmutableMap access$100(SoySauceImpl x0) {
        return x0.printDirectives;
    }

    static /* synthetic */ CompiledTemplates access$200(SoySauceImpl x0) {
        return x0.templates;
    }

    private static final class Scoper {
        final SoyScopedData.Enterable scope;
        final BidiGlobalDir dir;

        Scoper(SoyScopedData.Enterable scope, BidiGlobalDir dir) {
            this.scope = scope;
            this.dir = dir;
        }

        SoyScopedData.InScope enter() {
            return this.scope.enter(this.dir);
        }
    }

    private static final class WriteContinuationImpl
    implements SoySauce.WriteContinuation {
        final RenderResult result;
        final Object lock = new Object();
        @GuardedBy(value="lock")
        final Scoper scoper;
        @GuardedBy(value="lock")
        final RenderContext context;
        @GuardedBy(value="lock")
        final LoggingAdvisingAppendable out;
        @GuardedBy(value="lock")
        final CompiledTemplate template;
        @GuardedBy(value="lock")
        boolean hasContinueBeenCalled;

        WriteContinuationImpl(RenderResult result, Scoper scoper, RenderContext context, LoggingAdvisingAppendable out, CompiledTemplate template) {
            Preconditions.checkArgument((!result.isDone() ? 1 : 0) != 0);
            this.result = (RenderResult)Preconditions.checkNotNull((Object)result);
            this.scoper = (Scoper)Preconditions.checkNotNull((Object)scoper);
            this.context = (RenderContext)Preconditions.checkNotNull((Object)context);
            this.out = (LoggingAdvisingAppendable)Preconditions.checkNotNull((Object)out);
            this.template = (CompiledTemplate)Preconditions.checkNotNull((Object)template);
        }

        @Override
        public RenderResult result() {
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SoySauce.WriteContinuation continueRender() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                if (this.hasContinueBeenCalled) {
                    throw new IllegalStateException("continueRender() has already been called.");
                }
                this.hasContinueBeenCalled = true;
                return SoySauceImpl.doRender(this.template, this.scoper, this.out, this.context);
            }
        }
    }

    final class RendererImpl
    implements SoySauce.Renderer {
        private final String templateName;
        private final CompiledTemplate.Factory templateFactory;
        private final SanitizedContent.ContentKind contentKind;
        private Predicate<String> activeDelegatePackages = arg -> false;
        private SoyMsgBundle msgs = SoyMsgBundle.EMPTY;
        private SoyLogger logger = SoyLogger.NO_OP;
        private final RenderContext.Builder contextBuilder = new RenderContext.Builder().withCompiledTemplates(SoySauceImpl.access$200(SoySauceImpl.this)).withSoyPrintDirectives((Map<String, ? extends SoyJavaPrintDirective>)SoySauceImpl.access$100(SoySauceImpl.this)).withPluginInstances((Map<String, Supplier<Object>>)SoySauceImpl.access$000(SoySauceImpl.this));
        private SoyRecord data = ParamStore.EMPTY_INSTANCE;
        private SoyRecord ij = ParamStore.EMPTY_INSTANCE;
        private Map<String, Supplier<Object>> perRenderPluginInstances = null;
        private boolean dataSetInConstructor;

        RendererImpl(String templateName, CompiledTemplate.Factory templateFactory, @Nullable SanitizedContent.ContentKind contentKind, Map<String, ?> data) {
            this.templateName = templateName;
            this.templateFactory = (CompiledTemplate.Factory)Preconditions.checkNotNull((Object)templateFactory);
            this.contentKind = contentKind;
            if (data != null) {
                this.data = this.soyValueProviderMapAsParamStore(data);
                this.dataSetInConstructor = true;
            }
        }

        private BasicParamStore soyValueProviderMapAsParamStore(Map<String, ?> source) {
            BasicParamStore dest = new BasicParamStore(source.size());
            for (Map.Entry<String, ?> entry : source.entrySet()) {
                dest.setField(entry.getKey(), (SoyValueProvider)entry.getValue());
            }
            return dest;
        }

        private BasicParamStore mapAsParamStore(Map<String, ?> source) {
            BasicParamStore dest = new BasicParamStore(source.size());
            for (Map.Entry<String, ?> entry : source.entrySet()) {
                SoyValueProvider value;
                String key = entry.getKey();
                try {
                    value = SoyValueConverter.INSTANCE.convert(entry.getValue());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unable to convert param " + key + " to a SoyValue", e);
                }
                dest.setField(key, value);
            }
            return dest;
        }

        @Override
        public RendererImpl setIj(Map<String, ?> record) {
            this.ij = this.mapAsParamStore(record);
            return this;
        }

        @Override
        public RendererImpl setIj(SoyTemplateData templateData) {
            this.ij = this.soyValueProviderMapAsParamStore(templateData.getParamsAsMap());
            return this;
        }

        @Override
        public RendererImpl setPluginInstances(Map<String, Supplier<Object>> pluginInstances) {
            this.perRenderPluginInstances = (Map)Preconditions.checkNotNull(pluginInstances);
            return this;
        }

        @Override
        public RendererImpl setData(Map<String, ?> record) {
            Preconditions.checkState((!this.dataSetInConstructor ? 1 : 0) != 0, (Object)"May not call setData on a Renderer createdd from a TemplateParams");
            this.data = this.mapAsParamStore(record);
            return this;
        }

        @Override
        public RendererImpl setActiveDelegatePackageSelector(Predicate<String> active) {
            this.activeDelegatePackages = (Predicate)Preconditions.checkNotNull(active);
            return this;
        }

        @Override
        public RendererImpl setCssRenamingMap(SoyCssRenamingMap cssRenamingMap) {
            this.contextBuilder.withCssRenamingMap(cssRenamingMap);
            return this;
        }

        @Override
        public RendererImpl setXidRenamingMap(SoyIdRenamingMap xidRenamingMap) {
            this.contextBuilder.withXidRenamingMap(xidRenamingMap);
            return this;
        }

        @Override
        public RendererImpl setMsgBundle(SoyMsgBundle msgs) {
            this.msgs = (SoyMsgBundle)Preconditions.checkNotNull((Object)msgs);
            return this;
        }

        @Override
        public RendererImpl setDebugSoyTemplateInfo(boolean debugSoyTemplateInfo) {
            this.contextBuilder.withDebugSoyTemplateInfo(debugSoyTemplateInfo);
            return this;
        }

        @Override
        public RendererImpl setSoyLogger(SoyLogger logger) {
            this.logger = (SoyLogger)Preconditions.checkNotNull((Object)logger);
            return this;
        }

        @Override
        public SoySauce.WriteContinuation renderHtml(AdvisingAppendable out) throws IOException {
            this.enforceContentKind(SanitizedContent.ContentKind.HTML);
            return this.startRender(OutputAppendable.create(out, this.logger));
        }

        @Override
        public SoySauce.Continuation<SanitizedContent> renderHtml() {
            return this.renderSanitizedContent(SanitizedContent.ContentKind.HTML);
        }

        @Override
        public SoySauce.WriteContinuation renderJs(AdvisingAppendable out) throws IOException {
            this.enforceContentKind(SanitizedContent.ContentKind.JS);
            return this.startRender(OutputAppendable.create(out, this.logger));
        }

        @Override
        public SoySauce.Continuation<SanitizedContent> renderJs() {
            return this.renderSanitizedContent(SanitizedContent.ContentKind.JS);
        }

        @Override
        public SoySauce.WriteContinuation renderUri(AdvisingAppendable out) throws IOException {
            this.enforceContentKind(SanitizedContent.ContentKind.URI);
            return this.startRender(OutputAppendable.create(out, this.logger));
        }

        @Override
        public SoySauce.Continuation<SanitizedContent> renderUri() {
            return this.renderSanitizedContent(SanitizedContent.ContentKind.URI);
        }

        @Override
        public SoySauce.WriteContinuation renderTrustedResourceUri(AdvisingAppendable out) throws IOException {
            this.enforceContentKind(SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI);
            return this.startRender(OutputAppendable.create(out, this.logger));
        }

        @Override
        public SoySauce.Continuation<SanitizedContent> renderTrustedResourceUri() {
            return this.renderSanitizedContent(SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI);
        }

        @Override
        public SoySauce.WriteContinuation renderAttributes(AdvisingAppendable out) throws IOException {
            this.enforceContentKind(SanitizedContent.ContentKind.ATTRIBUTES);
            return this.startRender(OutputAppendable.create(out, this.logger));
        }

        @Override
        public SoySauce.Continuation<SanitizedContent> renderAttributes() {
            return this.renderSanitizedContent(SanitizedContent.ContentKind.ATTRIBUTES);
        }

        @Override
        public SoySauce.WriteContinuation renderCss(AdvisingAppendable out) throws IOException {
            this.enforceContentKind(SanitizedContent.ContentKind.CSS);
            return this.startRender(OutputAppendable.create(out, this.logger));
        }

        @Override
        public SoySauce.Continuation<SanitizedContent> renderCss() {
            return this.renderSanitizedContent(SanitizedContent.ContentKind.CSS);
        }

        @Override
        public SoySauce.WriteContinuation renderText(AdvisingAppendable out) throws IOException {
            return this.startRender(OutputAppendable.create(out, this.logger));
        }

        @Override
        public SoySauce.Continuation<String> renderText() {
            StringBuilder sb = new StringBuilder();
            OutputAppendable buf = OutputAppendable.create(sb, this.logger);
            try {
                return Continuations.stringContinuation(this.startRender(buf), sb);
            }
            catch (IOException e) {
                throw new AssertionError("impossible", e);
            }
        }

        private SoySauce.Continuation<SanitizedContent> renderSanitizedContent(SanitizedContent.ContentKind contentKind) {
            this.enforceContentKind(contentKind);
            StringBuilder sb = new StringBuilder();
            OutputAppendable buf = OutputAppendable.create(sb, this.logger);
            try {
                return Continuations.strictContinuation(this.startRender(buf), sb, contentKind);
            }
            catch (IOException e) {
                throw new AssertionError("impossible", e);
            }
        }

        private <T> SoySauce.WriteContinuation startRender(OutputAppendable out) throws IOException {
            if (this.perRenderPluginInstances != null) {
                this.contextBuilder.withPluginInstances((Map<String, Supplier<Object>>)ImmutableMap.builder().putAll((Map)SoySauceImpl.this.pluginInstances).putAll(this.perRenderPluginInstances).build());
            }
            RenderContext context = this.contextBuilder.withMessageBundle(this.msgs).withActiveDelPackageSelector(this.activeDelegatePackages).withLogger(this.logger).build();
            Scoper scoper = new Scoper(SoySauceImpl.this.apiCallScope, BidiGlobalDir.forStaticIsRtl(this.msgs.isRtl()));
            CompiledTemplate template = this.templateFactory.create(this.data, this.ij);
            return SoySauceImpl.doRender(template, scoper, out, context);
        }

        private void enforceContentKind(SanitizedContent.ContentKind expectedContentKind) {
            if (expectedContentKind == SanitizedContent.ContentKind.TEXT) {
                return;
            }
            if (expectedContentKind != this.contentKind) {
                throw new IllegalStateException("Expected template '" + this.templateName + "' to be kind=\"" + Ascii.toLowerCase((String)expectedContentKind.name()) + "\" but was kind=\"" + Ascii.toLowerCase((String)this.contentKind.name()) + "\"");
            }
        }
    }
}

