/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.api;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.jbcsrc.api.SoySauce;
import com.google.template.soy.jbcsrc.api.SoySauceImpl;
import com.google.template.soy.jbcsrc.shared.CompiledTemplates;
import com.google.template.soy.shared.internal.InternalPlugins;
import com.google.template.soy.shared.internal.SoySimpleScope;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;

public final class SoySauceBuilder {
    private ImmutableList<SoyFunction> userFunctions = ImmutableList.of();
    private ImmutableList<SoyPrintDirective> userDirectives = ImmutableList.of();
    private ImmutableMap<String, Supplier<Object>> userPluginInstances = ImmutableMap.of();
    private CompiledTemplates.Factory compiledTemplatesFactory = CompiledTemplates::new;
    private ClassLoader loader;

    public SoySauceBuilder withPluginInstances(Map<String, Supplier<Object>> pluginInstances) {
        this.userPluginInstances = ImmutableMap.copyOf(pluginInstances);
        return this;
    }

    public SoySauceBuilder withClassLoader(ClassLoader loader) {
        this.loader = loader;
        return this;
    }

    SoySauceBuilder withFunctions(Iterable<? extends SoyFunction> userFunctions) {
        this.userFunctions = InternalPlugins.filterDuplicateFunctions(userFunctions);
        return this;
    }

    SoySauceBuilder withDirectives(Iterable<? extends SoyPrintDirective> userDirectives) {
        this.userDirectives = InternalPlugins.filterDuplicateDirectives(userDirectives);
        return this;
    }

    SoySauceBuilder withCustomCompiledTemplatesFactory(CompiledTemplates.Factory compiledTemplatesFactory) {
        this.compiledTemplatesFactory = compiledTemplatesFactory;
        return this;
    }

    public SoySauce build() {
        SoySimpleScope scopedData = new SoySimpleScope();
        if (this.loader == null) {
            this.loader = SoySauceBuilder.class.getClassLoader();
        }
        return new SoySauceImpl(this.compiledTemplatesFactory.create(SoySauceBuilder.readDelTemplatesFromMetaInf(this.loader), this.loader), scopedData.enterable(), this.userFunctions, (ImmutableList<? extends SoyPrintDirective>)ImmutableList.builder().addAll(InternalPlugins.internalDirectives(scopedData)).addAll(this.userDirectives).build(), this.userPluginInstances);
    }

    private static ImmutableSet<String> readDelTemplatesFromMetaInf(ClassLoader loader) {
        try {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            Enumeration<URL> resources = loader.getResources("META-INF/services/com.google.template.soy.deltemplates");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream in = url.openStream();
                Throwable throwable = null;
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                    String line = reader.readLine();
                    while (line != null) {
                        builder.add((Object)line);
                        line = reader.readLine();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            return builder.build();
        }
        catch (IOException iox) {
            throw new RuntimeException("Unable to read deltemplate listing", iox);
        }
    }
}

