/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.jbcsrc.CompiledTemplateMetadata;
import com.google.template.soy.jbcsrc.internal.InnerClasses;
import com.google.template.soy.jbcsrc.internal.SoyClassWriter;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.ConstructorRef;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.Flags;
import com.google.template.soy.jbcsrc.restricted.LocalVariable;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import java.util.ArrayList;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

final class TemplateFactoryCompiler {
    private static final TypeInfo FACTORY_TYPE = TypeInfo.create(CompiledTemplate.Factory.class);
    private static final Method FACTORY_CONSTRUCTOR = new Method("<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]));
    private static final Method CREATE_METHOD;
    private final CompiledTemplateMetadata template;
    private final TemplateNode templateNode;
    private final InnerClasses innerClasses;
    private final Visibility visibility;

    TemplateFactoryCompiler(CompiledTemplateMetadata currentClass, TemplateNode templateNode, InnerClasses innerClasses, Visibility visibility) {
        this.template = currentClass;
        this.templateNode = templateNode;
        this.innerClasses = innerClasses;
        this.visibility = visibility;
    }

    void compile() {
        int factoryAccess = (this.visibility == Visibility.PRIVATE ? 0 : 1) | 0x10;
        TypeInfo factoryType = this.innerClasses.registerInnerClass("Factory", factoryAccess);
        SoyClassWriter cw = SoyClassWriter.builder(factoryType).extending(FACTORY_TYPE).setAccess(factoryAccess).sourceFileName(this.templateNode.getSourceLocation().getFileName()).build();
        this.innerClasses.registerAsInnerClass(cw, factoryType);
        FieldRef instanceField = FieldRef.create(factoryType, "INSTANCE", factoryType.type(), factoryAccess | 8);
        instanceField.defineField(cw);
        this.generateStaticInitializer(cw, factoryType, instanceField);
        this.defineFactoryConstructor(cw, factoryType);
        this.generateCreateMethod(cw, factoryType);
        cw.visitEnd();
        this.innerClasses.add(cw.toClassData());
    }

    private void generateStaticInitializer(ClassVisitor cv, TypeInfo factoryType, FieldRef instanceField) {
        ArrayList<Statement> initStatements = new ArrayList<Statement>();
        initStatements.add(instanceField.putStaticField(ConstructorRef.create(factoryType, FACTORY_CONSTRUCTOR).construct(new Expression[0])));
        initStatements.add(Statement.RETURN);
        if (Flags.DEBUG) {
            initStatements.add(new Statement(){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    adapter.pushType(TemplateFactoryCompiler.this.template.typeInfo().type());
                    adapter.visitVarInsn(58, 0);
                    adapter.returnValue();
                }
            });
        }
        Statement.concat(initStatements).writeMethod(8, BytecodeUtils.CLASS_INIT, cv);
    }

    private void defineFactoryConstructor(ClassVisitor cv, TypeInfo factoryType) {
        CodeBuilder mg = new CodeBuilder(2, BytecodeUtils.NULLARY_INIT, null, cv);
        mg.visitCode();
        Label start = mg.mark();
        Label end = mg.newLabel();
        LocalVariable thisVar = LocalVariable.createThisVar(factoryType, start, end);
        thisVar.gen(mg);
        mg.invokeConstructor(FACTORY_TYPE.type(), BytecodeUtils.NULLARY_INIT);
        mg.returnValue();
        mg.mark(end);
        thisVar.tableEntry(mg);
        mg.endMethod();
    }

    private void generateCreateMethod(ClassVisitor cv, TypeInfo factoryType) {
        final Label start = new Label();
        final Label end = new Label();
        final LocalVariable thisVar = LocalVariable.createThisVar(factoryType, start, end);
        final LocalVariable paramsVar = LocalVariable.createLocal("params", 1, BytecodeUtils.SOY_RECORD_TYPE, start, end);
        final LocalVariable ijVar = LocalVariable.createLocal("ij", 2, BytecodeUtils.SOY_RECORD_TYPE, start, end);
        final Statement returnTemplate = Statement.returnExpression(this.template.constructor().construct(paramsVar, ijVar));
        new Statement(){

            @Override
            protected void doGen(CodeBuilder ga) {
                ga.mark(start);
                returnTemplate.gen(ga);
                ga.mark(end);
                thisVar.tableEntry(ga);
                paramsVar.tableEntry(ga);
                ijVar.tableEntry(ga);
            }
        }.writeMethod(1, CREATE_METHOD, cv);
    }

    static {
        try {
            CREATE_METHOD = Method.getMethod((java.lang.reflect.Method)CompiledTemplate.Factory.class.getDeclaredMethod("create", SoyRecord.class, SoyRecord.class));
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new AssertionError((Object)e);
        }
    }
}

