/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcPrintDirective;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.types.UnknownType;
import java.util.List;

final class RenderContextExpression
extends Expression
implements JbcSrcPluginContext {
    private static final MethodRef GET_DELTEMPLATE = MethodRef.create(RenderContext.class, "getDelTemplate", String.class, String.class, Boolean.TYPE, SoyRecord.class, SoyRecord.class);
    private static final MethodRef GET_PLUGIN_INSTANCE = MethodRef.create(RenderContext.class, "getPluginInstance", String.class);
    private static final MethodRef GET_LOCALE = MethodRef.create(RenderContext.class, "getLocale", new Class[0]);
    private static final MethodRef GET_PRINT_DIRECTIVE = MethodRef.create(RenderContext.class, "getPrintDirective", String.class);
    private static final MethodRef GET_SOY_MSG_PARTS = MethodRef.create(RenderContext.class, "getSoyMsgParts", Long.TYPE, ImmutableList.class);
    private static final MethodRef GET_SOY_MSG_PARTS_WITH_ALTERNATE_ID = MethodRef.create(RenderContext.class, "getSoyMsgPartsWithAlternateId", Long.TYPE, ImmutableList.class, Long.TYPE);
    private static final MethodRef RENAME_CSS_SELECTOR = MethodRef.create(RenderContext.class, "renameCssSelector", String.class).asNonNullable();
    private static final MethodRef RENAME_XID = MethodRef.create(RenderContext.class, "renameXid", String.class).asNonNullable();
    private static final MethodRef USE_PRIMARY_MSG_IF_FALLBACK = MethodRef.create(RenderContext.class, "usePrimaryMsgIfFallback", Long.TYPE, Long.TYPE);
    private static final MethodRef USE_PRIMARY_OR_ALTERNATE_IF_FALLBACK = MethodRef.create(RenderContext.class, "usePrimaryOrAlternateIfFallback", Long.TYPE, Long.TYPE, Long.TYPE);
    private static final MethodRef USE_PRIMARY_IF_FALLBACK_OR_FALLBACK_ALTERNATE = MethodRef.create(RenderContext.class, "usePrimaryIfFallbackOrFallbackAlternate", Long.TYPE, Long.TYPE, Long.TYPE);
    private static final MethodRef USE_PRIMARY_OR_ALTERNATE_IF_FALLBACK_OR_FALLBACK_ALTERNATE = MethodRef.create(RenderContext.class, "usePrimaryOrAlternateIfFallbackOrFallbackAlternate", Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE);
    private static final MethodRef GET_DEBUG_SOY_TEMPLATE_INFO = MethodRef.create(RenderContext.class, "getDebugSoyTemplateInfo", new Class[0]);
    private static final MethodRef GET_BIDI_GLOBAL_DIR = MethodRef.create(RenderContext.class, "getBidiGlobalDir", new Class[0]);
    private static final MethodRef GET_ALL_REQUIRED_CSS_NAMESPACES = MethodRef.create(RenderContext.class, "getAllRequiredCssNamespaces", String.class);
    private static final MethodRef GET_ESCAPING_DIRECTIVE_AS_FUNCTION = MethodRef.create(RenderContext.class, "getEscapingDirectiveAsFunction", String.class);
    private static final MethodRef HAS_LOGGER = MethodRef.create(RenderContext.class, "hasLogger", new Class[0]).asCheap();
    private static final MethodRef GET_LOGGER = MethodRef.create(RenderContext.class, "getLogger", new Class[0]);
    private final Expression delegate;

    RenderContextExpression(Expression renderContext) {
        super(renderContext.resultType(), renderContext.features());
        this.delegate = renderContext;
    }

    @Override
    protected void doGen(CodeBuilder adapter) {
        this.delegate.gen(adapter);
    }

    @Override
    public Expression getBidiGlobalDir() {
        return this.delegate.invoke(GET_BIDI_GLOBAL_DIR, new Expression[0]);
    }

    @Override
    public Expression getAllRequiredCssNamespaces(SoyExpression template) {
        return this.delegate.invoke(GET_ALL_REQUIRED_CSS_NAMESPACES, template.unboxAsString());
    }

    Expression getDebugSoyTemplateInfo() {
        return this.delegate.invoke(GET_DEBUG_SOY_TEMPLATE_INFO, new Expression[0]);
    }

    Expression getPluginInstance(String pluginName) {
        return this.delegate.invoke(GET_PLUGIN_INSTANCE, BytecodeUtils.constant(pluginName));
    }

    Expression renameXid(String value) {
        return this.delegate.invoke(RENAME_XID, BytecodeUtils.constant(value));
    }

    Expression renameCss(String value) {
        return this.delegate.invoke(RENAME_CSS_SELECTOR, BytecodeUtils.constant(value));
    }

    Expression getDeltemplate(String delCalleeName, Expression variantExpr, boolean allowEmptyDefault, Expression params, Expression ijRecord) {
        return this.delegate.invoke(GET_DELTEMPLATE, BytecodeUtils.constant(delCalleeName), variantExpr, BytecodeUtils.constant(allowEmptyDefault), params, ijRecord);
    }

    @Override
    public Expression getULocale() {
        return this.delegate.invoke(GET_LOCALE, new Expression[0]);
    }

    Expression getSoyMsgParts(long id, Expression defaultParts) {
        return this.delegate.invoke(GET_SOY_MSG_PARTS, BytecodeUtils.constant(id), defaultParts);
    }

    Expression getSoyMsgPartsWithAlternateId(long id, Expression defaultParts, long alternateId) {
        return this.delegate.invoke(GET_SOY_MSG_PARTS_WITH_ALTERNATE_ID, BytecodeUtils.constant(id), defaultParts, BytecodeUtils.constant(alternateId));
    }

    Expression getPrintDirective(String name) {
        return this.delegate.invoke(GET_PRINT_DIRECTIVE, BytecodeUtils.constant(name));
    }

    Expression getEscapingDirectiveAsFunction(String name) {
        return this.delegate.invoke(GET_ESCAPING_DIRECTIVE_AS_FUNCTION, BytecodeUtils.constant(name));
    }

    SoyExpression applyPrintDirective(SoyPrintDirective directive, SoyExpression value) {
        return this.applyPrintDirective(directive, value, (List<SoyExpression>)ImmutableList.of());
    }

    SoyExpression applyPrintDirective(SoyPrintDirective directive, SoyExpression value, List<SoyExpression> args) {
        value = directive instanceof SoyJbcSrcPrintDirective ? ((SoyJbcSrcPrintDirective)directive).applyForJbcSrc(this, value, args) : SoyExpression.forSoyValue(UnknownType.getInstance(), MethodRef.RUNTIME_APPLY_PRINT_DIRECTIVE.invoke(this.getPrintDirective(directive.getName()), value.box(), SoyExpression.asBoxedList(args)));
        return value;
    }

    Expression usePrimaryMsgIfFallback(long msgId, long fallbackId) {
        return this.delegate.invoke(USE_PRIMARY_MSG_IF_FALLBACK, BytecodeUtils.constant(msgId), BytecodeUtils.constant(fallbackId));
    }

    Expression usePrimaryOrAlternateIfFallback(long msgId, long alternateId, long fallbackId) {
        return this.delegate.invoke(USE_PRIMARY_OR_ALTERNATE_IF_FALLBACK, BytecodeUtils.constant(msgId), BytecodeUtils.constant(alternateId), BytecodeUtils.constant(fallbackId));
    }

    Expression usePrimaryIfFallbackOrFallbackAlternate(long msgId, long fallbackId, long fallbackAlternateId) {
        return this.delegate.invoke(USE_PRIMARY_IF_FALLBACK_OR_FALLBACK_ALTERNATE, BytecodeUtils.constant(msgId), BytecodeUtils.constant(fallbackId), BytecodeUtils.constant(fallbackAlternateId));
    }

    Expression usePrimaryOrAlternateIfFallbackOrFallbackAlternate(long msgId, long alternateId, long fallbackId, long fallbackAlternateId) {
        return this.delegate.invoke(USE_PRIMARY_OR_ALTERNATE_IF_FALLBACK_OR_FALLBACK_ALTERNATE, BytecodeUtils.constant(msgId), BytecodeUtils.constant(alternateId), BytecodeUtils.constant(fallbackId), BytecodeUtils.constant(fallbackAlternateId));
    }

    public Expression hasLogger() {
        return this.delegate.invoke(HAS_LOGGER, new Expression[0]);
    }

    public Expression getLogger() {
        return this.delegate.invoke(GET_LOGGER, new Expression[0]);
    }
}

