/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeScriptProto;
import com.google.common.html.types.SafeStyleProto;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.common.io.BaseEncoding;
import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionLite;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.template.soy.data.ProtoFieldInterpreter;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SanitizedContents;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.internal.proto.FieldVisitor;
import com.google.template.soy.internal.proto.JavaQualifiedNames;
import com.google.template.soy.jbcsrc.ExpressionDetacher;
import com.google.template.soy.jbcsrc.LocalVariableManager;
import com.google.template.soy.jbcsrc.restricted.BytecodeProducer;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.LocalVariable;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyRuntimeType;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.UnionType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

final class ProtoUtils {
    private static final Type BYTE_STRING_TYPE = Type.getType(ByteString.class);
    private static final Type EXTENSION_TYPE = Type.getType(GeneratedMessage.GeneratedExtension.class);
    private static final Type[] ONE_INT_ARG = new Type[]{Type.INT_TYPE};
    private static final MethodRef BASE_ENCODING_BASE_64 = MethodRef.create(BaseEncoding.class, "base64", new Class[0]).asNonNullable().asCheap();
    private static final MethodRef BASE_ENCODING_DECODE = MethodRef.create(BaseEncoding.class, "decode", CharSequence.class).asNonNullable().asCheap();
    private static final MethodRef BASE_ENCODING_ENCODE = MethodRef.create(BaseEncoding.class, "encode", byte[].class).asNonNullable().asCheap();
    private static final MethodRef BYTE_STRING_COPY_FROM = MethodRef.create(ByteString.class, "copyFrom", byte[].class).asNonNullable();
    private static final MethodRef BYTE_STRING_TO_BYTE_ARRAY = MethodRef.create(ByteString.class, "toByteArray", new Class[0]).asNonNullable();
    private static final MethodRef EXTENDABLE_BUILDER_ADD_EXTENSION = MethodRef.create(GeneratedMessage.ExtendableBuilder.class, "addExtension", ExtensionLite.class, Object.class).asNonNullable();
    private static final MethodRef EXTENDABLE_BUILDER_SET_EXTENSION = MethodRef.create(GeneratedMessage.ExtendableBuilder.class, "setExtension", ExtensionLite.class, Object.class).asNonNullable();
    private static final MethodRef EXTENDABLE_MESSAGE_GET_EXTENSION = MethodRef.create(GeneratedMessage.ExtendableMessage.class, "getExtension", ExtensionLite.class).asNonNullable().asCheap();
    private static final MethodRef EXTENDABLE_MESSAGE_HAS_EXTENSION = MethodRef.create(GeneratedMessage.ExtendableMessage.class, "hasExtension", ExtensionLite.class).asNonNullable().asCheap();
    private static final ImmutableMap<String, MethodRef> SAFE_PROTO_TO_SANITIZED_CONTENT = ImmutableMap.builder().put((Object)SafeHtmlProto.getDescriptor().getFullName(), (Object)ProtoUtils.createSafeProtoToSanitizedContentFactoryMethod(SafeHtmlProto.class)).put((Object)SafeScriptProto.getDescriptor().getFullName(), (Object)ProtoUtils.createSafeProtoToSanitizedContentFactoryMethod(SafeScriptProto.class)).put((Object)SafeStyleProto.getDescriptor().getFullName(), (Object)ProtoUtils.createSafeProtoToSanitizedContentFactoryMethod(SafeStyleProto.class)).put((Object)SafeStyleSheetProto.getDescriptor().getFullName(), (Object)ProtoUtils.createSafeProtoToSanitizedContentFactoryMethod(SafeStyleSheetProto.class)).put((Object)SafeUrlProto.getDescriptor().getFullName(), (Object)ProtoUtils.createSafeProtoToSanitizedContentFactoryMethod(SafeUrlProto.class)).put((Object)TrustedResourceUrlProto.getDescriptor().getFullName(), (Object)ProtoUtils.createSafeProtoToSanitizedContentFactoryMethod(TrustedResourceUrlProto.class)).build();
    private static final ImmutableMap<String, MethodRef> SANITIZED_CONTENT_TO_PROTO = ImmutableMap.builder().put((Object)SafeHtmlProto.getDescriptor().getFullName(), (Object)MethodRef.create(SanitizedContent.class, "toSafeHtmlProto", new Class[0])).put((Object)SafeScriptProto.getDescriptor().getFullName(), (Object)MethodRef.create(SanitizedContent.class, "toSafeScriptProto", new Class[0])).put((Object)SafeStyleProto.getDescriptor().getFullName(), (Object)MethodRef.create(SanitizedContent.class, "toSafeStyleProto", new Class[0])).put((Object)SafeStyleSheetProto.getDescriptor().getFullName(), (Object)MethodRef.create(SanitizedContent.class, "toSafeStyleSheetProto", new Class[0])).put((Object)SafeUrlProto.getDescriptor().getFullName(), (Object)MethodRef.create(SanitizedContent.class, "toSafeUrlProto", new Class[0])).put((Object)TrustedResourceUrlProto.getDescriptor().getFullName(), (Object)MethodRef.create(SanitizedContent.class, "toTrustedResourceUrlProto", new Class[0])).build();
    private static final RepeatedFieldInterpreter REPEATED_FIELD_INTERPRETER = new RepeatedFieldInterpreter();

    ProtoUtils() {
    }

    private static MethodRef createSafeProtoToSanitizedContentFactoryMethod(Class<?> clazz) {
        return MethodRef.create(SanitizedContents.class, "from" + clazz.getSimpleName(), clazz).asNonNullable();
    }

    static SoyExpression accessField(SoyProtoType protoType, SoyExpression baseExpr, String fieldName, SoyType fieldType) {
        return new AccessorGenerator(protoType, baseExpr, fieldName, fieldType, true).generate();
    }

    static SoyExpression hasserField(SoyExpression baseExpr, String fieldName) {
        SoyProtoType protoType = (SoyProtoType)baseExpr.soyType();
        return new HasserGenerator(protoType, baseExpr, fieldName).generate();
    }

    static SoyExpression accessExtensionField(SoyExpression baseExpr, MethodCallNode node, String fieldName, boolean useBrokenSemantics) {
        SoyProtoType protoType = (SoyProtoType)baseExpr.soyType();
        return new AccessorGenerator(protoType, baseExpr, fieldName, node.getType(), useBrokenSemantics).generate();
    }

    static SoyExpression accessProtoUnionField(SoyExpression baseExpr, FieldAccessNode node, LocalVariableManager varManager) {
        return new ProtoUnionAccessorGenerator(baseExpr, node, varManager).generate();
    }

    static SoyExpression createProto(ProtoInitNode node, Function<ExprNode, SoyExpression> compilerFunction, ExpressionDetacher detacher, LocalVariableManager varManager) {
        return new ProtoInitGenerator(node, compilerFunction, detacher, varManager).generate();
    }

    private static boolean shouldConvertBetweenStringAndLong(Descriptors.FieldDescriptor descriptor) {
        DescriptorProtos.FieldOptions.JSType jsType;
        return com.google.template.soy.internal.proto.ProtoUtils.hasJsType(descriptor) && (jsType = com.google.template.soy.internal.proto.ProtoUtils.getJsType(descriptor)) == DescriptorProtos.FieldOptions.JSType.JS_STRING;
    }

    private static TypeInfo messageRuntimeType(Descriptors.Descriptor descriptor) {
        String className = JavaQualifiedNames.getClassName(descriptor);
        return TypeInfo.createClass(className);
    }

    private static TypeInfo enumRuntimeType(Descriptors.EnumDescriptor descriptor) {
        String className = JavaQualifiedNames.getClassName(descriptor);
        return TypeInfo.createClass(className);
    }

    private static TypeInfo builderRuntimeType(Descriptors.Descriptor descriptor) {
        String className = JavaQualifiedNames.getClassName(descriptor);
        return TypeInfo.createClass(className + "$Builder");
    }

    private static Type getRuntimeType(Descriptors.FieldDescriptor field) {
        switch (field.getJavaType()) {
            case BOOLEAN: {
                return Type.BOOLEAN_TYPE;
            }
            case BYTE_STRING: {
                return BYTE_STRING_TYPE;
            }
            case DOUBLE: {
                return Type.DOUBLE_TYPE;
            }
            case ENUM: {
                return ProtoUtils.isProto3EnumField(field) ? Type.INT_TYPE : TypeInfo.createClass(JavaQualifiedNames.getClassName(field.getEnumType())).type();
            }
            case FLOAT: {
                return Type.FLOAT_TYPE;
            }
            case INT: {
                return Type.INT_TYPE;
            }
            case LONG: {
                return Type.LONG_TYPE;
            }
            case MESSAGE: {
                return TypeInfo.createClass(JavaQualifiedNames.getClassName(field.getMessageType())).type();
            }
            case STRING: {
                return BytecodeUtils.STRING_TYPE;
            }
        }
        throw new AssertionError((Object)"unexpected type");
    }

    private static MethodRef getGetterMethod(Descriptors.FieldDescriptor descriptor) {
        Type runtimeType;
        Preconditions.checkArgument((!descriptor.isExtension() ? 1 : 0) != 0, (String)"extensions do not have getter methods. %s", (Object)descriptor);
        TypeInfo message = ProtoUtils.messageRuntimeType(descriptor.getContainingType());
        String repeatedType = "";
        boolean isProto3Enum = ProtoUtils.isProto3EnumField(descriptor);
        if (descriptor.isMapField()) {
            repeatedType = "Map";
            runtimeType = BytecodeUtils.MAP_TYPE;
            isProto3Enum = ProtoUtils.mapValueIsProto3Enum(descriptor);
        } else if (descriptor.isRepeated()) {
            repeatedType = "List";
            runtimeType = BytecodeUtils.LIST_TYPE;
        } else {
            runtimeType = isProto3Enum ? Type.INT_TYPE : ProtoUtils.getRuntimeType(descriptor);
        }
        return MethodRef.createInstanceMethod(message, new Method("get" + JavaQualifiedNames.getFieldName(descriptor, true) + (isProto3Enum ? "Value" : "") + repeatedType, runtimeType, MethodRef.NO_METHOD_ARGS)).asNonNullable().asCheap();
    }

    private static boolean mapValueIsProto3Enum(Descriptors.FieldDescriptor descriptor) {
        Descriptors.FieldDescriptor valueDescriptor = (Descriptors.FieldDescriptor)descriptor.getMessageType().getFields().get(1);
        return ProtoUtils.isProto3EnumField(valueDescriptor);
    }

    private static boolean isProto3EnumField(Descriptors.FieldDescriptor descriptor) {
        return descriptor.getType() == Descriptors.FieldDescriptor.Type.ENUM && descriptor.getFile().getSyntax() == Descriptors.FileDescriptor.Syntax.PROTO3;
    }

    private static MethodRef getHasserMethod(Descriptors.FieldDescriptor descriptor) {
        TypeInfo message = ProtoUtils.messageRuntimeType(descriptor.getContainingType());
        return MethodRef.createInstanceMethod(message, new Method("has" + JavaQualifiedNames.getFieldName(descriptor, true), Type.BOOLEAN_TYPE, MethodRef.NO_METHOD_ARGS)).asCheap();
    }

    private static MethodRef getOneOfCaseMethod(Descriptors.OneofDescriptor descriptor) {
        TypeInfo message = ProtoUtils.messageRuntimeType(descriptor.getContainingType());
        return MethodRef.createInstanceMethod(message, new Method("get" + JavaQualifiedNames.underscoresToCamelCase(descriptor.getName(), true) + "Case", TypeInfo.createClass(JavaQualifiedNames.getCaseEnumClassName(descriptor)).type(), MethodRef.NO_METHOD_ARGS)).asCheap();
    }

    private static MethodRef getBuilderMethod(Descriptors.Descriptor descriptor) {
        TypeInfo message = ProtoUtils.messageRuntimeType(descriptor);
        TypeInfo builder = ProtoUtils.builderRuntimeType(descriptor);
        return MethodRef.createStaticMethod(message, new Method("newBuilder", builder.type(), MethodRef.NO_METHOD_ARGS)).asNonNullable();
    }

    private static MethodRef getDefaultInstanceMethod(Descriptors.Descriptor descriptor) {
        TypeInfo message = ProtoUtils.messageRuntimeType(descriptor);
        return MethodRef.createStaticMethod(message, new Method("getDefaultInstance", message.type(), MethodRef.NO_METHOD_ARGS)).asNonNullable();
    }

    private static MethodRef getPutMethod(Descriptors.FieldDescriptor descriptor) {
        Preconditions.checkState((boolean)descriptor.isMapField());
        List mapFields = descriptor.getMessageType().getFields();
        TypeInfo builder = ProtoUtils.builderRuntimeType(descriptor.getContainingType());
        return MethodRef.createInstanceMethod(builder, new Method("put" + JavaQualifiedNames.getFieldName(descriptor, true), builder.type(), new Type[]{ProtoUtils.getRuntimeType((Descriptors.FieldDescriptor)mapFields.get(0)), ProtoUtils.getRuntimeType((Descriptors.FieldDescriptor)mapFields.get(1))}));
    }

    private static MethodRef getSetOrAddMethod(Descriptors.FieldDescriptor descriptor) {
        TypeInfo builder = ProtoUtils.builderRuntimeType(descriptor.getContainingType());
        String prefix = descriptor.isRepeated() ? "add" : "set";
        boolean isProto3EnumField = ProtoUtils.isProto3EnumField(descriptor);
        String suffix = isProto3EnumField ? "Value" : "";
        return MethodRef.createInstanceMethod(builder, new Method(prefix + JavaQualifiedNames.getFieldName(descriptor, true) + suffix, builder.type(), new Type[]{isProto3EnumField ? Type.INT_TYPE : ProtoUtils.getRuntimeType(descriptor)})).asNonNullable();
    }

    private static MethodRef getBuildMethod(Descriptors.Descriptor descriptor) {
        TypeInfo message = ProtoUtils.messageRuntimeType(descriptor);
        TypeInfo builder = ProtoUtils.builderRuntimeType(descriptor);
        return MethodRef.createInstanceMethod(builder, new Method("build", message.type(), MethodRef.NO_METHOD_ARGS)).asNonNullable();
    }

    private static MethodRef getForNumberMethod(Descriptors.EnumDescriptor descriptor) {
        TypeInfo enumType = ProtoUtils.enumRuntimeType(descriptor);
        return MethodRef.createStaticMethod(enumType, new Method("forNumber", enumType.type(), ONE_INT_ARG)).asNonNullable().asCheap();
    }

    private static FieldRef getExtensionField(Descriptors.FieldDescriptor descriptor) {
        Preconditions.checkArgument((boolean)descriptor.isExtension(), (String)"%s is not an extension", (Object)descriptor);
        String extensionFieldName = JavaQualifiedNames.getFieldName(descriptor, false);
        if (descriptor.getExtensionScope() != null) {
            TypeInfo owner = ProtoUtils.messageRuntimeType(descriptor.getExtensionScope());
            return FieldRef.createPublicStaticField(owner, extensionFieldName, EXTENSION_TYPE);
        }
        String containingClass = JavaQualifiedNames.getPackage(descriptor.getFile()) + "." + JavaQualifiedNames.getOuterClassname(descriptor.getFile());
        return FieldRef.createPublicStaticField(TypeInfo.createClass(containingClass), extensionFieldName, EXTENSION_TYPE);
    }

    private static class RepeatedFieldInterpreter
    extends FieldVisitor<Expression> {
        private static final FieldRef LONG_AS_INT = FieldRef.staticFieldReference(ProtoFieldInterpreter.class, "LONG_AS_INT");
        private static final FieldRef UNSIGNED_INT = FieldRef.staticFieldReference(ProtoFieldInterpreter.class, "UNSIGNED_INT");
        private static final FieldRef UNSIGNEDLONG_AS_STRING = FieldRef.staticFieldReference(ProtoFieldInterpreter.class, "UNSIGNEDLONG_AS_STRING");
        private static final FieldRef LONG_AS_STRING = FieldRef.staticFieldReference(ProtoFieldInterpreter.class, "LONG_AS_STRING");
        private static final FieldRef BOOL = FieldRef.staticFieldReference(ProtoFieldInterpreter.class, "BOOL");
        private static final FieldRef BYTES = FieldRef.staticFieldReference(ProtoFieldInterpreter.class, "BYTES");
        private static final FieldRef STRING = FieldRef.staticFieldReference(ProtoFieldInterpreter.class, "STRING");
        private static final FieldRef DOUBLE_AS_FLOAT = FieldRef.staticFieldReference(ProtoFieldInterpreter.class, "DOUBLE_AS_FLOAT");
        private static final FieldRef FLOAT = FieldRef.staticFieldReference(ProtoFieldInterpreter.class, "FLOAT");
        private static final FieldRef INT = FieldRef.staticFieldReference(ProtoFieldInterpreter.class, "INT");
        private static final FieldRef SAFE_HTML_PROTO = FieldRef.staticFieldReference(ProtoFieldInterpreter.class, "SAFE_HTML_PROTO");
        private static final FieldRef SAFE_SCRIPT_PROTO = FieldRef.staticFieldReference(ProtoFieldInterpreter.class, "SAFE_SCRIPT_PROTO");
        private static final FieldRef SAFE_STYLE_PROTO = FieldRef.staticFieldReference(ProtoFieldInterpreter.class, "SAFE_STYLE_PROTO");
        private static final FieldRef SAFE_STYLE_SHEET_PROTO = FieldRef.staticFieldReference(ProtoFieldInterpreter.class, "SAFE_STYLE_SHEET_PROTO");
        private static final FieldRef SAFE_URL_PROTO = FieldRef.staticFieldReference(ProtoFieldInterpreter.class, "SAFE_URL_PROTO");
        private static final FieldRef TRUSTED_RESOURCE_URI_PROTO = FieldRef.staticFieldReference(ProtoFieldInterpreter.class, "TRUSTED_RESOURCE_URI_PROTO");
        private static final FieldRef PROTO_MESSAGE = FieldRef.staticFieldReference(ProtoFieldInterpreter.class, "PROTO_MESSAGE");
        private static final FieldRef ENUM_FROM_PROTO = FieldRef.staticFieldReference(ProtoFieldInterpreter.class, "ENUM_FROM_PROTO");

        private RepeatedFieldInterpreter() {
        }

        @Override
        protected Expression visitMap(Descriptors.FieldDescriptor mapField, Expression keyInterpreter, Expression valueInterpreter) {
            throw new AssertionError((Object)"visit map key/value individually");
        }

        @Override
        protected Expression visitRepeated(Expression valueInterpreter) {
            return valueInterpreter;
        }

        @Override
        protected Expression visitLongAsInt() {
            return LONG_AS_INT.accessor();
        }

        @Override
        protected Expression visitUnsignedInt() {
            return UNSIGNED_INT.accessor();
        }

        @Override
        protected Expression visitUnsignedLongAsString() {
            return UNSIGNEDLONG_AS_STRING.accessor();
        }

        @Override
        protected Expression visitLongAsString() {
            return LONG_AS_STRING.accessor();
        }

        @Override
        protected Expression visitBool() {
            return BOOL.accessor();
        }

        @Override
        protected Expression visitInt() {
            return INT.accessor();
        }

        @Override
        protected Expression visitBytes() {
            return BYTES.accessor();
        }

        @Override
        protected Expression visitString() {
            return STRING.accessor();
        }

        @Override
        protected Expression visitDoubleAsFloat() {
            return DOUBLE_AS_FLOAT.accessor();
        }

        @Override
        protected Expression visitFloat() {
            return FLOAT.accessor();
        }

        @Override
        protected Expression visitSafeHtml() {
            return SAFE_HTML_PROTO.accessor();
        }

        @Override
        protected Expression visitSafeScript() {
            return SAFE_SCRIPT_PROTO.accessor();
        }

        @Override
        protected Expression visitSafeStyle() {
            return SAFE_STYLE_PROTO.accessor();
        }

        @Override
        protected Expression visitSafeStyleSheet() {
            return SAFE_STYLE_SHEET_PROTO.accessor();
        }

        @Override
        protected Expression visitSafeUrl() {
            return SAFE_URL_PROTO.accessor();
        }

        @Override
        protected Expression visitTrustedResourceUrl() {
            return TRUSTED_RESOURCE_URI_PROTO.accessor();
        }

        @Override
        protected Expression visitMessage(Descriptors.Descriptor message) {
            return PROTO_MESSAGE.accessor();
        }

        @Override
        protected Expression visitEnum(Descriptors.EnumDescriptor enumType, Descriptors.FieldDescriptor fieldType) {
            if (fieldType.getFile().getSyntax() == Descriptors.FileDescriptor.Syntax.PROTO3) {
                return INT.accessor();
            }
            return ENUM_FROM_PROTO.accessor();
        }
    }

    private static final class ProtoInitGenerator {
        private final ProtoInitNode node;
        private final Function<ExprNode, SoyExpression> compilerFunction;
        private final ExpressionDetacher detacher;
        private final LocalVariableManager varManager;
        private final SoyProtoType protoType;
        private final Descriptors.Descriptor descriptor;

        ProtoInitGenerator(ProtoInitNode node, Function<ExprNode, SoyExpression> compilerFunction, ExpressionDetacher detacher, LocalVariableManager varManager) {
            this.node = node;
            this.compilerFunction = compilerFunction;
            this.detacher = detacher;
            this.varManager = varManager;
            this.protoType = (SoyProtoType)node.getType();
            this.descriptor = this.protoType.getDescriptor();
        }

        private SoyExpression compile(ExprNode expr) {
            return (SoyExpression)this.compilerFunction.apply((Object)expr);
        }

        SoyExpression generate() {
            if (this.node.numChildren() == 0) {
                Expression defaultInstance = ProtoUtils.getDefaultInstanceMethod(this.descriptor).invoke(new Expression[0]);
                return SoyExpression.forProto(SoyRuntimeType.getUnboxedType(this.protoType).get(), defaultInstance);
            }
            final Expression newBuilderCall = ProtoUtils.getBuilderMethod(this.descriptor).invoke(new Expression[0]);
            final ImmutableList<Statement> setters = this.getFieldSetters();
            final MethodRef buildCall = ProtoUtils.getBuildMethod(this.descriptor);
            Expression expression = new Expression(ProtoUtils.messageRuntimeType(this.descriptor).type()){

                @Override
                protected void doGen(CodeBuilder cb) {
                    newBuilderCall.gen(cb);
                    for (Statement setter : setters) {
                        setter.gen(cb);
                    }
                    buildCall.invokeUnchecked(cb);
                }
            }.asNonNullable();
            return SoyExpression.forProto(SoyRuntimeType.getUnboxedType(this.protoType).get(), expression);
        }

        private ImmutableList<Statement> getFieldSetters() {
            ImmutableList.Builder setters = ImmutableList.builder();
            for (int i = 0; i < this.node.numChildren(); ++i) {
                Descriptors.FieldDescriptor field = this.protoType.getFieldDescriptor(this.node.getParamName(i).identifier());
                ExprNode baseArg = this.node.getChild(i);
                Statement setter = field.isRepeated() ? this.handleRepeated(baseArg, field) : (field.isExtension() ? this.handleExtension(this.compile(baseArg), field) : this.handleNormalSetter(this.compile(baseArg), field));
                setters.add((Object)setter);
            }
            return setters.build();
        }

        private Statement handleMapSetter(final SoyExpression keyArg, final SoyExpression valueArg, Descriptors.FieldDescriptor field) {
            final MethodRef putMethod = ProtoUtils.getPutMethod(field);
            List descriptors = field.getMessageType().getFields();
            final Descriptors.FieldDescriptor keyDescriptor = (Descriptors.FieldDescriptor)descriptors.get(0);
            final Descriptors.FieldDescriptor valueDescriptor = (Descriptors.FieldDescriptor)descriptors.get(1);
            return new Statement(){

                @Override
                protected void doGen(CodeBuilder cb) {
                    keyArg.gen(cb);
                    ProtoInitGenerator.unboxAndCoerce(cb, keyArg, keyDescriptor);
                    valueArg.gen(cb);
                    ProtoInitGenerator.unboxAndCoerce(cb, valueArg, valueDescriptor);
                    putMethod.invokeUnchecked(cb);
                }
            };
        }

        private Statement handleNormalSetter(final SoyExpression baseArg, final Descriptors.FieldDescriptor field) {
            final MethodRef setterMethod = ProtoUtils.getSetOrAddMethod(field);
            final boolean isNullable = !baseArg.isNonNullable();
            return new Statement(){

                @Override
                protected void doGen(CodeBuilder cb) {
                    baseArg.gen(cb);
                    Label argIsNull = null;
                    Label end = null;
                    if (isNullable) {
                        argIsNull = new Label();
                        end = new Label();
                        cb.dup();
                        cb.ifNull(argIsNull);
                    }
                    ProtoInitGenerator.unboxAndCoerce(cb, baseArg, field);
                    setterMethod.invokeUnchecked(cb);
                    if (isNullable) {
                        cb.goTo(end);
                        cb.mark(argIsNull);
                        cb.pop();
                        cb.mark(end);
                    }
                }
            };
        }

        private Statement handleMapSetterNotNull(SoyExpression mapArg, Descriptors.FieldDescriptor field) {
            Preconditions.checkArgument((boolean)mapArg.isNonNullable());
            Expression resolved = this.detacher.resolveSoyValueProviderMap(mapArg.invoke(MethodRef.SOY_MAP_IMPL_AS_JAVA_MAP, new Expression[0]));
            LocalVariableManager.Scope scope = this.varManager.enterScope();
            Expression getMapIterator = resolved.invoke(MethodRef.MAP_ENTRY_SET, new Expression[0]).invoke(MethodRef.GET_ITERATOR, new Expression[0]);
            LocalVariable iter = scope.createTemporary(field.getName() + "__iter", getMapIterator.resultType());
            final Statement loopInitialization = iter.store(getMapIterator, iter.start());
            Expression iterNext = iter.invoke(MethodRef.ITERATOR_NEXT, new Expression[0]).checkedCast(BytecodeUtils.MAP_ENTRY_TYPE);
            LocalVariable mapEntry = scope.createTemporary(field.getName() + "__mapEntry", iterNext.resultType());
            final Statement initMapEntry = mapEntry.store(iterNext, mapEntry.start());
            final Statement scopeExit = scope.exitScope();
            MapType mapType = (MapType)mapArg.soyType();
            SoyType keyType = mapType.getKeyType();
            SoyRuntimeType keyRuntimeType = SoyRuntimeType.getBoxedType(keyType);
            SoyType valueType = mapType.getValueType();
            SoyRuntimeType valueRuntimeType = SoyRuntimeType.getBoxedType(valueType);
            SoyExpression mapKey = SoyExpression.forSoyValue(keyType, mapEntry.invoke(MethodRef.MAP_GET_KEY, new Expression[0]).checkedCast(keyRuntimeType.runtimeType()).asNonNullable());
            SoyExpression mapValue = SoyExpression.forSoyValue(valueType, mapEntry.invoke(MethodRef.MAP_GET_VALUE, new Expression[0]).checkedCast(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE).invoke(MethodRef.SOY_VALUE_PROVIDER_RESOLVE, new Expression[0]).checkedCast(valueRuntimeType.runtimeType())).asNonNullable();
            final Expression iterHasNext = iter.invoke(MethodRef.ITERATOR_HAS_NEXT, new Expression[0]);
            final Statement putOne = this.handleMapSetter(mapKey, mapValue, field);
            return new Statement(){

                @Override
                protected void doGen(CodeBuilder cb) {
                    loopInitialization.gen(cb);
                    Label loopStart = cb.mark();
                    iterHasNext.gen(cb);
                    Label end = new Label();
                    cb.ifZCmp(153, end);
                    initMapEntry.gen(cb);
                    putOne.gen(cb);
                    cb.goTo(loopStart);
                    cb.mark(end);
                    scopeExit.gen(cb);
                }
            };
        }

        private Statement handleRepeated(ExprNode argNode, Descriptors.FieldDescriptor field) {
            if (argNode.getKind() == ExprNode.Kind.LIST_LITERAL_NODE) {
                Preconditions.checkState((!field.isMapField() ? 1 : 0) != 0);
                ArrayList<Statement> additions = new ArrayList<Statement>();
                ListLiteralNode list = (ListLiteralNode)argNode;
                for (ExprNode element : list.getChildren()) {
                    SoyExpression expression = this.compile(element).asNonNullable();
                    additions.add(field.isExtension() ? this.handleExtension(expression, field) : this.handleNormalSetter(expression, field));
                }
                return Statement.concat(additions);
            }
            if (argNode.getKind() == ExprNode.Kind.MAP_LITERAL_NODE) {
                Preconditions.checkState((boolean)field.isMapField());
                ArrayList<Statement> puts = new ArrayList<Statement>();
                MapLiteralNode map = (MapLiteralNode)argNode;
                for (int i = 0; i < map.numChildren(); i += 2) {
                    SoyExpression key = this.compile(map.getChild(i));
                    SoyExpression value = this.compile(map.getChild(i + 1));
                    puts.add(this.handleMapSetter(key, value, field));
                }
                return Statement.concat(puts);
            }
            final SoyExpression baseArg = this.compile(argNode);
            if (baseArg.soyType().equals(ListType.EMPTY_LIST) || baseArg.soyType().equals(MapType.EMPTY_MAP)) {
                return Statement.NULL_STATEMENT;
            }
            if (baseArg.isNonNullable()) {
                return field.isMapField() ? this.handleMapSetterNotNull(baseArg, field) : this.handleRepeatedNotNull(baseArg, field);
            }
            final Label isNonNull = new Label();
            final Label end = new Label();
            SoyExpression nonNull = baseArg.withSource(new Expression(baseArg.resultType(), baseArg.features()){

                @Override
                protected void doGen(CodeBuilder cb) {
                    baseArg.gen(cb);
                    cb.dup();
                    cb.ifNonNull(isNonNull);
                    cb.pop();
                    cb.goTo(end);
                    cb.mark(isNonNull);
                }
            }).asNonNullable();
            final Statement handle = field.isMapField() ? this.handleMapSetterNotNull(nonNull, field) : this.handleRepeatedNotNull(nonNull, field);
            return new Statement(){

                @Override
                protected void doGen(CodeBuilder cb) {
                    handle.gen(cb);
                    cb.mark(end);
                }
            };
        }

        private Statement handleRepeatedNotNull(SoyExpression listArg, Descriptors.FieldDescriptor field) {
            Preconditions.checkArgument((boolean)listArg.isNonNullable());
            SoyExpression unboxed = listArg.unboxAsList();
            Expression resolved = this.detacher.resolveSoyValueProviderList(unboxed);
            LocalVariableManager.Scope scope = this.varManager.enterScope();
            LocalVariable list = scope.createTemporary(field.getName() + "__list", resolved.resultType());
            final LocalVariable listSize = scope.createTemporary(field.getName() + "__size", Type.INT_TYPE);
            final LocalVariable index = scope.createTemporary(field.getName() + "__index", Type.INT_TYPE);
            final Statement indexInitialization = index.store(BytecodeUtils.constant(0), index.start());
            final Statement loopInitialization = Statement.concat(list.store(resolved, list.start()), listSize.store(list.invoke(MethodRef.LIST_SIZE, new Expression[0]), listSize.start()));
            final Statement scopeExit = scope.exitScope();
            SoyType elementSoyType = ((ListType)unboxed.soyType()).getElementType();
            SoyRuntimeType elementType = SoyRuntimeType.getBoxedType(elementSoyType);
            Expression getAndResolve = list.invoke(MethodRef.LIST_GET, index).checkedCast(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE).invoke(MethodRef.SOY_VALUE_PROVIDER_RESOLVE, new Expression[0]).checkedCast(elementType.runtimeType());
            SoyExpression soyValue = SoyExpression.forSoyValue(elementType.soyType(), getAndResolve).asNonNullable();
            final Statement getAndAddOne = field.isExtension() ? this.handleExtension(soyValue, field) : this.handleNormalSetter(soyValue, field);
            return new Statement(){

                @Override
                protected void doGen(CodeBuilder cb) {
                    loopInitialization.gen(cb);
                    listSize.gen(cb);
                    Label listIsEmpty = new Label();
                    cb.ifZCmp(153, listIsEmpty);
                    indexInitialization.gen(cb);
                    Label loopStart = cb.mark();
                    getAndAddOne.gen(cb);
                    cb.iinc(index.index(), 1);
                    index.gen(cb);
                    listSize.gen(cb);
                    cb.ifICmp(155, loopStart);
                    cb.mark(listIsEmpty);
                    scopeExit.gen(cb);
                }
            };
        }

        private Statement handleExtension(final SoyExpression baseArg, final Descriptors.FieldDescriptor field) {
            final Expression extensionIdentifier = ProtoUtils.getExtensionField(field).accessor();
            final MethodRef setterMethod = field.isRepeated() ? EXTENDABLE_BUILDER_ADD_EXTENSION : EXTENDABLE_BUILDER_SET_EXTENSION;
            final boolean isNullable = !baseArg.isNonNullable();
            return new Statement(){

                @Override
                protected void doGen(CodeBuilder cb) {
                    baseArg.gen(cb);
                    Label argIsNull = null;
                    Label end = null;
                    if (isNullable) {
                        argIsNull = new Label();
                        end = new Label();
                        cb.dup();
                        cb.ifNull(argIsNull);
                    }
                    ProtoInitGenerator.unboxAndCoerce(cb, baseArg, field);
                    extensionIdentifier.gen(cb);
                    cb.swap();
                    setterMethod.invokeUnchecked(cb);
                    if (isNullable) {
                        cb.goTo(end);
                        cb.mark(argIsNull);
                        cb.pop();
                        cb.mark(end);
                    }
                    cb.checkCast(ProtoUtils.builderRuntimeType(descriptor).type());
                }
            };
        }

        private static void unboxAndCoerce(CodeBuilder cb, SoyExpression baseArg, Descriptors.FieldDescriptor field) {
            Type currentType = !ProtoInitGenerator.isSafeProto(field) ? (baseArg.isBoxed() ? BytecodeUtils.unboxUnchecked(cb, baseArg.soyRuntimeType(), ProtoInitGenerator.classToUnboxTo(field)) : baseArg.resultType()) : baseArg.resultType();
            ProtoInitGenerator.coerce(cb, currentType, field);
        }

        @Nullable
        private static Class<?> classToUnboxTo(Descriptors.FieldDescriptor field) {
            switch (field.getJavaType()) {
                case BOOLEAN: {
                    return Boolean.TYPE;
                }
                case FLOAT: 
                case DOUBLE: {
                    return Double.TYPE;
                }
                case INT: 
                case ENUM: {
                    return Long.TYPE;
                }
                case LONG: {
                    return ProtoUtils.shouldConvertBetweenStringAndLong(field) ? String.class : Long.TYPE;
                }
                case STRING: 
                case BYTE_STRING: {
                    return String.class;
                }
                case MESSAGE: {
                    if (ProtoInitGenerator.isSafeProto(field)) {
                        throw new IllegalStateException("SanitizedContent objects shouldn't be unboxed");
                    }
                    return Message.class;
                }
            }
            throw new AssertionError((Object)("unsupported field type: " + field));
        }

        private static void coerce(CodeBuilder cb, Type currentType, Descriptors.FieldDescriptor field) {
            Type fieldType;
            switch (field.getJavaType()) {
                case BOOLEAN: 
                case STRING: 
                case DOUBLE: {
                    break;
                }
                case FLOAT: {
                    if (currentType.equals((Object)Type.FLOAT_TYPE)) break;
                    cb.cast(currentType, Type.FLOAT_TYPE);
                    break;
                }
                case INT: {
                    Preconditions.checkState((boolean)currentType.equals((Object)Type.LONG_TYPE));
                    if (com.google.template.soy.internal.proto.ProtoUtils.isUnsigned(field)) {
                        MethodRef.UNSIGNED_INTS_SATURATED_CAST.invokeUnchecked(cb);
                        break;
                    }
                    cb.cast(currentType, Type.INT_TYPE);
                    break;
                }
                case LONG: {
                    if (!ProtoUtils.shouldConvertBetweenStringAndLong(field)) break;
                    if (com.google.template.soy.internal.proto.ProtoUtils.isUnsigned(field)) {
                        MethodRef.UNSIGNED_LONGS_PARSE_UNSIGNED_LONG.invokeUnchecked(cb);
                        break;
                    }
                    MethodRef.LONG_PARSE_LONG.invokeUnchecked(cb);
                    break;
                }
                case BYTE_STRING: {
                    BASE_ENCODING_BASE_64.invokeUnchecked(cb);
                    cb.swap();
                    BASE_ENCODING_DECODE.invokeUnchecked(cb);
                    BYTE_STRING_COPY_FROM.invokeUnchecked(cb);
                    break;
                }
                case MESSAGE: {
                    ProtoInitGenerator.coerceToMessage(cb, currentType, field);
                    break;
                }
                case ENUM: {
                    if (!currentType.equals((Object)Type.INT_TYPE)) {
                        cb.cast(currentType, Type.INT_TYPE);
                    }
                    if (!ProtoUtils.isProto3EnumField(field)) {
                        ProtoUtils.getForNumberMethod(field.getEnumType()).invokeUnchecked(cb);
                    }
                    return;
                }
            }
            if (field.isExtension() && BytecodeUtils.isPrimitive(fieldType = ProtoUtils.getRuntimeType(field))) {
                cb.valueOf(fieldType);
            }
        }

        private static void coerceToMessage(CodeBuilder cb, Type currentType, Descriptors.FieldDescriptor field) {
            Type runtimeFieldType = ProtoUtils.getRuntimeType(field);
            if (ProtoInitGenerator.isSafeProto(field)) {
                MethodRef toProto = (MethodRef)SANITIZED_CONTENT_TO_PROTO.get((Object)field.getMessageType().getFullName());
                if (!currentType.equals((Object)BytecodeUtils.SANITIZED_CONTENT_TYPE)) {
                    cb.checkCast(BytecodeUtils.SANITIZED_CONTENT_TYPE);
                }
                toProto.invokeUnchecked(cb);
                currentType = toProto.returnType();
            }
            if (!currentType.equals((Object)runtimeFieldType)) {
                cb.checkCast(runtimeFieldType);
            }
        }

        private static boolean isSafeProto(Descriptors.FieldDescriptor field) {
            return field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE && SAFE_PROTO_TO_SANITIZED_CONTENT.containsKey((Object)field.getMessageType().getFullName());
        }
    }

    private static final class HasserGenerator
    extends BaseGenerator {
        final String fieldName;
        final Descriptors.FieldDescriptor descriptor;

        HasserGenerator(SoyProtoType protoType, SoyExpression baseExpr, String fieldName) {
            super(SoyRuntimeType.getUnboxedType(protoType).get(), baseExpr);
            this.fieldName = fieldName;
            this.descriptor = protoType.getFieldDescriptor(fieldName);
        }

        SoyExpression generate() {
            SoyExpression typedBaseExpr = this.getTypedBaseExpression();
            if (this.descriptor.isExtension()) {
                throw new AssertionError((Object)("extensions don't have hassers: " + this.descriptor));
            }
            if (this.descriptor.isRepeated()) {
                throw new AssertionError((Object)("repeated fields don't have hassers: " + this.descriptor));
            }
            return this.handleNormalField(typedBaseExpr);
        }

        private SoyExpression handleNormalField(SoyExpression typedBaseExpr) {
            MethodRef hasMethodRef = ProtoUtils.getHasserMethod(this.descriptor);
            return SoyExpression.forBool(typedBaseExpr.invoke(hasMethodRef, new Expression[0]));
        }
    }

    private static final class ProtoUnionAccessorGenerator {
        private final SoyExpression baseExpr;
        private final FieldAccessNode node;
        private final LocalVariableManager varManager;

        ProtoUnionAccessorGenerator(SoyExpression baseExpr, FieldAccessNode node, LocalVariableManager varManager) {
            Preconditions.checkArgument((baseExpr.soyType().getKind() == SoyType.Kind.UNION ? 1 : 0) != 0, (Object)baseExpr.soyType());
            this.baseExpr = baseExpr;
            this.node = node;
            this.varManager = varManager;
        }

        private Expression getUnboxedBaseExpression() {
            Preconditions.checkState((boolean)this.baseExpr.isBoxed());
            return this.baseExpr.invoke(MethodRef.SOY_PROTO_VALUE_GET_PROTO, new Expression[0]);
        }

        SoyExpression generate() {
            SoyRuntimeType resultType = SoyRuntimeType.getUnboxedType(this.node.getType()).orElseGet(() -> SoyRuntimeType.getBoxedType(this.node.getType()));
            LocalVariableManager.Scope scope = this.varManager.enterScope();
            Expression unboxedBaseExpr = this.getUnboxedBaseExpression();
            final LocalVariable base = scope.createTemporary(this.node.getFieldName() + "__base", unboxedBaseExpr.resultType());
            final Statement baseInit = base.store(unboxedBaseExpr, base.start());
            final Statement scopeExit = scope.exitScope();
            boolean foundBoxed = false;
            Set<SoyType> members = ((UnionType)this.baseExpr.soyType()).getMembers();
            final LinkedHashMap<SoyRuntimeType, SoyExpression> getters = new LinkedHashMap<SoyRuntimeType, SoyExpression>();
            for (SoyType member : members) {
                SoyRuntimeType unboxed;
                SoyProtoType protoType = (SoyProtoType)member;
                SoyExpression fieldAccess = ProtoUtils.accessField(protoType, SoyExpression.forProto(unboxed = SoyRuntimeType.getUnboxedType(protoType).get(), base.checkedCast(unboxed.runtimeType())), this.node.getFieldName(), protoType.getFieldType(this.node.getFieldName()));
                if (fieldAccess.isBoxed()) {
                    foundBoxed = true;
                }
                getters.put(unboxed, fieldAccess);
            }
            if (resultType.isBoxed() || foundBoxed) {
                resultType = resultType.box();
                getters.replaceAll((key, value) -> value.box());
            }
            return SoyExpression.forRuntimeType(resultType, new Expression(resultType.runtimeType()){

                @Override
                protected void doGen(CodeBuilder cb) {
                    Label end = new Label();
                    baseInit.gen(cb);
                    Iterator i = getters.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry entry = i.next();
                        SoyRuntimeType type = (SoyRuntimeType)entry.getKey();
                        SoyExpression getter = (SoyExpression)entry.getValue();
                        boolean last = !i.hasNext();
                        Label next = null;
                        if (!last) {
                            next = new Label();
                            base.gen(cb);
                            cb.instanceOf(type.runtimeType());
                            cb.ifZCmp(153, next);
                        }
                        getter.gen(cb);
                        if (last) continue;
                        cb.goTo(end);
                        cb.mark(next);
                    }
                    cb.mark(end);
                    scopeExit.gen(cb);
                }
            });
        }
    }

    private static final class AccessorGenerator
    extends BaseGenerator {
        final SoyType fieldType;
        final String fieldName;
        final Descriptors.FieldDescriptor descriptor;
        final boolean shouldCheckForFieldPresence;

        AccessorGenerator(SoyProtoType protoType, SoyExpression baseExpr, String fieldName, SoyType fieldType, boolean useBrokenSemantics) {
            super(SoyRuntimeType.getUnboxedType(protoType).get(), baseExpr);
            this.fieldName = fieldName;
            this.fieldType = fieldType;
            this.descriptor = protoType.getFieldDescriptor(fieldName);
            this.shouldCheckForFieldPresence = useBrokenSemantics && protoType.shouldCheckFieldPresenceToEmulateJspbNullability(fieldName);
        }

        SoyExpression generate() {
            SoyExpression typedBaseExpr = this.getTypedBaseExpression();
            if (this.descriptor.isExtension()) {
                return this.handleExtension(typedBaseExpr);
            }
            return this.handleNormalField(typedBaseExpr);
        }

        private SoyExpression handleNormalField(final SoyExpression typedBaseExpr) {
            BytecodeProducer hasCheck;
            final MethodRef getMethodRef = ProtoUtils.getGetterMethod(this.descriptor);
            if (this.descriptor.isMapField()) {
                return this.handleMapField(typedBaseExpr, getMethodRef);
            }
            if (this.descriptor.isRepeated()) {
                return SoyExpression.forBoxedList((ListType)this.fieldType, MethodRef.LAZY_PROTO_TO_SOY_VALUE_LIST_FOR_LIST.invoke(typedBaseExpr.invoke(getMethodRef, new Expression[0]), FieldVisitor.visitField(this.descriptor, REPEATED_FIELD_INTERPRETER)));
            }
            if (!this.shouldCheckForFieldPresence) {
                return this.interpretField(typedBaseExpr.invoke(getMethodRef, new Expression[0]));
            }
            final Label hasFieldLabel = new Label();
            Descriptors.OneofDescriptor containingOneof = this.descriptor.getContainingOneof();
            if (containingOneof != null) {
                final MethodRef getCaseRef = ProtoUtils.getOneOfCaseMethod(containingOneof);
                final Expression fieldNumber = BytecodeUtils.constant(this.descriptor.getNumber());
                hasCheck = new BytecodeProducer(){

                    @Override
                    protected void doGen(CodeBuilder adapter) {
                        getCaseRef.invokeUnchecked(adapter);
                        adapter.visitMethodInsn(182, getCaseRef.returnType().getInternalName(), "getNumber", "()I", false);
                        fieldNumber.gen(adapter);
                        adapter.ifCmp(Type.INT_TYPE, 153, hasFieldLabel);
                    }
                };
            } else {
                final MethodRef hasMethodRef = ProtoUtils.getHasserMethod(this.descriptor);
                hasCheck = new BytecodeProducer(){

                    @Override
                    protected void doGen(CodeBuilder adapter) {
                        hasMethodRef.invokeUnchecked(adapter);
                        adapter.ifZCmp(154, hasFieldLabel);
                    }
                };
            }
            final Label endLabel = new Label();
            SoyExpression interpretedField = this.interpretField(new Expression(getMethodRef.returnType(), getMethodRef.features().minus(Expression.Feature.NON_NULLABLE)){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    typedBaseExpr.gen(adapter);
                    adapter.dup();
                    hasCheck.gen(adapter);
                    adapter.pop();
                    adapter.visitInsn(1);
                    adapter.goTo(endLabel);
                    adapter.mark(hasFieldLabel);
                    getMethodRef.invokeUnchecked(adapter);
                }
            });
            if (BytecodeUtils.isPrimitive(interpretedField.resultType())) {
                interpretedField = interpretedField.box();
            }
            return interpretedField.labelEnd(endLabel).asNullable();
        }

        private SoyExpression handleMapField(SoyExpression typedBaseExpr, MethodRef getMethodRef) {
            List mapFields = this.descriptor.getMessageType().getFields();
            Descriptors.FieldDescriptor keyDescriptor = (Descriptors.FieldDescriptor)mapFields.get(0);
            Descriptors.FieldDescriptor valueDescriptor = (Descriptors.FieldDescriptor)mapFields.get(1);
            return SoyExpression.forMap((MapType)this.fieldType, MethodRef.LAZY_PROTO_TO_SOY_VALUE_MAP_FOR_MAP.invoke(typedBaseExpr.invoke(getMethodRef, new Expression[0]), FieldVisitor.visitField(keyDescriptor, REPEATED_FIELD_INTERPRETER), FieldVisitor.visitField(valueDescriptor, REPEATED_FIELD_INTERPRETER), BytecodeUtils.constant(AccessorGenerator.getKeyType(keyDescriptor))));
        }

        private static final Type getKeyType(Descriptors.FieldDescriptor keyDescriptor) {
            switch (keyDescriptor.getJavaType()) {
                case INT: {
                    return BytecodeUtils.INTEGER_TYPE;
                }
                case LONG: {
                    return BytecodeUtils.BOXED_LONG_TYPE;
                }
                case BOOLEAN: {
                    return BytecodeUtils.BOXED_BOOLEAN_TYPE;
                }
                case STRING: {
                    return BytecodeUtils.STRING_TYPE;
                }
            }
            throw new AssertionError((Object)("Invalid proto map key type: " + keyDescriptor));
        }

        private SoyExpression interpretField(Expression field) {
            switch (this.descriptor.getJavaType()) {
                case FLOAT: {
                    return SoyExpression.forFloat(BytecodeUtils.numericConversion(field, Type.DOUBLE_TYPE));
                }
                case DOUBLE: {
                    return SoyExpression.forFloat(field);
                }
                case ENUM: {
                    if (ProtoUtils.isProto3EnumField(this.descriptor)) {
                        return SoyExpression.forInt(BytecodeUtils.numericConversion(field, Type.LONG_TYPE));
                    }
                    return SoyExpression.forInt(BytecodeUtils.numericConversion(field.invoke(MethodRef.PROTOCOL_ENUM_GET_NUMBER, new Expression[0]), Type.LONG_TYPE));
                }
                case INT: {
                    if (com.google.template.soy.internal.proto.ProtoUtils.isUnsigned(this.descriptor)) {
                        return SoyExpression.forInt(MethodRef.UNSIGNED_INTS_TO_LONG.invoke(field));
                    }
                    return SoyExpression.forInt(BytecodeUtils.numericConversion(field, Type.LONG_TYPE));
                }
                case LONG: {
                    if (ProtoUtils.shouldConvertBetweenStringAndLong(this.descriptor)) {
                        if (com.google.template.soy.internal.proto.ProtoUtils.isUnsigned(this.descriptor)) {
                            return SoyExpression.forString(MethodRef.UNSIGNED_LONGS_TO_STRING.invoke(field));
                        }
                        return SoyExpression.forString(MethodRef.LONG_TO_STRING.invoke(field));
                    }
                    return SoyExpression.forInt(field);
                }
                case BOOLEAN: {
                    return SoyExpression.forBool(field);
                }
                case STRING: {
                    return SoyExpression.forString(field);
                }
                case MESSAGE: {
                    return this.messageToSoyExpression(field);
                }
                case BYTE_STRING: {
                    return this.byteStringToBase64String(field);
                }
            }
            throw new AssertionError((Object)("unsupported field type: " + this.descriptor));
        }

        private SoyExpression handleExtension(final SoyExpression typedBaseExpr) {
            FieldRef extensionField = ProtoUtils.getExtensionField(this.descriptor);
            final Expression extensionFieldAccessor = extensionField.accessor();
            if (this.descriptor.isRepeated()) {
                return SoyExpression.forBoxedList((ListType)this.fieldType, MethodRef.GET_EXTENSION_LIST.invoke(typedBaseExpr, extensionFieldAccessor, FieldVisitor.visitField(this.descriptor, REPEATED_FIELD_INTERPRETER)));
            }
            if (!this.descriptor.hasDefaultValue() && this.shouldCheckForFieldPresence) {
                final Label endLabel = new Label();
                SoyExpression interpretedField = this.interpretExtensionField(new Expression(EXTENDABLE_MESSAGE_GET_EXTENSION.returnType(), EXTENDABLE_MESSAGE_GET_EXTENSION.features().minus(Expression.Feature.NON_NULLABLE)){

                    @Override
                    protected void doGen(CodeBuilder adapter) {
                        typedBaseExpr.gen(adapter);
                        adapter.dup();
                        extensionFieldAccessor.gen(adapter);
                        EXTENDABLE_MESSAGE_HAS_EXTENSION.invokeUnchecked(adapter);
                        Label hasFieldLabel = new Label();
                        adapter.ifZCmp(154, hasFieldLabel);
                        adapter.pop();
                        adapter.visitInsn(1);
                        adapter.goTo(endLabel);
                        adapter.mark(hasFieldLabel);
                        extensionFieldAccessor.gen(adapter);
                        EXTENDABLE_MESSAGE_GET_EXTENSION.invokeUnchecked(adapter);
                    }
                });
                if (BytecodeUtils.isPrimitive(interpretedField.resultType())) {
                    interpretedField = interpretedField.box();
                }
                return interpretedField.labelEnd(endLabel).asNullable();
            }
            return this.interpretExtensionField(typedBaseExpr.invoke(EXTENDABLE_MESSAGE_GET_EXTENSION, extensionFieldAccessor));
        }

        private SoyExpression interpretExtensionField(Expression field) {
            switch (this.descriptor.getJavaType()) {
                case FLOAT: 
                case DOUBLE: {
                    return SoyExpression.forFloat(field.checkedCast(Number.class).invoke(MethodRef.NUMBER_DOUBLE_VALUE, new Expression[0]));
                }
                case ENUM: {
                    return SoyExpression.forInt(BytecodeUtils.numericConversion(field.checkedCast(ProtocolMessageEnum.class).invoke(MethodRef.PROTOCOL_ENUM_GET_NUMBER, new Expression[0]), Type.LONG_TYPE));
                }
                case INT: {
                    if (com.google.template.soy.internal.proto.ProtoUtils.isUnsigned(this.descriptor)) {
                        return SoyExpression.forInt(MethodRef.UNSIGNED_INTS_TO_LONG.invoke(field.checkedCast(Integer.class).invoke(MethodRef.NUMBER_INT_VALUE, new Expression[0])));
                    }
                    return SoyExpression.forInt(field.checkedCast(Integer.class).invoke(MethodRef.NUMBER_LONG_VALUE, new Expression[0]));
                }
                case LONG: {
                    if (ProtoUtils.shouldConvertBetweenStringAndLong(this.descriptor)) {
                        if (com.google.template.soy.internal.proto.ProtoUtils.isUnsigned(this.descriptor)) {
                            return SoyExpression.forString(MethodRef.UNSIGNED_LONGS_TO_STRING.invoke(field.checkedCast(Long.class).invoke(MethodRef.NUMBER_LONG_VALUE, new Expression[0])));
                        }
                        return SoyExpression.forString(field.invoke(MethodRef.OBJECT_TO_STRING, new Expression[0]));
                    }
                    return SoyExpression.forInt(field.checkedCast(Number.class).invoke(MethodRef.NUMBER_LONG_VALUE, new Expression[0]));
                }
                case BOOLEAN: {
                    return SoyExpression.forBool(field.checkedCast(Boolean.class).invoke(MethodRef.BOOLEAN_VALUE, new Expression[0]));
                }
                case STRING: {
                    return SoyExpression.forString(field.checkedCast(String.class));
                }
                case MESSAGE: {
                    Type javaType = SoyRuntimeType.protoType(this.descriptor.getMessageType());
                    return this.messageToSoyExpression(field.checkedCast(javaType));
                }
                case BYTE_STRING: {
                    return this.byteStringToBase64String(field.checkedCast(ByteString.class));
                }
            }
            throw new AssertionError((Object)("unsupported field type: " + this.descriptor));
        }

        private SoyExpression byteStringToBase64String(Expression byteString) {
            byteString.checkAssignableTo(BYTE_STRING_TYPE);
            final Expression byteArray = byteString.invoke(BYTE_STRING_TO_BYTE_ARRAY, new Expression[0]);
            return SoyExpression.forString(new Expression(BytecodeUtils.STRING_TYPE, Expression.Feature.NON_NULLABLE, new Expression.Feature[0]){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    byteArray.gen(adapter);
                    BASE_ENCODING_BASE_64.invokeUnchecked(adapter);
                    adapter.swap();
                    BASE_ENCODING_ENCODE.invokeUnchecked(adapter);
                }
            });
        }

        private SoyExpression messageToSoyExpression(Expression field) {
            if (this.fieldType.getKind() == SoyType.Kind.PROTO) {
                SoyProtoType fieldProtoType = (SoyProtoType)this.fieldType;
                SoyRuntimeType protoRuntimeType = SoyRuntimeType.getUnboxedType(fieldProtoType).get();
                return SoyExpression.forProto(protoRuntimeType, field);
            }
            Descriptors.Descriptor messageType = this.descriptor.getMessageType();
            MethodRef fromProtoMethod = (MethodRef)SAFE_PROTO_TO_SANITIZED_CONTENT.get((Object)messageType.getFullName());
            return SoyExpression.forSoyValue(this.fieldType, fromProtoMethod.invoke(field));
        }
    }

    private static abstract class BaseGenerator {
        final SoyRuntimeType unboxedRuntimeType;
        final SoyExpression baseExpr;

        public BaseGenerator(SoyRuntimeType unboxedRuntimeType, SoyExpression baseExpr) {
            this.unboxedRuntimeType = unboxedRuntimeType;
            this.baseExpr = baseExpr;
        }

        SoyExpression getTypedBaseExpression() {
            if (this.baseExpr.isBoxed()) {
                return SoyExpression.forProto(this.unboxedRuntimeType, this.baseExpr.invoke(MethodRef.SOY_PROTO_VALUE_GET_PROTO, new Expression[0]).checkedCast(this.unboxedRuntimeType.runtimeType()));
            }
            if (this.baseExpr.soyRuntimeType().equals(this.unboxedRuntimeType)) {
                return this.baseExpr;
            }
            throw new AssertionError((Object)"should be impossible");
        }
    }
}

