/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.jbcsrc.AppendableExpression;
import com.google.template.soy.jbcsrc.DetachState;
import com.google.template.soy.jbcsrc.ExpressionCompiler;
import com.google.template.soy.jbcsrc.ExtraCodeCompiler;
import com.google.template.soy.jbcsrc.FieldManager;
import com.google.template.soy.jbcsrc.PrintDirectives;
import com.google.template.soy.jbcsrc.TemplateParameterLookup;
import com.google.template.soy.jbcsrc.TemplateVariableManager;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.ConstructorRef;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcPrintDirective;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralCaseSpec;
import com.google.template.soy.msgs.restricted.SoyMsgPluralPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralRemainderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.msgs.restricted.SoyMsgSelectPart;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.EscapingMode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.VeLogNode;
import com.google.template.soy.types.StringType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.objectweb.asm.Label;

final class MsgCompiler {
    private static final ConstructorRef SOY_MSG_PLACEHOLDER_PART = ConstructorRef.create(SoyMsgPlaceholderPart.class, String.class);
    private static final ConstructorRef SOY_MSG_PLURAL_REMAINDER_PART = ConstructorRef.create(SoyMsgPluralRemainderPart.class, String.class);
    private static final ConstructorRef SOY_MSG_PURAL_PART = ConstructorRef.create(SoyMsgPluralPart.class, String.class, Integer.TYPE, Iterable.class);
    private static final ConstructorRef SOY_MSG_SELECT_PART = ConstructorRef.create(SoyMsgSelectPart.class, String.class, Iterable.class);
    private static final MethodRef SOY_MSG_RAW_TEXT_PART_OF = MethodRef.create(SoyMsgRawTextPart.class, "of", String.class);
    private static final MethodRef CASE_CREATE = MethodRef.create(SoyMsgPart.Case.class, "create", Object.class, Iterable.class);
    private static final ConstructorRef SOY_MSG_PLURAL_CASE_SPEC_TYPE = ConstructorRef.create(SoyMsgPluralCaseSpec.class, SoyMsgPluralCaseSpec.Type.class);
    private static final ConstructorRef SOY_MSG_PLURAL_CASE_SPEC_LONG = ConstructorRef.create(SoyMsgPluralCaseSpec.class, Long.TYPE);
    private static final ExtraCodeCompiler EXIT_LOGGABLE_ELEMENT = new ExtraCodeCompiler(){

        @Override
        public Statement compile(ExpressionCompiler exprCompiler, AppendableExpression appendable) {
            return appendable.exitLoggableElement().toStatement();
        }
    };
    private final Expression thisVar;
    private final DetachState detachState;
    private final TemplateVariableManager variables;
    private final TemplateParameterLookup parameterLookup;
    private final FieldManager fields;
    private final AppendableExpression appendableExpression;
    private final PlaceholderCompiler placeholderCompiler;

    MsgCompiler(Expression thisVar, DetachState detachState, TemplateVariableManager variables, TemplateParameterLookup parameterLookup, FieldManager fields, AppendableExpression appendableExpression, PlaceholderCompiler placeholderCompiler) {
        this.thisVar = (Expression)Preconditions.checkNotNull((Object)thisVar);
        this.detachState = (DetachState)Preconditions.checkNotNull((Object)detachState);
        this.variables = (TemplateVariableManager)Preconditions.checkNotNull((Object)variables);
        this.parameterLookup = (TemplateParameterLookup)Preconditions.checkNotNull((Object)parameterLookup);
        this.fields = (FieldManager)Preconditions.checkNotNull((Object)fields);
        this.appendableExpression = (AppendableExpression)Preconditions.checkNotNull((Object)appendableExpression);
        this.placeholderCompiler = (PlaceholderCompiler)Preconditions.checkNotNull((Object)placeholderCompiler);
    }

    Statement compileMessage(MsgUtils.MsgPartsAndIds partsAndId, MsgNode msg, ImmutableList<SoyPrintDirective> escapingDirectives) {
        Expression soyMsgDefaultParts = this.compileDefaultMessagePartsConstant(partsAndId);
        Expression soyMsgParts = msg.getAlternateId().isPresent() ? this.parameterLookup.getRenderContext().getSoyMsgPartsWithAlternateId(partsAndId.id, soyMsgDefaultParts, msg.getAlternateId().getAsLong()) : this.parameterLookup.getRenderContext().getSoyMsgParts(partsAndId.id, soyMsgDefaultParts);
        Statement printMsg = msg.isRawTextMsg() ? this.handleBasicTranslation(msg, (List<SoyPrintDirective>)escapingDirectives, soyMsgParts) : this.handleTranslationWithPlaceholders(msg, escapingDirectives, soyMsgParts, this.parameterLookup.getPluginContext().getULocale(), partsAndId);
        return Statement.concat(printMsg.withSourceLocation(msg.getSourceLocation()), this.detachState.detachLimited(this.appendableExpression));
    }

    private Expression compileDefaultMessagePartsConstant(MsgUtils.MsgPartsAndIds partsAndId) {
        return this.fields.addStaticField("msg_parts_" + partsAndId.id, this.partsToPartsList(partsAndId.parts)).accessor();
    }

    private Expression partsToPartsList(ImmutableList<SoyMsgPart> parts) throws AssertionError {
        ArrayList<Expression> partsExprs = new ArrayList<Expression>(parts.size());
        for (SoyMsgPart part : parts) {
            partsExprs.add(this.partToPartExpression(part));
        }
        return BytecodeUtils.asImmutableList(partsExprs);
    }

    private Expression partToPartExpression(SoyMsgPart part) {
        if (part instanceof SoyMsgPlaceholderPart) {
            return SOY_MSG_PLACEHOLDER_PART.construct(BytecodeUtils.constant(((SoyMsgPlaceholderPart)part).getPlaceholderName()));
        }
        if (part instanceof SoyMsgPluralPart) {
            SoyMsgPluralPart pluralPart = (SoyMsgPluralPart)part;
            ArrayList<Expression> caseExprs = new ArrayList<Expression>(pluralPart.getCases().size());
            for (SoyMsgPart.Case item : pluralPart.getCases()) {
                Expression spec = ((SoyMsgPluralCaseSpec)item.spec()).getType() == SoyMsgPluralCaseSpec.Type.EXPLICIT ? SOY_MSG_PLURAL_CASE_SPEC_LONG.construct(BytecodeUtils.constant(((SoyMsgPluralCaseSpec)item.spec()).getExplicitValue())) : SOY_MSG_PLURAL_CASE_SPEC_TYPE.construct(FieldRef.enumReference(((SoyMsgPluralCaseSpec)item.spec()).getType()).accessor());
                caseExprs.add(CASE_CREATE.invoke(spec, this.partsToPartsList(item.parts())));
            }
            return SOY_MSG_PURAL_PART.construct(BytecodeUtils.constant(pluralPart.getPluralVarName()), BytecodeUtils.constant(pluralPart.getOffset()), BytecodeUtils.asList(caseExprs));
        }
        if (part instanceof SoyMsgPluralRemainderPart) {
            return SOY_MSG_PLURAL_REMAINDER_PART.construct(BytecodeUtils.constant(((SoyMsgPluralRemainderPart)part).getPluralVarName()));
        }
        if (part instanceof SoyMsgRawTextPart) {
            return SOY_MSG_RAW_TEXT_PART_OF.invoke(BytecodeUtils.constant(((SoyMsgRawTextPart)part).getRawText(), this.fields));
        }
        if (part instanceof SoyMsgSelectPart) {
            SoyMsgSelectPart selectPart = (SoyMsgSelectPart)part;
            ArrayList<Expression> caseExprs = new ArrayList<Expression>(selectPart.getCases().size());
            for (SoyMsgPart.Case item : selectPart.getCases()) {
                caseExprs.add(CASE_CREATE.invoke(item.spec() == null ? BytecodeUtils.constantNull(BytecodeUtils.STRING_TYPE) : BytecodeUtils.constant((String)item.spec()), this.partsToPartsList(item.parts())));
            }
            return SOY_MSG_SELECT_PART.construct(BytecodeUtils.constant(selectPart.getSelectVarName()), BytecodeUtils.asList(caseExprs));
        }
        throw new AssertionError((Object)("unrecognized part: " + part));
    }

    private Statement handleBasicTranslation(MsgNode msg, List<SoyPrintDirective> escapingDirectives, Expression soyMsgParts) {
        SoyExpression text = SoyExpression.forString(soyMsgParts.invoke(MethodRef.LIST_GET, BytecodeUtils.constant(0)).checkedCast(SoyMsgRawTextPart.class).invoke(MethodRef.SOY_MSG_RAW_TEXT_PART_GET_RAW_TEXT, new Expression[0]));
        if (msg.getEscapingMode() == EscapingMode.ESCAPE_HTML) {
            text = SoyExpression.forString(MethodRef.MSG_RENDERER_ESCAPE_HTML.invoke(text));
        }
        for (SoyPrintDirective directive : escapingDirectives) {
            text = this.parameterLookup.getRenderContext().applyPrintDirective(directive, text);
        }
        return this.appendableExpression.appendString(text.coerceToString()).toStatement();
    }

    private Statement handleTranslationWithPlaceholders(MsgNode msg, ImmutableList<SoyPrintDirective> escapingDirectives, Expression soyMsgParts, Expression locale, MsgUtils.MsgPartsAndIds partsAndId) {
        Statement render;
        LinkedHashMap<String, Function<Expression, Statement>> placeholderNameToPutStatement = new LinkedHashMap<String, Function<Expression, Statement>>();
        this.putPlaceholdersIntoMap(msg, (Iterable<? extends SoyMsgPart>)partsAndId.parts, (Map<String, Function<Expression, Statement>>)placeholderNameToPutStatement);
        Preconditions.checkState((!placeholderNameToPutStatement.isEmpty() ? 1 : 0) != 0);
        ConstructorRef cstruct = msg.isPlrselMsg() ? ConstructorRef.PLRSEL_MSG_RENDERER : ConstructorRef.MSG_RENDERER;
        Statement initRendererStatement = this.fields.getCurrentRenderee().putInstanceField(this.thisVar, cstruct.construct(BytecodeUtils.constant(partsAndId.id), soyMsgParts, locale, BytecodeUtils.constant(placeholderNameToPutStatement.size()), BytecodeUtils.constant(msg.getEscapingMode() == EscapingMode.ESCAPE_HTML)));
        ArrayList<Statement> initializationStatements = new ArrayList<Statement>();
        initializationStatements.add(initRendererStatement);
        for (Function fn : placeholderNameToPutStatement.values()) {
            initializationStatements.add((Statement)fn.apply((Object)this.fields.getCurrentRenderee().accessor(this.thisVar)));
        }
        Statement initMsgRenderer = Statement.concat(initializationStatements);
        if (PrintDirectives.areAllPrintDirectivesStreamable(escapingDirectives)) {
            Statement initAppendable = Statement.NULL_STATEMENT;
            Statement clearAppendable = Statement.NULL_STATEMENT;
            Expression appendable = this.appendableExpression;
            if (!escapingDirectives.isEmpty()) {
                SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions wrappedAppendable = PrintDirectives.applyStreamingEscapingDirectives(escapingDirectives, appendable, this.parameterLookup.getPluginContext(), this.variables);
                FieldRef currentAppendableField = this.fields.getCurrentAppendable();
                initAppendable = currentAppendableField.putInstanceField(this.thisVar, wrappedAppendable.appendable());
                appendable = currentAppendableField.accessor(this.thisVar);
                clearAppendable = currentAppendableField.putInstanceField(this.thisVar, BytecodeUtils.constantNull(BytecodeUtils.LOGGING_ADVISING_APPENDABLE_TYPE));
                if (wrappedAppendable.closeable()) {
                    clearAppendable = Statement.concat(this.appendableExpression.checkedCast(BytecodeUtils.CLOSEABLE_TYPE).invokeVoid(MethodRef.CLOSEABLE_CLOSE, new Expression[0]), clearAppendable);
                }
            }
            render = Statement.concat(initAppendable, this.detachState.detachForRender(this.fields.getCurrentRenderee().accessor(this.thisVar).invoke(MethodRef.SOY_VALUE_PROVIDER_RENDER_AND_RESOLVE, appendable, BytecodeUtils.constant(true))), clearAppendable);
        } else {
            Label start = new Label();
            SoyExpression value = SoyExpression.forSoyValue(StringType.getInstance(), this.detachState.createExpressionDetacher(start).resolveSoyValueProvider(this.fields.getCurrentRenderee().accessor(this.thisVar)).checkedCast(BytecodeUtils.SOY_STRING_TYPE));
            for (SoyPrintDirective directive : escapingDirectives) {
                value = this.parameterLookup.getRenderContext().applyPrintDirective(directive, value);
            }
            render = this.appendableExpression.appendString(value.unboxAsString()).toStatement().labelStart(start);
        }
        return Statement.concat(initMsgRenderer, render, this.fields.getCurrentRenderee().putInstanceField(this.thisVar, BytecodeUtils.constantNull(ConstructorRef.MSG_RENDERER.instanceClass().type())));
    }

    private void putPlaceholdersIntoMap(MsgNode originalMsg, Iterable<? extends SoyMsgPart> parts, Map<String, Function<Expression, Statement>> placeholderNameToPutStatement) {
        for (SoyMsgPart soyMsgPart : parts) {
            if (soyMsgPart instanceof SoyMsgRawTextPart || soyMsgPart instanceof SoyMsgPluralRemainderPart) continue;
            if (soyMsgPart instanceof SoyMsgPluralPart) {
                this.putPluralPartIntoMap(originalMsg, placeholderNameToPutStatement, (SoyMsgPluralPart)soyMsgPart);
                continue;
            }
            if (soyMsgPart instanceof SoyMsgSelectPart) {
                this.putSelectPartIntoMap(originalMsg, placeholderNameToPutStatement, (SoyMsgSelectPart)soyMsgPart);
                continue;
            }
            if (soyMsgPart instanceof SoyMsgPlaceholderPart) {
                this.putPlaceholderIntoMap(originalMsg, placeholderNameToPutStatement, (SoyMsgPlaceholderPart)soyMsgPart);
                continue;
            }
            throw new AssertionError((Object)("unexpected child: " + soyMsgPart));
        }
    }

    private void putSelectPartIntoMap(MsgNode originalMsg, Map<String, Function<Expression, Statement>> placeholderNameToPutStatement, SoyMsgSelectPart select) {
        MsgSelectNode repSelectNode = originalMsg.getRepSelectNode(select.getSelectVarName());
        if (!placeholderNameToPutStatement.containsKey(select.getSelectVarName())) {
            Label reattachPoint = new Label();
            Expression value = this.placeholderCompiler.compileToString(repSelectNode.getExpr(), reattachPoint);
            placeholderNameToPutStatement.put(select.getSelectVarName(), this.putToMapFunction(select.getSelectVarName(), value, reattachPoint));
        }
        for (SoyMsgPart.Case caseOrDefault : select.getCases()) {
            this.putPlaceholdersIntoMap(originalMsg, (Iterable<? extends SoyMsgPart>)caseOrDefault.parts(), placeholderNameToPutStatement);
        }
    }

    private void putPluralPartIntoMap(MsgNode originalMsg, Map<String, Function<Expression, Statement>> placeholderNameToPutStatement, SoyMsgPluralPart plural) {
        MsgPluralNode repPluralNode = originalMsg.getRepPluralNode(plural.getPluralVarName());
        if (!placeholderNameToPutStatement.containsKey(plural.getPluralVarName())) {
            Label reattachPoint = new Label();
            Expression value = this.placeholderCompiler.compileToNumber(repPluralNode.getExpr(), reattachPoint);
            placeholderNameToPutStatement.put(plural.getPluralVarName(), this.putToMapFunction(plural.getPluralVarName(), value, reattachPoint));
        }
        for (SoyMsgPart.Case caseOrDefault : plural.getCases()) {
            this.putPlaceholdersIntoMap(originalMsg, (Iterable<? extends SoyMsgPart>)caseOrDefault.parts(), placeholderNameToPutStatement);
        }
    }

    private void putPlaceholderIntoMap(MsgNode originalMsg, Map<String, Function<Expression, Statement>> placeholderNameToPutStatement, SoyMsgPlaceholderPart placeholder) throws AssertionError {
        String placeholderName = placeholder.getPlaceholderName();
        if (!placeholderNameToPutStatement.containsKey(placeholderName)) {
            Function<Expression, Statement> putEntyInMap;
            MsgPlaceholderNode repPlaceholderNode = originalMsg.getRepPlaceholderNode(placeholder.getPlaceholderName());
            if (repPlaceholderNode.numChildren() == 0) {
                placeholderNameToPutStatement.put(placeholderName, this.putToMapFunction(placeholderName, FieldRef.EMPTY_STRING_DATA.accessor()));
                return;
            }
            SoyNode.StandaloneNode initialNode = (SoyNode.StandaloneNode)repPlaceholderNode.getChild(0);
            if (initialNode instanceof MsgHtmlTagNode && repPlaceholderNode.getParent().getKind() == SoyNode.Kind.VE_LOG_NODE) {
                final VeLogNode veLogNode = (VeLogNode)repPlaceholderNode.getParent();
                int childIndex = veLogNode.getChildIndex(repPlaceholderNode);
                if (childIndex == 0) {
                    ExtraCodeCompiler enterLoggableElement = new ExtraCodeCompiler(){

                        @Override
                        public Statement compile(ExpressionCompiler exprCompiler, AppendableExpression appendable) {
                            Label restartPoint = new Label();
                            SoyExpression veData = exprCompiler.compile((ExprNode)veLogNode.getVeDataExpression(), MsgCompiler.this.detachState);
                            return appendable.enterLoggableElement(MethodRef.CREATE_LOG_STATEMENT.invoke(BytecodeUtils.constant(false), veData)).toStatement().labelStart(restartPoint);
                        }
                    };
                    String closeTagPlaceholderName = originalMsg.getPlaceholder((MsgPlaceholderNode)veLogNode.getChild(veLogNode.numChildren() - 1)).name();
                    putEntyInMap = closeTagPlaceholderName.equals(placeholderName) ? this.putToMapFunction(placeholderName, this.placeholderCompiler.compileToSoyValueProvider(placeholderName, initialNode, enterLoggableElement, EXIT_LOGGABLE_ELEMENT)) : mapExpression -> mapExpression.checkedCast(ConstructorRef.MSG_RENDERER.instanceClass().type()).invokeVoid(MethodRef.MSG_RENDERER_SET_PLACEHOLDER_AND_ORDERING, BytecodeUtils.constant(placeholderName), this.placeholderCompiler.compileToSoyValueProvider(placeholderName, initialNode, enterLoggableElement, ExtraCodeCompiler.NO_OP), BytecodeUtils.constant(closeTagPlaceholderName));
                } else {
                    putEntyInMap = childIndex == veLogNode.numChildren() - 1 ? this.putToMapFunction(placeholderName, this.placeholderCompiler.compileToSoyValueProvider(placeholderName, initialNode, ExtraCodeCompiler.NO_OP, EXIT_LOGGABLE_ELEMENT)) : this.addNodeToPlaceholderMap(placeholderName, initialNode);
                }
            } else if (initialNode instanceof MsgHtmlTagNode || initialNode instanceof CallNode || initialNode instanceof PrintNode || initialNode instanceof RawTextNode) {
                putEntyInMap = this.addNodeToPlaceholderMap(placeholderName, initialNode);
            } else {
                throw new AssertionError((Object)("Unexpected child: " + initialNode.getClass()));
            }
            placeholderNameToPutStatement.put(placeholderName, putEntyInMap);
        }
    }

    private Function<Expression, Statement> addNodeToPlaceholderMap(String mapKey, SoyNode.StandaloneNode node) {
        return this.putToMapFunction(mapKey, this.placeholderCompiler.compileToSoyValueProvider(mapKey, node, ExtraCodeCompiler.NO_OP, ExtraCodeCompiler.NO_OP));
    }

    private Function<Expression, Statement> putToMapFunction(String mapKey, Expression valueExpression) {
        return this.putToMapFunction(mapKey, valueExpression, null);
    }

    private Function<Expression, Statement> putToMapFunction(String mapKey, Expression valueExpression, @Nullable Label labelStart) {
        return mapExpression -> {
            Statement statement = mapExpression.checkedCast(ConstructorRef.MSG_RENDERER.instanceClass().type()).invokeVoid(MethodRef.MSG_RENDERER_SET_PLACEHOLDER, BytecodeUtils.constant(mapKey), valueExpression);
            if (labelStart != null) {
                statement = statement.labelStart(labelStart);
            }
            return statement;
        };
    }

    static interface PlaceholderCompiler {
        public Expression compileToString(ExprRootNode var1, Label var2);

        public Expression compileToNumber(ExprRootNode var1, Label var2);

        public Expression compileToSoyValueProvider(String var1, SoyNode.StandaloneNode var2, ExtraCodeCompiler var3, ExtraCodeCompiler var4);
    }
}

