/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.template.soy.base.internal.UniqueNameGenerator;
import com.google.template.soy.jbcsrc.AutoValue_FieldManager_StaticFieldVariable;
import com.google.template.soy.jbcsrc.internal.JbcSrcNameGenerators;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.ClassFieldManager;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

final class FieldManager
implements ClassFieldManager {
    private final UniqueNameGenerator fieldNames = JbcSrcNameGenerators.forFieldNames();
    private final TypeInfo owner;
    private final List<FieldRef> fields = new ArrayList<FieldRef>();
    private final List<StaticFieldVariable> staticFields = new ArrayList<StaticFieldVariable>();
    @Nullable
    private FieldRef currentCalleeField;
    @Nullable
    private FieldRef currentRendereeField;
    @Nullable
    private FieldRef currentAppendable;
    private boolean definedFields = false;

    FieldManager(TypeInfo owner) {
        this.owner = owner;
        this.fieldNames.claimName("$currentCallee");
        this.fieldNames.claimName("$currentRenderee");
        this.fieldNames.claimName("$currentAppendable");
    }

    FieldRef addGeneratedField(String suggestedName, Type type) {
        String name = this.fieldNames.generateName(suggestedName);
        return this.doAddField(name, type, 2);
    }

    FieldRef addGeneratedFinalField(String suggestedName, Type type) {
        String name = this.fieldNames.generateName(suggestedName);
        return this.doAddField(name, type, 18);
    }

    FieldRef addField(String name, Type type) {
        this.fieldNames.claimName(name);
        return this.doAddField(name, type, 2);
    }

    FieldRef addFinalField(String name, Type type) {
        this.fieldNames.claimName(name);
        return this.doAddField(name, type, 18);
    }

    private FieldRef doAddField(String name, Type type, int modifiers) {
        Preconditions.checkState((!this.definedFields ? 1 : 0) != 0);
        FieldRef field = FieldRef.create(this.owner, name, type, modifiers);
        this.fields.add(field);
        return field;
    }

    @Override
    public FieldRef addStaticField(String proposedName, Expression initializer) {
        return this.addStaticField(proposedName, initializer, 26);
    }

    private FieldRef addStaticField(String proposedName, Expression initializer, int accessFlags) {
        String name = this.fieldNames.generateName(proposedName);
        FieldRef ref = this.doAddField(name, initializer.resultType(), accessFlags);
        if (initializer.isNonNullable()) {
            ref = ref.asNonNull();
        }
        this.staticFields.add(new AutoValue_FieldManager_StaticFieldVariable(ref, initializer));
        return ref;
    }

    FieldRef addPackagePrivateStaticField(String proposedName, Expression initializer) {
        return this.addStaticField(proposedName, initializer, 24);
    }

    void defineFields(ClassVisitor writer) {
        Preconditions.checkState((!this.definedFields ? 1 : 0) != 0);
        this.definedFields = true;
        for (FieldRef field : this.fields) {
            field.defineField(writer);
        }
    }

    void defineStaticInitializer(ClassVisitor writer) {
        Preconditions.checkState((boolean)this.definedFields);
        if (this.staticFields.isEmpty()) {
            return;
        }
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (StaticFieldVariable staticField : this.staticFields) {
            statements.add(staticField.field().putStaticField(staticField.initializer()));
        }
        statements.add(Statement.RETURN);
        Statement.concat(statements).writeMethod(8, BytecodeUtils.CLASS_INIT, writer);
    }

    FieldRef getCurrentCalleeField() {
        FieldRef local = this.currentCalleeField;
        if (local == null) {
            local = this.currentCalleeField = this.doAddField("$currentCallee", BytecodeUtils.COMPILED_TEMPLATE_TYPE, 2);
        }
        return local;
    }

    FieldRef getCurrentRenderee() {
        FieldRef local = this.currentRendereeField;
        if (local == null) {
            local = this.currentRendereeField = this.doAddField("$currentRenderee", BytecodeUtils.SOY_VALUE_PROVIDER_TYPE, 2);
        }
        return local;
    }

    FieldRef getCurrentAppendable() {
        FieldRef local = this.currentAppendable;
        if (local == null) {
            local = this.currentAppendable = this.doAddField("$currentAppendable", BytecodeUtils.LOGGING_ADVISING_APPENDABLE_TYPE, 2);
        }
        return local;
    }

    @AutoValue
    static abstract class StaticFieldVariable {
        StaticFieldVariable() {
        }

        abstract FieldRef field();

        abstract Expression initializer();
    }
}

