/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.internal.RuntimeMapTypeTracker;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.AbstractLocalVarDefn;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListComprehensionNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.NullSafeAccessNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.exprtree.VeLiteralNode;
import com.google.template.soy.jbcsrc.AbstractTemplateParameterLookup;
import com.google.template.soy.jbcsrc.CompiledTemplateRegistry;
import com.google.template.soy.jbcsrc.EnhancedAbstractExprNodeVisitor;
import com.google.template.soy.jbcsrc.ExpressionDetacher;
import com.google.template.soy.jbcsrc.FieldManager;
import com.google.template.soy.jbcsrc.JbcSrcValueFactory;
import com.google.template.soy.jbcsrc.LocalVariableManager;
import com.google.template.soy.jbcsrc.ProtoUtils;
import com.google.template.soy.jbcsrc.RenderContextExpression;
import com.google.template.soy.jbcsrc.SyntheticVarName;
import com.google.template.soy.jbcsrc.TemplateParameterLookup;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.ConstructorRef;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.LocalVariable;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyRuntimeType;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.jbcsrc.shared.LegacyFunctionAdapter;
import com.google.template.soy.jbcsrc.shared.TemplateCallFactory;
import com.google.template.soy.logging.ValidatedLoggingConfig;
import com.google.template.soy.plugin.internal.JavaPluginExecContext;
import com.google.template.soy.plugin.java.internal.PluginAnalyzer;
import com.google.template.soy.plugin.java.restricted.SoyJavaSourceFunction;
import com.google.template.soy.shared.internal.BuiltinMethod;
import com.google.template.soy.shared.restricted.SoyMethod;
import com.google.template.soy.shared.restricted.SoySourceFunctionMethod;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.defn.LocalVar;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

final class ExpressionCompiler {
    private final TemplateParameterLookup parameters;
    private final LocalVariableManager varManager;
    private final FieldManager fields;
    private final ErrorReporter reporter;
    private final SoyTypeRegistry registry;
    private final CompiledTemplateRegistry compiledTemplateRegistry;

    static ExpressionCompiler create(TemplateParameterLookup parameters, LocalVariableManager varManager, FieldManager fields, ErrorReporter reporter, SoyTypeRegistry registry, CompiledTemplateRegistry compiledTemplateRegistry) {
        return new ExpressionCompiler((TemplateParameterLookup)Preconditions.checkNotNull((Object)parameters), varManager, fields, reporter, registry, compiledTemplateRegistry);
    }

    static BasicExpressionCompiler createConstantCompiler(final LocalVariableManager varManager, FieldManager fields, ErrorReporter reporter, SoyTypeRegistry registry, CompiledTemplateRegistry compiledTemplateRegistry) {
        return new BasicExpressionCompiler(new CompilerVisitor(new AbstractTemplateParameterLookup(){

            UnsupportedOperationException unsupported() {
                return new UnsupportedOperationException("This method isn't supported in constant context");
            }

            @Override
            FieldRef getParamField(TemplateParam param) {
                throw this.unsupported();
            }

            @Override
            FieldRef getParamsRecordField() {
                throw this.unsupported();
            }

            @Override
            FieldRef getIjRecordField() {
                throw this.unsupported();
            }

            @Override
            Expression getCompiledTemplate() {
                throw this.unsupported();
            }

            @Override
            public Expression getLocal(AbstractLocalVarDefn<?> local) {
                return varManager.getVariable(local.name());
            }

            @Override
            public Expression getLocal(SyntheticVarName varName) {
                throw this.unsupported();
            }

            @Override
            public RenderContextExpression getRenderContext() {
                throw this.unsupported();
            }
        }, varManager, fields, ExpressionDetacher.NullDetatcher.INSTANCE, reporter, registry, compiledTemplateRegistry));
    }

    static BasicExpressionCompiler createBasicCompiler(TemplateParameterLookup parameters, LocalVariableManager varManager, FieldManager fields, ErrorReporter reporter, SoyTypeRegistry registry, CompiledTemplateRegistry compiledTemplateRegistry) {
        return new BasicExpressionCompiler(parameters, varManager, fields, reporter, registry, compiledTemplateRegistry);
    }

    static boolean canCompileToConstant(ExprRootNode expr) {
        return (Boolean)CanCompileToConstantVisitor.INSTANCE.exec(expr);
    }

    private ExpressionCompiler(TemplateParameterLookup parameters, LocalVariableManager varManager, FieldManager fields, ErrorReporter reporter, SoyTypeRegistry registry, CompiledTemplateRegistry compiledTemplateRegistry) {
        this.parameters = (TemplateParameterLookup)Preconditions.checkNotNull((Object)parameters);
        this.varManager = (LocalVariableManager)Preconditions.checkNotNull((Object)varManager);
        this.fields = (FieldManager)Preconditions.checkNotNull((Object)fields);
        this.reporter = reporter;
        this.registry = registry;
        this.compiledTemplateRegistry = compiledTemplateRegistry;
    }

    SoyExpression compile(ExprNode node, ExpressionDetacher detacher) {
        return this.asBasicCompiler(detacher).compile(node);
    }

    SoyExpression compile(ExprNode node, ExpressionDetacher.Factory detacherFactory) {
        Label reattachPoint = new Label();
        SoyExpression exec = this.compile(node, detacherFactory.createExpressionDetacher(reattachPoint));
        return exec.withSource(exec.labelStart(reattachPoint));
    }

    Optional<SoyExpression> compileWithNoDetaches(ExprNode node) {
        Preconditions.checkNotNull((Object)node);
        if (((Boolean)RequiresDetachVisitor.INSTANCE.exec(node)).booleanValue()) {
            return Optional.empty();
        }
        return Optional.of((SoyExpression)new CompilerVisitor(this.parameters, this.varManager, this.fields, null, this.reporter, this.registry, this.compiledTemplateRegistry).exec(node));
    }

    BasicExpressionCompiler asBasicCompiler(ExpressionDetacher detacher) {
        return new BasicExpressionCompiler(new CompilerVisitor(this.parameters, this.varManager, this.fields, detacher, this.reporter, this.registry, this.compiledTemplateRegistry));
    }

    private static final class RequiresDetachVisitor
    extends EnhancedAbstractExprNodeVisitor<Boolean> {
        static final RequiresDetachVisitor INSTANCE = new RequiresDetachVisitor();

        private RequiresDetachVisitor() {
        }

        @Override
        Boolean visitForLoopVar(VarRefNode varRef, LocalVar local) {
            return true;
        }

        @Override
        protected Boolean visitListComprehensionNode(ListComprehensionNode node) {
            return true;
        }

        @Override
        Boolean visitParam(VarRefNode varRef, TemplateParam param) {
            return true;
        }

        @Override
        Boolean visitLetNodeVar(VarRefNode node, LocalVar local) {
            return true;
        }

        @Override
        protected Boolean visitMethodCallNode(MethodCallNode node) {
            if (node.getMethodName().toString().equals("bind")) {
                for (Boolean childRequiresDetach : this.visitChildren(node)) {
                    if (!childRequiresDetach.booleanValue()) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        @Override
        protected Boolean visitDataAccessNode(DataAccessNode node) {
            return true;
        }

        @Override
        protected Boolean visitProtoInitNode(ProtoInitNode node) {
            for (Boolean i : this.visitChildren(node)) {
                if (!i.booleanValue()) continue;
                return true;
            }
            SoyProtoType protoType = (SoyProtoType)node.getType();
            for (Identifier paramName : node.getParamNames()) {
                if (!protoType.getFieldDescriptor(paramName.identifier()).isRepeated()) continue;
                return true;
            }
            return false;
        }

        @Override
        protected Boolean visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                for (Boolean i : this.visitChildren((ExprNode.ParentExprNode)node)) {
                    if (!i.booleanValue()) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class CanCompileToConstantVisitor
    extends AbstractReturningExprNodeVisitor<Boolean> {
        static final CanCompileToConstantVisitor INSTANCE = new CanCompileToConstantVisitor();

        private CanCompileToConstantVisitor() {
        }

        @Override
        protected Boolean visitExprRootNode(ExprRootNode node) {
            return this.areAllChildrenConstant(node);
        }

        @Override
        protected Boolean visitVarRefNode(VarRefNode node) {
            switch (node.getDefnDecl().kind()) {
                case COMPREHENSION_VAR: {
                    return true;
                }
                case PARAM: 
                case LOCAL_VAR: 
                case STATE: {
                    return false;
                }
            }
            throw new AssertionError();
        }

        @Override
        protected Boolean visitPrimitiveNode(ExprNode.PrimitiveNode node) {
            return true;
        }

        @Override
        protected Boolean visitVeLiteralNode(VeLiteralNode node) {
            return true;
        }

        @Override
        protected Boolean visitTemplateLiteralNode(TemplateLiteralNode node) {
            return false;
        }

        @Override
        protected Boolean visitGlobalNode(GlobalNode node) {
            return true;
        }

        @Override
        protected Boolean visitListLiteralNode(ListLiteralNode node) {
            return this.areAllChildrenConstant(node);
        }

        @Override
        protected Boolean visitListComprehensionNode(ListComprehensionNode node) {
            return this.areAllChildrenConstant(node);
        }

        @Override
        protected Boolean visitRecordLiteralNode(RecordLiteralNode node) {
            return this.areAllChildrenConstant(node);
        }

        @Override
        protected Boolean visitMapLiteralNode(MapLiteralNode node) {
            return this.areAllChildrenConstant(node);
        }

        @Override
        protected Boolean visitProtoInitNode(ProtoInitNode node) {
            return this.areAllChildrenConstant(node);
        }

        @Override
        protected Boolean visitMethodCallNode(MethodCallNode node) {
            if (node.getMethodName().toString().equals("bind")) {
                return this.areAllChildrenConstant(node);
            }
            return false;
        }

        @Override
        protected Boolean visitDataAccessNode(DataAccessNode node) {
            return false;
        }

        @Override
        protected Boolean visitNullSafeAccessNode(NullSafeAccessNode node) {
            return (Boolean)this.visit(node.getBase()) != false && this.areAllChildrenConstant(node);
        }

        @Override
        protected Boolean visitOperatorNode(ExprNode.OperatorNode node) {
            return this.areAllChildrenConstant(node);
        }

        @Override
        protected Boolean visitFunctionNode(FunctionNode node) {
            if (!this.areAllChildrenConstant(node)) {
                return false;
            }
            if (!node.isPure()) {
                return false;
            }
            if (node.getSoyFunction() instanceof SoyJavaSourceFunction) {
                try {
                    PluginAnalyzer.PluginMetadata metadata = PluginAnalyzer.analyze((SoyJavaSourceFunction)node.getSoyFunction());
                    return metadata.pluginInstanceNames().isEmpty() && !metadata.accessesContext();
                }
                catch (Throwable ignored) {
                    return false;
                }
            }
            return false;
        }

        private boolean areAllChildrenConstant(ExprNode.ParentExprNode node) {
            for (ExprNode child : node.getChildren()) {
                if (((Boolean)this.visit(child)).booleanValue()) continue;
                return false;
            }
            return true;
        }
    }

    private static final class CompilerVisitor
    extends EnhancedAbstractExprNodeVisitor<SoyExpression> {
        @Nullable
        final ExpressionDetacher detacher;
        final TemplateParameterLookup parameters;
        final LocalVariableManager varManager;
        final FieldManager fields;
        final ErrorReporter reporter;
        final SoyTypeRegistry registry;
        final CompiledTemplateRegistry compiledTemplateRegistry;
        private static final Handle GETFACTORY_HANDLE = MethodRef.create(TemplateCallFactory.class, "bootstrapFactoryLookup", MethodHandles.Lookup.class, String.class, MethodType.class, String.class).asHandle();
        private static final String TEMPLATE_FACTORY_SIGNATURE = Type.getMethodDescriptor((Type)BytecodeUtils.COMPILED_TEMPLATE_FACTORY_TYPE, (Type[])new Type[]{BytecodeUtils.RENDER_CONTEXT_TYPE});

        CompilerVisitor(TemplateParameterLookup parameters, LocalVariableManager varManager, FieldManager fields, ExpressionDetacher detacher, ErrorReporter reporter, SoyTypeRegistry registry, CompiledTemplateRegistry compiledTemplateRegistry) {
            this.detacher = detacher;
            this.parameters = parameters;
            this.varManager = varManager;
            this.fields = fields;
            this.reporter = reporter;
            this.registry = registry;
            this.compiledTemplateRegistry = compiledTemplateRegistry;
        }

        @Override
        protected final SoyExpression visit(ExprNode node) {
            return ((SoyExpression)super.visit(node)).withSourceLocation(node.getSourceLocation());
        }

        @Override
        protected final SoyExpression visitExprRootNode(ExprRootNode node) {
            return this.visit(node.getRoot());
        }

        @Override
        protected final SoyExpression visitNullNode(NullNode node) {
            return SoyExpression.NULL;
        }

        @Override
        protected final SoyExpression visitFloatNode(FloatNode node) {
            return SoyExpression.forFloat(BytecodeUtils.constant(node.getValue()));
        }

        @Override
        protected final SoyExpression visitStringNode(StringNode node) {
            return SoyExpression.forString(BytecodeUtils.constant(node.getValue(), this.fields));
        }

        @Override
        protected final SoyExpression visitBooleanNode(BooleanNode node) {
            return node.getValue() ? SoyExpression.TRUE : SoyExpression.FALSE;
        }

        @Override
        protected final SoyExpression visitIntegerNode(IntegerNode node) {
            return SoyExpression.forInt(BytecodeUtils.constant(node.getValue()));
        }

        @Override
        protected final SoyExpression visitGlobalNode(GlobalNode node) {
            return this.visit(node.getValue());
        }

        @Override
        protected final SoyExpression visitListLiteralNode(ListLiteralNode node) {
            return SoyExpression.forList((ListType)node.getType(), SoyExpression.asBoxedValueProviderList(this.visitChildren(node)));
        }

        @Override
        protected final SoyExpression visitListComprehensionNode(ListComprehensionNode node) {
            ExprNode listExpr = node.getListExpr();
            SoyExpression soyList = this.visit(listExpr);
            SoyExpression javaList = soyList.unboxAsList();
            ExprNode mapExpr = node.getListItemTransformExpr();
            ExprNode filterExpr = node.getFilterExpr();
            String varName = node.getListIterVar().name();
            LocalVariableManager.Scope scope = this.varManager.enterScope();
            LocalVariable listVar = scope.createTemporary(varName + "_input_list", BytecodeUtils.LIST_TYPE);
            final Statement listVarInitializer = listVar.store((Expression)javaList, listVar.start());
            final LocalVariable resultVar = scope.createTemporary(varName + "_output_list", BytecodeUtils.LIST_TYPE);
            final Statement resultVarInitializer = resultVar.store(ConstructorRef.ARRAY_LIST.construct(new Expression[0]), resultVar.start());
            final LocalVariable sizeVar = scope.createTemporary(varName + "_input_list_size", Type.INT_TYPE);
            final Statement sizeVarInitializer = sizeVar.store(listVar.invoke(MethodRef.LIST_SIZE, new Expression[0]), sizeVar.start());
            final LocalVariable indexVar = scope.createTemporary(varName + "_index", Type.INT_TYPE);
            final Statement indexVarInitializer = indexVar.store(BytecodeUtils.constant(0), indexVar.start());
            LocalVariable itemVar = scope.createNamedLocal(node.getListIterVar().name(), BytecodeUtils.SOY_VALUE_PROVIDER_TYPE);
            final Statement itemVarInitializer = itemVar.store(listVar.invoke(MethodRef.LIST_GET, indexVar).checkedCast(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE), itemVar.start());
            final LocalVariable userIndexVar = node.getIndexVar() == null ? null : scope.createNamedLocal(node.getIndexVar().name(), BytecodeUtils.SOY_VALUE_PROVIDER_TYPE);
            final Statement userIndexVarInitializer = userIndexVar == null ? null : userIndexVar.store(SoyExpression.forInt(BytecodeUtils.numericConversion(indexVar, Type.LONG_TYPE)).boxAsSoyValueProvider().checkedCast(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE), userIndexVar.start());
            final Expression visitedMap = this.visit(mapExpr).boxAsSoyValueProvider();
            final SoyExpression visitedFilter = filterExpr != null ? this.visit(filterExpr).coerceToBoolean() : null;
            final Statement exitScope = scope.exitScope();
            return SoyExpression.forList((ListType)node.getType(), new Expression(BytecodeUtils.LIST_TYPE, Expression.Feature.NON_NULLABLE, new Expression.Feature[0]){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    listVarInitializer.gen(adapter);
                    resultVarInitializer.gen(adapter);
                    sizeVarInitializer.gen(adapter);
                    indexVarInitializer.gen(adapter);
                    Label loopStart = new Label();
                    Label loopContinue = new Label();
                    Label loopEnd = new Label();
                    adapter.mark(loopStart);
                    indexVar.gen(adapter);
                    sizeVar.gen(adapter);
                    adapter.ifICmp(156, loopEnd);
                    itemVarInitializer.gen(adapter);
                    if (userIndexVar != null) {
                        userIndexVarInitializer.gen(adapter);
                    }
                    if (visitedFilter != null) {
                        visitedFilter.gen(adapter);
                        adapter.ifZCmp(153, loopContinue);
                    }
                    resultVar.gen(adapter);
                    visitedMap.gen(adapter);
                    MethodRef.ARRAY_LIST_ADD.invokeUnchecked(adapter);
                    adapter.pop();
                    adapter.mark(loopContinue);
                    adapter.iinc(indexVar.index(), 1);
                    adapter.goTo(loopStart);
                    adapter.mark(loopEnd);
                    resultVar.gen(adapter);
                    exitScope.gen(adapter);
                }
            }).box();
        }

        @Override
        protected final SoyExpression visitRecordLiteralNode(RecordLiteralNode node) {
            int numItems = node.numChildren();
            ArrayList<Expression> keys = new ArrayList<Expression>(numItems);
            ArrayList<SoyExpression> values = new ArrayList<SoyExpression>(numItems);
            for (int i = 0; i < numItems; ++i) {
                keys.add(BytecodeUtils.constant(node.getKey(i).identifier()));
                values.add(this.visit(node.getChild(i)).box());
            }
            Expression soyDict = MethodRef.DICT_IMPL_FOR_PROVIDER_MAP.invoke(BytecodeUtils.newLinkedHashMap(keys, values), FieldRef.enumReference(RuntimeMapTypeTracker.Type.LEGACY_OBJECT_MAP_OR_RECORD).accessor());
            return SoyExpression.forSoyValue(node.getType(), soyDict);
        }

        @Override
        protected final SoyExpression visitMapLiteralNode(MapLiteralNode node) {
            int numItems = node.numChildren() / 2;
            if (numItems == 0) {
                return SoyExpression.forSoyValue(node.getType(), FieldRef.EMPTY_MAP.accessor());
            }
            ArrayList<SoyExpression> keys = new ArrayList<SoyExpression>(numItems);
            ArrayList<SoyExpression> values = new ArrayList<SoyExpression>(numItems);
            for (int i = 0; i < numItems; ++i) {
                keys.add(this.visit(node.getChild(2 * i)).box());
                values.add(this.visit(node.getChild(2 * i + 1)).box());
            }
            Expression soyDict = MethodRef.MAP_IMPL_FOR_PROVIDER_MAP.invoke(BytecodeUtils.newHashMap(keys, values));
            return SoyExpression.forSoyValue(node.getType(), soyDict);
        }

        @Override
        protected final SoyExpression visitEqualOpNode(OperatorNodes.EqualOpNode node) {
            return SoyExpression.forBool(BytecodeUtils.compareSoyEquals(this.visit(node.getChild(0)), this.visit(node.getChild(1))));
        }

        @Override
        protected final SoyExpression visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
            return SoyExpression.forBool(BytecodeUtils.logicalNot(BytecodeUtils.compareSoyEquals(this.visit(node.getChild(0)), this.visit(node.getChild(1)))));
        }

        @Override
        protected final SoyExpression visitLessThanOpNode(OperatorNodes.LessThanOpNode node) {
            SoyExpression left = this.visit(node.getChild(0));
            SoyExpression right = this.visit(node.getChild(1));
            if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
                return SoyExpression.forBool(BytecodeUtils.compare(155, left.unboxAsLong(), right.unboxAsLong()));
            }
            if (left.assignableToNullableNumber() && right.assignableToNullableNumber()) {
                return SoyExpression.forBool(BytecodeUtils.compare(155, left.coerceToDouble(), right.coerceToDouble()));
            }
            if (left.assignableToNullableString() && right.assignableToNullableString()) {
                return this.createStringComparisonOperator(155, left, right);
            }
            return SoyExpression.forBool(MethodRef.RUNTIME_LESS_THAN.invoke(left.box(), right.box()));
        }

        @Override
        protected final SoyExpression visitGreaterThanOpNode(OperatorNodes.GreaterThanOpNode node) {
            SoyExpression left = this.visit(node.getChild(0));
            SoyExpression right = this.visit(node.getChild(1));
            if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
                return SoyExpression.forBool(BytecodeUtils.compare(157, left.unboxAsLong(), right.unboxAsLong()));
            }
            if (left.assignableToNullableNumber() && right.assignableToNullableNumber()) {
                return SoyExpression.forBool(BytecodeUtils.compare(157, left.coerceToDouble(), right.coerceToDouble()));
            }
            if (left.assignableToNullableString() && right.assignableToNullableString()) {
                return this.createStringComparisonOperator(157, left, right);
            }
            return SoyExpression.forBool(MethodRef.RUNTIME_LESS_THAN.invoke(right.box(), left.box()));
        }

        @Override
        protected final SoyExpression visitLessThanOrEqualOpNode(OperatorNodes.LessThanOrEqualOpNode node) {
            SoyExpression left = this.visit(node.getChild(0));
            SoyExpression right = this.visit(node.getChild(1));
            if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
                return SoyExpression.forBool(BytecodeUtils.compare(158, left.unboxAsLong(), right.unboxAsLong()));
            }
            if (left.assignableToNullableNumber() && right.assignableToNullableNumber()) {
                return SoyExpression.forBool(BytecodeUtils.compare(158, left.coerceToDouble(), right.coerceToDouble()));
            }
            if (left.assignableToNullableString() && right.assignableToNullableString()) {
                return this.createStringComparisonOperator(158, left, right);
            }
            return SoyExpression.forBool(MethodRef.RUNTIME_LESS_THAN_OR_EQUAL.invoke(left.box(), right.box()));
        }

        @Override
        protected final SoyExpression visitGreaterThanOrEqualOpNode(OperatorNodes.GreaterThanOrEqualOpNode node) {
            SoyExpression left = this.visit(node.getChild(0));
            SoyExpression right = this.visit(node.getChild(1));
            if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
                return SoyExpression.forBool(BytecodeUtils.compare(156, left.unboxAsLong(), right.unboxAsLong()));
            }
            if (left.assignableToNullableNumber() && right.assignableToNullableNumber()) {
                return SoyExpression.forBool(BytecodeUtils.compare(156, left.coerceToDouble(), right.coerceToDouble()));
            }
            if (left.assignableToNullableString() && right.assignableToNullableString()) {
                return this.createStringComparisonOperator(156, left, right);
            }
            return SoyExpression.forBool(MethodRef.RUNTIME_LESS_THAN_OR_EQUAL.invoke(right.box(), left.box()));
        }

        private SoyExpression createStringComparisonOperator(int operator, SoyExpression left, SoyExpression right) {
            return SoyExpression.forBool(BytecodeUtils.compare(operator, left.coerceToString().invoke(MethodRef.STRING_COMPARE_TO, right.coerceToString()), BytecodeUtils.constant(0)));
        }

        @Override
        protected final SoyExpression visitPlusOpNode(OperatorNodes.PlusOpNode node) {
            SoyExpression left = this.visit(node.getChild(0));
            SoyRuntimeType leftRuntimeType = left.soyRuntimeType();
            SoyExpression right = this.visit(node.getChild(1));
            SoyRuntimeType rightRuntimeType = right.soyRuntimeType();
            if (leftRuntimeType.assignableToNullableNumber() && rightRuntimeType.assignableToNullableNumber()) {
                if (leftRuntimeType.assignableToNullableInt() && rightRuntimeType.assignableToNullableInt()) {
                    return CompilerVisitor.applyBinaryIntOperator(97, left, right);
                }
                if (leftRuntimeType.assignableToNullableFloat() || rightRuntimeType.assignableToNullableFloat()) {
                    return CompilerVisitor.applyBinaryFloatOperator(99, left, right);
                }
            }
            if (leftRuntimeType.isKnownString() || rightRuntimeType.isKnownString()) {
                SoyExpression leftString = left.coerceToString();
                SoyExpression rightString = right.coerceToString();
                return SoyExpression.forString(leftString.invoke(MethodRef.STRING_CONCAT, rightString));
            }
            return SoyExpression.forSoyValue(SoyTypes.NUMBER_TYPE, MethodRef.RUNTIME_PLUS.invoke(left.box(), right.box()));
        }

        @Override
        protected final SoyExpression visitMinusOpNode(OperatorNodes.MinusOpNode node) {
            SoyExpression left = this.visit(node.getChild(0));
            SoyExpression right = this.visit(node.getChild(1));
            if (left.assignableToNullableNumber() && right.assignableToNullableNumber()) {
                if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
                    return CompilerVisitor.applyBinaryIntOperator(101, left, right);
                }
                if (left.assignableToNullableFloat() || right.assignableToNullableFloat()) {
                    return CompilerVisitor.applyBinaryFloatOperator(103, left, right);
                }
            }
            return SoyExpression.forSoyValue(SoyTypes.NUMBER_TYPE, MethodRef.RUNTIME_MINUS.invoke(left.box(), right.box()));
        }

        @Override
        protected final SoyExpression visitTimesOpNode(OperatorNodes.TimesOpNode node) {
            SoyExpression left = this.visit(node.getChild(0));
            SoyExpression right = this.visit(node.getChild(1));
            if (left.assignableToNullableNumber() && right.assignableToNullableNumber()) {
                if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
                    return CompilerVisitor.applyBinaryIntOperator(105, left, right);
                }
                if (left.assignableToNullableFloat() || right.assignableToNullableFloat()) {
                    return CompilerVisitor.applyBinaryFloatOperator(107, left, right);
                }
            }
            return SoyExpression.forSoyValue(SoyTypes.NUMBER_TYPE, MethodRef.RUNTIME_TIMES.invoke(left.box(), right.box()));
        }

        @Override
        protected final SoyExpression visitDivideByOpNode(OperatorNodes.DivideByOpNode node) {
            return CompilerVisitor.applyBinaryFloatOperator(111, this.visit(node.getChild(0)), this.visit(node.getChild(1)));
        }

        @Override
        protected final SoyExpression visitModOpNode(OperatorNodes.ModOpNode node) {
            return CompilerVisitor.applyBinaryIntOperator(113, this.visit(node.getChild(0)), this.visit(node.getChild(1)));
        }

        private static SoyExpression applyBinaryIntOperator(final int operator, SoyExpression left, SoyExpression right) {
            final SoyExpression leftInt = left.unboxAsLong();
            final SoyExpression rightInt = right.unboxAsLong();
            return SoyExpression.forInt(new Expression(Type.LONG_TYPE){

                @Override
                protected void doGen(CodeBuilder mv) {
                    leftInt.gen(mv);
                    rightInt.gen(mv);
                    mv.visitInsn(operator);
                }
            });
        }

        private static SoyExpression applyBinaryFloatOperator(final int operator, SoyExpression left, SoyExpression right) {
            final SoyExpression leftFloat = left.coerceToDouble();
            final SoyExpression rightFloat = right.coerceToDouble();
            return SoyExpression.forFloat(new Expression(Type.DOUBLE_TYPE){

                @Override
                protected void doGen(CodeBuilder mv) {
                    leftFloat.gen(mv);
                    rightFloat.gen(mv);
                    mv.visitInsn(operator);
                }
            });
        }

        @Override
        protected final SoyExpression visitNegativeOpNode(OperatorNodes.NegativeOpNode node) {
            SoyExpression child = this.visit(node.getChild(0));
            if (child.assignableToNullableInt()) {
                final SoyExpression intExpr = child.unboxAsLong();
                return SoyExpression.forInt(new Expression(Type.LONG_TYPE, child.features()){

                    @Override
                    protected void doGen(CodeBuilder mv) {
                        intExpr.gen(mv);
                        mv.visitInsn(117);
                    }
                });
            }
            if (child.assignableToNullableFloat()) {
                final SoyExpression floatExpr = child.unboxAsDouble();
                return SoyExpression.forFloat(new Expression(Type.DOUBLE_TYPE, child.features()){

                    @Override
                    protected void doGen(CodeBuilder mv) {
                        floatExpr.gen(mv);
                        mv.visitInsn(119);
                    }
                });
            }
            return SoyExpression.forSoyValue(SoyTypes.NUMBER_TYPE, MethodRef.RUNTIME_NEGATIVE.invoke(child.box()));
        }

        @Override
        protected final SoyExpression visitNotOpNode(OperatorNodes.NotOpNode node) {
            return SoyExpression.forBool(BytecodeUtils.logicalNot(this.visit(node.getChild(0)).coerceToBoolean()));
        }

        @Override
        protected final SoyExpression visitAndOpNode(OperatorNodes.AndOpNode node) {
            SoyExpression left = this.visit(node.getChild(0)).coerceToBoolean();
            SoyExpression right = this.visit(node.getChild(1)).coerceToBoolean();
            return SoyExpression.forBool(BytecodeUtils.logicalAnd(left, right));
        }

        @Override
        protected final SoyExpression visitOrOpNode(OperatorNodes.OrOpNode node) {
            SoyExpression left = this.visit(node.getChild(0)).coerceToBoolean();
            SoyExpression right = this.visit(node.getChild(1)).coerceToBoolean();
            return SoyExpression.forBool(BytecodeUtils.logicalOr(left, right));
        }

        @Override
        protected SoyExpression visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
            SoyExpression left = this.visit(node.getLeftChild());
            if (left.isNonNullable()) {
                return left;
            }
            SoyExpression right = this.visit(node.getRightChild());
            if (SoyTypes.removeNull(left.soyType()).equals(right.soyType())) {
                SoyExpression result;
                if (left.isBoxed() == right.isBoxed()) {
                    result = right.withSource(BytecodeUtils.firstNonNull(left, right));
                } else {
                    SoyExpression boxedRight = right.box();
                    result = boxedRight.withSource(BytecodeUtils.firstNonNull(left.box(), boxedRight));
                }
                if (Expression.areAllCheap(left, right)) {
                    result = result.asCheap();
                }
                return result;
            }
            Type runtimeType = SoyRuntimeType.getBoxedType(node.getType()).runtimeType();
            return SoyExpression.forSoyValue(node.getType(), BytecodeUtils.firstNonNull(left.box().checkedCast(runtimeType), right.box().checkedCast(runtimeType)));
        }

        @Override
        protected final SoyExpression visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
            SoyExpression condition = this.visit(node.getChild(0)).coerceToBoolean();
            SoyExpression trueBranch = this.visit(node.getChild(1));
            SoyExpression falseBranch = this.visit(node.getChild(2));
            boolean typesEqual = trueBranch.soyType().equals(falseBranch.soyType());
            if (typesEqual) {
                if (trueBranch.isBoxed() == falseBranch.isBoxed()) {
                    return trueBranch.withSource(BytecodeUtils.ternary(condition, trueBranch, falseBranch));
                }
                SoyExpression boxedTrue = trueBranch.box();
                return boxedTrue.withSource(BytecodeUtils.ternary(condition, boxedTrue, falseBranch.box()));
            }
            Type boxedRuntimeType = SoyRuntimeType.getBoxedType(node.getType()).runtimeType();
            return SoyExpression.forSoyValue(node.getType(), BytecodeUtils.ternary(condition, trueBranch.box().checkedCast(boxedRuntimeType), falseBranch.box().checkedCast(boxedRuntimeType)));
        }

        @Override
        SoyExpression visitForLoopVar(VarRefNode varRef, LocalVar local) {
            Expression expression = this.parameters.getLocal(local);
            if (expression.resultType().equals((Object)Type.LONG_TYPE)) {
                return SoyExpression.forInt(expression);
            }
            expression = this.detacher.resolveSoyValueProvider(expression);
            return SoyExpression.forSoyValue(varRef.getType(), expression.checkedCast(SoyRuntimeType.getBoxedType(varRef.getType()).runtimeType()));
        }

        @Override
        SoyExpression visitParam(VarRefNode varRef, TemplateParam param) {
            Expression paramExpr = this.detacher.resolveSoyValueProvider(this.parameters.getParam(param));
            return SoyExpression.forSoyValue(varRef.getType(), paramExpr.checkedCast(SoyRuntimeType.getBoxedType(varRef.getType()).runtimeType()));
        }

        @Override
        SoyExpression visitLetNodeVar(VarRefNode varRef, LocalVar local) {
            Expression expression = this.parameters.getLocal(local);
            expression = this.detacher.resolveSoyValueProvider(expression);
            return SoyExpression.forSoyValue(varRef.getType(), expression.checkedCast(SoyRuntimeType.getBoxedType(varRef.getType()).runtimeType()));
        }

        @Override
        SoyExpression visitListComprehensionVar(VarRefNode varRef, ListComprehensionNode.ComprehensionVarDefn var) {
            Expression expression = this.parameters.getLocal(var);
            expression = this.detacher.resolveSoyValueProvider(expression);
            return SoyExpression.forSoyValue(varRef.getType(), expression.checkedCast(SoyRuntimeType.getBoxedType(varRef.getType()).runtimeType()));
        }

        @Override
        protected SoyExpression visitDataAccessNode(DataAccessNode node) {
            return this.visitDataAccessNodeRecurse(node);
        }

        private SoyExpression visitDataAccessNodeRecurse(final ExprNode node) {
            switch (node.getKind()) {
                case FIELD_ACCESS_NODE: 
                case ITEM_ACCESS_NODE: 
                case METHOD_CALL_NODE: {
                    SoyExpression baseExpr = this.visitDataAccessNodeRecurse(((DataAccessNode)node).getBaseExprChild());
                    if (baseExpr.soyType() == NullType.getInstance()) {
                        return SoyExpression.forSoyValue(node.getType(), new Expression(SoyRuntimeType.getBoxedType(node.getType()).runtimeType(), Expression.Feature.CHEAP, new Expression.Feature[0]){

                            @Override
                            protected void doGen(CodeBuilder cb) {
                                String accessType;
                                switch (node.getKind()) {
                                    case FIELD_ACCESS_NODE: {
                                        accessType = "field " + ((FieldAccessNode)node).getFieldName();
                                        break;
                                    }
                                    case ITEM_ACCESS_NODE: {
                                        accessType = "element " + ((ItemAccessNode)node).getSourceStringSuffix();
                                        break;
                                    }
                                    case METHOD_CALL_NODE: {
                                        accessType = "method " + ((MethodCallNode)node).getMethodName().identifier();
                                        break;
                                    }
                                    default: {
                                        throw new AssertionError();
                                    }
                                }
                                cb.throwException(BytecodeUtils.NULL_POINTER_EXCEPTION_TYPE, String.format("Attempted to access %s of null", accessType));
                            }
                        });
                    }
                    baseExpr = baseExpr.asNonNullable();
                    return this.visitDataAccess((DataAccessNode)node, baseExpr, false);
                }
            }
            return this.visit(node);
        }

        private SoyExpression visitDataAccess(DataAccessNode node, SoyExpression baseExpr, boolean hasAssertNonNull) {
            SoyExpression result;
            switch (node.getKind()) {
                case FIELD_ACCESS_NODE: {
                    result = this.visitFieldAccess(baseExpr, (FieldAccessNode)node).withSourceLocation(node.getSourceLocation());
                    break;
                }
                case ITEM_ACCESS_NODE: {
                    result = this.visitItemAccess(baseExpr, (ItemAccessNode)node).withSourceLocation(node.getSourceLocation());
                    break;
                }
                case METHOD_CALL_NODE: {
                    result = this.visitMethodCall(baseExpr, (MethodCallNode)node).withSourceLocation(node.getSourceLocation());
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (hasAssertNonNull) {
                result = CompilerVisitor.assertNonNull(result, node);
            }
            return result;
        }

        private SoyExpression visitFieldAccess(SoyExpression baseExpr, FieldAccessNode node) {
            Preconditions.checkArgument((!node.isNullSafe() ? 1 : 0) != 0);
            if (baseExpr.soyRuntimeType().isKnownProtoOrUnionOfProtos()) {
                if (baseExpr.soyType().getKind() == SoyType.Kind.PROTO) {
                    SoyProtoType protoType = (SoyProtoType)baseExpr.soyType();
                    return ProtoUtils.accessField(protoType, baseExpr, node.getFieldName(), node.getType());
                }
                return ProtoUtils.accessProtoUnionField(baseExpr, node, this.varManager);
            }
            Expression fieldProvider = MethodRef.RUNTIME_GET_FIELD_PROVIDER.invoke(baseExpr.box().checkedCast(SoyRecord.class), BytecodeUtils.constant(node.getFieldName()));
            return SoyExpression.forSoyValue(node.getType(), this.detacher.resolveSoyValueProvider(fieldProvider).checkedCast(SoyRuntimeType.getBoxedType(node.getType()).runtimeType()));
        }

        private SoyExpression visitItemAccess(SoyExpression baseExpr, ItemAccessNode node) {
            Preconditions.checkArgument((!node.isNullSafe() ? 1 : 0) != 0);
            SoyExpression keyExpr = this.visit(node.getKeyExprChild());
            Expression soyValueProvider = baseExpr.soyRuntimeType().isKnownListOrUnionOfLists() ? MethodRef.RUNTIME_GET_LIST_ITEM.invoke(baseExpr.unboxAsList(), keyExpr.unboxAsLong()) : (baseExpr.soyRuntimeType().isKnownMapOrUnionOfMaps() ? MethodRef.RUNTIME_GET_MAP_ITEM.invoke(baseExpr.box().checkedCast(SoyMap.class), keyExpr.box()) : MethodRef.RUNTIME_GET_LEGACY_OBJECT_MAP_ITEM.invoke(baseExpr.box().checkedCast(SoyLegacyObjectMap.class), keyExpr.box()));
            Expression soyValue = this.detacher.resolveSoyValueProvider(soyValueProvider).checkedCast(SoyRuntimeType.getBoxedType(node.getType()).runtimeType());
            return SoyExpression.forSoyValue(node.getType(), soyValue);
        }

        private SoyExpression visitMethodCall(SoyExpression baseExpr, MethodCallNode node) {
            SoyMethod function;
            Preconditions.checkArgument((!node.isNullSafe() ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)node.isMethodResolved());
            if (!BytecodeUtils.isPrimitive(baseExpr.resultType())) {
                baseExpr = CompilerVisitor.assertNonNull(baseExpr, node.getBaseExprChild());
            }
            if ((function = node.getSoyMethod()) instanceof BuiltinMethod) {
                BuiltinMethod builtinMethod = (BuiltinMethod)function;
                switch (builtinMethod) {
                    case GET_EXTENSION: {
                        return ProtoUtils.accessExtensionField(baseExpr, node, BuiltinMethod.getProtoExtensionIdFromMethodCall(node), true);
                    }
                    case HAS_PROTO_FIELD: {
                        return ProtoUtils.hasserField(baseExpr, BuiltinMethod.getProtoFieldNameFromMethodCall(node));
                    }
                    case BIND: {
                        return SoyExpression.forSoyValue(node.getType(), MethodRef.RUNTIME_BIND_TEMPLATE_PARAMS.invoke(this.visit(node.getChild(0)), this.visit(node.getChild(1))));
                    }
                }
            } else if (function instanceof SoySourceFunctionMethod) {
                SoySourceFunctionMethod sourceMethod = (SoySourceFunctionMethod)function;
                ArrayList<SoyExpression> args = new ArrayList<SoyExpression>(node.numParams() + 1);
                args.add(baseExpr);
                node.getParams().forEach(n -> args.add(this.visit((ExprNode)n)));
                return this.visitSoyJavaSourceFunction(JavaPluginExecContext.forMethodCallNode(node, sourceMethod), args);
            }
            throw new AssertionError(function.getClass());
        }

        @Override
        protected SoyExpression visitNullSafeAccessNode(NullSafeAccessNode nullSafeAccessNode) {
            Label nullSafeExit = new Label();
            SoyExpression accumulator = this.visit(nullSafeAccessNode.getBase());
            ExprNode dataAccess = nullSafeAccessNode.getDataAccess();
            while (dataAccess.getKind() == ExprNode.Kind.NULL_SAFE_ACCESS_NODE) {
                NullSafeAccessNode node = (NullSafeAccessNode)dataAccess;
                accumulator = this.accumulateNullSafeDataAccess((DataAccessNode)node.getBase(), accumulator, nullSafeExit, false);
                dataAccess = node.getDataAccess();
            }
            if (BytecodeUtils.isPrimitive((accumulator = this.accumulateNullSafeDataAccessTail((ExprNode.AccessChainComponentNode)dataAccess, accumulator, nullSafeExit)).resultType())) {
                accumulator = accumulator.box();
            }
            return accumulator.asNullable().labelEnd(nullSafeExit);
        }

        private static SoyExpression addNullSafetyCheck(final SoyExpression baseExpr, final Label nullSafeExit) {
            return baseExpr.withSource(new Expression(baseExpr.resultType(), baseExpr.features()){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    baseExpr.gen(adapter);
                    BytecodeUtils.nullCoalesce(adapter, nullSafeExit);
                }
            }).asNonNullable();
        }

        private SoyExpression accumulateNullSafeDataAccessTail(ExprNode.AccessChainComponentNode dataAccessNode, SoyExpression baseExpr, Label nullSafeExit) {
            boolean hasAssertNonNull = false;
            if (dataAccessNode.getKind() == ExprNode.Kind.ASSERT_NON_NULL_OP_NODE) {
                OperatorNodes.AssertNonNullOpNode assertNonNull = (OperatorNodes.AssertNonNullOpNode)dataAccessNode;
                dataAccessNode = (ExprNode.AccessChainComponentNode)assertNonNull.getChild(0);
                hasAssertNonNull = true;
            }
            return this.accumulateNullSafeDataAccess((DataAccessNode)dataAccessNode, baseExpr, nullSafeExit, hasAssertNonNull);
        }

        private SoyExpression accumulateNullSafeDataAccess(DataAccessNode dataAccessNode, SoyExpression baseExpr, Label nullSafeExit, boolean hasAssertNonNull) {
            baseExpr = CompilerVisitor.addNullSafetyCheck(baseExpr, nullSafeExit);
            return this.accumulateDataAccess(dataAccessNode, baseExpr, hasAssertNonNull);
        }

        private SoyExpression accumulateDataAccess(DataAccessNode dataAccessNode, SoyExpression baseExpr, boolean hasAssertNonNull) {
            if (dataAccessNode.getBaseExprChild() instanceof DataAccessNode) {
                baseExpr = this.accumulateDataAccess((DataAccessNode)dataAccessNode.getBaseExprChild(), baseExpr, false).asNonNullable();
            }
            return this.visitDataAccess(dataAccessNode, baseExpr, hasAssertNonNull);
        }

        @Override
        SoyExpression visitIsFirstFunction(FunctionNode node) {
            VarRefNode varRef = (VarRefNode)node.getChild(0);
            SoyNode.LocalVarNode foreach = (SoyNode.LocalVarNode)((LocalVar)varRef.getDefnDecl()).declaringNode();
            SyntheticVarName indexVar = SyntheticVarName.foreachLoopIndex((ForNonemptyNode)foreach);
            final Expression expr = this.parameters.getLocal(indexVar);
            return SoyExpression.forBool(new Expression(Type.BOOLEAN_TYPE){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    expr.gen(adapter);
                    Label ifFirst = new Label();
                    adapter.ifZCmp(153, ifFirst);
                    adapter.pushBoolean(false);
                    Label end = new Label();
                    adapter.goTo(end);
                    adapter.mark(ifFirst);
                    adapter.pushBoolean(true);
                    adapter.mark(end);
                }
            });
        }

        @Override
        SoyExpression visitIsLastFunction(FunctionNode node) {
            VarRefNode varRef = (VarRefNode)node.getChild(0);
            SoyNode.LocalVarNode foreach = (SoyNode.LocalVarNode)((LocalVar)varRef.getDefnDecl()).declaringNode();
            SyntheticVarName indexVar = SyntheticVarName.foreachLoopIndex((ForNonemptyNode)foreach);
            SyntheticVarName lengthVar = SyntheticVarName.foreachLoopLength((ForNonemptyNode)foreach);
            final Expression index = this.parameters.getLocal(indexVar);
            final Expression length = this.parameters.getLocal(lengthVar);
            return SoyExpression.forBool(new Expression(Type.BOOLEAN_TYPE){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    index.gen(adapter);
                    adapter.pushInt(1);
                    adapter.visitInsn(96);
                    length.gen(adapter);
                    Label ifLast = new Label();
                    adapter.ifICmp(153, ifLast);
                    adapter.pushBoolean(false);
                    Label end = new Label();
                    adapter.goTo(end);
                    adapter.mark(ifLast);
                    adapter.pushBoolean(true);
                    adapter.mark(end);
                }
            });
        }

        @Override
        SoyExpression visitIndexFunction(FunctionNode node) {
            VarRefNode varRef = (VarRefNode)node.getChild(0);
            SoyNode.LocalVarNode foreach = (SoyNode.LocalVarNode)((LocalVar)varRef.getDefnDecl()).declaringNode();
            SyntheticVarName indexVar = SyntheticVarName.foreachLoopIndex((ForNonemptyNode)foreach);
            return SoyExpression.forInt(BytecodeUtils.numericConversion(this.parameters.getLocal(indexVar), Type.LONG_TYPE));
        }

        @Override
        protected SoyExpression visitAssertNonNullOpNode(OperatorNodes.AssertNonNullOpNode node) {
            return this.assertNonNull((ExprNode)Iterables.getOnlyElement(node.getChildren()));
        }

        @Override
        SoyExpression visitCheckNotNullFunction(FunctionNode node) {
            return this.assertNonNull((ExprNode)Iterables.getOnlyElement(node.getChildren()));
        }

        private SoyExpression assertNonNull(ExprNode node) {
            return CompilerVisitor.assertNonNull(this.visit(node), node);
        }

        private static SoyExpression assertNonNull(final SoyExpression expr, final ExprNode node) {
            return expr.withSource(new Expression(expr.resultType(), expr.features()){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    expr.gen(adapter);
                    adapter.dup();
                    Label end = new Label();
                    adapter.ifNonNull(end);
                    adapter.throwException(BytecodeUtils.NULL_POINTER_EXCEPTION_TYPE, "'" + node.toSourceString() + "' evaluates to null");
                    adapter.mark(end);
                }
            }).asNonNullable();
        }

        @Override
        SoyExpression visitCssFunction(FunctionNode node) {
            StringNode selector = (StringNode)Iterables.getLast(node.getChildren());
            Expression renamedSelector = this.parameters.getRenderContext().renameCss(selector.getValue());
            if (node.numChildren() == 1) {
                return SoyExpression.forString(renamedSelector);
            }
            SoyExpression base = this.visit(node.getChild(0)).coerceToString();
            Expression fullSelector = base.invoke(MethodRef.STRING_CONCAT, BytecodeUtils.constant("-")).invoke(MethodRef.STRING_CONCAT, renamedSelector);
            return SoyExpression.forString(fullSelector);
        }

        @Override
        SoyExpression visitXidFunction(FunctionNode node) {
            StringNode xid = (StringNode)Iterables.getOnlyElement(node.getChildren());
            Expression renamedXid = this.parameters.getRenderContext().renameXid(xid.getValue());
            return SoyExpression.forString(renamedXid);
        }

        @Override
        SoyExpression visitSoyServerKeyFunction(FunctionNode node) {
            ExprNode child = (ExprNode)Iterables.getOnlyElement(node.getChildren());
            return SoyExpression.forString(MethodRef.SOY_SERVER_KEY.invoke(this.visit(child).box()));
        }

        @Override
        SoyExpression visitIsPrimaryMsgInUse(FunctionNode node) {
            return SoyExpression.forBool(this.parameters.getRenderContext().usePrimaryMsgIfFallback(((IntegerNode)node.getChild(1)).getValue(), ((IntegerNode)node.getChild(2)).getValue()));
        }

        @Override
        SoyExpression visitToFloatFunction(FunctionNode node) {
            SoyExpression arg = this.visit(node.getChild(0));
            return SoyExpression.forFloat(BytecodeUtils.numericConversion(arg.unboxAsLong(), Type.DOUBLE_TYPE));
        }

        @Override
        SoyExpression visitDebugSoyTemplateInfoFunction(FunctionNode node) {
            return SoyExpression.forBool(this.parameters.getRenderContext().getDebugSoyTemplateInfo());
        }

        @Override
        SoyExpression visitVeDataFunction(FunctionNode node) {
            SoyExpression ve = this.visit(node.getChild(0));
            Expression data = this.visit(node.getChild(1)).unboxAsMessage();
            return SoyExpression.forSoyValue(node.getType(), MethodRef.SOY_VISUAL_ELEMENT_DATA_CREATE.invoke(ve, data));
        }

        @Override
        SoyExpression visitPluginFunction(FunctionNode node) {
            Object fn = node.getSoyFunction();
            List<SoyExpression> args = this.visitChildren(node);
            if (fn instanceof SoyJavaSourceFunction) {
                return this.visitSoyJavaSourceFunction(JavaPluginExecContext.forFunctionNode(node, (SoyJavaSourceFunction)fn), args);
            }
            Expression legacyFunctionRuntimeExpr = this.parameters.getRenderContext().getPluginInstance(node.getFunctionName()).checkedCast(LegacyFunctionAdapter.class);
            Expression list = SoyExpression.asBoxedList(args);
            return SoyExpression.forSoyValue(node.getType(), MethodRef.RUNTIME_CALL_LEGACY_FUNCTION.invoke(legacyFunctionRuntimeExpr, list).checkedCast(SoyRuntimeType.getBoxedType(node.getType()).runtimeType()));
        }

        SoyExpression visitSoyJavaSourceFunction(JavaPluginExecContext context, List<SoyExpression> args) {
            return new JbcSrcValueFactory(context, this.parameters == null ? new JbcSrcPluginContext(){

                private Expression error() {
                    throw new UnsupportedOperationException("Cannot access contextual data from a pure context");
                }

                @Override
                public Expression getBidiGlobalDir() {
                    return this.error();
                }

                @Override
                public Expression getAllRequiredCssNamespaces(SoyExpression template) {
                    return this.error();
                }

                @Override
                public Expression getULocale() {
                    return this.error();
                }
            } : this.parameters.getPluginContext(), pluginName -> {
                if (this.parameters == null) {
                    throw new UnsupportedOperationException("Pure functions cannot have instances");
                }
                return this.parameters.getRenderContext().getPluginInstance(pluginName);
            }, this.reporter, this.registry).computeForJavaSource(args);
        }

        @Override
        protected final SoyExpression visitProtoInitNode(ProtoInitNode node) {
            return ProtoUtils.createProto(node, (Function<ExprNode, SoyExpression>)((Function)this::visit), this.detacher, this.varManager);
        }

        @Override
        protected SoyExpression visitVeLiteralNode(VeLiteralNode node) {
            Expression visualElement;
            ValidatedLoggingConfig.ValidatedLoggableElement element = node.getLoggableElement();
            if (element.hasMetadata()) {
                MethodRef metadata = MethodRef.createStaticMethod(TypeInfo.create(String.format("%s.%s", element.getJavaPackage(), element.getClassName()), false), new Method(element.getGeneratedVeMetadataMethodName(), BytecodeUtils.LOGGABLE_ELEMENT_METADATA_TYPE, MethodRef.NO_METHOD_ARGS)).asNonNullable().asCheap();
                visualElement = MethodRef.SOY_VISUAL_ELEMENT_CREATE_METADATA.invoke(BytecodeUtils.constant(node.getId()), BytecodeUtils.constant(node.getName().identifier()), metadata.invoke(new Expression[0]));
            } else {
                visualElement = MethodRef.SOY_VISUAL_ELEMENT_CREATE.invoke(BytecodeUtils.constant(node.getId()), BytecodeUtils.constant(node.getName().identifier()));
            }
            return SoyExpression.forSoyValue(node.getType(), visualElement);
        }

        @Override
        protected SoyExpression visitTemplateLiteralNode(final TemplateLiteralNode node) {
            final RenderContextExpression renderContext = this.parameters.getRenderContext();
            return SoyExpression.forSoyValue(node.getType(), new Expression(BytecodeUtils.COMPILED_TEMPLATE_FACTORY_TYPE){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    renderContext.gen(adapter);
                    adapter.visitInvokeDynamicInsn("create", TEMPLATE_FACTORY_SIGNATURE, GETFACTORY_HANDLE, new Object[]{node.getResolvedName()});
                }
            });
        }

        @Override
        protected final SoyExpression visitExprNode(ExprNode node) {
            throw new UnsupportedOperationException("Support for " + (Object)((Object)node.getKind()) + " has not been added yet");
        }
    }

    static final class BasicExpressionCompiler {
        private final CompilerVisitor compilerVisitor;

        private BasicExpressionCompiler(TemplateParameterLookup parameters, LocalVariableManager varManager, FieldManager fields, ErrorReporter reporter, SoyTypeRegistry registry, CompiledTemplateRegistry compiledTemplateRegistry) {
            this.compilerVisitor = new CompilerVisitor(parameters, varManager, fields, ExpressionDetacher.BasicDetacher.INSTANCE, reporter, registry, compiledTemplateRegistry);
        }

        private BasicExpressionCompiler(CompilerVisitor visitor) {
            this.compilerVisitor = visitor;
        }

        SoyExpression compile(ExprNode expr) {
            return (SoyExpression)this.compilerVisitor.exec(expr);
        }

        List<SoyExpression> compileToList(List<? extends ExprNode> children) {
            ArrayList<SoyExpression> soyExprs = new ArrayList<SoyExpression>(children.size());
            for (ExprNode exprNode : children) {
                soyExprs.add(this.compile(exprNode));
            }
            return soyExprs;
        }
    }
}

