/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyCompilationException;
import com.google.template.soy.jbcsrc.CompiledTemplateMetadata;
import com.google.template.soy.jbcsrc.CompiledTemplateRegistry;
import com.google.template.soy.jbcsrc.TemplateCompiler;
import com.google.template.soy.jbcsrc.internal.AbstractMemoryClassLoader;
import com.google.template.soy.jbcsrc.internal.ClassData;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class CompilingClassLoader
extends AbstractMemoryClassLoader {
    private final Map<String, ClassData> classesByName = Collections.synchronizedMap(new HashMap());
    private final CompiledTemplateRegistry registry;
    private final ImmutableMap<String, SoyFileSupplier> filePathsToSuppliers;
    private final ImmutableMap<String, TemplateNode> classNameToTemplateNode;
    private final ImmutableMap<String, CompiledTemplateMetadata> classNameToTemplateMetadata;
    private final SoyTypeRegistry typeRegistry;

    CompilingClassLoader(CompiledTemplateRegistry registry, SoyFileSetNode fileSet, ImmutableMap<String, SoyFileSupplier> filePathsToSuppliers, SoyTypeRegistry typeRegistry) {
        this.registry = registry;
        ImmutableMap.Builder classNameToTemplateNode = ImmutableMap.builder();
        ImmutableMap.Builder classNameToTemplateMetadata = ImmutableMap.builder();
        for (SoyFileNode file : fileSet.getChildren()) {
            for (TemplateNode template : file.getTemplates()) {
                CompiledTemplateMetadata meta = registry.getTemplateInfo(template);
                classNameToTemplateNode.put((Object)meta.typeInfo().className(), (Object)template);
                classNameToTemplateMetadata.put((Object)meta.typeInfo().className(), (Object)meta);
            }
        }
        this.classNameToTemplateNode = classNameToTemplateNode.build();
        this.classNameToTemplateMetadata = classNameToTemplateMetadata.build();
        this.typeRegistry = typeRegistry;
        this.filePathsToSuppliers = filePathsToSuppliers;
    }

    @Override
    protected ClassData getClassData(String name) {
        ClassData classDef = this.classesByName.get(name);
        if (classDef != null) {
            return classDef;
        }
        boolean isFactory = name.endsWith("$Factory");
        String compiledTemplateName = isFactory ? name.substring(0, name.length() - ("Factory".length() + 1)) : name;
        CompiledTemplateMetadata meta = (CompiledTemplateMetadata)this.classNameToTemplateMetadata.get((Object)compiledTemplateName);
        if (meta == null) {
            return null;
        }
        ClassData clazzToLoad = null;
        ErrorReporter reporter = ErrorReporter.create(this.filePathsToSuppliers);
        for (ClassData clazz : new TemplateCompiler(this.registry, meta, (TemplateNode)this.classNameToTemplateNode.get((Object)compiledTemplateName), reporter, this.typeRegistry).compile()) {
            String className = clazz.type().className();
            if (className.equals(name)) {
                clazzToLoad = clazz;
                continue;
            }
            this.classesByName.put(className, clazz);
        }
        if (reporter.hasErrors()) {
            Iterable errors = Iterables.concat(reporter.getErrors(), reporter.getWarnings());
            throw new SoyCompilationException(errors);
        }
        return clazzToLoad;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

