/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.template.soy.jbcsrc.CompiledTemplateMetadata;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;

final class CompiledTemplateRegistry {
    private final LoadingCache<TemplateMetadata, CompiledTemplateMetadata> templateToMetadata;
    private final TemplateRegistry registry;

    CompiledTemplateRegistry(TemplateRegistry registry) {
        this.registry = registry;
        this.templateToMetadata = CacheBuilder.newBuilder().build(CacheLoader.from(CompiledTemplateRegistry::createMetadata));
    }

    static CompiledTemplateMetadata createMetadata(TemplateMetadata template) {
        return CompiledTemplateMetadata.create(template.getTemplateName(), template.getSoyFileKind());
    }

    CompiledTemplateMetadata getBasicTemplateInfoByTemplateName(String templateName) {
        return (CompiledTemplateMetadata)this.templateToMetadata.getUnchecked((Object)this.registry.getBasicTemplateOrElement(templateName));
    }

    CompiledTemplateMetadata getTemplateInfo(TemplateNode template) {
        return (CompiledTemplateMetadata)this.templateToMetadata.getUnchecked((Object)this.registry.getMetadata(template));
    }
}

