/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.auto.value.AutoValue;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.jbcsrc.AutoValue_CompiledTemplateMetadata;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.ConstructorRef;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

@AutoValue
abstract class CompiledTemplateMetadata {
    private static final Method GENERATED_CONSTRUCTOR = new Method("<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{BytecodeUtils.SOY_RECORD_TYPE, BytecodeUtils.SOY_RECORD_TYPE}));
    private static final Method RENDER_METHOD;
    private static final Method KIND_METHOD;

    CompiledTemplateMetadata() {
    }

    static CompiledTemplateMetadata create(String templateName, SoyFileKind kind) {
        String className = Names.javaClassNameFromSoyTemplateName(templateName);
        String factoryClassName = className + "$Factory";
        TypeInfo type = TypeInfo.createClass(className);
        TypeInfo factoryType = TypeInfo.createClass(factoryClassName);
        return new AutoValue_CompiledTemplateMetadata(ConstructorRef.create(type, GENERATED_CONSTRUCTOR), FieldRef.create(factoryType, "INSTANCE", factoryType.type(), 25, false), MethodRef.createInstanceMethod(type, RENDER_METHOD).asNonNullable(), MethodRef.createInstanceMethod(type, KIND_METHOD).asCheap(), type, kind);
    }

    abstract ConstructorRef constructor();

    abstract FieldRef factoryInstance();

    abstract MethodRef renderMethod();

    abstract MethodRef kindMethod();

    abstract TypeInfo typeInfo();

    abstract SoyFileKind filekind();

    static {
        try {
            RENDER_METHOD = Method.getMethod((java.lang.reflect.Method)CompiledTemplate.class.getMethod("render", LoggingAdvisingAppendable.class, RenderContext.class));
            KIND_METHOD = Method.getMethod((java.lang.reflect.Method)CompiledTemplate.class.getMethod("kind", new Class[0]));
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

