/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.base.internal.SoyJarFileWriter;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.jbcsrc.CompiledTemplateMetadata;
import com.google.template.soy.jbcsrc.CompiledTemplateRegistry;
import com.google.template.soy.jbcsrc.CompilingClassLoader;
import com.google.template.soy.jbcsrc.TemplateCompiler;
import com.google.template.soy.jbcsrc.internal.ClassData;
import com.google.template.soy.jbcsrc.restricted.Flags;
import com.google.template.soy.jbcsrc.shared.CompiledTemplates;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.jbcsrc.shared.PluginRuntimeInstanceInfo;
import com.google.template.soy.plugin.java.internal.PluginAnalyzer;
import com.google.template.soy.plugin.java.restricted.SoyJavaSourceFunction;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.TemplateType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;

public final class BytecodeCompiler {
    public static Optional<CompiledTemplates> compile(TemplateRegistry registry, SoyFileSetNode fileSet, ErrorReporter reporter, ImmutableMap<String, SoyFileSupplier> filePathsToSuppliers, SoyTypeRegistry typeRegistry) {
        ErrorReporter.Checkpoint checkpoint = reporter.checkpoint();
        if (reporter.errorsSince(checkpoint)) {
            return Optional.empty();
        }
        CompiledTemplateRegistry compilerRegistry = new CompiledTemplateRegistry(registry);
        CompiledTemplates templates = new CompiledTemplates((ImmutableSet<String>)((ImmutableSet)registry.getAllTemplates().stream().filter(template -> template.getTemplateKind() == TemplateType.TemplateKind.DELTEMPLATE).map(TemplateMetadata::getTemplateName).collect(ImmutableSet.toImmutableSet())), new CompilingClassLoader(compilerRegistry, fileSet, filePathsToSuppliers, typeRegistry));
        if (reporter.errorsSince(checkpoint)) {
            return Optional.empty();
        }
        return Optional.of(templates);
    }

    public static void compileToJar(TemplateRegistry registry, SoyFileSetNode fileSet, ErrorReporter reporter, SoyTypeRegistry typeRegistry, ByteSink sink) throws IOException {
        ErrorReporter.Checkpoint checkpoint = reporter.checkpoint();
        if (reporter.errorsSince(checkpoint)) {
            return;
        }
        CompiledTemplateRegistry compilerRegistry = new CompiledTemplateRegistry(registry);
        if (reporter.errorsSince(checkpoint)) {
            return;
        }
        try (final SoyJarFileWriter writer = new SoyJarFileWriter(sink.openStream());){
            final TreeSet delTemplates = new TreeSet();
            final TreeMap pluginInstances = new TreeMap();
            BytecodeCompiler.compileTemplates(compilerRegistry, fileSet, reporter, typeRegistry, new CompilerListener<Void, IOException>(){

                @Override
                void onCompile(ClassData clazz) throws IOException {
                    writer.writeEntry(clazz.type().internalName() + ".class", ByteSource.wrap((byte[])clazz.data()));
                }

                @Override
                void onCompileDelTemplate(String name) {
                    delTemplates.add(name);
                }

                @Override
                void onFunctionCallFound(FunctionNode fnNode) {
                    if (fnNode.getSoyFunction() instanceof SoyJavaSourceFunction) {
                        ImmutableSet<String> instances;
                        if (!pluginInstances.containsKey(fnNode.getFunctionName()) && !(instances = PluginAnalyzer.analyze((SoyJavaSourceFunction)fnNode.getSoyFunction(), fnNode.numChildren()).pluginInstanceNames()).isEmpty()) {
                            pluginInstances.put(fnNode.getFunctionName(), PluginRuntimeInstanceInfo.builder().setPluginName(fnNode.getFunctionName()).setInstanceClassName((String)Iterables.getOnlyElement(instances)));
                        }
                        if (pluginInstances.containsKey(fnNode.getFunctionName())) {
                            ((PluginRuntimeInstanceInfo.Builder)pluginInstances.get(fnNode.getFunctionName())).sourceLocationsBuilder().add((Object)fnNode.getSourceLocation().toString());
                        }
                    }
                }
            });
            if (!delTemplates.isEmpty()) {
                String delData = Joiner.on((char)'\n').join(delTemplates);
                writer.writeEntry("META-INF/services/com.google.template.soy.deltemplates", ByteSource.wrap((byte[])delData.getBytes(StandardCharsets.UTF_8)));
            }
            if (!pluginInstances.isEmpty()) {
                String pluginData = "";
                for (String pluginName : pluginInstances.keySet()) {
                    PluginRuntimeInstanceInfo pluginInstanceInfo = ((PluginRuntimeInstanceInfo.Builder)pluginInstances.get(pluginName)).build();
                    pluginData = pluginData + pluginName + ":" + pluginInstanceInfo.instanceClassName() + ":" + String.join((CharSequence)",", pluginInstanceInfo.sourceLocations()) + "\n";
                }
                writer.writeEntry("META-INF/services/com.google.template.soy.plugins", ByteSource.wrap((byte[])pluginData.getBytes(StandardCharsets.UTF_8)));
            }
        }
    }

    public static void writeSrcJar(SoyFileSetNode soyFileSet, ImmutableMap<String, SoyFileSupplier> files, ByteSink sink) throws IOException {
        try (SoyJarFileWriter writer = new SoyJarFileWriter(sink.openStream());){
            for (SoyFileNode file : soyFileSet.getChildren()) {
                String namespace = file.getNamespace();
                String fileName = file.getFileName();
                writer.writeEntry(Names.javaFileName(namespace, fileName), ((SoyFileSupplier)files.get((Object)file.getFilePath())).asCharSource().asByteSource(StandardCharsets.UTF_8));
            }
        }
    }

    private static <T, E extends Throwable> T compileTemplates(CompiledTemplateRegistry registry, SoyFileSetNode fileSet, ErrorReporter errorReporter, SoyTypeRegistry typeRegistry, CompilerListener<T, E> listener) throws E {
        for (SoyFileNode file : fileSet.getChildren()) {
            for (TemplateNode template : file.getTemplates()) {
                CompiledTemplateMetadata classInfo = registry.getTemplateInfo(template);
                TemplateCompiler templateCompiler = new TemplateCompiler(registry, classInfo, template, errorReporter, typeRegistry);
                for (ClassData clazz : templateCompiler.compile()) {
                    if (Flags.DEBUG) {
                        clazz.checkClass();
                    }
                    listener.onCompile(clazz);
                }
                if (template instanceof TemplateDelegateNode) {
                    listener.onCompileDelTemplate(template.getTemplateName());
                } else {
                    listener.onCompileTemplate(template.getTemplateName());
                }
                for (FunctionNode fnNode : SoyTreeUtils.getAllNodesOfType(template, FunctionNode.class)) {
                    listener.onFunctionCallFound(fnNode);
                }
            }
        }
        return listener.getResult();
    }

    private BytecodeCompiler() {
    }

    private static abstract class CompilerListener<T, E extends Throwable> {
        private CompilerListener() {
        }

        abstract void onCompile(ClassData var1) throws E;

        void onCompileDelTemplate(String name) {
        }

        void onCompileTemplate(String name) {
        }

        void onFunctionCallFound(FunctionNode function) {
        }

        T getResult() {
            return null;
        }
    }
}

