/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.invocationbuilders.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.template.soy.invocationbuilders.javatypes.JavaType;
import com.google.template.soy.invocationbuilders.javatypes.ListJavaType;
import com.google.template.soy.invocationbuilders.javatypes.MapJavaType;
import com.google.template.soy.invocationbuilders.javatypes.ProtoEnumJavaType;
import com.google.template.soy.invocationbuilders.javatypes.ProtoJavaType;
import com.google.template.soy.invocationbuilders.javatypes.RecordJavaType;
import com.google.template.soy.invocationbuilders.javatypes.SimpleJavaType;
import com.google.template.soy.types.AbstractMapType;
import com.google.template.soy.types.FloatType;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.RecordType;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.UnionType;
import com.google.template.soy.types.UnknownType;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;

final class InvocationBuilderTypeUtils {
    private InvocationBuilderTypeUtils() {
    }

    static ImmutableList<JavaType> getJavaTypes(SoyType soyType) {
        return InvocationBuilderTypeUtils.getJavaTypes(soyType, false);
    }

    static ImmutableList<JavaType> getJavaTypes(SoyType soyType, boolean shouldMakeNullable) {
        boolean nonLegacyMap = true;
        ImmutableList types = ImmutableList.of();
        switch (soyType.getKind()) {
            case BOOL: {
                types = ImmutableList.of((Object)SimpleJavaType.BOOLEAN);
                break;
            }
            case INT: {
                types = ImmutableList.of((Object)SimpleJavaType.INT);
                break;
            }
            case FLOAT: {
                types = ImmutableList.of((Object)SimpleJavaType.FLOAT);
                break;
            }
            case STRING: {
                types = ImmutableList.of((Object)SimpleJavaType.STRING);
                break;
            }
            case HTML: {
                types = ImmutableList.of((Object)SimpleJavaType.HTML);
                break;
            }
            case JS: {
                types = ImmutableList.of((Object)SimpleJavaType.JS);
                break;
            }
            case URI: {
                types = ImmutableList.of((Object)SimpleJavaType.URL);
                break;
            }
            case TRUSTED_RESOURCE_URI: {
                types = ImmutableList.of((Object)SimpleJavaType.TRUSTED_RESOURCE_URL);
                break;
            }
            case MESSAGE: {
                types = ImmutableList.of((Object)SimpleJavaType.MESSAGE);
                break;
            }
            case PROTO: {
                SoyProtoType asProto = (SoyProtoType)soyType;
                types = ImmutableList.of((Object)new ProtoJavaType(asProto.getDescriptor()));
                break;
            }
            case PROTO_ENUM: {
                SoyProtoEnumType asProtoEnum = (SoyProtoEnumType)soyType;
                types = ImmutableList.of((Object)new ProtoEnumJavaType(asProtoEnum.getDescriptor()));
                break;
            }
            case LIST: {
                SoyType elementType = ((ListType)soyType).getElementType();
                if (elementType.getKind() == SoyType.Kind.RECORD) {
                    types = InvocationBuilderTypeUtils.trySimpleRecordType((RecordType)elementType, true);
                    break;
                }
                ImmutableList<JavaType> listElementTypes = InvocationBuilderTypeUtils.getJavaTypes(elementType);
                if (listElementTypes.size() == 1 && ((JavaType)listElementTypes.get(0)).isGenericsTypeSupported()) {
                    return ImmutableList.of((Object)new ListJavaType((JavaType)listElementTypes.get(0)));
                }
                types = ImmutableList.of();
                break;
            }
            case LEGACY_OBJECT_MAP: {
                nonLegacyMap = false;
            }
            case MAP: {
                ImmutableList<JavaType> valueTypes;
                AbstractMapType soyAbstractMapType = (AbstractMapType)soyType;
                ImmutableList<JavaType> keyTypes = InvocationBuilderTypeUtils.getJavaTypes(soyAbstractMapType.getKeyType());
                if (keyTypes.size() != 1 || !((JavaType)keyTypes.get(0)).isGenericsTypeSupported() || (valueTypes = InvocationBuilderTypeUtils.getJavaTypes(soyAbstractMapType.getValueType())).size() != 1 || !((JavaType)valueTypes.get(0)).isGenericsTypeSupported()) break;
                types = ImmutableList.of((Object)new MapJavaType((JavaType)keyTypes.get(0), (JavaType)valueTypes.get(0), nonLegacyMap));
                break;
            }
            case UNION: {
                types = InvocationBuilderTypeUtils.convertSoyUnionTypeToJavaTypes((UnionType)soyType);
                break;
            }
            case ANY: 
            case UNKNOWN: {
                types = ImmutableList.of((Object)SimpleJavaType.OBJECT.asNullable());
                break;
            }
            case ATTRIBUTES: {
                types = ImmutableList.of((Object)SimpleJavaType.ATTRIBUTES);
                break;
            }
            case CSS: {
                types = ImmutableList.of((Object)SimpleJavaType.CSS);
                break;
            }
            case RECORD: {
                types = InvocationBuilderTypeUtils.trySimpleRecordType((RecordType)soyType, false);
                break;
            }
        }
        if (shouldMakeNullable) {
            return (ImmutableList)types.stream().map(type -> type.asNullable()).collect(ImmutableList.toImmutableList());
        }
        return types;
    }

    private static ImmutableList<JavaType> trySimpleRecordType(RecordType recordType, boolean list) {
        Preconditions.checkArgument((!recordType.getMembers().isEmpty() ? 1 : 0) != 0);
        if (Streams.stream(SoyTypes.getTypeTraverser(recordType, null)).anyMatch(t -> t.getKind() == SoyType.Kind.RECORD && t != recordType)) {
            return ImmutableList.of();
        }
        ImmutableMap.Builder javaTypeMap = ImmutableMap.builder();
        for (RecordType.Member member : recordType.getMembers()) {
            ImmutableList<JavaType> types = InvocationBuilderTypeUtils.getJavaTypes(member.type());
            if (types.size() != 1) {
                return ImmutableList.of();
            }
            javaTypeMap.put((Object)member.name(), (Object)((JavaType)types.get(0)));
        }
        return ImmutableList.of((Object)new RecordJavaType((ImmutableMap<String, JavaType>)javaTypeMap.build(), list));
    }

    public static boolean isJavaIncompatible(SoyType type) {
        switch (type.getKind()) {
            case VE: 
            case VE_DATA: {
                return true;
            }
        }
        return false;
    }

    static Optional<SoyType> upcastTypesForIndirectParams(Set<SoyType> allTypes) {
        if (allTypes.size() == 1) {
            return Optional.of((SoyType)Iterables.getOnlyElement(allTypes));
        }
        if (allTypes.contains(UnknownType.getInstance())) {
            return Optional.of(UnknownType.getInstance());
        }
        if (allTypes.size() == 2) {
            Iterator<SoyType> i = allTypes.iterator();
            SoyType first = i.next();
            SoyType second = i.next();
            if (first.equals(UnionType.of(NullType.getInstance(), second))) {
                return Optional.of(first);
            }
            if (second.equals(UnionType.of(NullType.getInstance(), first))) {
                return Optional.of(second);
            }
        }
        return Optional.empty();
    }

    private static ImmutableList<JavaType> convertSoyUnionTypeToJavaTypes(UnionType unionType) {
        if (unionType.equals(UnionType.of(NullType.getInstance(), IntType.getInstance(), FloatType.getInstance()))) {
            return ImmutableList.of((Object)SimpleJavaType.NUMBER.asNullable());
        }
        if (unionType.equals(UnionType.of(IntType.getInstance(), FloatType.getInstance()))) {
            return ImmutableList.of((Object)SimpleJavaType.NUMBER);
        }
        boolean unionAllowsNull = unionType.getMembers().stream().anyMatch(member -> member instanceof NullType);
        ImmutableList.Builder javaTypeListBuilder = new ImmutableList.Builder();
        for (SoyType soyUnionMemberType : unionType.getMembers()) {
            if (soyUnionMemberType instanceof NullType) continue;
            ImmutableList<JavaType> javaTypesForUnionMember = InvocationBuilderTypeUtils.getJavaTypes(soyUnionMemberType, unionAllowsNull);
            if (javaTypesForUnionMember.isEmpty()) {
                return ImmutableList.of();
            }
            javaTypeListBuilder.addAll(javaTypesForUnionMember);
        }
        return InvocationBuilderTypeUtils.clearListIfHasTypeErasureOverloadCollisions((ImmutableList<JavaType>)javaTypeListBuilder.build());
    }

    private static ImmutableList<JavaType> clearListIfHasTypeErasureOverloadCollisions(ImmutableList<JavaType> types) {
        long numTopLevelListTypes = types.stream().filter(type -> type instanceof ListJavaType).count();
        long numTopLevelMapTypes = types.stream().filter(type -> type instanceof MapJavaType).count();
        if (numTopLevelListTypes > 1L || numTopLevelMapTypes > 1L) {
            return ImmutableList.of();
        }
        return types;
    }
}

