/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.invocationbuilders.passes;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.IndentedLinesBuilder;
import com.google.template.soy.invocationbuilders.javatypes.CodeGenUtils;
import com.google.template.soy.invocationbuilders.javatypes.FutureJavaType;
import com.google.template.soy.invocationbuilders.javatypes.JavaType;
import com.google.template.soy.invocationbuilders.javatypes.RecordJavaType;
import com.google.template.soy.invocationbuilders.passes.SoyFileNodeTransformer;
import com.google.template.soy.shared.internal.gencode.GeneratedFile;
import com.google.template.soy.shared.internal.gencode.JavaGenerationUtils;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class GenInvocationBuildersVisitor
extends AbstractSoyNodeVisitor<ImmutableList<GeneratedFile>> {
    private static final Logger logger = Logger.getLogger(GenInvocationBuildersVisitor.class.getName());
    private static final String TEMPLATE_NAME_FIELD = "__NAME__";
    private static final String PARAMS_FIELD = "__PARAMS__";
    private static final String PROTOS_FIELD = "__PROTOS__";
    private static final String DEFAULT_INSTANCE_FIELD = "__DEFAULT_INSTANCE__";
    private final SoyFileNodeTransformer transformer;
    private IndentedLinesBuilder ilb;
    private ImmutableList.Builder<GeneratedFile> generatedFiles;
    private static final ImmutableSet<String> RESERVED_JAVA_WORDS = ImmutableSet.of((Object)"abstract", (Object)"assert", (Object)"boolean", (Object)"byte", (Object)"case", (Object)"catch", (Object[])new String[]{"char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"});

    public GenInvocationBuildersVisitor(String javaPackage, TemplateRegistry templateRegistry) {
        this.transformer = new SoyFileNodeTransformer(javaPackage, templateRegistry);
    }

    @Override
    public ImmutableList<GeneratedFile> exec(SoyNode node) {
        this.generatedFiles = new ImmutableList.Builder();
        this.ilb = null;
        this.visit(node);
        ImmutableList builtFileList = this.generatedFiles.build();
        GenInvocationBuildersVisitor.logWarningIfFilenamesNotUnique((ImmutableList<GeneratedFile>)builtFileList);
        return builtFileList;
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        for (SoyFileNode soyFile : node.getChildren()) {
            this.visit(soyFile);
        }
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode soyFile) {
        SoyFileNodeTransformer.FileInfo fileInfo = this.transformer.transform(soyFile);
        this.ilb = new IndentedLinesBuilder(2);
        this.appendFileHeaderAndImports(fileInfo);
        String javaClassNameForSoyFile = fileInfo.className();
        JavaGenerationUtils.appendJavadoc(this.ilb, "Wrapper class containing {@link com.google.template.soy.data.SoyTemplate} builders for each template in: " + fileInfo.soyFileName() + ".", false, true);
        this.ilb.appendLine("@javax.annotation.Generated(\"com.google.template.soy.SoyParseInfoGenerator\")");
        this.ilb.appendLine("public final class " + javaClassNameForSoyFile + " {");
        this.ilb.increaseIndent();
        this.appendProtoDescriptors(fileInfo, soyFile.getSoyTypeRegistry());
        this.generateParamsClassesForEachTemplate(fileInfo);
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        String fileName = javaClassNameForSoyFile + ".java";
        this.generatedFiles.add((Object)GeneratedFile.create(fileName, this.ilb.toString()));
        this.ilb = null;
    }

    private void generateParamsClassesForEachTemplate(SoyFileNodeTransformer.FileInfo soyFile) {
        soyFile.templates().forEach(t -> {
            switch (t.status()) {
                case HANDLED: {
                    this.visitTemplateInfo((SoyFileNodeTransformer.TemplateInfo)t);
                    break;
                }
                case NAME_COLLISION: {
                    GenInvocationBuildersVisitor.logDuplicateTemplateNameWarning(t.templateName(), t.className());
                }
            }
        });
    }

    private void visitTemplateInfo(SoyFileNodeTransformer.TemplateInfo template) {
        String paramsClass = template.className();
        String templateDescription = template.soyDocDesc();
        this.ilb.appendLine(new Object[0]);
        JavaGenerationUtils.appendJavadoc(this.ilb, "Template params for " + template.templateNameForUserMsgs() + (templateDescription != null ? ": " + templateDescription : "."), false, true);
        this.ilb.appendLine("public static final class " + paramsClass + " extends com.google.template.soy.data.BaseSoyTemplateImpl {");
        this.ilb.increaseIndent();
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("private static final java.lang.String __NAME__ = \"" + template.templateName() + "\";");
        this.ilb.appendLine(new Object[0]);
        this.appendFutureWrapperMethod(paramsClass);
        this.ilb.appendLine("private " + paramsClass + "(com.google.common.collect.ImmutableMap<java.lang.String, com.google.template.soy.data.SoyValueProvider> data) {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("super(data);");
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("@java.lang.Override");
        this.ilb.appendLine("public final java.lang.String getTemplateName() {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("return __NAME__;");
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
        this.appendParamsBuilderClass(template, paramsClass);
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
    }

    private void appendProtoDescriptors(SoyFileNodeTransformer.FileInfo fileInfo, SoyTypeRegistry typeRegistry) {
        List<String> protoTypes = fileInfo.getProtoTypes(typeRegistry).stream().sorted().collect(Collectors.toList());
        if (protoTypes.isEmpty()) {
            return;
        }
        this.ilb.appendLine(new Object[0]);
        JavaGenerationUtils.appendJavadoc(this.ilb, "The list of protos used by all templates (public and private) in this Soy file, which are used by 1) the edit-refresh development compiler and 2) the java compiler to enforce strict proto deps.", false, true);
        this.ilb.appendLineStart("private static final com.google.common.collect.ImmutableList<com.google.protobuf.Descriptors.FileDescriptor> __PROTOS__ = ");
        JavaGenerationUtils.appendFunctionCallWithParamsOnNewLines(this.ilb, "com.google.common.collect.ImmutableList.of", protoTypes);
        this.ilb.appendLineEnd(";");
    }

    private void appendFutureWrapperMethod(String paramsClass) {
        JavaGenerationUtils.appendJavadoc(this.ilb, "Wraps a ListenableFuture<" + paramsClass + "> as a SoyTemplate.AsyncWrapper<" + paramsClass + ">", false, true);
        this.ilb.appendLine("public static com.google.template.soy.data.SoyTemplate.AsyncWrapper<" + paramsClass + "> wrapFuture(com.google.common.util.concurrent.ListenableFuture<" + paramsClass + "> paramsFuture) {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("return new com.google.template.soy.data.SoyTemplate.AsyncWrapper<>(__NAME__, paramsFuture);");
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
    }

    private void appendParamsBuilderClass(SoyFileNodeTransformer.TemplateInfo template, String templateParamsClassname) {
        JavaGenerationUtils.appendJavadoc(this.ilb, "Creates a new Builder instance.", false, true);
        this.ilb.appendLine("public static Builder builder() {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("return new Builder();");
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
        List<SoyFileNodeTransformer.ParamInfo> combinedParams = template.params().stream().filter(info -> {
            switch (info.status()) {
                case HANDLED: 
                case UNHANDLED_TYPE: {
                    return true;
                }
                case NAME_COLLISION: {
                    GenInvocationBuildersVisitor.logDuplicateParamNameWarning(info.name(), info.setterName(), template.templateName());
                    return true;
                }
                case JAVA_INCOMPATIBLE: {
                    break;
                }
                case INDIRECT_INCOMPATIBLE_TYPES: {
                    logger.warning(String.format("Parameter '%s' in %s has different types in different templates. No parameter setter generated.", info.name(), template.templateName()));
                    break;
                }
                case INDIRECT_PROTO: {
                    logger.warning(String.format("Indirect parameter '%s' in %s is of type proto or proto enum. No parameter setter generated.", info.name(), template.templateName()));
                }
            }
            return false;
        }).collect(Collectors.toList());
        List<SoyFileNodeTransformer.ParamInfo> nonInjectedParams = combinedParams.stream().filter(p -> !p.injected()).collect(Collectors.toList());
        if (nonInjectedParams.stream().noneMatch(SoyFileNodeTransformer.ParamInfo::requiredAndNotIndirect)) {
            this.ilb.appendLine("private static final " + templateParamsClassname + " " + DEFAULT_INSTANCE_FIELD + " = new " + templateParamsClassname + "(com.google.common.collect.ImmutableMap.of());");
            this.ilb.appendLine(new Object[0]);
            JavaGenerationUtils.appendJavadoc(this.ilb, "Creates a new instance of " + templateParamsClassname + " with no parameters set. This method was generated because all template parameters are optional.", false, true);
            this.ilb.appendLine("public static " + templateParamsClassname + " getDefaultInstance() {");
            this.ilb.increaseIndent();
            this.ilb.appendLine("return __DEFAULT_INSTANCE__;");
            this.ilb.decreaseIndent();
            this.ilb.appendLine("}");
            this.ilb.appendLine(new Object[0]);
        }
        GenInvocationBuildersVisitor.appendParamConstants(this.ilb, combinedParams);
        boolean anyAccumulatorParameters = nonInjectedParams.stream().flatMap(param -> param.javaTypes().stream()).anyMatch(javaType -> javaType instanceof RecordJavaType && ((RecordJavaType)javaType).isList());
        this.ilb.appendLine("@com.google.errorprone.annotations.CanIgnoreReturnValue");
        this.ilb.appendLine("public static final class Builder extends com.google.template.soy.data.BaseSoyTemplateImpl." + (anyAccumulatorParameters ? "AbstractBuilderWithAccumulatorParameters" : "AbstractBuilder") + "<Builder, " + templateParamsClassname + "> {");
        this.ilb.appendLine(new Object[0]);
        this.ilb.increaseIndent();
        this.ilb.appendLine("private Builder() {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("super(", nonInjectedParams.size(), ");");
        GenInvocationBuildersVisitor.appendRecordListInitializations(this.ilb, nonInjectedParams);
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("@java.lang.Override");
        this.ilb.appendLine("protected com.google.common.collect.ImmutableSet<com.google.template.soy.data.SoyTemplateParam<?>> allParams() {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("return __PARAMS__;");
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("@java.lang.Override");
        this.ilb.appendLine("protected " + templateParamsClassname + " buildInternal(com.google.common.collect.ImmutableMap<java.lang.String, com.google.template.soy.data.SoyValueProvider> data) {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("return new " + templateParamsClassname + "(data);");
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        nonInjectedParams.stream().filter(p -> p.status() == SoyFileNodeTransformer.ParamStatus.HANDLED).forEach(this::writeSettersForParam);
        this.ilb.appendLine(new Object[0]);
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
    }

    private static void appendParamConstants(IndentedLinesBuilder ilb, List<SoyFileNodeTransformer.ParamInfo> params) {
        HashSet<String> usedNames = new HashSet<String>();
        ArrayList<String> nonInjected = new ArrayList<String>();
        for (SoyFileNodeTransformer.ParamInfo param : params) {
            JavaType javaType;
            while (usedNames.contains(param.constantFieldName())) {
                param.updateConstantFieldName();
            }
            String fieldName = param.constantFieldName();
            usedNames.add(fieldName);
            if (!param.injected()) {
                nonInjected.add(fieldName);
            }
            String genericType = "?";
            List<JavaType> types = param.javaTypes();
            if (types.size() == 1 && (javaType = types.get(0)).isTypeLiteralSupported()) {
                genericType = javaType.asTypeLiteralString();
            }
            String visibility = !"?".equals(genericType) ? "public" : "private";
            CodeGenUtils.Member factory = CodeGenUtils.STANDARD_P;
            if (param.injected()) {
                factory = CodeGenUtils.INJECTED_P;
            } else if (param.indirect()) {
                factory = CodeGenUtils.INDIRECT_P;
            }
            String paramDescription = param.param().getDescription();
            paramDescription = paramDescription == null ? "" : paramDescription + " ";
            String typeToken = "?".equals(genericType) ? "com.google.common.reflect.TypeToken.of(java.lang.Object.class)" : (genericType.matches("(\\.|\\w)+") ? "com.google.common.reflect.TypeToken.of(" + genericType + ".class)" : "new com.google.common.reflect.TypeToken<" + genericType + ">() {}");
            ilb.appendLine(String.format("/** {@%s %s} %s*/", param.injected() ? "inject" : "param", param.name(), paramDescription));
            ilb.appendLine(String.format("%s static final com.google.template.soy.data.SoyTemplateParam<%s>", visibility, genericType));
            ilb.increaseIndent(2);
            ilb.appendLine(fieldName, " =");
            ilb.increaseIndent(2);
            ilb.appendLine(factory, "(");
            ilb.increaseIndent(2);
            ilb.appendLine("\"", param.name(), "\",");
            ilb.appendLine("/* required= */ ", param.required(), ",");
            ilb.appendLine(typeToken, ");");
            ilb.decreaseIndent(6);
            ilb.appendLine(new Object[0]);
        }
        ilb.appendLineStart("private static final com.google.common.collect.ImmutableSet<com.google.template.soy.data.SoyTemplateParam<?>> __PARAMS__ = ");
        JavaGenerationUtils.appendFunctionCallWithParamsOnNewLines(ilb, "com.google.common.collect.ImmutableSet.of", nonInjected);
        ilb.appendLineEnd(";");
        ilb.appendLine(new Object[0]);
    }

    private static void appendRecordListInitializations(IndentedLinesBuilder ilb, List<SoyFileNodeTransformer.ParamInfo> params) {
        for (SoyFileNodeTransformer.ParamInfo param : params) {
            List<JavaType> types;
            if (!param.required() || (types = param.javaTypes()).size() != 1 || !(types.get(0) instanceof RecordJavaType) || !((RecordJavaType)types.get(0)).isList()) continue;
            ilb.appendLine(String.format("%s(%s);", CodeGenUtils.INIT_LIST_PARAM, param.constantFieldName()));
        }
    }

    private void appendFileHeaderAndImports(SoyFileNodeTransformer.FileInfo soyFile) {
        this.ilb.appendLine("// This file was automatically generated by the Soy compiler.");
        this.ilb.appendLine("// Please don't edit this file by hand.");
        this.ilb.appendLine("// source: " + soyFile.soyFilePath());
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("package " + soyFile.packageName() + ";");
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine(new Object[0]);
    }

    private void writeSettersForParam(SoyFileNodeTransformer.ParamInfo param) {
        param.javaTypes().forEach(javaType -> GenInvocationBuildersVisitor.writeSetter(this.ilb, param, javaType));
        switch (param.futureStatus()) {
            case HANDLED: {
                for (JavaType futureType : param.futureTypes()) {
                    GenInvocationBuildersVisitor.writeFutureSetter(this.ilb, param, new FutureJavaType(futureType));
                }
                break;
            }
            case NAME_COLLISION: {
                logger.warning(String.format("Achievement unlocked. You have a template with parameters named %s and %sFuture, preventing a future setter from being created for the first parameter.", param.name(), param.name()));
                break;
            }
        }
    }

    private static void writeSetter(IndentedLinesBuilder ilb, SoyFileNodeTransformer.ParamInfo param, JavaType javaType) {
        String paramDescription = param.param().getDescription();
        ilb.appendLine(new Object[0]);
        JavaGenerationUtils.appendJavadoc(ilb, "Sets " + param.name() + (Strings.isNullOrEmpty((String)paramDescription) ? "." : ": " + paramDescription), false, true);
        if (javaType instanceof RecordJavaType) {
            GenInvocationBuildersVisitor.writeRecordSetter(ilb, param, (RecordJavaType)javaType);
        } else {
            String javaTypeString = javaType.toJavaTypeString();
            boolean nullable = javaType.isNullable();
            ilb.appendLine("public Builder " + param.setterName() + "(" + (nullable ? "@javax.annotation.Nullable " : "") + javaTypeString + " value) {");
            ilb.increaseIndent();
            String newVariableName = javaType.asInlineCast("value");
            ilb.appendLine("return " + CodeGenUtils.SET_PARAM_INTERNAL + "(", param.constantFieldName(), ", ", newVariableName, ");");
            ilb.decreaseIndent();
            ilb.appendLine("}");
        }
    }

    private static void writeRecordSetter(IndentedLinesBuilder ilb, SoyFileNodeTransformer.ParamInfo param, RecordJavaType type) {
        ilb.appendLineStart("public Builder ", type.isList() ? param.adderName() : param.setterName(), "(");
        ImmutableList paramNames = type.getJavaTypeMap().keySet().asList();
        ArrayList<String> javaParamNames = new ArrayList<String>();
        boolean first = true;
        for (Map.Entry entry : type.getJavaTypeMap().entrySet()) {
            JavaType paramType;
            String paramName = GenInvocationBuildersVisitor.makeParamName((String)entry.getKey());
            javaParamNames.add(paramName);
            if (!first) {
                ilb.append(", ");
            }
            if ((paramType = (JavaType)entry.getValue()).isNullable()) {
                ilb.append("@javax.annotation.Nullable ");
            }
            ilb.append(paramType.toJavaTypeString()).append(" ").append(paramName);
            first = false;
        }
        ilb.appendLineEnd(") {");
        ilb.increaseIndent();
        CodeGenUtils.Member delegate = type.isList() ? CodeGenUtils.ADD_TO_LIST_PARAM : CodeGenUtils.SET_PARAM_INTERNAL;
        ilb.appendLineStart("return ", delegate, "(", param.constantFieldName(), ", " + CodeGenUtils.AS_RECORD + "(");
        int numParams = paramNames.size();
        for (int i = 0; i < numParams; ++i) {
            if (i != 0) {
                ilb.append(", ");
            }
            ilb.append("\"").append((CharSequence)paramNames.get(i)).append("\", ").append(((JavaType)type.getJavaTypeMap().get(paramNames.get(i))).asInlineCast((String)javaParamNames.get(i)));
        }
        ilb.appendLineEnd("));");
        ilb.decreaseIndent();
        ilb.appendLine("}");
    }

    private static void writeFutureSetter(IndentedLinesBuilder ilb, SoyFileNodeTransformer.ParamInfo param, FutureJavaType javaType) {
        ilb.appendLine(new Object[0]);
        JavaGenerationUtils.appendJavadoc(ilb, "Future compatible version of {@link #" + param.setterName() + "(" + GenInvocationBuildersVisitor.stripGenerics(javaType.getType().toJavaTypeString()) + ")}.", false, true);
        ilb.appendLine("public Builder " + param.futureSetterName() + "(" + javaType.toJavaTypeString() + " future) {");
        ilb.increaseIndent();
        ilb.appendLine("return " + CodeGenUtils.SET_PARAM_INTERNAL + "(" + param.constantFieldName() + ", " + javaType.asInlineCast("future") + ");");
        ilb.decreaseIndent();
        ilb.appendLine("}");
    }

    private static String stripGenerics(String type) {
        String newType = type;
        while (!(newType = (type = newType).replaceAll("<[^>]*>", "")).equals(type)) {
        }
        return newType;
    }

    private static void logDuplicateTemplateNameWarning(String templateName, String generatedClassName) {
        logger.warning(String.format("When generating Soy Java Template Builders, the template: %s generated the same Java UpperCamelCase name as another template in this file, or collided with a reserved identifier: " + SoyFileNodeTransformer.RESERVED_IDENTIFIERS + ".\nThis template was skipped during Soy java_builders generation.\nTo use this API, all Soy template names in a given file should be unique when converted to UpperCamelCase (with non-alphanumeric characters stripped).\nThe generated Java class name was: %s.", templateName, generatedClassName));
    }

    private static void logDuplicateParamNameWarning(String templateParamName, String setterName, String templateName) {
        logger.warning(String.format("When generating Soy Java Template Builders, the param named %s in template %s generated the same UpperCamelCase name as another parameter, or collided with a reserved identifier: " + SoyFileNodeTransformer.RESERVED_IDENTIFIERS + ".\nParam: %s is being skipped (no setters will be generated for this param). The generated setter name was: %s.\nTo use this API, all parameter names for a given template should be unique when converted to UpperCamelCase (with non-alphanumeric characters stripped).\n", templateParamName, templateName, templateParamName, setterName));
    }

    private static void logWarningIfFilenamesNotUnique(ImmutableList<GeneratedFile> files) {
        ImmutableList duplicateFilenames = (ImmutableList)files.stream().collect(Collectors.groupingBy(GeneratedFile::fileName, Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(e -> (String)e.getKey()).collect(ImmutableList.toImmutableList());
        for (String fileName : duplicateFilenames) {
            logger.warning("While generating Soy Java invocation builders, multiple files in this soy fileset mapped to the same file name: " + fileName + ".\n To use this api, soy file names should be unique when converted to UpperCamelCase (with non-alpha-numeric characters stripped).\n");
        }
    }

    private static String makeParamName(String s) {
        return RESERVED_JAVA_WORDS.contains((Object)(s = JavaGenerationUtils.makeLowerCamelCase(s))) ? s + "_" : s;
    }
}

