/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.invocationbuilders.javatypes;

import com.google.protobuf.Descriptors;
import com.google.template.soy.internal.proto.JavaQualifiedNames;
import com.google.template.soy.invocationbuilders.javatypes.CodeGenUtils;
import com.google.template.soy.invocationbuilders.javatypes.JavaType;

public final class ProtoJavaType
extends JavaType {
    private static final CodeGenUtils.Member AS_PROTO = CodeGenUtils.castFunction("asProto");
    private static final CodeGenUtils.Member AS_NULLABLE_PROTO = CodeGenUtils.castFunction("asNullableProto");
    private final Descriptors.Descriptor protoDescriptor;

    public ProtoJavaType(Descriptors.Descriptor protoDescriptor) {
        this(protoDescriptor, false);
    }

    public ProtoJavaType(Descriptors.Descriptor protoDescriptor, boolean isNullable) {
        super(isNullable);
        this.protoDescriptor = protoDescriptor;
    }

    @Override
    public String toJavaTypeString() {
        return JavaQualifiedNames.getQualifiedName(this.protoDescriptor);
    }

    @Override
    String asGenericsTypeArgumentString() {
        return this.toJavaTypeString();
    }

    @Override
    public ProtoJavaType asNullable() {
        return new ProtoJavaType(this.protoDescriptor, true);
    }

    @Override
    public String getAsInlineCastFunction(int depth) {
        return "AbstractBuilder::" + this.getCastFunction();
    }

    private CodeGenUtils.Member getCastFunction() {
        return this.isNullable() ? AS_NULLABLE_PROTO : AS_PROTO;
    }

    @Override
    public String asInlineCast(String variable, int depth) {
        return this.getCastFunction() + "(" + variable + ")";
    }
}

