/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractExprNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.types.NamedTemplateType;
import com.google.template.soy.types.SoyType;
import java.util.Optional;
import javax.annotation.Nullable;

public final class TemplateLiteralNode
extends AbstractExprNode {
    private final boolean isSynthetic;
    private Identifier templateIdentifier;
    private Optional<String> resolvedName;
    private SoyType type;

    public TemplateLiteralNode(Identifier templateIdentifier, SourceLocation sourceLocation, boolean isSynthetic) {
        super(sourceLocation);
        this.templateIdentifier = templateIdentifier;
        this.resolvedName = Optional.empty();
        this.type = NamedTemplateType.create(templateIdentifier.identifier());
        this.isSynthetic = isSynthetic;
    }

    private TemplateLiteralNode(TemplateLiteralNode orig, CopyState copyState) {
        super(orig, copyState);
        this.templateIdentifier = orig.templateIdentifier;
        this.resolvedName = orig.resolvedName;
        this.type = orig.type;
        this.isSynthetic = orig.isSynthetic;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    public void resolveTemplateName(Identifier resolvedIdent) {
        Preconditions.checkState((!this.resolvedName.isPresent() ? 1 : 0) != 0, (Object)"Template identifier has already been resolved.");
        this.templateIdentifier = resolvedIdent;
        this.resolvedName = Optional.of(resolvedIdent.identifier());
        if (this.type instanceof NamedTemplateType) {
            this.type = NamedTemplateType.create(resolvedIdent.identifier());
        }
    }

    public boolean isResolved() {
        return this.resolvedName.isPresent();
    }

    @Nullable
    public String getResolvedName() {
        return this.resolvedName.orElse(null);
    }

    public Identifier getIdentifier() {
        return this.templateIdentifier;
    }

    @Override
    public SoyType getType() {
        return this.type;
    }

    public void setType(SoyType type) {
        this.type = type;
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.TEMPLATE_LITERAL_NODE;
    }

    @Override
    public String toSourceString() {
        return this.isSynthetic ? this.templateIdentifier.originalName() : "template(" + this.templateIdentifier.originalName() + ")";
    }

    @Override
    public TemplateLiteralNode copy(CopyState copyState) {
        return new TemplateLiteralNode(this, copyState);
    }
}

