/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.ExprNode;

public final class ProtoInitNode
extends AbstractParentExprNode {
    private final Identifier protoName;
    private final ImmutableList<Identifier> paramNames;

    public ProtoInitNode(Identifier protoName, Iterable<Identifier> paramNames, SourceLocation sourceLocation) {
        super(sourceLocation);
        this.protoName = protoName;
        this.paramNames = ImmutableList.copyOf(paramNames);
    }

    private ProtoInitNode(ProtoInitNode orig, CopyState copyState) {
        super(orig, copyState);
        this.protoName = orig.protoName;
        this.paramNames = orig.paramNames;
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.PROTO_INIT_NODE;
    }

    public String getProtoName() {
        return this.protoName.identifier();
    }

    public Identifier getIdentifier() {
        return this.protoName;
    }

    public ImmutableList<Identifier> getParamNames() {
        return this.paramNames;
    }

    public Identifier getParamName(int i) {
        return (Identifier)this.paramNames.get(i);
    }

    @Override
    public String toSourceString() {
        StringBuilder sourceSb = new StringBuilder();
        sourceSb.append(this.protoName).append('(');
        for (int i = 0; i < this.numChildren(); ++i) {
            if (i > 0) {
                sourceSb.append(", ");
            }
            sourceSb.append(this.paramNames.get(i)).append(": ");
            sourceSb.append(this.getChild(i).toSourceString());
        }
        sourceSb.append(')');
        return sourceSb.toString();
    }

    @Override
    public ProtoInitNode copy(CopyState copyState) {
        return new ProtoInitNode(this, copyState);
    }
}

