/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.shared.restricted.SoyMethod;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import java.util.List;

public final class MethodCallNode
extends DataAccessNode {
    private final Identifier methodName;
    private SoyMethod method;

    public MethodCallNode(ExprNode base, List<ExprNode> params, Identifier methodName, SourceLocation location, boolean isNullSafe) {
        super(base, location, isNullSafe);
        Preconditions.checkArgument((methodName != null ? 1 : 0) != 0);
        this.methodName = methodName;
        this.addChildren((List<? extends ExprNode>)params);
    }

    private MethodCallNode(MethodCallNode orig, CopyState copyState) {
        super(orig, copyState);
        this.methodName = orig.methodName;
        this.method = orig.method;
    }

    public Identifier getMethodName() {
        return this.methodName;
    }

    public void setSoyMethod(SoyMethod method) {
        this.method = method;
    }

    public SoyMethod getSoyMethod() {
        Preconditions.checkState((this.method != null ? 1 : 0) != 0, (Object)"setSoyMethod() hasn't been called yet");
        return this.method;
    }

    public SoyType getBaseType(boolean nullSafe) {
        SoyType type = this.getBaseExprChild().getType();
        if (nullSafe) {
            type = SoyTypes.tryRemoveNull(type);
        }
        return type;
    }

    public List<ExprNode> getParams() {
        return this.getChildren().subList(1, this.numChildren());
    }

    public int numParams() {
        return this.numChildren() - 1;
    }

    public boolean isMethodResolved() {
        return this.method != null;
    }

    @Override
    public String getSourceStringSuffix() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.isNullSafe ? "?." : ".").append(this.getMethodName().identifier()).append('(');
        for (int i = 1; i < this.numChildren(); ++i) {
            if (i > 1) {
                sb.append(", ");
            }
            sb.append(this.getChild(i).toSourceString());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.METHOD_CALL_NODE;
    }

    @Override
    public ExprNode copy(CopyState copyState) {
        return new MethodCallNode(this, copyState);
    }
}

