/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.exprtree.AbstractVarDefn;
import com.google.template.soy.types.SoyType;

public abstract class AbstractLocalVarDefn<T extends Node>
extends AbstractVarDefn {
    private final T declaringNode;

    private static String checkAndFixName(String name) {
        Preconditions.checkArgument((name.charAt(0) == '$' ? 1 : 0) != 0);
        return name.substring(1);
    }

    public AbstractLocalVarDefn(String name, SourceLocation nameLocation, T declaringNode, SoyType type) {
        super(AbstractLocalVarDefn.checkAndFixName(name), nameLocation, type);
        this.declaringNode = declaringNode;
    }

    public AbstractLocalVarDefn(AbstractLocalVarDefn<T> localVar, T declaringNode) {
        super(localVar);
        Preconditions.checkArgument((localVar.declaringNode != declaringNode ? 1 : 0) != 0);
        this.declaringNode = declaringNode;
    }

    public void setType(SoyType type) {
        this.type = type;
    }

    public T declaringNode() {
        return this.declaringNode;
    }

    @Override
    public boolean isInjected() {
        return false;
    }
}

