/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.error;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SourceSnippetPrinter;
import com.google.template.soy.error.SoyError;
import com.google.template.soy.error.SoyErrorKind;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

final class ErrorReporterImpl
extends ErrorReporter {
    private final List<RecordedError> reports = new ArrayList<RecordedError>();
    private int errorCount;
    private final ImmutableMap<String, SoyFileSupplier> filePathsToSuppliers;
    private static final SourceSnippetPrinter snippetPrinter = new SourceSnippetPrinter();

    ErrorReporterImpl(ImmutableMap<String, SoyFileSupplier> filePathsToSuppliers) {
        this.filePathsToSuppliers = filePathsToSuppliers;
    }

    @Override
    public void report(SourceLocation location, SoyErrorKind kind, Object ... args) {
        ++this.errorCount;
        this.reports.add(new RecordedError(location, kind, args, false));
    }

    @Override
    public void warn(SourceLocation location, SoyErrorKind kind, Object ... args) {
        this.reports.add(new RecordedError(location, kind, args, true));
    }

    @Override
    public ImmutableList<SoyError> getErrors() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (RecordedError report : this.reports) {
            if (report.isWarning) continue;
            builder.add((Object)report.asSoyError(this.filePathsToSuppliers));
        }
        return builder.build();
    }

    @Override
    public ImmutableList<SoyError> getWarnings() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (RecordedError report : this.reports) {
            if (!report.isWarning) continue;
            builder.add((Object)report.asSoyError(this.filePathsToSuppliers));
        }
        return builder.build();
    }

    @Override
    public void copyTo(ErrorReporter other) {
        for (RecordedError report : this.reports) {
            report.copyTo(other);
        }
    }

    @Override
    int getCurrentNumberOfErrors() {
        return this.errorCount;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("errors", this.errorCount).add("warnings", this.reports.size() - this.errorCount).toString();
    }

    private static final class RecordedError {
        final SourceLocation location;
        final SoyErrorKind kind;
        final Object[] args;
        final boolean isWarning;

        RecordedError(SourceLocation location, SoyErrorKind kind, Object[] args, boolean isWarning) {
            this.location = (SourceLocation)Preconditions.checkNotNull((Object)location);
            this.kind = (SoyErrorKind)Preconditions.checkNotNull((Object)kind);
            this.args = (Object[])Preconditions.checkNotNull((Object)args);
            this.isWarning = isWarning;
        }

        void copyTo(ErrorReporter other) {
            if (this.isWarning) {
                other.warn(this.location, this.kind, this.args);
            } else {
                other.report(this.location, this.kind, this.args);
            }
        }

        SoyError asSoyError(ImmutableMap<String, SoyFileSupplier> filePathsToSuppliers) {
            Optional<String> snippet = Optional.ofNullable((SoyFileSupplier)filePathsToSuppliers.get((Object)this.location.getFilePath())).flatMap(supplier -> snippetPrinter.getSnippet((SoyFileSupplier)supplier, this.location));
            return SoyError.create(this.location, this.kind, this.kind.format(this.args), snippet, this.isWarning);
        }
    }
}

