/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internalutils;

import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.StringNode;
import java.util.Map;
import javax.annotation.Nullable;

public class InternalValueUtils {
    private InternalValueUtils() {
    }

    @Nullable
    public static ExprNode.PrimitiveNode convertPrimitiveDataToExpr(PrimitiveData primitiveData, SourceLocation location) {
        if (primitiveData instanceof StringData) {
            return new StringNode(primitiveData.stringValue(), QuoteStyle.SINGLE, location);
        }
        if (primitiveData instanceof BooleanData) {
            return new BooleanNode(primitiveData.booleanValue(), location);
        }
        if (primitiveData instanceof IntegerData) {
            if (!IntegerNode.isInRange(primitiveData.longValue())) {
                return null;
            }
            return new IntegerNode(primitiveData.longValue(), location);
        }
        if (primitiveData instanceof FloatData) {
            return new FloatNode(primitiveData.floatValue(), location);
        }
        if (primitiveData instanceof NullData) {
            return new NullNode(location);
        }
        throw new IllegalArgumentException("can't convert: " + (primitiveData instanceof UndefinedData ? "undefined" : primitiveData) + " to an ExprNode");
    }

    public static PrimitiveData convertPrimitiveExprToData(ExprNode.PrimitiveNode primitiveNode) {
        if (primitiveNode instanceof StringNode) {
            return StringData.forValue(((StringNode)primitiveNode).getValue());
        }
        if (primitiveNode instanceof BooleanNode) {
            return BooleanData.forValue(((BooleanNode)primitiveNode).getValue());
        }
        if (primitiveNode instanceof IntegerNode) {
            return IntegerData.forValue(((IntegerNode)primitiveNode).getValue());
        }
        if (primitiveNode instanceof FloatNode) {
            return FloatData.forValue(((FloatNode)primitiveNode).getValue());
        }
        if (primitiveNode instanceof NullNode) {
            return NullData.INSTANCE;
        }
        throw new IllegalArgumentException();
    }

    public static ImmutableMap<String, PrimitiveData> convertCompileTimeGlobalsMap(Map<String, ?> compileTimeGlobalsMap) {
        ImmutableMap.Builder resultMapBuilder = ImmutableMap.builder();
        for (Map.Entry<String, ?> entry : compileTimeGlobalsMap.entrySet()) {
            PrimitiveData value;
            Object valueObj = entry.getValue();
            boolean isValidValue = true;
            try {
                SoyValue value0 = SoyValueConverter.INSTANCE.convert(valueObj).resolve();
                if (!(value0 instanceof PrimitiveData)) {
                    isValidValue = false;
                }
                value = (PrimitiveData)value0;
            }
            catch (SoyDataException sde) {
                isValidValue = false;
                value = null;
            }
            if (!isValidValue) {
                throw new IllegalArgumentException("Compile-time globals map contains invalid value: " + valueObj + " for key: " + entry.getKey());
            }
            resultMapBuilder.put((Object)entry.getKey(), (Object)value);
        }
        return resultMapBuilder.build();
    }
}

