/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SoyAbstractValue;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.restricted.StringData;
import java.io.IOException;
import java.util.Map;

public final class SoyLegacyObjectMapImpl
extends SoyAbstractValue
implements SoyLegacyObjectMap {
    private final ImmutableMap<String, SoyValueProvider> map;

    public SoyLegacyObjectMapImpl(ImmutableMap<String, SoyValueProvider> map) {
        this.map = (ImmutableMap)Preconditions.checkNotNull(map);
    }

    @Override
    public int getItemCnt() {
        return this.map.size();
    }

    @Override
    public Iterable<? extends SoyValue> getItemKeys() {
        return Iterables.transform((Iterable)this.map.keySet(), StringData::forValue);
    }

    @Override
    public boolean hasItem(SoyValue key) {
        return this.map.containsKey((Object)SoyLegacyObjectMapImpl.getStringKey(key));
    }

    @Override
    public SoyValue getItem(SoyValue key) {
        SoyValueProvider provider = this.getItemProvider(key);
        return provider != null ? provider.resolve() : null;
    }

    @Override
    public SoyValueProvider getItemProvider(SoyValue key) {
        return (SoyValueProvider)this.map.get((Object)SoyLegacyObjectMapImpl.getStringKey(key));
    }

    @Override
    public boolean coerceToBoolean() {
        return true;
    }

    @Override
    public String coerceToString() {
        LoggingAdvisingAppendable.BufferingAppendable mapStr = LoggingAdvisingAppendable.buffering();
        try {
            this.render(mapStr);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return ((Object)mapStr).toString();
    }

    @Override
    public void render(LoggingAdvisingAppendable appendable) throws IOException {
        appendable.append('{');
        boolean isFirst = true;
        for (Map.Entry entry : this.map.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                appendable.append(", ");
            }
            appendable.append((CharSequence)entry.getKey()).append(": ");
            ((SoyValueProvider)entry.getValue()).resolve().render(appendable);
        }
        appendable.append('}');
    }

    @Override
    public final boolean equals(Object other) {
        return this == other;
    }

    @Override
    public final int hashCode() {
        return System.identityHashCode(this);
    }

    private static String getStringKey(SoyValue key) {
        try {
            return key.stringValue();
        }
        catch (SoyDataException e) {
            throw new SoyDataException("SoyLegacyObjectMap accessed with non-string key (got key type " + key.getClass().getName() + ").", e);
        }
    }
}

