/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internal;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SoyAbstractValue;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.StringData;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
abstract class AbstractSoyList
extends SoyAbstractValue
implements SoyList {
    AbstractSoyList() {
    }

    @Override
    public final int getItemCnt() {
        return this.length();
    }

    @Nonnull
    public final Iterable<IntegerData> getItemKeys() {
        ImmutableList.Builder indicesBuilder = ImmutableList.builder();
        int n = this.length();
        for (int i = 0; i < n; ++i) {
            indicesBuilder.add((Object)IntegerData.forValue(i));
        }
        return indicesBuilder.build();
    }

    @Override
    public final boolean hasItem(SoyValue key) {
        int index = AbstractSoyList.getIntegerIndex(key);
        return 0 <= index && index < this.length();
    }

    @Override
    public final SoyValue getItem(SoyValue key) {
        return this.get(AbstractSoyList.getIntegerIndex(key));
    }

    @Override
    public final SoyValueProvider getItemProvider(SoyValue key) {
        return this.getProvider(AbstractSoyList.getIntegerIndex(key));
    }

    private static int getIntegerIndex(SoyValue key) {
        if (key instanceof StringData) {
            try {
                return Integer.parseInt(key.stringValue());
            }
            catch (IllegalArgumentException e) {
                throw new SoyDataException("\"" + key + "\" is not a valid list index (must be an int)", e);
            }
        }
        return key.integerValue();
    }

    @Override
    public final boolean equals(Object other) {
        return this == other;
    }

    @Override
    public final int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public final boolean coerceToBoolean() {
        return true;
    }

    @Override
    public final String coerceToString() {
        LoggingAdvisingAppendable.BufferingAppendable listStr = LoggingAdvisingAppendable.buffering();
        try {
            this.render(listStr);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return ((Object)listStr).toString();
    }

    @Override
    public void render(LoggingAdvisingAppendable appendable) throws IOException {
        appendable.append('[');
        boolean isFirst = true;
        for (SoyValueProvider soyValueProvider : this.asJavaList()) {
            if (isFirst) {
                isFirst = false;
            } else {
                appendable.append(", ");
            }
            soyValueProvider.resolve().render(appendable);
        }
        appendable.append(']');
    }
}

