/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.data.SoyTemplate;
import com.google.template.soy.data.SoyTemplateParam;
import com.google.template.soy.parseinfo.SoyTemplateInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class SoyTemplates {
    private static final ClassValue<String> templateNameValue = new ClassValue<String>(){

        @Override
        protected String computeValue(Class<?> type) {
            try {
                Field field = type.getDeclaredField("__NAME__");
                field.setAccessible(true);
                return (String)field.get(null);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Unexpected error while accessing the template name of " + type.getName(), e);
            }
        }
    };
    private static final ClassValue<ImmutableSet<SoyTemplateParam<?>>> templateParamsValue = new ClassValue<ImmutableSet<SoyTemplateParam<?>>>(){

        @Override
        protected ImmutableSet<SoyTemplateParam<?>> computeValue(Class<?> type) {
            try {
                Field field = type.getDeclaredField("__PARAMS__");
                field.setAccessible(true);
                return (ImmutableSet)field.get(null);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Unexpected error while accessing the template params of " + type.getName(), e);
            }
        }
    };

    private SoyTemplates() {
    }

    public static <T extends SoyTemplate> T getDefaultInstance(Class<T> type) {
        try {
            Method factory = type.getDeclaredMethod("getDefaultInstance", new Class[0]);
            Object instance = factory.invoke(null, new Object[0]);
            return (T)((SoyTemplate)type.cast(instance));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No default instance for template type " + type.getName(), e);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unexpected error while calling getDefaultInstance() on " + type.getName(), e);
        }
    }

    public static <T extends SoyTemplate> SoyTemplate.Builder<T> getBuilder(Class<T> type) {
        try {
            Method factory = type.getDeclaredMethod("builder", new Class[0]);
            SoyTemplate.Builder instance = (SoyTemplate.Builder)factory.invoke(null, new Object[0]);
            return instance;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unexpected error while calling builder() on " + type.getName(), e);
        }
    }

    public static String getTemplateName(Class<? extends SoyTemplate> type) {
        return templateNameValue.get(type);
    }

    static ImmutableSet<SoyTemplateParam<?>> getParams(Class<? extends SoyTemplate> type) {
        return templateParamsValue.get(type);
    }

    public static SoyTemplateInfo asSoyTemplateInfo(Class<? extends SoyTemplate> type) {
        return new SoyTemplateInfoShim(type);
    }

    private static final class SoyTemplateInfoShim
    extends SoyTemplateInfo {
        SoyTemplateInfoShim(Class<? extends SoyTemplate> type) {
            super(SoyTemplates.getTemplateName(type), SoyTemplateInfoShim.paramsAsMap(SoyTemplates.getParams(type)));
        }

        private static ImmutableMap<String, SoyTemplateInfo.ParamRequisiteness> paramsAsMap(ImmutableSet<SoyTemplateParam<?>> params) {
            return (ImmutableMap)params.stream().collect(ImmutableMap.toImmutableMap(SoyTemplateParam::getName, p -> p.isRequired() ? SoyTemplateInfo.ParamRequisiteness.REQUIRED : SoyTemplateInfo.ParamRequisiteness.OPTIONAL));
        }
    }
}

