/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.google.template.soy.data.Flags;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.ProtoFieldInterpreter;
import com.google.template.soy.data.SoyAbstractValue;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.internal.proto.Field;
import com.google.template.soy.internal.proto.JavaQualifiedNames;
import com.google.template.soy.jbcsrc.shared.Names;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SoyProtoValue
extends SoyAbstractValue
implements SoyLegacyObjectMap,
SoyRecord {
    private static final Logger logger = Logger.getLogger(SoyProtoValue.class.getName());
    private static final LoadingCache<Descriptors.Descriptor, ProtoClass> classCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<Descriptors.Descriptor, ProtoClass>(){
        final Field.Factory<FieldWithInterpreter> factory = FieldWithInterpreter::new;

        public ProtoClass load(Descriptors.Descriptor descriptor) throws Exception {
            LinkedHashSet<Descriptors.FieldDescriptor> extensions = new LinkedHashSet<Descriptors.FieldDescriptor>();
            return new ProtoClass(SoyProtoValue.getDefaultInstance(descriptor), Field.getFieldsForType(descriptor, extensions, this.factory));
        }
    });
    private final Message proto;
    private ProtoClass clazz;
    private Object locationKey;

    private static Message getDefaultInstance(Descriptors.Descriptor key) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> messageClass = Class.forName(JavaQualifiedNames.getClassName(key));
        return (Message)messageClass.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]);
    }

    public static SoyProtoValue create(Message proto) {
        return new SoyProtoValue(proto);
    }

    private SoyProtoValue(Message proto) {
        this.proto = (Message)Preconditions.checkNotNull((Object)proto);
    }

    private ProtoClass clazz() {
        ProtoClass localClazz = this.clazz;
        if (localClazz == null) {
            this.clazz = localClazz = (ProtoClass)classCache.getUnchecked((Object)this.proto.getDescriptorForType());
        }
        return localClazz;
    }

    public Message getProto() {
        return this.proto;
    }

    public SoyValue getProtoField(String name) {
        return this.getProtoField(name, true);
    }

    public SoyValue getProtoField(String name, boolean useBrokenProtoSemantics) {
        FieldWithInterpreter field = (FieldWithInterpreter)this.clazz().fields.get((Object)name);
        if (field == null) {
            throw new IllegalArgumentException("Proto " + this.proto.getClass().getName() + " does not have a field of name " + name);
        }
        if (useBrokenProtoSemantics && field.shouldCheckFieldPresenceToEmulateJspbNullability() && !this.proto.hasField(field.getDescriptor())) {
            return NullData.INSTANCE;
        }
        return field.interpretField(this.proto);
    }

    public boolean hasProtoField(String name) {
        FieldWithInterpreter field = (FieldWithInterpreter)this.clazz().fields.get((Object)name);
        if (field == null) {
            throw new IllegalArgumentException("Proto " + this.proto.getClass().getName() + " does not have a field of name " + name);
        }
        if (field.getDescriptor().isRepeated()) {
            throw new IllegalArgumentException("Cannot check for presence on repeated field " + name);
        }
        return this.proto.hasField(field.getDescriptor());
    }

    public void setAccessLocationKey(Object location) {
        this.locationKey = location;
    }

    @Override
    @Deprecated
    public boolean hasField(String name) {
        if (this.asRecord()) {
            return this.doHasField(name);
        }
        return false;
    }

    private boolean doHasField(String name) {
        FieldWithInterpreter field = (FieldWithInterpreter)this.clazz().fields.get((Object)name);
        if (field == null) {
            return false;
        }
        return field.hasField(this.proto);
    }

    @Override
    @Deprecated
    public SoyValue getField(String name) {
        if (this.asRecord()) {
            return this.doGetField(name);
        }
        return null;
    }

    private SoyValue doGetField(String name) {
        SoyValueProvider valueProvider = this.doGetFieldProvider(name);
        return valueProvider != null ? valueProvider.resolve() : null;
    }

    @Override
    @Deprecated
    public SoyValueProvider getFieldProvider(String name) {
        if (this.asRecord()) {
            return this.doGetFieldProvider(name);
        }
        return null;
    }

    private SoyValueProvider doGetFieldProvider(String name) {
        if (!this.doHasField(name)) {
            return null;
        }
        return ((FieldWithInterpreter)this.clazz().fields.get((Object)name)).interpretField(this.proto).resolve();
    }

    @Override
    public final ImmutableMap<String, SoyValueProvider> recordAsMap() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public int getItemCnt() {
        return this.getItemKeys().size();
    }

    @Deprecated
    public Collection<SoyValue> getItemKeys() {
        if (this.asMap()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String key : this.clazz().fields.keySet()) {
                if (!this.doHasField(key)) continue;
                builder.add((Object)StringData.forValue(key));
            }
            return builder.build();
        }
        return ImmutableList.of();
    }

    @Override
    @Deprecated
    public boolean hasItem(SoyValue key) {
        if (this.asMap()) {
            return this.doHasField(key.stringValue());
        }
        return false;
    }

    @Override
    @Deprecated
    public SoyValue getItem(SoyValue key) {
        if (this.asMap()) {
            return this.doGetField(key.stringValue());
        }
        return null;
    }

    @Override
    @Deprecated
    public SoyValueProvider getItemProvider(SoyValue key) {
        if (this.asMap()) {
            return this.doGetFieldProvider(key.stringValue());
        }
        return null;
    }

    @CheckReturnValue
    private boolean asMap() {
        return this.asDeprecatedType("map");
    }

    @CheckReturnValue
    private boolean asRecord() {
        return this.asDeprecatedType("record");
    }

    @CheckReturnValue
    private boolean asDeprecatedType(String type) {
        Object locationKey = this.getAndClearLocationKey();
        String fullName = this.clazz().fullName;
        if (locationKey == null) {
            Exception e = new Exception("bad proto access");
            Names.rewriteStackTrace(e);
            logger.log(Level.SEVERE, String.format("Accessing a proto of type %s as a %s is deprecated. Add static types to fix.", fullName, type), e);
        } else {
            logger.log(Level.SEVERE, String.format("Accessing a proto of type %s as a %s is deprecated. Add static types to fix.\n\t%s", fullName, type, locationKey), new Exception("bad proto access @" + locationKey));
        }
        return Flags.allowReflectiveProtoAccess();
    }

    private Object getAndClearLocationKey() {
        Object key = this.locationKey;
        if (key != null) {
            this.locationKey = null;
        }
        return key;
    }

    @Override
    public boolean equals(Object other) {
        return other != null && this.getClass() == other.getClass() && this.proto == ((SoyProtoValue)other).proto;
    }

    @Override
    public boolean coerceToBoolean() {
        return true;
    }

    @Override
    public String coerceToString() {
        return this.proto.toString();
    }

    @Override
    public void render(LoggingAdvisingAppendable appendable) throws IOException {
        TextFormat.print((MessageOrBuilder)this.proto, (Appendable)appendable);
    }

    public String toString() {
        return String.format("SoyProtoValue<%s>", this.proto.getDescriptorForType().getFullName());
    }

    @Override
    public int hashCode() {
        return this.proto.hashCode();
    }

    public static final class Builder {
        private final ProtoClass clazz;
        private final Message.Builder builder;

        public Builder(Descriptors.Descriptor soyProto) {
            this.clazz = (ProtoClass)classCache.getUnchecked((Object)soyProto);
            this.builder = this.clazz.defaultInstance.newBuilderForType();
        }

        public Builder setField(String field, SoyValue value) {
            ((FieldWithInterpreter)this.clazz.fields.get((Object)field)).assignField(this.builder, value);
            return this;
        }

        public SoyProtoValue build() {
            SoyProtoValue soyProtoValue = new SoyProtoValue(this.builder.build());
            soyProtoValue.clazz = this.clazz;
            return soyProtoValue;
        }
    }

    private static final class FieldWithInterpreter
    extends Field {
        @LazyInit
        ProtoFieldInterpreter interpreter;

        FieldWithInterpreter(Descriptors.FieldDescriptor fieldDesc) {
            super(fieldDesc);
        }

        private ProtoFieldInterpreter impl() {
            ProtoFieldInterpreter local = this.interpreter;
            if (local == null) {
                local = ProtoFieldInterpreter.create(this.getDescriptor());
            }
            return local;
        }

        public SoyValue interpretField(Message message) {
            return this.impl().soyFromProto(message.getField(this.getDescriptor()));
        }

        public void assignField(Message.Builder builder, SoyValue value) {
            builder.setField(this.getDescriptor(), this.impl().protoFromSoy(value));
        }

        boolean hasField(Message proto) {
            return !this.shouldCheckFieldPresenceToEmulateJspbNullability() || proto.hasField(this.getDescriptor());
        }
    }

    private static final class ProtoClass {
        final ImmutableMap<String, FieldWithInterpreter> fields;
        final Message defaultInstance;
        final String fullName;

        ProtoClass(Message defaultInstance, ImmutableMap<String, FieldWithInterpreter> fields) {
            this.fullName = defaultInstance.getDescriptorForType().getFullName();
            this.defaultInstance = (Message)Preconditions.checkNotNull((Object)defaultInstance);
            this.fields = (ImmutableMap)Preconditions.checkNotNull(fields);
        }
    }
}

