/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.base.Preconditions;
import com.google.common.html.types.SafeHtml;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeHtmls;
import com.google.common.html.types.SafeScript;
import com.google.common.html.types.SafeScriptProto;
import com.google.common.html.types.SafeScripts;
import com.google.common.html.types.SafeStyle;
import com.google.common.html.types.SafeStyleProto;
import com.google.common.html.types.SafeStyleSheet;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.common.html.types.SafeStyleSheets;
import com.google.common.html.types.SafeStyles;
import com.google.common.html.types.SafeUrl;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.SafeUrls;
import com.google.common.html.types.TrustedResourceUrl;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.common.html.types.TrustedResourceUrls;
import com.google.common.html.types.UncheckedConversions;
import com.google.errorprone.annotations.DoNotMock;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.data.Dir;
import com.google.template.soy.data.Flags;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.restricted.SoyString;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@Immutable
@DoNotMock(value="Use SanitizedContents.emptyString or UnsafeSanitizedContentOrdainer.ordainAsSafe")
public class SanitizedContent
extends SoyData {
    private final ContentKind contentKind;
    private final Dir contentDir;
    private final String content;

    static SanitizedContent create(String content, ContentKind kind, @Nullable Dir dir) {
        Preconditions.checkArgument((kind != ContentKind.TEXT ? 1 : 0) != 0, (Object)"Use UnsanitizedString for SanitizedContent with a kind of TEXT");
        if (Flags.stringIsNotSanitizedContent()) {
            return new SanitizedContent(content, kind, dir);
        }
        return SanitizedCompatString.create(content, kind, dir);
    }

    static SanitizedContent create(String content, ContentKind kind) {
        Preconditions.checkArgument((kind != ContentKind.TEXT ? 1 : 0) != 0, (Object)"Use UnsanitizedString for SanitizedContent with a kind of TEXT");
        if (Flags.stringIsNotSanitizedContent()) {
            return new SanitizedContent(content, kind, kind.getDefaultDir());
        }
        return SanitizedCompatString.create(content, kind, kind.getDefaultDir());
    }

    SanitizedContent(String content, ContentKind contentKind, @Nullable Dir contentDir) {
        this.content = content;
        this.contentKind = contentKind;
        this.contentDir = contentDir;
    }

    public String getContent() {
        return this.content;
    }

    public final ContentKind getContentKind() {
        return this.contentKind;
    }

    @Nullable
    public Dir getContentDirection() {
        return this.contentDir;
    }

    @Override
    public boolean coerceToBoolean() {
        return this.getContent().length() > 0;
    }

    @Override
    public String coerceToString() {
        return this.toString();
    }

    public String toString() {
        return this.getContent();
    }

    @Override
    public void render(LoggingAdvisingAppendable appendable) throws IOException {
        appendable.setSanitizedContentKind(this.getContentKind()).setSanitizedContentDirectionality(this.getContentDirection()).append(this.content);
    }

    @Override
    public String stringValue() {
        return this.getContent();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof SanitizedContent && this.contentKind == ((SanitizedContent)other).contentKind && this.contentDir == ((SanitizedContent)other).contentDir && this.getContent().equals(((SanitizedContent)other).getContent());
    }

    @Override
    public int hashCode() {
        return this.getContent().hashCode() + 31 * this.contentKind.hashCode();
    }

    public SafeHtml toSafeHtml() {
        Preconditions.checkState((this.getContentKind() == ContentKind.HTML ? 1 : 0) != 0, (String)"toSafeHtml() only valid for SanitizedContent of kind HTML, is: %s", (Object)((Object)this.getContentKind()));
        return UncheckedConversions.safeHtmlFromStringKnownToSatisfyTypeContract((String)this.getContent());
    }

    public SafeHtmlProto toSafeHtmlProto() {
        return SafeHtmls.toProto((SafeHtml)this.toSafeHtml());
    }

    public SafeScript toSafeScript() {
        Preconditions.checkState((this.getContentKind() == ContentKind.JS ? 1 : 0) != 0, (String)"toSafeScript() only valid for SanitizedContent of kind JS, is: %s", (Object)((Object)this.getContentKind()));
        return UncheckedConversions.safeScriptFromStringKnownToSatisfyTypeContract((String)this.getContent());
    }

    public SafeScriptProto toSafeScriptProto() {
        return SafeScripts.toProto((SafeScript)this.toSafeScript());
    }

    public SafeStyle toSafeStyle() {
        Preconditions.checkState((this.getContentKind() == ContentKind.CSS ? 1 : 0) != 0, (String)"toSafeStyle() only valid for SanitizedContent of kind CSS, is: %s", (Object)((Object)this.getContentKind()));
        Preconditions.checkState((!this.getContent().contains("{") ? 1 : 0) != 0, (Object)"Calling toSafeStyle() with content that doesn't look like CSS declarations. Consider using toSafeStyleSheet().");
        return UncheckedConversions.safeStyleFromStringKnownToSatisfyTypeContract((String)this.getContent());
    }

    public SafeStyleProto toSafeStyleProto() {
        return SafeStyles.toProto((SafeStyle)this.toSafeStyle());
    }

    public SafeStyleSheet toSafeStyleSheet() {
        Preconditions.checkState((this.getContentKind() == ContentKind.CSS ? 1 : 0) != 0, (String)"toSafeStyleSheet() only valid for SanitizedContent of kind CSS, is: %s", (Object)((Object)this.getContentKind()));
        Preconditions.checkState((this.getContent().isEmpty() || this.getContent().indexOf(123) > 0 ? 1 : 0) != 0, (Object)"Calling toSafeStyleSheet() with content that doesn't look like a stylesheet");
        return UncheckedConversions.safeStyleSheetFromStringKnownToSatisfyTypeContract((String)this.getContent());
    }

    public SafeStyleSheetProto toSafeStyleSheetProto() {
        return SafeStyleSheets.toProto((SafeStyleSheet)this.toSafeStyleSheet());
    }

    public SafeUrl toSafeUrl() {
        Preconditions.checkState((this.getContentKind() == ContentKind.URI ? 1 : 0) != 0, (String)"toSafeUrl() only valid for SanitizedContent of kind URI, is: %s", (Object)((Object)this.getContentKind()));
        return UncheckedConversions.safeUrlFromStringKnownToSatisfyTypeContract((String)this.getContent());
    }

    public SafeUrlProto toSafeUrlProto() {
        return SafeUrls.toProto((SafeUrl)this.toSafeUrl());
    }

    public TrustedResourceUrl toTrustedResourceUrl() {
        Preconditions.checkState((this.getContentKind() == ContentKind.TRUSTED_RESOURCE_URI ? 1 : 0) != 0, (String)"toTrustedResourceUrl() only valid for SanitizedContent of kind TRUSTED_RESOURCE_URI, is: %s", (Object)((Object)this.getContentKind()));
        return UncheckedConversions.trustedResourceUrlFromStringKnownToSatisfyTypeContract((String)this.getContent());
    }

    public TrustedResourceUrlProto toTrustedResourceUrlProto() {
        return TrustedResourceUrls.toProto((TrustedResourceUrl)this.toTrustedResourceUrl());
    }

    private static final class SanitizedCompatString
    extends SanitizedContent
    implements SoyString {
        private SanitizedCompatString(String content, ContentKind contentKind, @Nullable Dir contentDir) {
            super(content, contentKind, contentDir);
        }

        static SanitizedCompatString create(String content, ContentKind kind, @Nullable Dir dir) {
            return new SanitizedCompatString(content, kind, dir);
        }

        static SanitizedCompatString create(String content, ContentKind kind) {
            return new SanitizedCompatString(content, kind, kind.getDefaultDir());
        }
    }

    public static enum ContentKind {
        HTML,
        JS,
        URI,
        TRUSTED_RESOURCE_URI,
        ATTRIBUTES,
        CSS,
        TEXT;


        @Nullable
        public Dir getDefaultDir() {
            switch (this) {
                case JS: 
                case URI: 
                case ATTRIBUTES: 
                case CSS: 
                case TRUSTED_RESOURCE_URI: {
                    return Dir.LTR;
                }
                case HTML: 
                case TEXT: {
                    return null;
                }
            }
            throw new AssertionError((Object)this);
        }
    }
}

