/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.error.SoyErrorKind;
import java.util.Optional;
import java.util.TreeMap;

public abstract class TemplateContentKind {
    public static final SoyErrorKind INVALID_ATTRIBUTE_VALUE = SoyErrorKind.of("Invalid value for template attribute ''kind'', expected one of " + BasicTemplateContentKind.access$000().keySet() + ".", new SoyErrorKind.StyleAllowance[0]);
    public static final BasicTemplateContentKind HTML = (BasicTemplateContentKind)BasicTemplateContentKind.access$000().get((Object)SanitizedContentKind.HTML.asAttributeValue());

    public static Optional<TemplateContentKind> fromAttributeValue(String attrValue) {
        Preconditions.checkNotNull((Object)attrValue);
        if (BasicTemplateContentKind.KINDS_BY_ATTR_VALUE.containsKey((Object)attrValue)) {
            return Optional.of((TemplateContentKind)BasicTemplateContentKind.KINDS_BY_ATTR_VALUE.get((Object)attrValue));
        }
        if (attrValue.equals("element")) {
            return Optional.of(ElementContentKind.ELEMENT);
        }
        return Optional.empty();
    }

    public abstract String asAttributeValue();

    public abstract SanitizedContentKind getSanitizedContentKind();

    public static class ElementContentKind
    extends TemplateContentKind {
        public static final ElementContentKind ELEMENT = new ElementContentKind("element");
        public static final boolean IS_GA = false;
        private final String attrValue;

        private ElementContentKind(String attrValue) {
            this.attrValue = attrValue;
        }

        @Override
        public String asAttributeValue() {
            return this.attrValue;
        }

        @Override
        public SanitizedContentKind getSanitizedContentKind() {
            return SanitizedContentKind.HTML;
        }
    }

    public static class BasicTemplateContentKind
    extends TemplateContentKind {
        private static final ImmutableMap<String, BasicTemplateContentKind> KINDS_BY_ATTR_VALUE;
        private final SanitizedContentKind sanitizedContentKind;

        private BasicTemplateContentKind(SanitizedContentKind kind) {
            this.sanitizedContentKind = (SanitizedContentKind)((Object)Preconditions.checkNotNull((Object)((Object)kind)));
        }

        @Override
        public String asAttributeValue() {
            return this.sanitizedContentKind.asAttributeValue();
        }

        @Override
        public SanitizedContentKind getSanitizedContentKind() {
            return this.sanitizedContentKind;
        }

        static {
            TreeMap<String, BasicTemplateContentKind> kindsByAttributeValue = new TreeMap<String, BasicTemplateContentKind>();
            for (SanitizedContentKind kind : SanitizedContentKind.values()) {
                kindsByAttributeValue.put(kind.asAttributeValue(), new BasicTemplateContentKind(kind));
            }
            KINDS_BY_ATTR_VALUE = ImmutableMap.copyOf(kindsByAttributeValue);
        }
    }
}

