/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.template.soy.AbstractSoyCompiler;
import com.google.template.soy.PluginLoader;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.SoyInputCache;
import com.google.template.soy.logging.VeMetadataGenerator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.kohsuke.args4j.Option;

public final class SoyVeMetadataGenerator
extends AbstractSoyCompiler {
    @Option(name="--mode", usage="Which VE metadata type to output.")
    private VeMetadataGenerator.Mode mode;
    @Option(name="--generator", usage="The build label that is generating this metadata.")
    private String generator;
    @Option(name="--annotated_logging_config_file", usage="The annotated logging config file with the metadata.")
    private File annotatedLoggingConfigFile;
    @Option(name="--output_file", usage="Where to write the VE metadata file.")
    private File outputFile;

    SoyVeMetadataGenerator(PluginLoader loader, SoyInputCache cache) {
        super(loader, cache);
    }

    private SoyVeMetadataGenerator() {
    }

    public static void main(String[] args) {
        new SoyVeMetadataGenerator().runMain(args);
    }

    @Override
    protected void compile(SoyFileSet.Builder sfsBuilder) throws IOException {
        String contents = sfsBuilder.build().generateVeMetadata(this.mode, Files.asByteSource((File)this.annotatedLoggingConfigFile), this.generator);
        Files.asCharSink((File)this.outputFile, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)contents);
    }

    @Override
    protected boolean requireSources() {
        return false;
    }
}

