/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.template.soy.SoyCompilerFileReader;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.shared.SoyAstCache;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

public interface SoyInputCache {
    public static final SoyInputCache DEFAULT = new SoyInputCache(){

        @Override
        public <T> T read(File file, CacheLoader<T> loader, SoyCompilerFileReader reader) throws IOException {
            T value = loader.read(file, reader, this);
            loader.onEvict(value);
            return value;
        }

        @Override
        public void declareDependency(File file, File dependency) {
        }

        @Override
        public SoyAstCache astCache() {
            return null;
        }

        @Override
        public SoyFileSupplier createFileSupplier(File file, String pathToUse, SoyCompilerFileReader reader) throws FileNotFoundException {
            return SoyFileSupplier.Factory.create(reader.read(file).asCharSource(StandardCharsets.UTF_8), pathToUse);
        }
    };

    public <T> T read(File var1, CacheLoader<T> var2, SoyCompilerFileReader var3) throws IOException;

    public void declareDependency(File var1, File var2);

    @Nullable
    public SoyAstCache astCache();

    public SoyFileSupplier createFileSupplier(File var1, String var2, SoyCompilerFileReader var3) throws FileNotFoundException;

    public static interface CacheLoader<T> {
        public T read(File var1, SoyCompilerFileReader var2, SoyInputCache var3) throws IOException;

        default public void onEvict(T item) throws IOException {
        }
    }
}

