/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.AutoValue_SoyFileSetParser;
import com.google.template.soy.AutoValue_SoyFileSetParser_CompilationUnitAndKind;
import com.google.template.soy.TemplateMetadataSerializer;
import com.google.template.soy.base.internal.FixedIdGenerator;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.IncrementingIdGenerator;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.css.CssRegistry;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyError;
import com.google.template.soy.passes.PassManager;
import com.google.template.soy.shared.SoyAstCache;
import com.google.template.soy.soyparse.SoyFileParser;
import com.google.template.soy.soytree.CompilationUnit;
import com.google.template.soy.soytree.FileSetTemplateRegistry;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileP;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNameRegistry;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.TemplatesPerFile;
import com.google.template.soy.types.SoyTypeRegistry;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

@AutoValue
public abstract class SoyFileSetParser {
    public static Builder newBuilder() {
        return new AutoValue_SoyFileSetParser.Builder();
    }

    @Nullable
    abstract SoyAstCache cache();

    public abstract ImmutableMap<String, SoyFileSupplier> soyFileSuppliers();

    abstract ImmutableList<CompilationUnitAndKind> compilationUnits();

    abstract PassManager passManager();

    abstract ErrorReporter errorReporter();

    public abstract SoyTypeRegistry typeRegistry();

    public abstract Optional<CssRegistry> cssRegistry();

    public ParseResult parse() {
        try {
            return this.parseWithVersions();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ParseResult parseWithVersions() throws IOException {
        SoyFileSetNode soyTree = new SoyFileSetNode(new IncrementingIdGenerator());
        boolean filesWereSkipped = false;
        FixedIdGenerator fixedIdGenerator = new FixedIdGenerator(-1);
        for (SoyFileSupplier fileSupplier : this.soyFileSuppliers().values()) {
            Object node;
            SoyFileSupplier.Version version = fileSupplier.getVersion();
            Object object = node = this.cache() != null ? this.cache().get(fileSupplier.getFilePath(), version) : null;
            if (node == null) {
                node = this.parseSoyFileHelper(fileSupplier, fixedIdGenerator);
                if (node == null) {
                    filesWereSkipped = true;
                    continue;
                }
                this.passManager().runParsePasses((SoyFileNode)node, fixedIdGenerator);
                if (this.cache() != null) {
                    this.cache().put(fileSupplier.getFilePath(), version, (SoyFileNode)node);
                }
            }
            node = SoyTreeUtils.cloneWithNewIds(node, soyTree.getNodeIdGenerator());
            soyTree.addChild(node);
        }
        if (filesWereSkipped) {
            return ParseResult.create(soyTree, Optional.empty(), (ImmutableList<SoyError>)ImmutableList.copyOf(this.errorReporter().getWarnings()));
        }
        FileSetTemplateRegistry.Builder builder = FileSetTemplateRegistry.builder(this.errorReporter());
        for (CompilationUnitAndKind unit : this.compilationUnits()) {
            for (SoyFileP file : unit.compilationUnit().getFileList()) {
                builder.addTemplatesForFile(file.getFilePath(), TemplateMetadataSerializer.templatesFromSoyFileP(file, unit.fileKind(), this.typeRegistry(), unit.filePath(), this.errorReporter()));
            }
        }
        TemplateNameRegistry templateNamesForEachFile = SoyFileSetParser.buildTemplateNameRegistryForDepsAndFileset(builder, soyTree);
        FileSetTemplateRegistry partialRegistryForDeps = builder.build();
        soyTree.setFileSetTemplateRegistry(partialRegistryForDeps);
        this.passManager().runPartialTemplateRegistryPasses(soyTree, templateNamesForEachFile, partialRegistryForDeps);
        for (SoyFileNode node : soyTree.getChildren()) {
            builder.addTemplatesForFile(node.getFilePath(), (ImmutableList<TemplateMetadata>)((ImmutableList)node.getTemplates().stream().map(TemplateMetadata::fromTemplate).collect(ImmutableList.toImmutableList())));
        }
        FileSetTemplateRegistry registry = builder.build();
        soyTree.setFileSetTemplateRegistry(registry);
        this.passManager().runWholeFilesetPasses(soyTree, registry);
        return ParseResult.create(soyTree, Optional.of(registry), (ImmutableList<SoyError>)ImmutableList.copyOf(this.errorReporter().getWarnings()));
    }

    private SoyFileNode parseSoyFileHelper(SoyFileSupplier soyFileSupplier, IdGenerator nodeIdGen) throws IOException {
        try (Reader soyFileReader = soyFileSupplier.open();){
            String filePath = soyFileSupplier.getFilePath();
            int lastBangIndex = filePath.lastIndexOf(33);
            if (lastBangIndex != -1) {
                filePath = filePath.substring(lastBangIndex + 1);
            }
            SoyFileNode soyFileNode = new SoyFileParser(nodeIdGen, soyFileReader, filePath, this.errorReporter()).parseSoyFile();
            return soyFileNode;
        }
    }

    private static TemplateNameRegistry buildTemplateNameRegistryForDepsAndFileset(FileSetTemplateRegistry.Builder fileSetRegistryWithDeps, SoyFileSetNode fileSet) {
        Map<String, TemplatesPerFile.Builder> soyFilePathsToTemplates = fileSetRegistryWithDeps.getTemplatesPerFileBuilder();
        for (SoyFileNode file : fileSet.getChildren()) {
            for (TemplateNode template : file.getTemplates()) {
                TemplatesPerFile.Builder fileRegistry = soyFilePathsToTemplates.computeIfAbsent(file.getFilePath(), TemplatesPerFile::builder);
                fileRegistry.addTemplate(template.getTemplateName());
            }
        }
        return TemplateNameRegistry.create((ImmutableMap<String, TemplatesPerFile>)((ImmutableMap)soyFilePathsToTemplates.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((TemplatesPerFile.Builder)e.getValue()).build()))));
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setCache(SoyAstCache var1);

        public abstract Builder setSoyFileSuppliers(ImmutableMap<String, SoyFileSupplier> var1);

        public abstract Builder setCompilationUnits(ImmutableList<CompilationUnitAndKind> var1);

        public abstract Builder setPassManager(PassManager var1);

        public abstract Builder setErrorReporter(ErrorReporter var1);

        public abstract Builder setTypeRegistry(SoyTypeRegistry var1);

        public abstract Builder setCssRegistry(Optional<CssRegistry> var1);

        public abstract SoyFileSetParser build();
    }

    public static class ParseResult {
        private final SoyFileSetNode soyTree;
        private final Optional<TemplateRegistry> registry;
        private final ImmutableList<SoyError> warnings;

        static ParseResult create(SoyFileSetNode soyTree, Optional<TemplateRegistry> registry, ImmutableList<SoyError> warnings) {
            return new ParseResult(soyTree, registry, warnings);
        }

        ParseResult(SoyFileSetNode soyTree, Optional<TemplateRegistry> registry, ImmutableList<SoyError> warnings) {
            this.soyTree = soyTree;
            this.registry = registry;
            this.warnings = warnings;
        }

        public SoyFileSetNode fileSet() {
            return this.soyTree;
        }

        public final TemplateRegistry registry() {
            return this.registry.orElseThrow(() -> new IllegalStateException("No template registry, did you forget to check the error reporter?"));
        }

        public final boolean hasRegistry() {
            return this.registry.isPresent();
        }

        public ImmutableList<SoyError> warnings() {
            return this.warnings;
        }
    }

    @AutoValue
    public static abstract class CompilationUnitAndKind {
        public static CompilationUnitAndKind create(SoyFileKind fileKind, String filePath, CompilationUnit compilationUnit) {
            Preconditions.checkArgument((fileKind != SoyFileKind.SRC ? 1 : 0) != 0, (Object)"compilation units should only represent dependencies");
            return new AutoValue_SoyFileSetParser_CompilationUnitAndKind(fileKind, filePath, compilationUnit);
        }

        abstract SoyFileKind fileKind();

        abstract String filePath();

        abstract CompilationUnit compilationUnit();
    }
}

