/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import com.google.protobuf.Descriptors;
import com.google.template.soy.SoyFileSetParser;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.base.internal.TriState;
import com.google.template.soy.conformance.ValidatedConformanceConfig;
import com.google.template.soy.css.CssRegistry;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyCompilationException;
import com.google.template.soy.error.SoyError;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.error.SoyInternalCompilerException;
import com.google.template.soy.incrementaldomsrc.IncrementalDomSrcMain;
import com.google.template.soy.incrementaldomsrc.SoyIncrementalDomSrcOptions;
import com.google.template.soy.invocationbuilders.passes.GenInvocationBuildersVisitor;
import com.google.template.soy.jbcsrc.BytecodeCompiler;
import com.google.template.soy.jbcsrc.api.SoySauce;
import com.google.template.soy.jbcsrc.api.SoySauceImpl;
import com.google.template.soy.jbcsrc.shared.CompiledTemplates;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.JsSrcMain;
import com.google.template.soy.logging.AnnotatedLoggingConfig;
import com.google.template.soy.logging.AnnotatedLoggingConfigGenerator;
import com.google.template.soy.logging.ValidatedLoggingConfig;
import com.google.template.soy.logging.VeMetadataGenerator;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.SoyMsgBundleHandler;
import com.google.template.soy.msgs.internal.ExtractMsgsVisitor;
import com.google.template.soy.parseinfo.passes.GenerateParseInfoVisitor;
import com.google.template.soy.passes.CheckTemplateHeaderVarsPass;
import com.google.template.soy.passes.ClearSoyDocStringsVisitor;
import com.google.template.soy.passes.PassManager;
import com.google.template.soy.passes.PluginResolver;
import com.google.template.soy.passes.SoyConformancePass;
import com.google.template.soy.plugin.internal.PluginValidator;
import com.google.template.soy.plugin.restricted.SoySourceFunction;
import com.google.template.soy.pysrc.SoyPySrcOptions;
import com.google.template.soy.pysrc.internal.PySrcMain;
import com.google.template.soy.shared.SoyAstCache;
import com.google.template.soy.shared.SoyGeneralOptions;
import com.google.template.soy.shared.internal.InternalPlugins;
import com.google.template.soy.shared.internal.SoyScopedData;
import com.google.template.soy.shared.internal.SoySimpleScope;
import com.google.template.soy.shared.internal.gencode.GeneratedFile;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.shared.restricted.SoyMethodSignature;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.CompilationUnit;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.tofu.SoyTofu;
import com.google.template.soy.tofu.internal.BaseTofu;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypeRegistryBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class SoyFileSet {
    private static final Logger logger = Logger.getLogger(SoyFileSet.class.getName());
    private final SoyScopedData scopedData;
    private final SoyTypeRegistry typeRegistry;
    private final ImmutableMap<String, SoyFileSupplier> soyFileSuppliers;
    private final ImmutableList<SoyFileSetParser.CompilationUnitAndKind> compilationUnits;
    @Nullable
    private final SoyAstCache cache;
    private final SoyGeneralOptions generalOptions;
    private final ValidatedConformanceConfig conformanceConfig;
    private final ValidatedLoggingConfig loggingConfig;
    private final ImmutableList<File> pluginRuntimeJars;
    private final Optional<CssRegistry> cssRegistry;
    private final ImmutableList<SoyFunction> soyFunctions;
    private final ImmutableList<SoyPrintDirective> printDirectives;
    private final ImmutableList<SoySourceFunction> soySourceFunctions;
    private final ImmutableList<SoySourceFunction> soyMethods;
    private final boolean skipPluginValidation;
    private final boolean optimize;
    private ErrorReporter errorReporter;
    @Nullable
    private final Appendable warningSink;

    @Deprecated
    public static Builder builder() {
        return new Builder(true);
    }

    SoyFileSet(SoyScopedData apiCallScopeProvider, SoyTypeRegistry typeRegistry, ImmutableList<SoyFunction> soyFunctions, ImmutableList<SoyPrintDirective> printDirectives, ImmutableList<SoySourceFunction> soySourceFunctions, ImmutableList<SoySourceFunction> soyMethods, ImmutableMap<String, SoyFileSupplier> soyFileSuppliers, ImmutableList<SoyFileSetParser.CompilationUnitAndKind> compilationUnits, SoyGeneralOptions generalOptions, @Nullable SoyAstCache cache, ValidatedConformanceConfig conformanceConfig, ValidatedLoggingConfig loggingConfig, @Nullable Appendable warningSink, ImmutableList<File> pluginRuntimeJars, boolean skipPluginValidation, boolean optimize, Optional<CssRegistry> cssRegistry) {
        this.scopedData = apiCallScopeProvider;
        this.typeRegistry = typeRegistry;
        this.soyFileSuppliers = soyFileSuppliers;
        this.compilationUnits = compilationUnits;
        this.cache = cache;
        this.generalOptions = generalOptions.clone();
        this.soyFunctions = InternalPlugins.filterDuplicateFunctions(soyFunctions);
        this.printDirectives = InternalPlugins.filterDuplicateDirectives(printDirectives);
        this.soySourceFunctions = soySourceFunctions;
        this.soyMethods = soyMethods;
        this.conformanceConfig = (ValidatedConformanceConfig)Preconditions.checkNotNull((Object)conformanceConfig);
        this.loggingConfig = (ValidatedLoggingConfig)Preconditions.checkNotNull((Object)loggingConfig);
        this.warningSink = warningSink;
        this.pluginRuntimeJars = pluginRuntimeJars;
        this.skipPluginValidation = skipPluginValidation;
        this.optimize = optimize;
        this.cssRegistry = cssRegistry;
    }

    @VisibleForTesting
    ImmutableMap<String, SoyFileSupplier> getSoyFileSuppliersForTesting() {
        return this.soyFileSuppliers;
    }

    @VisibleForTesting
    SoyTypeRegistry getTypeRegistryForTesting() {
        return this.typeRegistry;
    }

    private <T> T entryPoint(Supplier<T> variant) {
        Object rv;
        this.resetErrorReporter();
        try {
            rv = variant.get();
        }
        catch (SoyCompilationException | SoyInternalCompilerException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (this.errorReporter.hasErrors()) {
                throw new SoyInternalCompilerException(Iterables.concat(this.errorReporter.getErrors(), this.errorReporter.getWarnings()), (Throwable)e);
            }
            throw e;
        }
        this.throwIfErrorsPresent();
        this.reportWarnings();
        return (T)rv;
    }

    private void entryPointVoid(Runnable variant) {
        this.entryPoint(() -> {
            variant.run();
            return null;
        });
    }

    ImmutableList<GeneratedFile> generateInvocationBuilders(String javaPackage) {
        return (ImmutableList)this.entryPoint(() -> {
            SoyFileSetParser.ParseResult result = this.parseForGenJava();
            this.throwIfErrorsPresent();
            TemplateRegistry registry = result.registry();
            SoyFileSetNode soyTree = result.fileSet();
            return new GenInvocationBuildersVisitor(javaPackage, registry).exec(soyTree);
        });
    }

    ImmutableList<GeneratedFile> generateParseInfo(String javaPackage, String javaClassNameSource) {
        return (ImmutableList)this.entryPoint(() -> {
            SoyFileSetParser.ParseResult result = this.parseForGenJava();
            this.throwIfErrorsPresent();
            SoyFileSetNode soyTree = result.fileSet();
            TemplateRegistry registry = result.registry();
            return new GenerateParseInfoVisitor(javaPackage, javaClassNameSource, registry).exec(soyTree);
        });
    }

    void validateUserPlugins() {
        this.entryPointVoid(() -> {
            new PluginResolver(PluginResolver.Mode.REQUIRE_DEFINITIONS, (List<SoyPrintDirective>)this.printDirectives, (List<SoyFunction>)this.soyFunctions, (List<SoySourceFunction>)this.soySourceFunctions, (List<SoySourceFunction>)this.soyMethods, this.errorReporter);
            this.throwIfErrorsPresent();
            ImmutableSet internalFunctionNames = (ImmutableSet)InternalPlugins.internalFunctions().stream().map(Object::getClass).collect(ImmutableSet.toImmutableSet());
            new PluginValidator(this.errorReporter, this.typeRegistry, (List<File>)this.pluginRuntimeJars).validate((Iterable)this.soySourceFunctions.stream().filter(fn -> !internalFunctionNames.contains(fn.getClass())).collect(ImmutableList.toImmutableList()));
            this.throwIfErrorsPresent();
        });
    }

    void checkConformance() {
        this.entryPointVoid(() -> this.parse(this.passManagerBuilder().allowUnknownJsGlobals().allowV1Expression().desugarHtmlAndStateNodes(false).optimize(false).addHtmlAttributesForDebugging(false).addPassContinuationRule(SoyConformancePass.class, PassManager.PassContinuationRule.STOP_AFTER_PASS)));
    }

    AnnotatedLoggingConfig generateAnnotatedLoggingConfig(CharSource rawLoggingConfig, String javaPackage, String jsPackage, String className) {
        return (AnnotatedLoggingConfig)this.entryPoint(() -> {
            try {
                return new AnnotatedLoggingConfigGenerator(rawLoggingConfig, javaPackage, jsPackage, className, this.typeRegistry, this.errorReporter).generate();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    String generateVeMetadata(VeMetadataGenerator.Mode mode, ByteSource loggingConfigBytes, String generator) throws IOException {
        return new VeMetadataGenerator(mode, loggingConfigBytes, generator, this.typeRegistry).generate();
    }

    public SoyMsgBundle extractMsgs() {
        return (SoyMsgBundle)this.entryPoint(this::doExtractMsgs);
    }

    public void extractAndWriteMsgs(SoyMsgBundleHandler msgBundleHandler, SoyMsgBundleHandler.OutputFileOptions options, ByteSink output) throws IOException {
        this.entryPointVoid(() -> {
            SoyMsgBundle bundle = this.doExtractMsgs();
            try {
                msgBundleHandler.writeExtractedMsgs(bundle, options, output, this.errorReporter);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private SoyMsgBundle doExtractMsgs() {
        SoyFileSetNode soyTree = this.parse(this.passManagerBuilder().allowUnknownGlobals().allowV1Expression().allowUnknownJsGlobals().optimize(false).desugarHtmlAndStateNodes(false).setTypeRegistry(SoyTypeRegistry.DEFAULT_UNKNOWN).setPluginResolver(new PluginResolver(PluginResolver.Mode.ALLOW_UNDEFINED, (List<SoyPrintDirective>)this.printDirectives, (List<SoyFunction>)this.soyFunctions, (List<SoySourceFunction>)this.soySourceFunctions, (List<SoySourceFunction>)this.soyMethods, this.errorReporter)).disableAllTypeChecking(), SoyTypeRegistry.DEFAULT_UNKNOWN).fileSet();
        this.throwIfErrorsPresent();
        SoyMsgBundle bundle = new ExtractMsgsVisitor().exec(soyTree);
        this.throwIfErrorsPresent();
        return bundle;
    }

    @Deprecated
    public SoyTofu compileToTofu() {
        return this.compileToTofu((Map<String, Supplier<Object>>)ImmutableMap.of());
    }

    @Deprecated
    public SoyTofu compileToTofu(Map<String, Supplier<Object>> pluginInstances) {
        return (SoyTofu)this.entryPoint(() -> {
            ServerCompilationPrimitives primitives = this.compileForServerRendering();
            this.throwIfErrorsPresent();
            return this.doCompileToTofu(primitives, pluginInstances);
        });
    }

    private SoyTofu doCompileToTofu(ServerCompilationPrimitives primitives, Map<String, Supplier<Object>> pluginInstances) {
        return new BaseTofu(this.scopedData.enterable(), primitives.soyTree, pluginInstances);
    }

    public SoySauce compileTemplates() {
        return this.compileTemplates((Map<String, Supplier<Object>>)ImmutableMap.of());
    }

    public SoySauce compileTemplates(Map<String, Supplier<Object>> pluginInstances) {
        return (SoySauce)this.entryPoint(() -> {
            this.disallowExternalCalls();
            ServerCompilationPrimitives primitives = this.compileForServerRendering();
            this.throwIfErrorsPresent();
            return this.doCompileSoySauce(primitives, pluginInstances);
        });
    }

    void compileToJar(ByteSink jarTarget, Optional<ByteSink> srcJarTarget) {
        this.entryPointVoid(() -> {
            this.disallowExternalCalls();
            ServerCompilationPrimitives primitives = this.compileForServerRendering();
            try {
                BytecodeCompiler.compileToJar(primitives.registry, primitives.soyTree, this.errorReporter, this.typeRegistry, jarTarget);
                if (srcJarTarget.isPresent()) {
                    BytecodeCompiler.writeSrcJar(primitives.soyTree, this.soyFileSuppliers, (ByteSink)srcJarTarget.get());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private SoySauce doCompileSoySauce(ServerCompilationPrimitives primitives, Map<String, Supplier<Object>> pluginInstances) {
        Optional<CompiledTemplates> templates = BytecodeCompiler.compile(primitives.registry, primitives.soyTree, this.errorReporter, this.soyFileSuppliers, this.typeRegistry);
        this.throwIfErrorsPresent();
        return new SoySauceImpl(templates.get(), this.scopedData.enterable(), this.soyFunctions, this.printDirectives, (ImmutableMap<String, Supplier<Object>>)ImmutableMap.copyOf(pluginInstances));
    }

    private ServerCompilationPrimitives compileForServerRendering() {
        SoyFileSetParser.ParseResult result = this.parse();
        this.throwIfErrorsPresent();
        SoyFileSetNode soyTree = result.fileSet();
        TemplateRegistry registry = result.registry();
        if (this.cache == null) {
            new ClearSoyDocStringsVisitor().exec(soyTree);
        }
        this.throwIfErrorsPresent();
        return new ServerCompilationPrimitives(registry, soyTree);
    }

    private void disallowExternalCalls() {
        TriState allowExternalCalls = this.generalOptions.allowExternalCalls();
        if (allowExternalCalls == TriState.UNSET) {
            this.generalOptions.setAllowExternalCalls(false);
        } else if (allowExternalCalls == TriState.ENABLED) {
            throw new IllegalStateException("SoyGeneralOptions.setAllowExternalCalls(true) is not supported with this method");
        }
    }

    @Deprecated
    public List<String> compileToJsSrc(SoyJsSrcOptions jsSrcOptions, @Nullable SoyMsgBundle msgBundle) {
        return this.compileToJsSrcInternal(jsSrcOptions, msgBundle);
    }

    List<String> compileToJsSrcInternal(SoyJsSrcOptions jsSrcOptions, @Nullable SoyMsgBundle msgBundle) {
        return (List)this.entryPoint(() -> {
            PassManager.Builder builder = this.passManagerBuilder().allowV1Expression().allowUnknownJsGlobals().desugarHtmlAndStateNodes(false);
            SoyFileSetParser.ParseResult result = this.parse(builder);
            this.throwIfErrorsPresent();
            TemplateRegistry registry = result.registry();
            SoyFileSetNode fileSet = result.fileSet();
            return new JsSrcMain(this.scopedData.enterable(), this.typeRegistry).genJsSrc(fileSet, registry, jsSrcOptions, msgBundle, this.errorReporter);
        });
    }

    List<String> compileToIncrementalDomSrcInternal(SoyIncrementalDomSrcOptions jsSrcOptions) {
        return (List)this.entryPoint(() -> {
            SoyFileSetParser.ParseResult result = this.parse(this.passManagerBuilder().desugarHtmlAndStateNodes(false));
            this.throwIfErrorsPresent();
            return new IncrementalDomSrcMain(this.scopedData.enterable(), this.typeRegistry).genJsSrc(result.fileSet(), result.registry(), jsSrcOptions, this.errorReporter);
        });
    }

    void compileToPySrcFiles(String outputPathFormat, SoyPySrcOptions pySrcOptions) {
        this.entryPointVoid(() -> {
            try {
                SoyFileSetParser.ParseResult result = this.parse();
                this.throwIfErrorsPresent();
                new PySrcMain(this.scopedData.enterable()).genPyFiles(result.fileSet(), pySrcOptions, outputPathFormat, this.errorReporter);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    SoyFileSetParser.ParseResult compileMinimallyForHeaders() {
        return (SoyFileSetParser.ParseResult)this.entryPoint(() -> {
            this.disallowExternalCalls();
            return this.parse(this.passManagerBuilder().allowUnknownJsGlobals().addPassContinuationRule(CheckTemplateHeaderVarsPass.class, PassManager.PassContinuationRule.STOP_BEFORE_PASS).allowV1Expression(), this.typeRegistry);
        });
    }

    public SoyFileSetParser.ParseResult compileForAnalysis() {
        return (SoyFileSetParser.ParseResult)this.entryPoint(() -> {
            this.disallowExternalCalls();
            return this.parse(this.passManagerBuilder().optimize(false).astRewrites(false).addHtmlAttributesForDebugging(false).insertEscapingDirectives(false).desugarHtmlAndStateNodes(false).allowUnknownGlobals().allowUnknownJsGlobals().allowV1Expression(), this.typeRegistry);
        });
    }

    private SoyFileSetParser.ParseResult parseForGenJava() {
        return this.parse(this.passManagerBuilder().optimize(false).desugarHtmlAndStateNodes(false));
    }

    @VisibleForTesting
    SoyFileSetParser.ParseResult parse() {
        return this.parse(this.passManagerBuilder());
    }

    private SoyFileSetParser.ParseResult parse(PassManager.Builder builder) {
        return this.parse(builder, this.typeRegistry);
    }

    private SoyFileSetParser.ParseResult parse(PassManager.Builder builder, SoyTypeRegistry typeRegistry) {
        return SoyFileSetParser.newBuilder().setCache(this.cache).setSoyFileSuppliers(this.soyFileSuppliers).setCompilationUnits(this.compilationUnits).setCssRegistry(this.cssRegistry).setTypeRegistry(typeRegistry).setPassManager(builder.setTypeRegistry(typeRegistry).build()).setErrorReporter(this.errorReporter).build().parse();
    }

    private PassManager.Builder passManagerBuilder() {
        return new PassManager.Builder().setGeneralOptions(this.generalOptions).optimize(this.optimize).setSoyPrintDirectives(this.printDirectives).setCssRegistry(this.cssRegistry).setErrorReporter(this.errorReporter).setConformanceConfig(this.conformanceConfig).setLoggingConfig(this.loggingConfig).setPluginResolver(new PluginResolver(this.skipPluginValidation ? PluginResolver.Mode.ALLOW_UNDEFINED : PluginResolver.Mode.REQUIRE_DEFINITIONS, (List<SoyPrintDirective>)this.printDirectives, (List<SoyFunction>)this.soyFunctions, (List<SoySourceFunction>)this.soySourceFunctions, (List<SoySourceFunction>)this.soyMethods, this.errorReporter));
    }

    @VisibleForTesting
    void resetErrorReporter() {
        this.errorReporter = ErrorReporter.create(this.soyFileSuppliers);
    }

    private void throwIfErrorsPresent() {
        if (this.errorReporter.hasErrors()) {
            Iterable errors = Iterables.concat(this.errorReporter.getErrors(), this.errorReporter.getWarnings());
            this.errorReporter = null;
            throw new SoyCompilationException(errors);
        }
    }

    private void reportWarnings() {
        ImmutableList<SoyError> warnings = this.errorReporter.getWarnings();
        if (warnings.isEmpty()) {
            return;
        }
        if (this.generalOptions.getExperimentalFeatures().contains((Object)"testonly_throw_on_warnings")) {
            this.errorReporter = null;
            throw new SoyCompilationException((Iterable<SoyError>)warnings);
        }
        String formatted = SoyErrors.formatErrors(warnings);
        if (this.warningSink != null) {
            try {
                this.warningSink.append(formatted);
            }
            catch (IOException ioe) {
                System.err.println("error while printing warnings");
                ioe.printStackTrace();
            }
        } else {
            logger.warning(formatted);
        }
    }

    private static final class ServerCompilationPrimitives {
        final SoyFileSetNode soyTree;
        final TemplateRegistry registry;

        ServerCompilationPrimitives(TemplateRegistry registry, SoyFileSetNode soyTree) {
            this.registry = registry;
            this.soyTree = soyTree;
        }
    }

    public static final class Builder {
        private final ImmutableMap.Builder<String, SoyFileSupplier> filesBuilder = ImmutableMap.builder();
        private final ImmutableList.Builder<SoyFileSetParser.CompilationUnitAndKind> compilationUnitsBuilder = ImmutableList.builder();
        private SoyAstCache cache = null;
        private SoyGeneralOptions lazyGeneralOptions = null;
        private final SoyTypeRegistryBuilder typeRegistryBuilder = new SoyTypeRegistryBuilder();
        @Nullable
        private Appendable warningSink;
        private ValidatedConformanceConfig conformanceConfig = ValidatedConformanceConfig.EMPTY;
        private ValidatedLoggingConfig loggingConfig = ValidatedLoggingConfig.EMPTY;
        private ImmutableList<File> pluginRuntimeJars = ImmutableList.of();
        private Optional<CssRegistry> cssRegistry = Optional.empty();
        private boolean skipPluginValidation = false;
        private boolean optimize = true;
        private final ImmutableSet.Builder<SoyFunction> soyFunctions = ImmutableSet.builder();
        private final ImmutableSet.Builder<SoyPrintDirective> soyPrintDirectives = ImmutableSet.builder();
        private final ImmutableSet.Builder<SoySourceFunction> sourceFunctions = ImmutableSet.builder();
        private final ImmutableSet.Builder<SoySourceFunction> sourceMethods = ImmutableSet.builder();

        Builder(boolean ignored) {
        }

        public Builder setGeneralOptions(SoyGeneralOptions generalOptions) {
            Preconditions.checkState((this.lazyGeneralOptions == null ? 1 : 0) != 0, (Object)"Call SoyFileSet#setGeneralOptions before any other setters.");
            Preconditions.checkNotNull((Object)generalOptions, (Object)"Non-null argument expected.");
            this.lazyGeneralOptions = generalOptions.clone();
            return this;
        }

        private SoyGeneralOptions getGeneralOptions() {
            if (this.lazyGeneralOptions == null) {
                this.lazyGeneralOptions = new SoyGeneralOptions();
            }
            return this.lazyGeneralOptions;
        }

        public SoyFileSet build() {
            SoySimpleScope data = new SoySimpleScope();
            return new SoyFileSet(data, this.typeRegistryBuilder.build(), (ImmutableList<SoyFunction>)ImmutableList.builder().addAll(InternalPlugins.internalLegacyFunctions()).addAll((Iterable)this.soyFunctions.build()).build(), (ImmutableList<SoyPrintDirective>)ImmutableList.builder().addAll(InternalPlugins.internalDirectives(data)).addAll((Iterable)this.soyPrintDirectives.build()).build(), (ImmutableList<SoySourceFunction>)ImmutableList.builder().addAll(InternalPlugins.internalFunctions()).addAll((Iterable)this.sourceFunctions.build()).build(), (ImmutableList<SoySourceFunction>)ImmutableList.builder().addAll(InternalPlugins.internalMethods()).addAll((Iterable)this.sourceMethods.build()).build(), (ImmutableMap<String, SoyFileSupplier>)this.filesBuilder.build(), (ImmutableList<SoyFileSetParser.CompilationUnitAndKind>)this.compilationUnitsBuilder.build(), this.getGeneralOptions(), this.cache, this.conformanceConfig, this.loggingConfig, this.warningSink, this.pluginRuntimeJars, this.skipPluginValidation, this.optimize, this.cssRegistry);
        }

        public Builder addSourceFunction(SoySourceFunction function) {
            boolean method = false;
            if (function.getClass().isAnnotationPresent(SoyMethodSignature.class)) {
                this.sourceMethods.add((Object)function);
                method = true;
            }
            if (!method || function.getClass().isAnnotationPresent(SoyFunctionSignature.class)) {
                this.sourceFunctions.add((Object)function);
            }
            return this;
        }

        public Builder addSourceFunctions(Iterable<? extends SoySourceFunction> function) {
            for (SoySourceFunction soySourceFunction : function) {
                this.addSourceFunction(soySourceFunction);
            }
            return this;
        }

        public Builder addSourceMethod(SoySourceFunction function) {
            Preconditions.checkArgument((boolean)function.getClass().isAnnotationPresent(SoyMethodSignature.class));
            this.sourceMethods.add((Object)function);
            return this;
        }

        public Builder addSoyFunction(SoyFunction function) {
            this.soyFunctions.add((Object)function);
            return this;
        }

        public Builder addSoyFunctions(Iterable<? extends SoyFunction> function) {
            this.soyFunctions.addAll(function);
            return this;
        }

        public Builder addSoyPrintDirective(SoyPrintDirective function) {
            this.soyPrintDirectives.add((Object)function);
            return this;
        }

        public Builder addSoyPrintDirectives(Iterable<? extends SoyPrintDirective> function) {
            this.soyPrintDirectives.addAll(function);
            return this;
        }

        public Builder add(SoyFileSupplier soyFileSupplier) {
            return this.addFile(soyFileSupplier);
        }

        public Builder add(CharSource contentSource, String filePath) {
            return this.addFile(SoyFileSupplier.Factory.create(contentSource, filePath));
        }

        public Builder add(URL inputFileUrl, String filePath) {
            return this.addFile(SoyFileSupplier.Factory.create(inputFileUrl, filePath));
        }

        @Deprecated
        public Builder add(URL inputFileUrl) {
            return this.add(inputFileUrl, inputFileUrl.toString());
        }

        public Builder add(CharSequence content, String filePath) {
            return this.addFile(SoyFileSupplier.Factory.create(content, filePath));
        }

        public Builder add(File inputFile) {
            return this.addFile(SoyFileSupplier.Factory.create(inputFile));
        }

        public Builder setSoyAstCache(SoyAstCache cache) {
            this.cache = cache;
            return this;
        }

        public Builder setAllowExternalCalls(boolean allowExternalCalls) {
            this.getGeneralOptions().setAllowExternalCalls(allowExternalCalls);
            return this;
        }

        public Builder setExperimentalFeatures(List<String> experimentalFeatures) {
            this.getGeneralOptions().setExperimentalFeatures(experimentalFeatures);
            return this;
        }

        public Builder disableOptimizer() {
            this.optimize = false;
            return this;
        }

        public Builder setCompileTimeGlobals(Map<String, ?> compileTimeGlobalsMap) {
            this.getGeneralOptions().setCompileTimeGlobals(compileTimeGlobalsMap);
            return this;
        }

        public Builder setCompileTimeGlobals(File compileTimeGlobalsFile) throws IOException {
            this.getGeneralOptions().setCompileTimeGlobals(compileTimeGlobalsFile);
            return this;
        }

        public Builder setCompileTimeGlobals(URL compileTimeGlobalsResource) throws IOException {
            this.getGeneralOptions().setCompileTimeGlobals(compileTimeGlobalsResource);
            return this;
        }

        public Builder addProtoDescriptors(Descriptors.GenericDescriptor ... descriptors) {
            return this.addProtoDescriptors(Arrays.asList(descriptors));
        }

        public Builder addProtoDescriptors(Iterable<? extends Descriptors.GenericDescriptor> descriptors) {
            this.typeRegistryBuilder.addDescriptors(descriptors);
            return this;
        }

        Builder setConformanceConfig(ValidatedConformanceConfig config) {
            Preconditions.checkNotNull((Object)config);
            this.conformanceConfig = config;
            return this;
        }

        Builder addCompilationUnit(SoyFileKind fileKind, String filePath, CompilationUnit compilationUnit) {
            this.compilationUnitsBuilder.add((Object)SoyFileSetParser.CompilationUnitAndKind.create(fileKind, filePath, compilationUnit));
            return this;
        }

        Builder addFile(SoyFileSupplier supplier) {
            this.filesBuilder.put((Object)supplier.getFilePath(), (Object)supplier);
            return this;
        }

        Builder setWarningSink(Appendable warningSink) {
            this.warningSink = (Appendable)Preconditions.checkNotNull((Object)warningSink);
            return this;
        }

        public Builder setLoggingConfig(AnnotatedLoggingConfig config) {
            return this.setValidatedLoggingConfig(ValidatedLoggingConfig.create(config));
        }

        Builder setValidatedLoggingConfig(ValidatedLoggingConfig parseLoggingConfigs) {
            this.loggingConfig = (ValidatedLoggingConfig)Preconditions.checkNotNull((Object)parseLoggingConfigs);
            return this;
        }

        Builder setPluginRuntimeJars(List<File> pluginRuntimeJars) {
            this.pluginRuntimeJars = ImmutableList.copyOf(pluginRuntimeJars);
            return this;
        }

        public Builder setCssRegistry(CssRegistry cssRegistry) {
            this.cssRegistry = Optional.of(cssRegistry);
            return this;
        }

        public Builder setSkipPluginValidation(boolean skipPluginValidation) {
            this.skipPluginValidation = skipPluginValidation;
            return this;
        }
    }
}

