/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.io.Files;
import com.google.template.soy.AbstractSoyCompiler;
import com.google.template.soy.PluginLoader;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.SoyInputCache;
import com.google.template.soy.logging.AnnotatedLoggingConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.kohsuke.args4j.Option;

public final class SoyAnnotatedLoggingConfigGenerator
extends AbstractSoyCompiler {
    @Option(name="--raw_logging_config_file", usage="The logging config file to annotate.")
    private File rawLoggingConfigFile;
    @Option(name="--java_package", usage="The VE metadata Java package to use with the given logging config.")
    private String javaPackage;
    @Option(name="--js_package", usage="The VE metadata JS package to use with the given logging config.")
    private String jsPackage;
    @Option(name="--class_name", usage="The VE metadata class name to use with the given logging config.")
    private String className;
    @Option(name="--output_file", usage="Where to write the annotated logging config.")
    private File outputFile;

    SoyAnnotatedLoggingConfigGenerator(PluginLoader loader, SoyInputCache cache) {
        super(loader, cache);
    }

    private SoyAnnotatedLoggingConfigGenerator() {
    }

    public static void main(String[] args) {
        new SoyAnnotatedLoggingConfigGenerator().runMain(args);
    }

    @Override
    protected void compile(SoyFileSet.Builder sfsBuilder) throws IOException {
        AnnotatedLoggingConfig loggingConfig = sfsBuilder.build().generateAnnotatedLoggingConfig(Files.asCharSource((File)this.rawLoggingConfigFile, (Charset)StandardCharsets.UTF_8), this.javaPackage, this.jsPackage, this.className);
        try (FileOutputStream output = new FileOutputStream(this.outputFile);){
            loggingConfig.writeTo(output);
        }
    }

    @Override
    protected boolean requireSources() {
        return false;
    }
}

