

package com.google.template.soy.types;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.SanitizedContentKind;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_TemplateType extends TemplateType {

  private final TemplateType.TemplateKind templateKind;

  private final SanitizedContentKind contentKind;

  private final boolean strictHtml;

  private final ImmutableList<TemplateType.Parameter> parameters;

  private final ImmutableList<TemplateType.DataAllCallSituation> dataAllCallSituations;

  private final String identifierForDebugging;

  private final boolean inferredType;

  private AutoValue_TemplateType(
      TemplateType.TemplateKind templateKind,
      SanitizedContentKind contentKind,
      boolean strictHtml,
      ImmutableList<TemplateType.Parameter> parameters,
      ImmutableList<TemplateType.DataAllCallSituation> dataAllCallSituations,
      String identifierForDebugging,
      boolean inferredType) {
    this.templateKind = templateKind;
    this.contentKind = contentKind;
    this.strictHtml = strictHtml;
    this.parameters = parameters;
    this.dataAllCallSituations = dataAllCallSituations;
    this.identifierForDebugging = identifierForDebugging;
    this.inferredType = inferredType;
  }

  @Override
  public TemplateType.TemplateKind getTemplateKind() {
    return templateKind;
  }

  @Override
  public SanitizedContentKind getContentKind() {
    return contentKind;
  }

  @Override
  public boolean isStrictHtml() {
    return strictHtml;
  }

  @Override
  public ImmutableList<TemplateType.Parameter> getParameters() {
    return parameters;
  }

  @Override
  public ImmutableList<TemplateType.DataAllCallSituation> getDataAllCallSituations() {
    return dataAllCallSituations;
  }

  @Override
  public String getIdentifierForDebugging() {
    return identifierForDebugging;
  }

  @Override
  public boolean isInferredType() {
    return inferredType;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof TemplateType) {
      TemplateType that = (TemplateType) o;
      return this.templateKind.equals(that.getTemplateKind())
          && this.contentKind.equals(that.getContentKind())
          && this.strictHtml == that.isStrictHtml()
          && this.parameters.equals(that.getParameters())
          && this.dataAllCallSituations.equals(that.getDataAllCallSituations())
          && this.identifierForDebugging.equals(that.getIdentifierForDebugging())
          && this.inferredType == that.isInferredType();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= templateKind.hashCode();
    h$ *= 1000003;
    h$ ^= contentKind.hashCode();
    h$ *= 1000003;
    h$ ^= strictHtml ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= parameters.hashCode();
    h$ *= 1000003;
    h$ ^= dataAllCallSituations.hashCode();
    h$ *= 1000003;
    h$ ^= identifierForDebugging.hashCode();
    h$ *= 1000003;
    h$ ^= inferredType ? 1231 : 1237;
    return h$;
  }

  @Override
  public TemplateType.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends TemplateType.Builder {
    private TemplateType.TemplateKind templateKind;
    private SanitizedContentKind contentKind;
    private Boolean strictHtml;
    private ImmutableList<TemplateType.Parameter> parameters;
    private ImmutableList<TemplateType.DataAllCallSituation> dataAllCallSituations;
    private String identifierForDebugging;
    private Boolean inferredType;
    Builder() {
    }
    private Builder(TemplateType source) {
      this.templateKind = source.getTemplateKind();
      this.contentKind = source.getContentKind();
      this.strictHtml = source.isStrictHtml();
      this.parameters = source.getParameters();
      this.dataAllCallSituations = source.getDataAllCallSituations();
      this.identifierForDebugging = source.getIdentifierForDebugging();
      this.inferredType = source.isInferredType();
    }
    @Override
    public TemplateType.Builder setTemplateKind(TemplateType.TemplateKind templateKind) {
      if (templateKind == null) {
        throw new NullPointerException("Null templateKind");
      }
      this.templateKind = templateKind;
      return this;
    }
    @Override
    public TemplateType.Builder setContentKind(SanitizedContentKind contentKind) {
      if (contentKind == null) {
        throw new NullPointerException("Null contentKind");
      }
      this.contentKind = contentKind;
      return this;
    }
    @Override
    public TemplateType.Builder setStrictHtml(boolean strictHtml) {
      this.strictHtml = strictHtml;
      return this;
    }
    @Override
    public TemplateType.Builder setParameters(ImmutableList<TemplateType.Parameter> parameters) {
      if (parameters == null) {
        throw new NullPointerException("Null parameters");
      }
      this.parameters = parameters;
      return this;
    }
    @Override
    public TemplateType.Builder setDataAllCallSituations(ImmutableList<TemplateType.DataAllCallSituation> dataAllCallSituations) {
      if (dataAllCallSituations == null) {
        throw new NullPointerException("Null dataAllCallSituations");
      }
      this.dataAllCallSituations = dataAllCallSituations;
      return this;
    }
    @Override
    public TemplateType.Builder setIdentifierForDebugging(String identifierForDebugging) {
      if (identifierForDebugging == null) {
        throw new NullPointerException("Null identifierForDebugging");
      }
      this.identifierForDebugging = identifierForDebugging;
      return this;
    }
    @Override
    public TemplateType.Builder setInferredType(boolean inferredType) {
      this.inferredType = inferredType;
      return this;
    }
    @Override
    public TemplateType build() {
      String missing = "";
      if (this.templateKind == null) {
        missing += " templateKind";
      }
      if (this.contentKind == null) {
        missing += " contentKind";
      }
      if (this.strictHtml == null) {
        missing += " strictHtml";
      }
      if (this.parameters == null) {
        missing += " parameters";
      }
      if (this.dataAllCallSituations == null) {
        missing += " dataAllCallSituations";
      }
      if (this.identifierForDebugging == null) {
        missing += " identifierForDebugging";
      }
      if (this.inferredType == null) {
        missing += " inferredType";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_TemplateType(
          this.templateKind,
          this.contentKind,
          this.strictHtml,
          this.parameters,
          this.dataAllCallSituations,
          this.identifierForDebugging,
          this.inferredType);
    }
  }

}
