

package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.types.TemplateType;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_TemplateMetadata extends TemplateMetadata {

  private final SoyFileKind soyFileKind;

  private final SourceLocation sourceLocation;

  private final HtmlElementMetadataP htmlElement;

  private final SoyElementMetadataP soyElement;

  private final TemplateType.TemplateKind templateKind;

  private final String templateName;

  private final String delTemplateName;

  private final String delTemplateVariant;

  private final SanitizedContentKind contentKind;

  private final boolean strictHtml;

  private final Visibility visibility;

  private final String delPackageName;

  private final ImmutableList<TemplateMetadata.Parameter> parameters;

  private final ImmutableList<TemplateMetadata.DataAllCallSituation> dataAllCallSituations;

  private AutoValue_TemplateMetadata(
      SoyFileKind soyFileKind,
      SourceLocation sourceLocation,
      @Nullable HtmlElementMetadataP htmlElement,
      @Nullable SoyElementMetadataP soyElement,
      TemplateType.TemplateKind templateKind,
      String templateName,
      @Nullable String delTemplateName,
      @Nullable String delTemplateVariant,
      SanitizedContentKind contentKind,
      boolean strictHtml,
      Visibility visibility,
      @Nullable String delPackageName,
      ImmutableList<TemplateMetadata.Parameter> parameters,
      ImmutableList<TemplateMetadata.DataAllCallSituation> dataAllCallSituations) {
    this.soyFileKind = soyFileKind;
    this.sourceLocation = sourceLocation;
    this.htmlElement = htmlElement;
    this.soyElement = soyElement;
    this.templateKind = templateKind;
    this.templateName = templateName;
    this.delTemplateName = delTemplateName;
    this.delTemplateVariant = delTemplateVariant;
    this.contentKind = contentKind;
    this.strictHtml = strictHtml;
    this.visibility = visibility;
    this.delPackageName = delPackageName;
    this.parameters = parameters;
    this.dataAllCallSituations = dataAllCallSituations;
  }

  @Override
  public SoyFileKind getSoyFileKind() {
    return soyFileKind;
  }

  @Override
  public SourceLocation getSourceLocation() {
    return sourceLocation;
  }

  @Nullable
  @Override
  public HtmlElementMetadataP getHtmlElement() {
    return htmlElement;
  }

  @Nullable
  @Override
  public SoyElementMetadataP getSoyElement() {
    return soyElement;
  }

  @Override
  public TemplateType.TemplateKind getTemplateKind() {
    return templateKind;
  }

  @Override
  public String getTemplateName() {
    return templateName;
  }

  @Nullable
  @Override
  public String getDelTemplateName() {
    return delTemplateName;
  }

  @Nullable
  @Override
  public String getDelTemplateVariant() {
    return delTemplateVariant;
  }

  @Override
  public SanitizedContentKind getContentKind() {
    return contentKind;
  }

  @Override
  public boolean isStrictHtml() {
    return strictHtml;
  }

  @Override
  public Visibility getVisibility() {
    return visibility;
  }

  @Nullable
  @Override
  public String getDelPackageName() {
    return delPackageName;
  }

  @Override
  public ImmutableList<TemplateMetadata.Parameter> getParameters() {
    return parameters;
  }

  @Override
  public ImmutableList<TemplateMetadata.DataAllCallSituation> getDataAllCallSituations() {
    return dataAllCallSituations;
  }

  @Override
  public String toString() {
    return "TemplateMetadata{"
         + "soyFileKind=" + soyFileKind + ", "
         + "sourceLocation=" + sourceLocation + ", "
         + "htmlElement=" + htmlElement + ", "
         + "soyElement=" + soyElement + ", "
         + "templateKind=" + templateKind + ", "
         + "templateName=" + templateName + ", "
         + "delTemplateName=" + delTemplateName + ", "
         + "delTemplateVariant=" + delTemplateVariant + ", "
         + "contentKind=" + contentKind + ", "
         + "strictHtml=" + strictHtml + ", "
         + "visibility=" + visibility + ", "
         + "delPackageName=" + delPackageName + ", "
         + "parameters=" + parameters + ", "
         + "dataAllCallSituations=" + dataAllCallSituations
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof TemplateMetadata) {
      TemplateMetadata that = (TemplateMetadata) o;
      return this.soyFileKind.equals(that.getSoyFileKind())
          && this.sourceLocation.equals(that.getSourceLocation())
          && (this.htmlElement == null ? that.getHtmlElement() == null : this.htmlElement.equals(that.getHtmlElement()))
          && (this.soyElement == null ? that.getSoyElement() == null : this.soyElement.equals(that.getSoyElement()))
          && this.templateKind.equals(that.getTemplateKind())
          && this.templateName.equals(that.getTemplateName())
          && (this.delTemplateName == null ? that.getDelTemplateName() == null : this.delTemplateName.equals(that.getDelTemplateName()))
          && (this.delTemplateVariant == null ? that.getDelTemplateVariant() == null : this.delTemplateVariant.equals(that.getDelTemplateVariant()))
          && this.contentKind.equals(that.getContentKind())
          && this.strictHtml == that.isStrictHtml()
          && this.visibility.equals(that.getVisibility())
          && (this.delPackageName == null ? that.getDelPackageName() == null : this.delPackageName.equals(that.getDelPackageName()))
          && this.parameters.equals(that.getParameters())
          && this.dataAllCallSituations.equals(that.getDataAllCallSituations());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= soyFileKind.hashCode();
    h$ *= 1000003;
    h$ ^= sourceLocation.hashCode();
    h$ *= 1000003;
    h$ ^= (htmlElement == null) ? 0 : htmlElement.hashCode();
    h$ *= 1000003;
    h$ ^= (soyElement == null) ? 0 : soyElement.hashCode();
    h$ *= 1000003;
    h$ ^= templateKind.hashCode();
    h$ *= 1000003;
    h$ ^= templateName.hashCode();
    h$ *= 1000003;
    h$ ^= (delTemplateName == null) ? 0 : delTemplateName.hashCode();
    h$ *= 1000003;
    h$ ^= (delTemplateVariant == null) ? 0 : delTemplateVariant.hashCode();
    h$ *= 1000003;
    h$ ^= contentKind.hashCode();
    h$ *= 1000003;
    h$ ^= strictHtml ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= visibility.hashCode();
    h$ *= 1000003;
    h$ ^= (delPackageName == null) ? 0 : delPackageName.hashCode();
    h$ *= 1000003;
    h$ ^= parameters.hashCode();
    h$ *= 1000003;
    h$ ^= dataAllCallSituations.hashCode();
    return h$;
  }

  @Override
  public TemplateMetadata.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends TemplateMetadata.Builder {
    private SoyFileKind soyFileKind;
    private SourceLocation sourceLocation;
    private HtmlElementMetadataP htmlElement;
    private SoyElementMetadataP soyElement;
    private TemplateType.TemplateKind templateKind;
    private String templateName;
    private String delTemplateName;
    private String delTemplateVariant;
    private SanitizedContentKind contentKind;
    private Boolean strictHtml;
    private Visibility visibility;
    private String delPackageName;
    private ImmutableList<TemplateMetadata.Parameter> parameters;
    private ImmutableList<TemplateMetadata.DataAllCallSituation> dataAllCallSituations;
    Builder() {
    }
    private Builder(TemplateMetadata source) {
      this.soyFileKind = source.getSoyFileKind();
      this.sourceLocation = source.getSourceLocation();
      this.htmlElement = source.getHtmlElement();
      this.soyElement = source.getSoyElement();
      this.templateKind = source.getTemplateKind();
      this.templateName = source.getTemplateName();
      this.delTemplateName = source.getDelTemplateName();
      this.delTemplateVariant = source.getDelTemplateVariant();
      this.contentKind = source.getContentKind();
      this.strictHtml = source.isStrictHtml();
      this.visibility = source.getVisibility();
      this.delPackageName = source.getDelPackageName();
      this.parameters = source.getParameters();
      this.dataAllCallSituations = source.getDataAllCallSituations();
    }
    @Override
    public TemplateMetadata.Builder setSoyFileKind(SoyFileKind soyFileKind) {
      if (soyFileKind == null) {
        throw new NullPointerException("Null soyFileKind");
      }
      this.soyFileKind = soyFileKind;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setSourceLocation(SourceLocation sourceLocation) {
      if (sourceLocation == null) {
        throw new NullPointerException("Null sourceLocation");
      }
      this.sourceLocation = sourceLocation;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setHtmlElement(HtmlElementMetadataP htmlElement) {
      this.htmlElement = htmlElement;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setSoyElement(SoyElementMetadataP soyElement) {
      this.soyElement = soyElement;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setTemplateKind(TemplateType.TemplateKind templateKind) {
      if (templateKind == null) {
        throw new NullPointerException("Null templateKind");
      }
      this.templateKind = templateKind;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setTemplateName(String templateName) {
      if (templateName == null) {
        throw new NullPointerException("Null templateName");
      }
      this.templateName = templateName;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setDelTemplateName(String delTemplateName) {
      this.delTemplateName = delTemplateName;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setDelTemplateVariant(String delTemplateVariant) {
      this.delTemplateVariant = delTemplateVariant;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setContentKind(SanitizedContentKind contentKind) {
      if (contentKind == null) {
        throw new NullPointerException("Null contentKind");
      }
      this.contentKind = contentKind;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setStrictHtml(boolean strictHtml) {
      this.strictHtml = strictHtml;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setVisibility(Visibility visibility) {
      if (visibility == null) {
        throw new NullPointerException("Null visibility");
      }
      this.visibility = visibility;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setDelPackageName(@Nullable String delPackageName) {
      this.delPackageName = delPackageName;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setParameters(ImmutableList<TemplateMetadata.Parameter> parameters) {
      if (parameters == null) {
        throw new NullPointerException("Null parameters");
      }
      this.parameters = parameters;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setDataAllCallSituations(ImmutableList<TemplateMetadata.DataAllCallSituation> dataAllCallSituations) {
      if (dataAllCallSituations == null) {
        throw new NullPointerException("Null dataAllCallSituations");
      }
      this.dataAllCallSituations = dataAllCallSituations;
      return this;
    }
    @Override
    TemplateMetadata autobuild() {
      String missing = "";
      if (this.soyFileKind == null) {
        missing += " soyFileKind";
      }
      if (this.sourceLocation == null) {
        missing += " sourceLocation";
      }
      if (this.templateKind == null) {
        missing += " templateKind";
      }
      if (this.templateName == null) {
        missing += " templateName";
      }
      if (this.contentKind == null) {
        missing += " contentKind";
      }
      if (this.strictHtml == null) {
        missing += " strictHtml";
      }
      if (this.visibility == null) {
        missing += " visibility";
      }
      if (this.parameters == null) {
        missing += " parameters";
      }
      if (this.dataAllCallSituations == null) {
        missing += " dataAllCallSituations";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_TemplateMetadata(
          this.soyFileKind,
          this.sourceLocation,
          this.htmlElement,
          this.soyElement,
          this.templateKind,
          this.templateName,
          this.delTemplateName,
          this.delTemplateVariant,
          this.contentKind,
          this.strictHtml,
          this.visibility,
          this.delPackageName,
          this.parameters,
          this.dataAllCallSituations);
    }
  }

}
