/* SoyFileParserTokenManager.java */
/* Generated By:JavaCC: Do not edit this line. SoyFileParserTokenManager.java */
package com.google.template.soy.soyparse;
import static com.google.common.base.Preconditions.checkNotNull;
import static com.google.common.base.Preconditions.checkState;
import static com.google.template.soy.exprtree.Operator.createOperatorNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SourceLocation.Point;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.error.ErrorReporter.Checkpoint;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrorKind.StyleAllowance;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprNode.PrimitiveNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.ListComprehensionNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.GroupNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.exprtree.VeLiteralNode;
import com.google.template.soy.soytree.AliasDeclaration;
import com.google.template.soy.soytree.DelPackageDeclaration;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.Comment;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForIfemptyNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPluralCaseNode;
import com.google.template.soy.soytree.MsgPluralDefaultNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.NamespaceDeclaration;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SkipNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode.BlockNode;
import com.google.template.soy.soytree.SoyNode.StandaloneNode;
import com.google.template.soy.soytree.SoyNode.StatementNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateBasicNodeBuilder;
import com.google.template.soy.soytree.TemplateDelegateNodeBuilder;
import com.google.template.soy.soytree.TemplateElementNodeBuilder;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNode.SoyFileHeaderInfo;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.VeLogNode;
import com.google.template.soy.soytree.WhitespaceMode;
import com.google.template.soy.soytree.defn.ImportedVar;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import com.google.template.soy.types.ast.GenericTypeNode;
import com.google.template.soy.types.ast.NamedTypeNode;
import com.google.template.soy.types.ast.RecordTypeNode;
import com.google.template.soy.types.ast.TemplateTypeNode;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.UnionTypeNode;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.Set;
import javax.annotation.Nullable;

/** Token Manager. */
@SuppressWarnings("unused")class SoyFileParserTokenManager implements SoyFileParserConstants {
  private boolean isInTemplate;
  private int prevState = -1;
  private SoyFileParser parser;
  List<Comment> comments = new ArrayList<Comment>();

  void setParser(SoyFileParser parser) {
    this.parser = parser;
  }

  /**
   * Saves the current lexical state and switch to a new one.  To switch back call
   * {@link #popState()}.
   */
  void pushState(int newState) {
    if (prevState != -1) {
      // pushState is only used with lexical states (see below) that cannot mutually nest, so if
      // prevState isn't unset (i.e. -1) then something has gone wrong
      throw new IllegalStateException("pushed too deep");
    }
    if (newState != IN_SQ_ATTRIBUTE_VALUE
        & newState != IN_DQ_ATTRIBUTE_VALUE
        & newState != IN_DQ_STRING
        & newState != IN_SQ_STRING
        & newState != IN_SOYDOC
        & newState != IN_MULTILINE_COMMENT) {
      throw new IllegalArgumentException("not allowed to push " + lexStateNames[newState]);
    }
    prevState = curLexState;
    SwitchTo(newState);
  }

  /**
   * Switch back to the previous state stored in {@link #prevState}.
   */
  void popState() {
    int p = prevState;
    if (p == -1) {
      throw new IllegalStateException("popped too far");
    }
    SwitchTo(p);
    prevState = -1;
  }

  private void resetState() {
    isInTemplate = false;
    prevState = -1;
  }


  /**
   * If the matched whitespace token contains a blank line, stores the blank line as a "comment" for
   * the formatter. This should not be called on a token that contains non-whitespace.
   */
  void maybeAddBlankLines(Token whitespaceToken) {
     SourceLocation tokenLocation = parser.createSrcLoc(whitespaceToken);
    maybeAddBlankLines(tokenLocation.getBeginPoint(), tokenLocation.getEndPoint(),
        whitespaceToken.image);
  }

  /**
   * If a stretch of whitespace contains a blank line (e.g. "\n\n"), stores the blank line for the
   * formatter.
   */
  void maybeAddBlankLines(Point wsBegin, Point wsEnd, String whitespaceStr) {
    // Since whitespace is consumed in quite a few different ways/places by the parser, regexing the
    // whitespace tokens and/or special tokens here is a little easier than splitting out separate
    // blank line tokens and handling them everywhere we handle whitespace (e.g. RawTextBuilder
    // relies on WS tokens to construct text offsets).
    Matcher blankLineMatcher = Pattern.compile("\n(\\s*\n)+").matcher(whitespaceStr);
    // If the whitespace didn't contain any blank lines, early exit.
    if (!blankLineMatcher.find()) {
      return;
    }


    // If there was a blank line, construct a source location that starts at the first blank line
    // and ends at the last blank line.

    // The matched whitespace will always start at the "\n" at the end of the previous line. The
    // blank line starts at the beginning of the next line.
    SourceLocation.Point blankLineBegin =
        SourceLocation.Point.create(wsBegin.line() + 1, 1);

    // If the whitespace ends on a new line, the end point's line is blank. Otherwise, the stretch
    // of blank lines ended on the previous line.
    SourceLocation.Point blankLineEnd =
        whitespaceStr.charAt(whitespaceStr.length() - 1) == '\n'
        ? SourceLocation.Point.create(wsEnd.line(), 1)
        : SourceLocation.Point.create(wsEnd.line() - 1, 1);

    SourceLocation loc =
        new SourceLocation(
            parser.filePath,
            blankLineBegin,
            blankLineEnd);

    comments.add(Comment.create(Comment.Type.BLANK_LINES, whitespaceStr, loc));
  }

  void addLineComment(Token commentToken) {
    comments.add(
        Comment.create(Comment.Type.LINE, commentToken.image, parser.createSrcLoc(commentToken)));
  }

  void addRangeComment(Token commentToken) {
    comments.add(
        Comment.create(Comment.Type.RANGE, commentToken.image, parser.createSrcLoc(commentToken)));
  }

  void trimTokenBegin(Token token, int by) {
    for (int i = 0; i < by; i++) {
        char c = token.image.charAt(i);
        if (c == '\n') {
          token.beginLine += 1;
          token.beginColumn = 1;
        } else {
          token.beginColumn++;
        }
    }
    token.image = token.image.substring(by);
  }

  @Override
  public String toString() {
    return "TokenManager{" + lexStateNames[curLexState] + "}";
  }

  /** Debug output. */
  public  java.io.PrintStream debugStream = System.out;
  /** Set debug output. */
  public  void setDebugStream(java.io.PrintStream ds) { debugStream = ds; }
private final int jjStopStringLiteralDfa_12(int pos, long active0, long active1){
   switch (pos)
   {
      case 0:
         if ((active1 & 0x700000000000L) != 0L)
         {
            jjmatchedKind = 107;
            return -1;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_12(int pos, long active0, long active1){
   return jjMoveNfa_12(jjStopStringLiteralDfa_12(pos, active0, active1), pos + 1);
}
private int jjStopAtPos(int pos, int kind)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   return pos + 1;
}
private int jjMoveStringLiteralDfa0_12(){
   switch(curChar)
   {
      case 34:
         return jjStopAtPos(0, 106);
      case 92:
         return jjMoveStringLiteralDfa1_12(0x700000000000L);
      default :
         return jjMoveNfa_12(0, 0);
   }
}
private int jjMoveStringLiteralDfa1_12(long active1){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_12(0, 0L, active1);
      return 1;
   }
   switch(curChar)
   {
      case 34:
         if ((active1 & 0x400000000000L) != 0L)
            return jjStopAtPos(1, 110);
         break;
      case 39:
         if ((active1 & 0x200000000000L) != 0L)
            return jjStopAtPos(1, 109);
         break;
      case 92:
         if ((active1 & 0x100000000000L) != 0L)
            return jjStopAtPos(1, 108);
         break;
      default :
         break;
   }
   return jjStartNfa_12(0, 0L, active1);
}
static final long[] jjbitVec0 = {
   0xfffffffffffffffeL, 0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffffffffffffffL
};
static final long[] jjbitVec2 = {
   0x0L, 0x0L, 0xffffffffffffffffL, 0xffffffffffffffffL
};
private int jjMoveNfa_12(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 2;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0xffffffffffffdbffL & l) != 0L)
                  {
                     if (kind > 107)
                        kind = 107;
                  }
                  else if ((0x2400L & l) != 0L)
                  {
                     if (kind > 111)
                        kind = 111;
                  }
                  break;
               case 1:
                  if ((0x2400L & l) != 0L)
                     kind = 111;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  kind = 107;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 107)
                     kind = 107;
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 2 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private int jjMoveStringLiteralDfa0_10(){
   switch(curChar)
   {
      case 123:
         return jjMoveStringLiteralDfa1_10(0x40000000L);
      default :
         return 1;
   }
}
private int jjMoveStringLiteralDfa1_10(long active1){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      return 1;
   }
   switch(curChar)
   {
      case 47:
         return jjMoveStringLiteralDfa2_10(active1, 0x40000000L);
      default :
         return 2;
   }
}
private int jjMoveStringLiteralDfa2_10(long old1, long active1){
   if (((active1 &= old1)) == 0L)
      return 2;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      return 2;
   }
   switch(curChar)
   {
      case 108:
         return jjMoveStringLiteralDfa3_10(active1, 0x40000000L);
      default :
         return 3;
   }
}
private int jjMoveStringLiteralDfa3_10(long old1, long active1){
   if (((active1 &= old1)) == 0L)
      return 3;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      return 3;
   }
   switch(curChar)
   {
      case 105:
         return jjMoveStringLiteralDfa4_10(active1, 0x40000000L);
      default :
         return 4;
   }
}
private int jjMoveStringLiteralDfa4_10(long old1, long active1){
   if (((active1 &= old1)) == 0L)
      return 4;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      return 4;
   }
   switch(curChar)
   {
      case 116:
         return jjMoveStringLiteralDfa5_10(active1, 0x40000000L);
      default :
         return 5;
   }
}
private int jjMoveStringLiteralDfa5_10(long old1, long active1){
   if (((active1 &= old1)) == 0L)
      return 5;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      return 5;
   }
   switch(curChar)
   {
      case 101:
         return jjMoveStringLiteralDfa6_10(active1, 0x40000000L);
      default :
         return 6;
   }
}
private int jjMoveStringLiteralDfa6_10(long old1, long active1){
   if (((active1 &= old1)) == 0L)
      return 6;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      return 6;
   }
   switch(curChar)
   {
      case 114:
         return jjMoveStringLiteralDfa7_10(active1, 0x40000000L);
      default :
         return 7;
   }
}
private int jjMoveStringLiteralDfa7_10(long old1, long active1){
   if (((active1 &= old1)) == 0L)
      return 7;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      return 7;
   }
   switch(curChar)
   {
      case 97:
         return jjMoveStringLiteralDfa8_10(active1, 0x40000000L);
      default :
         return 8;
   }
}
private int jjMoveStringLiteralDfa8_10(long old1, long active1){
   if (((active1 &= old1)) == 0L)
      return 8;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      return 8;
   }
   switch(curChar)
   {
      case 108:
         return jjMoveStringLiteralDfa9_10(active1, 0x40000000L);
      default :
         return 9;
   }
}
private int jjMoveStringLiteralDfa9_10(long old1, long active1){
   if (((active1 &= old1)) == 0L)
      return 9;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      return 9;
   }
   switch(curChar)
   {
      case 125:
         if ((active1 & 0x40000000L) != 0L)
            return jjStopAtPos(9, 94);
         break;
      default :
         return 10;
   }
   return 10;
}
private int jjMoveStringLiteralDfa0_9(){
   switch(curChar)
   {
      case 39:
         return jjStopAtPos(0, 25);
      case 92:
         return jjMoveStringLiteralDfa1_9(0x20000000L);
      default :
         return 1;
   }
}
private int jjMoveStringLiteralDfa1_9(long active0){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      return 1;
   }
   switch(curChar)
   {
      case 39:
         if ((active0 & 0x20000000L) != 0L)
            return jjStopAtPos(1, 29);
         break;
      default :
         return 2;
   }
   return 2;
}
private final int jjStopStringLiteralDfa_3(int pos, long active0, long active1, long active2){
   switch (pos)
   {
      case 0:
         if ((active1 & 0x18000e00000000L) != 0L || (active2 & 0x381L) != 0L)
         {
            jjmatchedKind = 144;
            return 10;
         }
         if ((active0 & 0x10L) != 0L || (active1 & 0x4000000000000000L) != 0L)
            return 3;
         return -1;
      case 1:
         if ((active1 & 0x8000000000000L) != 0L || (active2 & 0x300L) != 0L)
            return 10;
         if ((active1 & 0x10000e00000000L) != 0L || (active2 & 0x81L) != 0L)
         {
            jjmatchedKind = 144;
            jjmatchedPos = 1;
            return 10;
         }
         return -1;
      case 2:
         if ((active1 & 0x10000000000000L) != 0L || (active2 & 0x81L) != 0L)
            return 10;
         if ((active1 & 0xe00000000L) != 0L)
         {
            jjmatchedKind = 144;
            jjmatchedPos = 2;
            return 10;
         }
         return -1;
      case 3:
         if ((active1 & 0x600000000L) != 0L)
            return 10;
         if ((active1 & 0x800000000L) != 0L)
         {
            jjmatchedKind = 144;
            jjmatchedPos = 3;
            return 10;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_3(int pos, long active0, long active1, long active2){
   return jjMoveNfa_3(jjStopStringLiteralDfa_3(pos, active0, active1, active2), pos + 1);
}
private int jjMoveStringLiteralDfa0_3(){
   switch(curChar)
   {
      case 33:
         jjmatchedKind = 143;
         return jjMoveStringLiteralDfa1_3(0x0L, 0x40000000000000L, 0x0L);
      case 34:
         return jjStopAtPos(0, 22);
      case 37:
         return jjStopAtPos(0, 127);
      case 38:
         return jjMoveStringLiteralDfa1_3(0x0L, 0x0L, 0x40000L);
      case 39:
         return jjStopAtPos(0, 103);
      case 40:
         return jjStopAtPos(0, 138);
      case 41:
         return jjStopAtPos(0, 139);
      case 42:
         return jjStopAtPos(0, 125);
      case 43:
         return jjStopAtPos(0, 123);
      case 44:
         return jjStopAtPos(0, 134);
      case 45:
         return jjStopAtPos(0, 124);
      case 46:
         return jjStopAtPos(0, 129);
      case 47:
         jjmatchedKind = 126;
         return jjMoveStringLiteralDfa1_3(0x10L, 0x0L, 0x0L);
      case 58:
         return jjStopAtPos(0, 113);
      case 60:
         jjmatchedKind = 119;
         return jjMoveStringLiteralDfa1_3(0x0L, 0x200000000000000L, 0x0L);
      case 61:
         jjmatchedKind = 141;
         return jjMoveStringLiteralDfa1_3(0x0L, 0x20000000000000L, 0x4000L);
      case 62:
         jjmatchedKind = 120;
         return jjMoveStringLiteralDfa1_3(0x0L, 0x400000000000000L, 0x0L);
      case 63:
         jjmatchedKind = 112;
         return jjMoveStringLiteralDfa1_3(0x0L, 0x4000000000000L, 0x24L);
      case 91:
         return jjStopAtPos(0, 131);
      case 93:
         return jjStopAtPos(0, 132);
      case 97:
         return jjMoveStringLiteralDfa1_3(0x0L, 0x10000000000000L, 0x0L);
      case 102:
         return jjMoveStringLiteralDfa1_3(0x0L, 0x800000000L, 0x80L);
      case 105:
         return jjMoveStringLiteralDfa1_3(0x0L, 0x0L, 0x300L);
      case 110:
         return jjMoveStringLiteralDfa1_3(0x0L, 0x200000000L, 0x1L);
      case 111:
         return jjMoveStringLiteralDfa1_3(0x0L, 0x8000000000000L, 0x0L);
      case 116:
         return jjMoveStringLiteralDfa1_3(0x0L, 0x400000000L, 0x0L);
      case 124:
         jjmatchedKind = 140;
         return jjMoveStringLiteralDfa1_3(0x0L, 0x0L, 0x80000L);
      default :
         return jjMoveNfa_3(5, 0);
   }
}
private int jjMoveStringLiteralDfa1_3(long active0, long active1, long active2){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_3(0, active0, active1, active2);
      return 1;
   }
   switch(curChar)
   {
      case 38:
         if ((active2 & 0x40000L) != 0L)
            return jjStopAtPos(1, 146);
         break;
      case 42:
         if ((active0 & 0x10L) != 0L)
            return jjStopAtPos(1, 4);
         break;
      case 46:
         if ((active2 & 0x4L) != 0L)
            return jjStopAtPos(1, 130);
         break;
      case 58:
         if ((active1 & 0x4000000000000L) != 0L)
            return jjStopAtPos(1, 114);
         break;
      case 61:
         if ((active1 & 0x20000000000000L) != 0L)
            return jjStopAtPos(1, 117);
         else if ((active1 & 0x40000000000000L) != 0L)
            return jjStopAtPos(1, 118);
         else if ((active1 & 0x200000000000000L) != 0L)
            return jjStopAtPos(1, 121);
         else if ((active1 & 0x400000000000000L) != 0L)
            return jjStopAtPos(1, 122);
         break;
      case 62:
         if ((active2 & 0x4000L) != 0L)
            return jjStopAtPos(1, 142);
         break;
      case 91:
         if ((active2 & 0x20L) != 0L)
            return jjStopAtPos(1, 133);
         break;
      case 97:
         return jjMoveStringLiteralDfa2_3(active0, 0L, active1, 0x800000000L, active2, 0L);
      case 102:
         if ((active2 & 0x200L) != 0L)
            return jjStartNfaWithStates_3(1, 137, 10);
         break;
      case 110:
         if ((active2 & 0x100L) != 0L)
            return jjStartNfaWithStates_3(1, 136, 10);
         return jjMoveStringLiteralDfa2_3(active0, 0L, active1, 0x10000000000000L, active2, 0L);
      case 111:
         return jjMoveStringLiteralDfa2_3(active0, 0L, active1, 0L, active2, 0x81L);
      case 114:
         if ((active1 & 0x8000000000000L) != 0L)
            return jjStartNfaWithStates_3(1, 115, 10);
         return jjMoveStringLiteralDfa2_3(active0, 0L, active1, 0x400000000L, active2, 0L);
      case 117:
         return jjMoveStringLiteralDfa2_3(active0, 0L, active1, 0x200000000L, active2, 0L);
      case 124:
         if ((active2 & 0x80000L) != 0L)
            return jjStopAtPos(1, 147);
         break;
      default :
         break;
   }
   return jjStartNfa_3(0, active0, active1, active2);
}
private int jjMoveStringLiteralDfa2_3(long old0, long active0, long old1, long active1, long old2, long active2){
   if (((active0 &= old0) | (active1 &= old1) | (active2 &= old2)) == 0L)
      return jjStartNfa_3(0, old0, old1, old2);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_3(1, 0L, active1, active2);
      return 2;
   }
   switch(curChar)
   {
      case 100:
         if ((active1 & 0x10000000000000L) != 0L)
            return jjStartNfaWithStates_3(2, 116, 10);
         break;
      case 108:
         return jjMoveStringLiteralDfa3_3(active1, 0xa00000000L, active2, 0L);
      case 114:
         if ((active2 & 0x80L) != 0L)
            return jjStartNfaWithStates_3(2, 135, 10);
         break;
      case 116:
         if ((active2 & 0x1L) != 0L)
            return jjStartNfaWithStates_3(2, 128, 10);
         break;
      case 117:
         return jjMoveStringLiteralDfa3_3(active1, 0x400000000L, active2, 0L);
      default :
         break;
   }
   return jjStartNfa_3(1, 0L, active1, active2);
}
private int jjMoveStringLiteralDfa3_3(long old1, long active1, long old2, long active2){
   if (((active1 &= old1) | (active2 &= old2)) == 0L)
      return jjStartNfa_3(1, 0L, old1, old2);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_3(2, 0L, active1, 0L);
      return 3;
   }
   switch(curChar)
   {
      case 101:
         if ((active1 & 0x400000000L) != 0L)
            return jjStartNfaWithStates_3(3, 98, 10);
         break;
      case 108:
         if ((active1 & 0x200000000L) != 0L)
            return jjStartNfaWithStates_3(3, 97, 10);
         break;
      case 115:
         return jjMoveStringLiteralDfa4_3(active1, 0x800000000L);
      default :
         break;
   }
   return jjStartNfa_3(2, 0L, active1, 0L);
}
private int jjMoveStringLiteralDfa4_3(long old1, long active1){
   if (((active1 &= old1)) == 0L)
      return jjStartNfa_3(2, 0L, old1, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_3(3, 0L, active1, 0L);
      return 4;
   }
   switch(curChar)
   {
      case 101:
         if ((active1 & 0x800000000L) != 0L)
            return jjStartNfaWithStates_3(4, 99, 10);
         break;
      default :
         break;
   }
   return jjStartNfa_3(3, 0L, active1, 0L);
}
private int jjStartNfaWithStates_3(int pos, int kind, int state)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) { return pos + 1; }
   return jjMoveNfa_3(state, pos + 1);
}
private int jjMoveNfa_3(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 26;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 5:
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 100)
                        kind = 100;
                     { jjCheckNAddStates(0, 4); }
                  }
                  else if ((0x100002600L & l) != 0L)
                  {
                     if (kind > 1)
                        kind = 1;
                     { jjCheckNAddTwoStates(0, 2); }
                  }
                  else if (curChar == 36)
                     jjstateSet[jjnewStateCnt++] = 12;
                  else if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 3;
                  if (curChar == 48)
                     jjstateSet[jjnewStateCnt++] = 6;
                  else if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 0:
                  if ((0x100002600L & l) == 0L)
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjCheckNAddTwoStates(0, 2); }
                  break;
               case 1:
                  if (curChar != 10)
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjCheckNAddTwoStates(0, 2); }
                  break;
               case 2:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 3:
                  if (curChar != 47)
                     break;
                  if (kind > 2)
                     kind = 2;
                  { jjCheckNAdd(4); }
                  break;
               case 4:
                  if ((0xffffffffffffdbffL & l) == 0L)
                     break;
                  if (kind > 2)
                     kind = 2;
                  { jjCheckNAdd(4); }
                  break;
               case 7:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 101)
                     kind = 101;
                  jjstateSet[jjnewStateCnt++] = 7;
                  break;
               case 8:
                  if (curChar == 48)
                     jjstateSet[jjnewStateCnt++] = 6;
                  break;
               case 10:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 144)
                     kind = 144;
                  jjstateSet[jjnewStateCnt++] = 10;
                  break;
               case 11:
                  if (curChar == 36)
                     jjstateSet[jjnewStateCnt++] = 12;
                  break;
               case 13:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 145)
                     kind = 145;
                  jjstateSet[jjnewStateCnt++] = 13;
                  break;
               case 14:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 100)
                     kind = 100;
                  { jjCheckNAddStates(0, 4); }
                  break;
               case 15:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 100)
                     kind = 100;
                  { jjCheckNAdd(15); }
                  break;
               case 16:
                  if ((0x3ff000000000000L & l) != 0L)
                     { jjCheckNAddTwoStates(16, 17); }
                  break;
               case 17:
                  if (curChar == 46)
                     { jjCheckNAdd(18); }
                  break;
               case 18:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 102)
                     kind = 102;
                  { jjCheckNAddTwoStates(18, 19); }
                  break;
               case 20:
                  if ((0x280000000000L & l) != 0L)
                     { jjCheckNAdd(21); }
                  break;
               case 21:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 102)
                     kind = 102;
                  { jjCheckNAdd(21); }
                  break;
               case 22:
                  if ((0x3ff000000000000L & l) != 0L)
                     { jjCheckNAddTwoStates(22, 23); }
                  break;
               case 24:
                  if ((0x280000000000L & l) != 0L)
                     { jjCheckNAdd(25); }
                  break;
               case 25:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 102)
                     kind = 102;
                  { jjCheckNAdd(25); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 5:
               case 10:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 144)
                     kind = 144;
                  { jjCheckNAdd(10); }
                  break;
               case 4:
                  if (kind > 2)
                     kind = 2;
                  jjstateSet[jjnewStateCnt++] = 4;
                  break;
               case 6:
                  if (curChar == 120)
                     { jjCheckNAdd(7); }
                  break;
               case 7:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 101)
                     kind = 101;
                  { jjCheckNAdd(7); }
                  break;
               case 12:
               case 13:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 145)
                     kind = 145;
                  { jjCheckNAdd(13); }
                  break;
               case 19:
                  if (curChar == 101)
                     { jjAddStates(5, 6); }
                  break;
               case 23:
                  if (curChar == 101)
                     { jjAddStates(7, 8); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 4:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 2)
                     kind = 2;
                  jjstateSet[jjnewStateCnt++] = 4;
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 26 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_5(int pos, long active0, long active1, long active2){
   switch (pos)
   {
      case 0:
         if ((active0 & 0xc967fdfe00000000L) != 0L || (active1 & 0x32faaaL) != 0L || (active2 & 0x300000L) != 0L)
            return 20;
         if ((active0 & 0x90L) != 0L)
         {
            jjmatchedKind = 96;
            return -1;
         }
         return -1;
      case 1:
         if ((active0 & 0x4000000000000000L) != 0L)
            return 71;
         if ((active0 & 0x4800000000000L) != 0L || (active1 & 0x2000L) != 0L)
            return 77;
         if ((active1 & 0x1000L) != 0L)
            return 59;
         if ((active0 & 0x90L) != 0L)
         {
            if (jjmatchedPos == 0)
            {
               jjmatchedKind = 96;
               jjmatchedPos = 0;
            }
            return -1;
         }
         if ((active1 & 0x8800L) != 0L)
            return 29;
         if ((active0 & 0x40000000000L) != 0L || (active1 & 0x200000L) != 0L)
            return 101;
         return -1;
      case 2:
         if ((active1 & 0x8800L) != 0L)
            return 28;
         if ((active0 & 0x4000000000000000L) != 0L)
            return 70;
         if ((active0 & 0x80L) != 0L)
         {
            if (jjmatchedPos == 0)
            {
               jjmatchedKind = 96;
               jjmatchedPos = 0;
            }
            return -1;
         }
         if ((active1 & 0x1000L) != 0L)
            return 60;
         return -1;
      case 3:
         if ((active0 & 0x4000000000000000L) != 0L)
            return 69;
         return -1;
      case 4:
         if ((active0 & 0x4000000000000000L) != 0L)
            return 68;
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_5(int pos, long active0, long active1, long active2){
   return jjMoveNfa_5(jjStopStringLiteralDfa_5(pos, active0, active1, active2), pos + 1);
}
private int jjMoveStringLiteralDfa0_5(){
   switch(curChar)
   {
      case 47:
         return jjMoveStringLiteralDfa1_5(0x90L, 0x0L, 0x0L);
      case 123:
         jjmatchedKind = 81;
         return jjMoveStringLiteralDfa1_5(0xc967fdfe00000000L, 0x30faaaL, 0x300000L);
      case 125:
         return jjStopAtPos(0, 41);
      default :
         return jjMoveNfa_5(1, 0);
   }
}
private int jjMoveStringLiteralDfa1_5(long active0, long active1, long active2){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_5(0, active0, active1, active2);
      return 1;
   }
   switch(curChar)
   {
      case 42:
         if ((active0 & 0x10L) != 0L)
         {
            jjmatchedKind = 4;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_5(active0, 0x80L, active1, 0L, active2, 0L);
      case 47:
         if ((active2 & 0x200000L) != 0L)
         {
            jjmatchedKind = 149;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_5(active0, 0x8960000e00000000L, active1, 0x1042aaL, active2, 0L);
      case 64:
         return jjMoveStringLiteralDfa2_5(active0, 0x1f000000000L, active1, 0L, active2, 0L);
      case 92:
         return jjMoveStringLiteralDfa2_5(active0, 0x700000000000L, active1, 0L, active2, 0L);
      case 100:
         return jjMoveStringLiteralDfa2_5(active0, 0L, active1, 0x8800L, active2, 0L);
      case 101:
         return jjMoveStringLiteralDfa2_5(active0, 0x4000000000000000L, active1, 0L, active2, 0L);
      case 105:
         return jjMoveStringLiteralDfa2_5(active0, 0L, active1, 0x1000L, active2, 0L);
      case 108:
         return jjMoveStringLiteralDfa2_5(active0, 0x4800000000000L, active1, 0x2000L, active2, 0L);
      case 110:
         return jjMoveStringLiteralDfa2_5(active0, 0x2080000000000L, active1, 0L, active2, 0L);
      case 114:
         return jjMoveStringLiteralDfa2_5(active0, 0x1000000000000L, active1, 0L, active2, 0L);
      case 115:
         return jjMoveStringLiteralDfa2_5(active0, 0x40000000000L, active1, 0x200000L, active2, 0L);
      case 123:
         if ((active2 & 0x100000L) != 0L)
            return jjStopAtPos(1, 148);
         break;
      default :
         break;
   }
   return jjStartNfa_5(0, active0, active1, active2);
}
private int jjMoveStringLiteralDfa2_5(long old0, long active0, long old1, long active1, long old2, long active2){
   if (((active0 &= old0) | (active1 &= old1) | (active2 &= old2)) == 0L)
      return jjStartNfa_5(0, old0, old1, old2);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_5(1, active0, active1, 0L);
      return 2;
   }
   switch(curChar)
   {
      case 42:
         if ((active0 & 0x80L) != 0L)
            return jjStopAtPos(2, 7);
         break;
      case 98:
         return jjMoveStringLiteralDfa3_5(active0, 0x3800000000000L, active1, 0L);
      case 99:
         return jjMoveStringLiteralDfa3_5(active0, 0x20000000000000L, active1, 0L);
      case 100:
         return jjMoveStringLiteralDfa3_5(active0, 0x40000400000000L, active1, 0L);
      case 101:
         return jjMoveStringLiteralDfa3_5(active0, 0x800000000L, active1, 0x8800L);
      case 102:
         return jjMoveStringLiteralDfa3_5(active0, 0L, active1, 0x1008L);
      case 105:
         return jjMoveStringLiteralDfa3_5(active0, 0x800408c000000000L, active1, 0L);
      case 107:
         return jjMoveStringLiteralDfa3_5(active0, 0L, active1, 0x200000L);
      case 108:
         return jjMoveStringLiteralDfa3_5(active0, 0x4000000000000000L, active1, 0x4002L);
      case 109:
         return jjMoveStringLiteralDfa3_5(active0, 0x800000000000000L, active1, 0L);
      case 110:
         return jjMoveStringLiteralDfa3_5(active0, 0x100000000000L, active1, 0L);
      case 111:
         return jjMoveStringLiteralDfa3_5(active0, 0L, active1, 0x2000L);
      case 112:
         return jjMoveStringLiteralDfa3_5(active0, 0x100043000000000L, active1, 0x20L);
      case 114:
         return jjMoveStringLiteralDfa3_5(active0, 0x200000000000L, active1, 0L);
      case 115:
         return jjMoveStringLiteralDfa3_5(active0, 0x10000000000L, active1, 0x280L);
      case 116:
         return jjMoveStringLiteralDfa3_5(active0, 0x400200000000L, active1, 0L);
      case 118:
         return jjMoveStringLiteralDfa3_5(active0, 0L, active1, 0x100000L);
      default :
         break;
   }
   return jjStartNfa_5(1, active0, active1, 0L);
}
private int jjMoveStringLiteralDfa3_5(long old0, long active0, long old1, long active1){
   if (((active0 &= old0) | (active1 &= old1)) == 0L)
      return jjStartNfa_5(1, old0, old1, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_5(2, active0, active1, 0L);
      return 3;
   }
   switch(curChar)
   {
      case 97:
         return jjMoveStringLiteralDfa4_5(active0, 0x120003000000000L, active1, 0L);
      case 98:
         return jjMoveStringLiteralDfa4_5(active0, 0L, active1, 0x8000L);
      case 101:
         return jjMoveStringLiteralDfa4_5(active0, 0x40000600000000L, active1, 0x101082L);
      case 102:
         return jjMoveStringLiteralDfa4_5(active0, 0x8000000000000000L, active1, 0x800L);
      case 103:
         return jjMoveStringLiteralDfa4_5(active0, 0L, active1, 0x2000L);
      case 105:
         return jjMoveStringLiteralDfa4_5(active0, 0L, active1, 0x200000L);
      case 108:
         return jjMoveStringLiteralDfa4_5(active0, 0x80800000000L, active1, 0x20L);
      case 110:
         return jjMoveStringLiteralDfa4_5(active0, 0xc000000000L, active1, 0L);
      case 111:
         return jjMoveStringLiteralDfa4_5(active0, 0L, active1, 0x4008L);
      case 115:
         return jjMoveStringLiteralDfa4_5(active0, 0x4802000000000000L, active1, 0L);
      case 116:
         return jjMoveStringLiteralDfa4_5(active0, 0x4010000000000L, active1, 0L);
      case 119:
         return jjMoveStringLiteralDfa4_5(active0, 0L, active1, 0x200L);
      case 125:
         if ((active0 & 0x40000000000L) != 0L)
            return jjStopAtPos(3, 42);
         else if ((active0 & 0x100000000000L) != 0L)
            return jjStopAtPos(3, 44);
         else if ((active0 & 0x200000000000L) != 0L)
            return jjStopAtPos(3, 45);
         else if ((active0 & 0x400000000000L) != 0L)
            return jjStopAtPos(3, 46);
         else if ((active0 & 0x800000000000L) != 0L)
            return jjStopAtPos(3, 47);
         else if ((active0 & 0x1000000000000L) != 0L)
            return jjStopAtPos(3, 48);
         break;
      default :
         break;
   }
   return jjStartNfa_5(2, active0, active1, 0L);
}
private int jjMoveStringLiteralDfa4_5(long old0, long active0, long old1, long active1){
   if (((active0 &= old0) | (active1 &= old1)) == 0L)
      return jjStartNfa_5(2, old0, old1, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_5(3, active0, active1, 0L);
      return 4;
   }
   switch(curChar)
   {
      case 97:
         return jjMoveStringLiteralDfa5_5(active0, 0x10000000000L, active1, 0x800L);
      case 101:
         return jjMoveStringLiteralDfa5_5(active0, 0x4004000800000000L, active1, 0L);
      case 103:
         return jjMoveStringLiteralDfa5_5(active0, 0x800000000000000L, active1, 0x4000L);
      case 105:
         return jjMoveStringLiteralDfa5_5(active0, 0L, active1, 0x200L);
      case 106:
         return jjMoveStringLiteralDfa5_5(active0, 0xc000000000L, active1, 0L);
      case 108:
         return jjMoveStringLiteralDfa5_5(active0, 0x60000400000000L, active1, 0x100080L);
      case 109:
         return jjMoveStringLiteralDfa5_5(active0, 0x200000000L, active1, 0x1000L);
      case 112:
         return jjMoveStringLiteralDfa5_5(active0, 0x2000000000000L, active1, 0x200000L);
      case 114:
         return jjMoveStringLiteralDfa5_5(active0, 0x100003000000000L, active1, 0x8L);
      case 116:
         return jjMoveStringLiteralDfa5_5(active0, 0L, active1, 0x2L);
      case 117:
         return jjMoveStringLiteralDfa5_5(active0, 0L, active1, 0x8020L);
      case 125:
         if ((active0 & 0x80000000000L) != 0L)
            return jjStopAtPos(4, 43);
         else if ((active0 & 0x8000000000000000L) != 0L)
            return jjStopAtPos(4, 63);
         else if ((active1 & 0x2000L) != 0L)
            return jjStopAtPos(4, 77);
         break;
      default :
         break;
   }
   return jjStartNfa_5(3, active0, active1, 0L);
}
private int jjMoveStringLiteralDfa5_5(long old0, long active0, long old1, long active1){
   if (((active0 &= old0) | (active1 &= old1)) == 0L)
      return jjStartNfa_5(3, old0, old1, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_5(4, active0, active1, 0L);
      return 5;
   }
   switch(curChar)
   {
      case 97:
         return jjMoveStringLiteralDfa6_5(active0, 0x100003000000000L, active1, 0L);
      case 99:
         return jjMoveStringLiteralDfa6_5(active0, 0x40000000000000L, active1, 0L);
      case 101:
         return jjMoveStringLiteralDfa6_5(active0, 0xc000000000L, active1, 0x80L);
      case 103:
         return jjMoveStringLiteralDfa6_5(active0, 0L, active1, 0x8000L);
      case 108:
         return jjMoveStringLiteralDfa6_5(active0, 0x20000000000000L, active1, 0L);
      case 109:
         return jjMoveStringLiteralDfa6_5(active0, 0x800000000L, active1, 0L);
      case 111:
         return jjMoveStringLiteralDfa6_5(active0, 0L, active1, 0x100000L);
      case 112:
         return jjMoveStringLiteralDfa6_5(active0, 0x200000000L, active1, 0x1000L);
      case 114:
         return jjMoveStringLiteralDfa6_5(active0, 0x4000000000000L, active1, 0x20L);
      case 116:
         return jjMoveStringLiteralDfa6_5(active0, 0x10400000000L, active1, 0x200L);
      case 117:
         return jjMoveStringLiteralDfa6_5(active0, 0L, active1, 0x800L);
      case 125:
         if ((active0 & 0x2000000000000L) != 0L)
            return jjStopAtPos(5, 49);
         else if ((active0 & 0x800000000000000L) != 0L)
            return jjStopAtPos(5, 59);
         else if ((active0 & 0x4000000000000000L) != 0L)
            return jjStopAtPos(5, 62);
         else if ((active1 & 0x2L) != 0L)
            return jjStopAtPos(5, 65);
         else if ((active1 & 0x8L) != 0L)
            return jjStopAtPos(5, 67);
         else if ((active1 & 0x4000L) != 0L)
            return jjStopAtPos(5, 78);
         else if ((active1 & 0x200000L) != 0L)
            return jjStopAtPos(5, 85);
         break;
      default :
         break;
   }
   return jjStartNfa_5(4, active0, active1, 0L);
}
private int jjMoveStringLiteralDfa6_5(long old0, long active0, long old1, long active1){
   if (((active0 &= old0) | (active1 &= old1)) == 0L)
      return jjStartNfa_5(4, old0, old1, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_5(5, active0, active1, 0L);
      return 6;
   }
   switch(curChar)
   {
      case 97:
         return jjMoveStringLiteralDfa7_5(active0, 0x44000000000000L, active1, 0x20L);
      case 99:
         return jjMoveStringLiteralDfa7_5(active0, 0xc000000000L, active1, 0x280L);
      case 101:
         if ((active0 & 0x10000000000L) != 0L)
            return jjStopAtPos(6, 40);
         return jjMoveStringLiteralDfa7_5(active0, 0xc00000000L, active1, 0L);
      case 103:
         return jjMoveStringLiteralDfa7_5(active0, 0L, active1, 0x108000L);
      case 108:
         return jjMoveStringLiteralDfa7_5(active0, 0x200000000L, active1, 0x800L);
      case 109:
         if ((active0 & 0x1000000000L) != 0L)
         {
            jjmatchedKind = 36;
            jjmatchedPos = 6;
         }
         return jjMoveStringLiteralDfa7_5(active0, 0x100002000000000L, active1, 0L);
      case 116:
         return jjMoveStringLiteralDfa7_5(active0, 0L, active1, 0x1000L);
      case 125:
         if ((active0 & 0x20000000000000L) != 0L)
            return jjStopAtPos(6, 53);
         break;
      default :
         break;
   }
   return jjStartNfa_5(5, active0, active1, 0L);
}
private int jjMoveStringLiteralDfa7_5(long old0, long active0, long old1, long active1){
   if (((active0 &= old0) | (active1 &= old1)) == 0L)
      return jjStartNfa_5(5, old0, old1, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_5(6, active0, active1, 0L);
      return 7;
   }
   switch(curChar)
   {
      case 63:
         if ((active0 & 0x2000000000L) != 0L)
            return jjStopAtPos(7, 37);
         break;
      case 97:
         return jjMoveStringLiteralDfa8_5(active0, 0x200000000L, active1, 0L);
      case 101:
         return jjMoveStringLiteralDfa8_5(active0, 0L, active1, 0x8000L);
      case 104:
         return jjMoveStringLiteralDfa8_5(active0, 0L, active1, 0x200L);
      case 108:
         return jjMoveStringLiteralDfa8_5(active0, 0x44000000000000L, active1, 0x20L);
      case 109:
         return jjMoveStringLiteralDfa8_5(active0, 0x400000000L, active1, 0L);
      case 110:
         return jjMoveStringLiteralDfa8_5(active0, 0x800000000L, active1, 0L);
      case 116:
         if ((active0 & 0x4000000000L) != 0L)
         {
            jjmatchedKind = 38;
            jjmatchedPos = 7;
         }
         return jjMoveStringLiteralDfa8_5(active0, 0x8000000000L, active1, 0x880L);
      case 121:
         return jjMoveStringLiteralDfa8_5(active0, 0L, active1, 0x1000L);
      case 125:
         if ((active0 & 0x100000000000000L) != 0L)
            return jjStopAtPos(7, 56);
         else if ((active1 & 0x100000L) != 0L)
            return jjStopAtPos(7, 84);
         break;
      default :
         break;
   }
   return jjStartNfa_5(6, active0, active1, 0L);
}
private int jjMoveStringLiteralDfa8_5(long old0, long active0, long old1, long active1){
   if (((active0 &= old0) | (active1 &= old1)) == 0L)
      return jjStartNfa_5(6, old0, old1, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_5(7, active0, active1, 0L);
      return 8;
   }
   switch(curChar)
   {
      case 63:
         if ((active0 & 0x8000000000L) != 0L)
            return jjStopAtPos(8, 39);
         break;
      case 108:
         return jjMoveStringLiteralDfa9_5(active0, 0x40000000000000L, active1, 0L);
      case 112:
         return jjMoveStringLiteralDfa9_5(active0, 0x400000000L, active1, 0L);
      case 114:
         return jjMoveStringLiteralDfa9_5(active0, 0L, active1, 0x8000L);
      case 116:
         return jjMoveStringLiteralDfa9_5(active0, 0xa00000000L, active1, 0L);
      case 125:
         if ((active0 & 0x4000000000000L) != 0L)
            return jjStopAtPos(8, 50);
         else if ((active1 & 0x20L) != 0L)
            return jjStopAtPos(8, 69);
         else if ((active1 & 0x80L) != 0L)
            return jjStopAtPos(8, 71);
         else if ((active1 & 0x200L) != 0L)
            return jjStopAtPos(8, 73);
         else if ((active1 & 0x800L) != 0L)
            return jjStopAtPos(8, 75);
         else if ((active1 & 0x1000L) != 0L)
            return jjStopAtPos(8, 76);
         break;
      default :
         break;
   }
   return jjStartNfa_5(7, active0, active1, 0L);
}
private int jjMoveStringLiteralDfa9_5(long old0, long active0, long old1, long active1){
   if (((active0 &= old0) | (active1 &= old1)) == 0L)
      return jjStartNfa_5(7, old0, old1, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_5(8, active0, active1, 0L);
      return 9;
   }
   switch(curChar)
   {
      case 101:
         return jjMoveStringLiteralDfa10_5(active0, 0x200000000L, active1, 0L);
      case 108:
         return jjMoveStringLiteralDfa10_5(active0, 0x400000000L, active1, 0L);
      case 125:
         if ((active0 & 0x800000000L) != 0L)
            return jjStopAtPos(9, 35);
         else if ((active0 & 0x40000000000000L) != 0L)
            return jjStopAtPos(9, 54);
         else if ((active1 & 0x8000L) != 0L)
            return jjStopAtPos(9, 79);
         break;
      default :
         break;
   }
   return jjStartNfa_5(8, active0, active1, 0L);
}
private int jjMoveStringLiteralDfa10_5(long old0, long active0, long old1, long active1){
   if (((active0 &= old0) | (active1 &= old1)) == 0L)
      return jjStartNfa_5(8, old0, old1, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_5(9, active0, 0L, 0L);
      return 10;
   }
   switch(curChar)
   {
      case 97:
         return jjMoveStringLiteralDfa11_5(active0, 0x400000000L);
      case 125:
         if ((active0 & 0x200000000L) != 0L)
            return jjStopAtPos(10, 33);
         break;
      default :
         break;
   }
   return jjStartNfa_5(9, active0, 0L, 0L);
}
private int jjMoveStringLiteralDfa11_5(long old0, long active0){
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_5(9, old0, 0L, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_5(10, active0, 0L, 0L);
      return 11;
   }
   switch(curChar)
   {
      case 116:
         return jjMoveStringLiteralDfa12_5(active0, 0x400000000L);
      default :
         break;
   }
   return jjStartNfa_5(10, active0, 0L, 0L);
}
private int jjMoveStringLiteralDfa12_5(long old0, long active0){
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_5(10, old0, 0L, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_5(11, active0, 0L, 0L);
      return 12;
   }
   switch(curChar)
   {
      case 101:
         return jjMoveStringLiteralDfa13_5(active0, 0x400000000L);
      default :
         break;
   }
   return jjStartNfa_5(11, active0, 0L, 0L);
}
private int jjMoveStringLiteralDfa13_5(long old0, long active0){
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_5(11, old0, 0L, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_5(12, active0, 0L, 0L);
      return 13;
   }
   switch(curChar)
   {
      case 125:
         if ((active0 & 0x400000000L) != 0L)
            return jjStopAtPos(13, 34);
         break;
      default :
         break;
   }
   return jjStartNfa_5(12, active0, 0L, 0L);
}
private int jjMoveNfa_5(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 141;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 60:
                  if ((0x100002600L & l) != 0L)
                  {
                     if (kind > 60)
                        kind = 60;
                  }
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 61;
                  break;
               case 1:
                  if ((0xffff7ffeffffd9ffL & l) != 0L)
                  {
                     if (kind > 96)
                        kind = 96;
                     { jjCheckNAdd(0); }
                  }
                  else if ((0x100002600L & l) != 0L)
                  {
                     if (kind > 95)
                        kind = 95;
                     { jjCheckNAddStates(9, 13); }
                  }
                  else if (curChar == 47)
                  {
                     if (kind > 96)
                        kind = 96;
                  }
                  if (curChar == 13)
                     { jjCheckNAddTwoStates(4, 10); }
                  break;
               case 0:
                  if ((0xffff7ffeffffd9ffL & l) == 0L)
                     break;
                  if (kind > 96)
                     kind = 96;
                  { jjCheckNAdd(0); }
                  break;
               case 2:
                  if ((0x100002600L & l) == 0L)
                     break;
                  if (kind > 95)
                     kind = 95;
                  { jjCheckNAddStates(9, 13); }
                  break;
               case 3:
                  if ((0x100002600L & l) != 0L)
                     { jjCheckNAddStates(14, 16); }
                  break;
               case 4:
                  if (curChar == 10)
                     { jjCheckNAddStates(14, 16); }
                  break;
               case 5:
                  if (curChar == 13)
                     { jjCheckNAdd(4); }
                  break;
               case 6:
                  if (curChar != 47)
                     break;
                  if (kind > 3)
                     kind = 3;
                  { jjCheckNAdd(7); }
                  break;
               case 7:
                  if ((0xffffffffffffdbffL & l) == 0L)
                     break;
                  if (kind > 3)
                     kind = 3;
                  { jjCheckNAdd(7); }
                  break;
               case 8:
                  if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 6;
                  break;
               case 9:
                  if ((0x100002600L & l) == 0L)
                     break;
                  if (kind > 95)
                     kind = 95;
                  { jjCheckNAddTwoStates(9, 11); }
                  break;
               case 10:
                  if (curChar != 10)
                     break;
                  if (kind > 95)
                     kind = 95;
                  { jjCheckNAddTwoStates(9, 11); }
                  break;
               case 11:
                  if (curChar == 13)
                     { jjCheckNAdd(10); }
                  break;
               case 12:
                  if (curChar == 13)
                     { jjCheckNAddTwoStates(4, 10); }
                  break;
               case 15:
                  if ((0x100002600L & l) != 0L && kind > 51)
                     kind = 51;
                  break;
               case 16:
                  if (curChar == 10 && kind > 51)
                     kind = 51;
                  break;
               case 17:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 16;
                  break;
               case 22:
                  if ((0x100002600L & l) != 0L && kind > 52)
                     kind = 52;
                  break;
               case 23:
                  if (curChar == 10 && kind > 52)
                     kind = 52;
                  break;
               case 24:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 23;
                  break;
               case 32:
                  if ((0x100002600L & l) != 0L && kind > 55)
                     kind = 55;
                  break;
               case 33:
                  if (curChar == 10 && kind > 55)
                     kind = 55;
                  break;
               case 34:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 33;
                  break;
               case 40:
                  if ((0x100002600L & l) != 0L && kind > 57)
                     kind = 57;
                  break;
               case 41:
                  if (curChar == 10 && kind > 57)
                     kind = 57;
                  break;
               case 42:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 41;
                  break;
               case 46:
                  if ((0x100002600L & l) != 0L && kind > 58)
                     kind = 58;
                  break;
               case 47:
                  if (curChar == 10 && kind > 58)
                     kind = 58;
                  break;
               case 48:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 47;
                  break;
               case 61:
                  if (curChar == 10 && kind > 60)
                     kind = 60;
                  break;
               case 62:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 61;
                  break;
               case 65:
                  if ((0x100002600L & l) != 0L && kind > 61)
                     kind = 61;
                  break;
               case 66:
                  if (curChar == 10 && kind > 61)
                     kind = 61;
                  break;
               case 67:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 66;
                  break;
               case 74:
                  if ((0x100002600L & l) != 0L && kind > 64)
                     kind = 64;
                  break;
               case 75:
                  if (curChar == 10 && kind > 64)
                     kind = 64;
                  break;
               case 76:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 75;
                  break;
               case 80:
                  if ((0x100002600L & l) != 0L && kind > 66)
                     kind = 66;
                  break;
               case 81:
                  if (curChar == 10 && kind > 66)
                     kind = 66;
                  break;
               case 82:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 81;
                  break;
               case 86:
                  if ((0x100002600L & l) != 0L && kind > 68)
                     kind = 68;
                  break;
               case 87:
                  if (curChar == 10 && kind > 68)
                     kind = 68;
                  break;
               case 88:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 87;
                  break;
               case 95:
                  if ((0x100002600L & l) != 0L && kind > 70)
                     kind = 70;
                  break;
               case 96:
                  if (curChar == 10 && kind > 70)
                     kind = 70;
                  break;
               case 97:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 96;
                  break;
               case 104:
                  if ((0x100002600L & l) != 0L && kind > 72)
                     kind = 72;
                  break;
               case 105:
                  if (curChar == 10 && kind > 72)
                     kind = 72;
                  break;
               case 106:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 105;
                  break;
               case 113:
                  if ((0x100002600L & l) != 0L && kind > 74)
                     kind = 74;
                  break;
               case 114:
                  if (curChar == 10 && kind > 74)
                     kind = 74;
                  break;
               case 115:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 114;
                  break;
               case 120:
                  if ((0x100002600L & l) != 0L && kind > 80)
                     kind = 80;
                  break;
               case 121:
                  if (curChar == 10 && kind > 80)
                     kind = 80;
                  break;
               case 122:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 121;
                  break;
               case 128:
                  if ((0x100002600L & l) != 0L && kind > 82)
                     kind = 82;
                  break;
               case 129:
                  if (curChar == 10 && kind > 82)
                     kind = 82;
                  break;
               case 130:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 129;
                  break;
               case 134:
                  if ((0x100002600L & l) != 0L && kind > 83)
                     kind = 83;
                  break;
               case 135:
                  if (curChar == 10 && kind > 83)
                     kind = 83;
                  break;
               case 136:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 135;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 20:
                  if (curChar == 118)
                     jjstateSet[jjnewStateCnt++] = 139;
                  else if (curChar == 107)
                     jjstateSet[jjnewStateCnt++] = 131;
                  else if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 125;
                  else if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 117;
                  else if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 110;
                  else if (curChar == 102)
                     jjstateSet[jjnewStateCnt++] = 83;
                  else if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 77;
                  else if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 71;
                  else if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 59;
                  else if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 43;
                  else if (curChar == 100)
                     jjstateSet[jjnewStateCnt++] = 29;
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 101;
                  else if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 92;
                  else if (curChar == 102)
                     jjstateSet[jjnewStateCnt++] = 57;
                  else if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 19;
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 37;
                  break;
               case 1:
                  if ((0xd7ffffffffffffffL & l) != 0L)
                  {
                     if (kind > 96)
                        kind = 96;
                     { jjCheckNAdd(0); }
                  }
                  else if (curChar == 123)
                     { jjAddStates(17, 32); }
                  break;
               case 101:
                  if (curChar == 119)
                     jjstateSet[jjnewStateCnt++] = 109;
                  else if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 100;
                  break;
               case 0:
                  if ((0xd7ffffffffffffffL & l) == 0L)
                     break;
                  if (kind > 96)
                     kind = 96;
                  { jjCheckNAdd(0); }
                  break;
               case 7:
                  if (kind > 3)
                     kind = 3;
                  jjstateSet[jjnewStateCnt++] = 7;
                  break;
               case 13:
                  if (curChar == 123)
                     { jjAddStates(17, 32); }
                  break;
               case 14:
                  if (curChar == 108)
                     { jjAddStates(33, 34); }
                  break;
               case 18:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 14;
                  break;
               case 19:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 18;
                  break;
               case 21:
                  if (curChar == 108)
                     { jjAddStates(35, 36); }
                  break;
               case 25:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 21;
                  break;
               case 26:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 25;
                  break;
               case 27:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 26;
                  break;
               case 28:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 27;
                  break;
               case 29:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 28;
                  break;
               case 30:
                  if (curChar == 100)
                     jjstateSet[jjnewStateCnt++] = 29;
                  break;
               case 31:
                  if (curChar == 109)
                     { jjAddStates(37, 38); }
                  break;
               case 35:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 31;
                  break;
               case 36:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 35;
                  break;
               case 37:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 36;
                  break;
               case 38:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 37;
                  break;
               case 39:
                  if (curChar == 103)
                     { jjAddStates(39, 40); }
                  break;
               case 43:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 39;
                  break;
               case 44:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 43;
                  break;
               case 45:
                  if (curChar == 103)
                     { jjAddStates(41, 42); }
                  break;
               case 49:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 45;
                  break;
               case 50:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 49;
                  break;
               case 51:
                  if (curChar == 107)
                     jjstateSet[jjnewStateCnt++] = 50;
                  break;
               case 52:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 51;
                  break;
               case 53:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 52;
                  break;
               case 54:
                  if (curChar == 98)
                     jjstateSet[jjnewStateCnt++] = 53;
                  break;
               case 55:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 54;
                  break;
               case 56:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 55;
                  break;
               case 57:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 56;
                  break;
               case 58:
                  if (curChar == 102)
                     jjstateSet[jjnewStateCnt++] = 57;
                  break;
               case 59:
                  if (curChar == 102)
                     { jjAddStates(43, 44); }
                  break;
               case 63:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 59;
                  break;
               case 64:
                  if (curChar == 102)
                     { jjAddStates(45, 46); }
                  break;
               case 68:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 64;
                  break;
               case 69:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 68;
                  break;
               case 70:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 69;
                  break;
               case 71:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 70;
                  break;
               case 72:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 71;
                  break;
               case 73:
                  if (curChar == 116)
                     { jjAddStates(47, 48); }
                  break;
               case 77:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 73;
                  break;
               case 78:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 77;
                  break;
               case 79:
                  if (curChar == 114)
                     { jjAddStates(49, 50); }
                  break;
               case 83:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 79;
                  break;
               case 84:
                  if (curChar == 102)
                     jjstateSet[jjnewStateCnt++] = 83;
                  break;
               case 85:
                  if (curChar == 108)
                     { jjAddStates(51, 52); }
                  break;
               case 89:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 85;
                  break;
               case 90:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 89;
                  break;
               case 91:
                  if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 90;
                  break;
               case 92:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 91;
                  break;
               case 93:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 92;
                  break;
               case 94:
                  if (curChar == 116)
                     { jjAddStates(53, 54); }
                  break;
               case 98:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 94;
                  break;
               case 99:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 98;
                  break;
               case 100:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 99;
                  break;
               case 102:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 101;
                  break;
               case 103:
                  if (curChar == 104)
                     { jjAddStates(55, 56); }
                  break;
               case 107:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 103;
                  break;
               case 108:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 107;
                  break;
               case 109:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 108;
                  break;
               case 110:
                  if (curChar == 119)
                     jjstateSet[jjnewStateCnt++] = 109;
                  break;
               case 111:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 110;
                  break;
               case 112:
                  if (curChar == 101)
                     { jjAddStates(57, 58); }
                  break;
               case 116:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 112;
                  break;
               case 117:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 116;
                  break;
               case 118:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 117;
                  break;
               case 119:
                  if (curChar == 116)
                     { jjAddStates(59, 60); }
                  break;
               case 123:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 119;
                  break;
               case 124:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 123;
                  break;
               case 125:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 124;
                  break;
               case 126:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 125;
                  break;
               case 127:
                  if (curChar == 121)
                     { jjAddStates(61, 62); }
                  break;
               case 131:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 127;
                  break;
               case 132:
                  if (curChar == 107)
                     jjstateSet[jjnewStateCnt++] = 131;
                  break;
               case 133:
                  if (curChar == 103)
                     { jjAddStates(63, 64); }
                  break;
               case 137:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 133;
                  break;
               case 138:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 137;
                  break;
               case 139:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 138;
                  break;
               case 140:
                  if (curChar == 118)
                     jjstateSet[jjnewStateCnt++] = 139;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 1:
               case 0:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 96)
                     kind = 96;
                  { jjCheckNAdd(0); }
                  break;
               case 7:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 3)
                     kind = 3;
                  jjstateSet[jjnewStateCnt++] = 7;
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 141 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_4(int pos, long active0, long active1, long active2){
   switch (pos)
   {
      case 0:
         if ((active1 & 0x18000e00000000L) != 0L || (active2 & 0x381L) != 0L)
         {
            jjmatchedKind = 144;
            return 10;
         }
         if ((active0 & 0x10L) != 0L || (active1 & 0x4000000000000000L) != 0L)
            return 3;
         return -1;
      case 1:
         if ((active1 & 0x8000000000000L) != 0L || (active2 & 0x300L) != 0L)
            return 10;
         if ((active1 & 0x10000e00000000L) != 0L || (active2 & 0x81L) != 0L)
         {
            jjmatchedKind = 144;
            jjmatchedPos = 1;
            return 10;
         }
         return -1;
      case 2:
         if ((active1 & 0x10000000000000L) != 0L || (active2 & 0x81L) != 0L)
            return 10;
         if ((active1 & 0xe00000000L) != 0L)
         {
            jjmatchedKind = 144;
            jjmatchedPos = 2;
            return 10;
         }
         return -1;
      case 3:
         if ((active1 & 0x600000000L) != 0L)
            return 10;
         if ((active1 & 0x800000000L) != 0L)
         {
            jjmatchedKind = 144;
            jjmatchedPos = 3;
            return 10;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_4(int pos, long active0, long active1, long active2){
   return jjMoveNfa_4(jjStopStringLiteralDfa_4(pos, active0, active1, active2), pos + 1);
}
private int jjMoveStringLiteralDfa0_4(){
   switch(curChar)
   {
      case 33:
         jjmatchedKind = 143;
         return jjMoveStringLiteralDfa1_4(0x0L, 0x40000000000000L, 0x0L);
      case 34:
         return jjStopAtPos(0, 104);
      case 37:
         return jjStopAtPos(0, 127);
      case 38:
         return jjMoveStringLiteralDfa1_4(0x0L, 0x0L, 0x40000L);
      case 39:
         return jjStopAtPos(0, 23);
      case 40:
         return jjStopAtPos(0, 138);
      case 41:
         return jjStopAtPos(0, 139);
      case 42:
         return jjStopAtPos(0, 125);
      case 43:
         return jjStopAtPos(0, 123);
      case 44:
         return jjStopAtPos(0, 134);
      case 45:
         return jjStopAtPos(0, 124);
      case 46:
         return jjStopAtPos(0, 129);
      case 47:
         jjmatchedKind = 126;
         return jjMoveStringLiteralDfa1_4(0x10L, 0x0L, 0x0L);
      case 58:
         return jjStopAtPos(0, 113);
      case 60:
         jjmatchedKind = 119;
         return jjMoveStringLiteralDfa1_4(0x0L, 0x200000000000000L, 0x0L);
      case 61:
         jjmatchedKind = 141;
         return jjMoveStringLiteralDfa1_4(0x0L, 0x20000000000000L, 0x4000L);
      case 62:
         jjmatchedKind = 120;
         return jjMoveStringLiteralDfa1_4(0x0L, 0x400000000000000L, 0x0L);
      case 63:
         jjmatchedKind = 112;
         return jjMoveStringLiteralDfa1_4(0x0L, 0x4000000000000L, 0x24L);
      case 91:
         return jjStopAtPos(0, 131);
      case 93:
         return jjStopAtPos(0, 132);
      case 97:
         return jjMoveStringLiteralDfa1_4(0x0L, 0x10000000000000L, 0x0L);
      case 102:
         return jjMoveStringLiteralDfa1_4(0x0L, 0x800000000L, 0x80L);
      case 105:
         return jjMoveStringLiteralDfa1_4(0x0L, 0x0L, 0x300L);
      case 110:
         return jjMoveStringLiteralDfa1_4(0x0L, 0x200000000L, 0x1L);
      case 111:
         return jjMoveStringLiteralDfa1_4(0x0L, 0x8000000000000L, 0x0L);
      case 116:
         return jjMoveStringLiteralDfa1_4(0x0L, 0x400000000L, 0x0L);
      case 124:
         jjmatchedKind = 140;
         return jjMoveStringLiteralDfa1_4(0x0L, 0x0L, 0x80000L);
      default :
         return jjMoveNfa_4(5, 0);
   }
}
private int jjMoveStringLiteralDfa1_4(long active0, long active1, long active2){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_4(0, active0, active1, active2);
      return 1;
   }
   switch(curChar)
   {
      case 38:
         if ((active2 & 0x40000L) != 0L)
            return jjStopAtPos(1, 146);
         break;
      case 42:
         if ((active0 & 0x10L) != 0L)
            return jjStopAtPos(1, 4);
         break;
      case 46:
         if ((active2 & 0x4L) != 0L)
            return jjStopAtPos(1, 130);
         break;
      case 58:
         if ((active1 & 0x4000000000000L) != 0L)
            return jjStopAtPos(1, 114);
         break;
      case 61:
         if ((active1 & 0x20000000000000L) != 0L)
            return jjStopAtPos(1, 117);
         else if ((active1 & 0x40000000000000L) != 0L)
            return jjStopAtPos(1, 118);
         else if ((active1 & 0x200000000000000L) != 0L)
            return jjStopAtPos(1, 121);
         else if ((active1 & 0x400000000000000L) != 0L)
            return jjStopAtPos(1, 122);
         break;
      case 62:
         if ((active2 & 0x4000L) != 0L)
            return jjStopAtPos(1, 142);
         break;
      case 91:
         if ((active2 & 0x20L) != 0L)
            return jjStopAtPos(1, 133);
         break;
      case 97:
         return jjMoveStringLiteralDfa2_4(active0, 0L, active1, 0x800000000L, active2, 0L);
      case 102:
         if ((active2 & 0x200L) != 0L)
            return jjStartNfaWithStates_4(1, 137, 10);
         break;
      case 110:
         if ((active2 & 0x100L) != 0L)
            return jjStartNfaWithStates_4(1, 136, 10);
         return jjMoveStringLiteralDfa2_4(active0, 0L, active1, 0x10000000000000L, active2, 0L);
      case 111:
         return jjMoveStringLiteralDfa2_4(active0, 0L, active1, 0L, active2, 0x81L);
      case 114:
         if ((active1 & 0x8000000000000L) != 0L)
            return jjStartNfaWithStates_4(1, 115, 10);
         return jjMoveStringLiteralDfa2_4(active0, 0L, active1, 0x400000000L, active2, 0L);
      case 117:
         return jjMoveStringLiteralDfa2_4(active0, 0L, active1, 0x200000000L, active2, 0L);
      case 124:
         if ((active2 & 0x80000L) != 0L)
            return jjStopAtPos(1, 147);
         break;
      default :
         break;
   }
   return jjStartNfa_4(0, active0, active1, active2);
}
private int jjMoveStringLiteralDfa2_4(long old0, long active0, long old1, long active1, long old2, long active2){
   if (((active0 &= old0) | (active1 &= old1) | (active2 &= old2)) == 0L)
      return jjStartNfa_4(0, old0, old1, old2);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_4(1, 0L, active1, active2);
      return 2;
   }
   switch(curChar)
   {
      case 100:
         if ((active1 & 0x10000000000000L) != 0L)
            return jjStartNfaWithStates_4(2, 116, 10);
         break;
      case 108:
         return jjMoveStringLiteralDfa3_4(active1, 0xa00000000L, active2, 0L);
      case 114:
         if ((active2 & 0x80L) != 0L)
            return jjStartNfaWithStates_4(2, 135, 10);
         break;
      case 116:
         if ((active2 & 0x1L) != 0L)
            return jjStartNfaWithStates_4(2, 128, 10);
         break;
      case 117:
         return jjMoveStringLiteralDfa3_4(active1, 0x400000000L, active2, 0L);
      default :
         break;
   }
   return jjStartNfa_4(1, 0L, active1, active2);
}
private int jjMoveStringLiteralDfa3_4(long old1, long active1, long old2, long active2){
   if (((active1 &= old1) | (active2 &= old2)) == 0L)
      return jjStartNfa_4(1, 0L, old1, old2);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_4(2, 0L, active1, 0L);
      return 3;
   }
   switch(curChar)
   {
      case 101:
         if ((active1 & 0x400000000L) != 0L)
            return jjStartNfaWithStates_4(3, 98, 10);
         break;
      case 108:
         if ((active1 & 0x200000000L) != 0L)
            return jjStartNfaWithStates_4(3, 97, 10);
         break;
      case 115:
         return jjMoveStringLiteralDfa4_4(active1, 0x800000000L);
      default :
         break;
   }
   return jjStartNfa_4(2, 0L, active1, 0L);
}
private int jjMoveStringLiteralDfa4_4(long old1, long active1){
   if (((active1 &= old1)) == 0L)
      return jjStartNfa_4(2, 0L, old1, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_4(3, 0L, active1, 0L);
      return 4;
   }
   switch(curChar)
   {
      case 101:
         if ((active1 & 0x800000000L) != 0L)
            return jjStartNfaWithStates_4(4, 99, 10);
         break;
      default :
         break;
   }
   return jjStartNfa_4(3, 0L, active1, 0L);
}
private int jjStartNfaWithStates_4(int pos, int kind, int state)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) { return pos + 1; }
   return jjMoveNfa_4(state, pos + 1);
}
private int jjMoveNfa_4(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 26;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 5:
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 100)
                        kind = 100;
                     { jjCheckNAddStates(0, 4); }
                  }
                  else if ((0x100002600L & l) != 0L)
                  {
                     if (kind > 1)
                        kind = 1;
                     { jjCheckNAddTwoStates(0, 2); }
                  }
                  else if (curChar == 36)
                     jjstateSet[jjnewStateCnt++] = 12;
                  else if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 3;
                  if (curChar == 48)
                     jjstateSet[jjnewStateCnt++] = 6;
                  else if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 0:
                  if ((0x100002600L & l) == 0L)
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjCheckNAddTwoStates(0, 2); }
                  break;
               case 1:
                  if (curChar != 10)
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjCheckNAddTwoStates(0, 2); }
                  break;
               case 2:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 3:
                  if (curChar != 47)
                     break;
                  if (kind > 2)
                     kind = 2;
                  { jjCheckNAdd(4); }
                  break;
               case 4:
                  if ((0xffffffffffffdbffL & l) == 0L)
                     break;
                  if (kind > 2)
                     kind = 2;
                  { jjCheckNAdd(4); }
                  break;
               case 7:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 101)
                     kind = 101;
                  jjstateSet[jjnewStateCnt++] = 7;
                  break;
               case 8:
                  if (curChar == 48)
                     jjstateSet[jjnewStateCnt++] = 6;
                  break;
               case 10:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 144)
                     kind = 144;
                  jjstateSet[jjnewStateCnt++] = 10;
                  break;
               case 11:
                  if (curChar == 36)
                     jjstateSet[jjnewStateCnt++] = 12;
                  break;
               case 13:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 145)
                     kind = 145;
                  jjstateSet[jjnewStateCnt++] = 13;
                  break;
               case 14:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 100)
                     kind = 100;
                  { jjCheckNAddStates(0, 4); }
                  break;
               case 15:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 100)
                     kind = 100;
                  { jjCheckNAdd(15); }
                  break;
               case 16:
                  if ((0x3ff000000000000L & l) != 0L)
                     { jjCheckNAddTwoStates(16, 17); }
                  break;
               case 17:
                  if (curChar == 46)
                     { jjCheckNAdd(18); }
                  break;
               case 18:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 102)
                     kind = 102;
                  { jjCheckNAddTwoStates(18, 19); }
                  break;
               case 20:
                  if ((0x280000000000L & l) != 0L)
                     { jjCheckNAdd(21); }
                  break;
               case 21:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 102)
                     kind = 102;
                  { jjCheckNAdd(21); }
                  break;
               case 22:
                  if ((0x3ff000000000000L & l) != 0L)
                     { jjCheckNAddTwoStates(22, 23); }
                  break;
               case 24:
                  if ((0x280000000000L & l) != 0L)
                     { jjCheckNAdd(25); }
                  break;
               case 25:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 102)
                     kind = 102;
                  { jjCheckNAdd(25); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 5:
               case 10:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 144)
                     kind = 144;
                  { jjCheckNAdd(10); }
                  break;
               case 4:
                  if (kind > 2)
                     kind = 2;
                  jjstateSet[jjnewStateCnt++] = 4;
                  break;
               case 6:
                  if (curChar == 120)
                     { jjCheckNAdd(7); }
                  break;
               case 7:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 101)
                     kind = 101;
                  { jjCheckNAdd(7); }
                  break;
               case 12:
               case 13:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 145)
                     kind = 145;
                  { jjCheckNAdd(13); }
                  break;
               case 19:
                  if (curChar == 101)
                     { jjAddStates(5, 6); }
                  break;
               case 23:
                  if (curChar == 101)
                     { jjAddStates(7, 8); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 4:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 2)
                     kind = 2;
                  jjstateSet[jjnewStateCnt++] = 4;
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 26 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_11(int pos, long active0, long active1){
   switch (pos)
   {
      case 0:
         if ((active1 & 0x700000000000L) != 0L)
         {
            jjmatchedKind = 107;
            return -1;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_11(int pos, long active0, long active1){
   return jjMoveNfa_11(jjStopStringLiteralDfa_11(pos, active0, active1), pos + 1);
}
private int jjMoveStringLiteralDfa0_11(){
   switch(curChar)
   {
      case 39:
         return jjStopAtPos(0, 105);
      case 92:
         return jjMoveStringLiteralDfa1_11(0x700000000000L);
      default :
         return jjMoveNfa_11(0, 0);
   }
}
private int jjMoveStringLiteralDfa1_11(long active1){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_11(0, 0L, active1);
      return 1;
   }
   switch(curChar)
   {
      case 34:
         if ((active1 & 0x400000000000L) != 0L)
            return jjStopAtPos(1, 110);
         break;
      case 39:
         if ((active1 & 0x200000000000L) != 0L)
            return jjStopAtPos(1, 109);
         break;
      case 92:
         if ((active1 & 0x100000000000L) != 0L)
            return jjStopAtPos(1, 108);
         break;
      default :
         break;
   }
   return jjStartNfa_11(0, 0L, active1);
}
private int jjMoveNfa_11(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 2;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0xffffffffffffdbffL & l) != 0L)
                  {
                     if (kind > 107)
                        kind = 107;
                  }
                  else if ((0x2400L & l) != 0L)
                  {
                     if (kind > 111)
                        kind = 111;
                  }
                  break;
               case 1:
                  if ((0x2400L & l) != 0L)
                     kind = 111;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  kind = 107;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 107)
                     kind = 107;
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 2 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_1(int pos, long active0, long active1){
   switch (pos)
   {
      case 0:
         if ((active0 & 0x10L) != 0L || (active1 & 0x800000L) != 0L)
            return 3;
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_1(int pos, long active0, long active1){
   return jjMoveNfa_1(jjStopStringLiteralDfa_1(pos, active0, active1), pos + 1);
}
private int jjMoveStringLiteralDfa0_1(){
   switch(curChar)
   {
      case 34:
         return jjStopAtPos(0, 20);
      case 39:
         return jjStopAtPos(0, 21);
      case 46:
         return jjStopAtPos(0, 92);
      case 47:
         return jjMoveStringLiteralDfa1_1(0x10L, 0x800000L);
      case 58:
         jjmatchedKind = 89;
         return jjMoveStringLiteralDfa1_1(0x0L, 0x4000000L);
      case 61:
         return jjStopAtPos(0, 91);
      case 125:
         return jjStopAtPos(0, 86);
      default :
         return jjMoveNfa_1(5, 0);
   }
}
private int jjMoveStringLiteralDfa1_1(long active0, long active1){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_1(0, active0, active1);
      return 1;
   }
   switch(curChar)
   {
      case 42:
         if ((active0 & 0x10L) != 0L)
            return jjStopAtPos(1, 4);
         break;
      case 61:
         if ((active1 & 0x4000000L) != 0L)
            return jjStopAtPos(1, 90);
         break;
      case 125:
         if ((active1 & 0x800000L) != 0L)
            return jjStopAtPos(1, 87);
         break;
      default :
         break;
   }
   return jjStartNfa_1(0, active0, active1);
}
private int jjMoveNfa_1(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 8;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 5:
                  if ((0x100002600L & l) != 0L)
                  {
                     if (kind > 1)
                        kind = 1;
                     { jjCheckNAddTwoStates(0, 2); }
                  }
                  else if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 3;
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 0:
                  if ((0x100002600L & l) == 0L)
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjCheckNAddTwoStates(0, 2); }
                  break;
               case 1:
                  if (curChar != 10)
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjCheckNAddTwoStates(0, 2); }
                  break;
               case 2:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 3:
                  if (curChar != 47)
                     break;
                  if (kind > 2)
                     kind = 2;
                  { jjCheckNAdd(4); }
                  break;
               case 4:
                  if ((0xffffffffffffdbffL & l) == 0L)
                     break;
                  if (kind > 2)
                     kind = 2;
                  { jjCheckNAdd(4); }
                  break;
               case 7:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 88)
                     kind = 88;
                  jjstateSet[jjnewStateCnt++] = 7;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 5:
               case 7:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 88)
                     kind = 88;
                  { jjCheckNAdd(7); }
                  break;
               case 4:
                  if (kind > 2)
                     kind = 2;
                  jjstateSet[jjnewStateCnt++] = 4;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 4:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 2)
                     kind = 2;
                  jjstateSet[jjnewStateCnt++] = 4;
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 8 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_0(int pos, long active0, long active1){
   switch (pos)
   {
      case 0:
         if ((active0 & 0x90L) != 0L)
            return 3;
         if ((active0 & 0x42000L) != 0L)
         {
            jjmatchedKind = 144;
            return 7;
         }
         if ((active0 & 0x10000L) != 0L)
            return 19;
         return -1;
      case 1:
         if ((active0 & 0x42000L) != 0L)
         {
            if (jjmatchedPos != 1)
            {
               jjmatchedKind = 144;
               jjmatchedPos = 1;
            }
            return 7;
         }
         return -1;
      case 2:
         if ((active0 & 0x42000L) != 0L)
         {
            jjmatchedKind = 144;
            jjmatchedPos = 2;
            return 7;
         }
         return -1;
      case 3:
         if ((active0 & 0x2000L) != 0L)
         {
            jjmatchedKind = 144;
            jjmatchedPos = 3;
            return 7;
         }
         if ((active0 & 0x40000L) != 0L)
            return 7;
         return -1;
      case 4:
         if ((active0 & 0x2000L) != 0L)
         {
            jjmatchedKind = 144;
            jjmatchedPos = 4;
            return 7;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_0(int pos, long active0, long active1){
   return jjMoveNfa_0(jjStopStringLiteralDfa_0(pos, active0, active1), pos + 1);
}
private int jjMoveStringLiteralDfa0_0(){
   switch(curChar)
   {
      case 39:
         return jjStopAtPos(0, 103);
      case 42:
         return jjStopAtPos(0, 19);
      case 44:
         return jjStopAtPos(0, 15);
      case 47:
         return jjMoveStringLiteralDfa1_0(0x90L);
      case 59:
         return jjStopAtPos(0, 14);
      case 102:
         return jjMoveStringLiteralDfa1_0(0x40000L);
      case 105:
         return jjMoveStringLiteralDfa1_0(0x2000L);
      case 123:
         return jjStartNfaWithStates_0(0, 16, 19);
      case 125:
         return jjStopAtPos(0, 17);
      default :
         return jjMoveNfa_0(5, 0);
   }
}
private int jjMoveStringLiteralDfa1_0(long active0){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(0, active0, 0L);
      return 1;
   }
   switch(curChar)
   {
      case 42:
         if ((active0 & 0x10L) != 0L)
         {
            jjmatchedKind = 4;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_0(active0, 0x80L);
      case 109:
         return jjMoveStringLiteralDfa2_0(active0, 0x2000L);
      case 114:
         return jjMoveStringLiteralDfa2_0(active0, 0x40000L);
      default :
         break;
   }
   return jjStartNfa_0(0, active0, 0L);
}
private int jjMoveStringLiteralDfa2_0(long old0, long active0){
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(0, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(1, active0, 0L);
      return 2;
   }
   switch(curChar)
   {
      case 42:
         if ((active0 & 0x80L) != 0L)
            return jjStopAtPos(2, 7);
         break;
      case 111:
         return jjMoveStringLiteralDfa3_0(active0, 0x40000L);
      case 112:
         return jjMoveStringLiteralDfa3_0(active0, 0x2000L);
      default :
         break;
   }
   return jjStartNfa_0(1, active0, 0L);
}
private int jjMoveStringLiteralDfa3_0(long old0, long active0){
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(1, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(2, active0, 0L);
      return 3;
   }
   switch(curChar)
   {
      case 109:
         if ((active0 & 0x40000L) != 0L)
            return jjStartNfaWithStates_0(3, 18, 7);
         break;
      case 111:
         return jjMoveStringLiteralDfa4_0(active0, 0x2000L);
      default :
         break;
   }
   return jjStartNfa_0(2, active0, 0L);
}
private int jjMoveStringLiteralDfa4_0(long old0, long active0){
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(2, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(3, active0, 0L);
      return 4;
   }
   switch(curChar)
   {
      case 114:
         return jjMoveStringLiteralDfa5_0(active0, 0x2000L);
      default :
         break;
   }
   return jjStartNfa_0(3, active0, 0L);
}
private int jjMoveStringLiteralDfa5_0(long old0, long active0){
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(3, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(4, active0, 0L);
      return 5;
   }
   switch(curChar)
   {
      case 116:
         if ((active0 & 0x2000L) != 0L)
            return jjStartNfaWithStates_0(5, 13, 7);
         break;
      default :
         break;
   }
   return jjStartNfa_0(4, active0, 0L);
}
private int jjStartNfaWithStates_0(int pos, int kind, int state)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) { return pos + 1; }
   return jjMoveNfa_0(state, pos + 1);
}
private int jjMoveNfa_0(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 80;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 5:
                  if ((0x100002600L & l) != 0L)
                  {
                     if (kind > 1)
                        kind = 1;
                     { jjCheckNAddTwoStates(0, 2); }
                  }
                  else if (curChar == 36)
                     jjstateSet[jjnewStateCnt++] = 9;
                  else if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 3;
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 0:
                  if ((0x100002600L & l) == 0L)
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjCheckNAddTwoStates(0, 2); }
                  break;
               case 1:
                  if (curChar != 10)
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjCheckNAddTwoStates(0, 2); }
                  break;
               case 2:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 3:
                  if (curChar != 47)
                     break;
                  if (kind > 2)
                     kind = 2;
                  { jjCheckNAdd(4); }
                  break;
               case 4:
                  if ((0xffffffffffffdbffL & l) == 0L)
                     break;
                  if (kind > 2)
                     kind = 2;
                  { jjCheckNAdd(4); }
                  break;
               case 7:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 144)
                     kind = 144;
                  jjstateSet[jjnewStateCnt++] = 7;
                  break;
               case 8:
                  if (curChar == 36)
                     jjstateSet[jjnewStateCnt++] = 9;
                  break;
               case 10:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 145)
                     kind = 145;
                  jjstateSet[jjnewStateCnt++] = 10;
                  break;
               case 13:
                  if ((0x100002600L & l) != 0L && kind > 10)
                     kind = 10;
                  break;
               case 14:
                  if (curChar == 10 && kind > 10)
                     kind = 10;
                  break;
               case 15:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 14;
                  break;
               case 21:
                  if ((0x100002600L & l) != 0L && kind > 11)
                     kind = 11;
                  break;
               case 22:
                  if (curChar == 10 && kind > 11)
                     kind = 11;
                  break;
               case 23:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 22;
                  break;
               case 33:
                  if ((0x100002600L & l) != 0L && kind > 12)
                     kind = 12;
                  break;
               case 34:
                  if (curChar == 10 && kind > 12)
                     kind = 12;
                  break;
               case 35:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 34;
                  break;
               case 46:
                  if ((0x100002600L & l) != 0L && kind > 30)
                     kind = 30;
                  break;
               case 47:
                  if (curChar == 10 && kind > 30)
                     kind = 30;
                  break;
               case 48:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 47;
                  break;
               case 60:
                  if ((0x100002600L & l) != 0L && kind > 31)
                     kind = 31;
                  break;
               case 61:
                  if (curChar == 10 && kind > 31)
                     kind = 31;
                  break;
               case 62:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 61;
                  break;
               case 71:
                  if ((0x100002600L & l) != 0L && kind > 32)
                     kind = 32;
                  break;
               case 72:
                  if (curChar == 10 && kind > 32)
                     kind = 32;
                  break;
               case 73:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 72;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 19:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 78;
                  else if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 68;
                  else if (curChar == 100)
                     jjstateSet[jjnewStateCnt++] = 57;
                  else if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 30;
                  else if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 18;
                  if (curChar == 100)
                     jjstateSet[jjnewStateCnt++] = 43;
                  break;
               case 5:
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 144)
                        kind = 144;
                     { jjCheckNAdd(7); }
                  }
                  else if (curChar == 123)
                     { jjAddStates(65, 70); }
                  break;
               case 4:
                  if (kind > 2)
                     kind = 2;
                  jjstateSet[jjnewStateCnt++] = 4;
                  break;
               case 6:
               case 7:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 144)
                     kind = 144;
                  { jjCheckNAdd(7); }
                  break;
               case 9:
               case 10:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 145)
                     kind = 145;
                  { jjCheckNAdd(10); }
                  break;
               case 11:
                  if (curChar == 123)
                     { jjAddStates(65, 70); }
                  break;
               case 12:
                  if (curChar == 115)
                     { jjAddStates(71, 72); }
                  break;
               case 16:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 12;
                  break;
               case 17:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 16;
                  break;
               case 18:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 17;
                  break;
               case 20:
                  if (curChar == 101)
                     { jjAddStates(73, 74); }
                  break;
               case 24:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 20;
                  break;
               case 25:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 24;
                  break;
               case 26:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 25;
                  break;
               case 27:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 26;
                  break;
               case 28:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 27;
                  break;
               case 29:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 28;
                  break;
               case 30:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 29;
                  break;
               case 31:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 30;
                  break;
               case 32:
                  if (curChar == 101)
                     { jjAddStates(75, 76); }
                  break;
               case 36:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 32;
                  break;
               case 37:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 36;
                  break;
               case 38:
                  if (curChar == 107)
                     jjstateSet[jjnewStateCnt++] = 37;
                  break;
               case 39:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 38;
                  break;
               case 40:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 39;
                  break;
               case 41:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 40;
                  break;
               case 42:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 41;
                  break;
               case 43:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 42;
                  break;
               case 44:
                  if (curChar == 100)
                     jjstateSet[jjnewStateCnt++] = 43;
                  break;
               case 45:
                  if (curChar == 101)
                     { jjAddStates(41, 42); }
                  break;
               case 49:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 45;
                  break;
               case 50:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 49;
                  break;
               case 51:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 50;
                  break;
               case 52:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 51;
                  break;
               case 53:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 52;
                  break;
               case 54:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 53;
                  break;
               case 55:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 54;
                  break;
               case 56:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 55;
                  break;
               case 57:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 56;
                  break;
               case 58:
                  if (curChar == 100)
                     jjstateSet[jjnewStateCnt++] = 57;
                  break;
               case 59:
                  if (curChar == 101)
                     { jjAddStates(43, 44); }
                  break;
               case 63:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 59;
                  break;
               case 64:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 63;
                  break;
               case 65:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 64;
                  break;
               case 66:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 65;
                  break;
               case 67:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 66;
                  break;
               case 68:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 67;
                  break;
               case 69:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 68;
                  break;
               case 70:
                  if (curChar == 116)
                     { jjAddStates(77, 78); }
                  break;
               case 74:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 70;
                  break;
               case 75:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 74;
                  break;
               case 76:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 75;
                  break;
               case 77:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 76;
                  break;
               case 78:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 77;
                  break;
               case 79:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 78;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 4:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 2)
                     kind = 2;
                  jjstateSet[jjnewStateCnt++] = 4;
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 80 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private int jjMoveStringLiteralDfa0_6(){
   switch(curChar)
   {
      case 42:
         return jjMoveStringLiteralDfa1_6(0x40L);
      default :
         return 1;
   }
}
private int jjMoveStringLiteralDfa1_6(long active0){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      return 1;
   }
   switch(curChar)
   {
      case 47:
         if ((active0 & 0x40L) != 0L)
            return jjStopAtPos(1, 6);
         break;
      default :
         return 2;
   }
   return 2;
}
private final int jjStopStringLiteralDfa_2(int pos, long active0, long active1, long active2){
   switch (pos)
   {
      case 0:
         if ((active1 & 0x18000e00000000L) != 0L || (active2 & 0x381L) != 0L)
         {
            jjmatchedKind = 144;
            return 10;
         }
         if ((active0 & 0x10L) != 0L || (active1 & 0x4000000000800000L) != 0L)
            return 3;
         return -1;
      case 1:
         if ((active1 & 0x8000000000000L) != 0L || (active2 & 0x300L) != 0L)
            return 10;
         if ((active1 & 0x10000e00000000L) != 0L || (active2 & 0x81L) != 0L)
         {
            jjmatchedKind = 144;
            jjmatchedPos = 1;
            return 10;
         }
         return -1;
      case 2:
         if ((active1 & 0x10000000000000L) != 0L || (active2 & 0x81L) != 0L)
            return 10;
         if ((active1 & 0xe00000000L) != 0L)
         {
            jjmatchedKind = 144;
            jjmatchedPos = 2;
            return 10;
         }
         return -1;
      case 3:
         if ((active1 & 0x600000000L) != 0L)
            return 10;
         if ((active1 & 0x800000000L) != 0L)
         {
            jjmatchedKind = 144;
            jjmatchedPos = 3;
            return 10;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_2(int pos, long active0, long active1, long active2){
   return jjMoveNfa_2(jjStopStringLiteralDfa_2(pos, active0, active1, active2), pos + 1);
}
private int jjMoveStringLiteralDfa0_2(){
   switch(curChar)
   {
      case 33:
         jjmatchedKind = 143;
         return jjMoveStringLiteralDfa1_2(0x0L, 0x40000000000000L, 0x0L);
      case 34:
         return jjStopAtPos(0, 104);
      case 37:
         return jjStopAtPos(0, 127);
      case 38:
         return jjMoveStringLiteralDfa1_2(0x0L, 0x0L, 0x40000L);
      case 39:
         return jjStopAtPos(0, 103);
      case 40:
         return jjStopAtPos(0, 138);
      case 41:
         return jjStopAtPos(0, 139);
      case 42:
         return jjStopAtPos(0, 125);
      case 43:
         return jjStopAtPos(0, 123);
      case 44:
         return jjStopAtPos(0, 134);
      case 45:
         return jjStopAtPos(0, 124);
      case 46:
         return jjStopAtPos(0, 129);
      case 47:
         jjmatchedKind = 126;
         return jjMoveStringLiteralDfa1_2(0x10L, 0x800000L, 0x0L);
      case 58:
         return jjStopAtPos(0, 113);
      case 60:
         jjmatchedKind = 119;
         return jjMoveStringLiteralDfa1_2(0x0L, 0x200000000000000L, 0x0L);
      case 61:
         jjmatchedKind = 141;
         return jjMoveStringLiteralDfa1_2(0x0L, 0x20000000000000L, 0x4000L);
      case 62:
         jjmatchedKind = 120;
         return jjMoveStringLiteralDfa1_2(0x0L, 0x400000000000000L, 0x0L);
      case 63:
         jjmatchedKind = 112;
         return jjMoveStringLiteralDfa1_2(0x0L, 0x4000000000000L, 0x24L);
      case 91:
         return jjStopAtPos(0, 131);
      case 93:
         return jjStopAtPos(0, 132);
      case 97:
         return jjMoveStringLiteralDfa1_2(0x0L, 0x10000000000000L, 0x0L);
      case 102:
         return jjMoveStringLiteralDfa1_2(0x0L, 0x800000000L, 0x80L);
      case 105:
         return jjMoveStringLiteralDfa1_2(0x0L, 0x0L, 0x300L);
      case 110:
         return jjMoveStringLiteralDfa1_2(0x0L, 0x200000000L, 0x1L);
      case 111:
         return jjMoveStringLiteralDfa1_2(0x0L, 0x8000000000000L, 0x0L);
      case 116:
         return jjMoveStringLiteralDfa1_2(0x0L, 0x400000000L, 0x0L);
      case 124:
         jjmatchedKind = 140;
         return jjMoveStringLiteralDfa1_2(0x0L, 0x0L, 0x80000L);
      case 125:
         return jjStopAtPos(0, 86);
      default :
         return jjMoveNfa_2(5, 0);
   }
}
private int jjMoveStringLiteralDfa1_2(long active0, long active1, long active2){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_2(0, active0, active1, active2);
      return 1;
   }
   switch(curChar)
   {
      case 38:
         if ((active2 & 0x40000L) != 0L)
            return jjStopAtPos(1, 146);
         break;
      case 42:
         if ((active0 & 0x10L) != 0L)
            return jjStopAtPos(1, 4);
         break;
      case 46:
         if ((active2 & 0x4L) != 0L)
            return jjStopAtPos(1, 130);
         break;
      case 58:
         if ((active1 & 0x4000000000000L) != 0L)
            return jjStopAtPos(1, 114);
         break;
      case 61:
         if ((active1 & 0x20000000000000L) != 0L)
            return jjStopAtPos(1, 117);
         else if ((active1 & 0x40000000000000L) != 0L)
            return jjStopAtPos(1, 118);
         else if ((active1 & 0x200000000000000L) != 0L)
            return jjStopAtPos(1, 121);
         else if ((active1 & 0x400000000000000L) != 0L)
            return jjStopAtPos(1, 122);
         break;
      case 62:
         if ((active2 & 0x4000L) != 0L)
            return jjStopAtPos(1, 142);
         break;
      case 91:
         if ((active2 & 0x20L) != 0L)
            return jjStopAtPos(1, 133);
         break;
      case 97:
         return jjMoveStringLiteralDfa2_2(active0, 0L, active1, 0x800000000L, active2, 0L);
      case 102:
         if ((active2 & 0x200L) != 0L)
            return jjStartNfaWithStates_2(1, 137, 10);
         break;
      case 110:
         if ((active2 & 0x100L) != 0L)
            return jjStartNfaWithStates_2(1, 136, 10);
         return jjMoveStringLiteralDfa2_2(active0, 0L, active1, 0x10000000000000L, active2, 0L);
      case 111:
         return jjMoveStringLiteralDfa2_2(active0, 0L, active1, 0L, active2, 0x81L);
      case 114:
         if ((active1 & 0x8000000000000L) != 0L)
            return jjStartNfaWithStates_2(1, 115, 10);
         return jjMoveStringLiteralDfa2_2(active0, 0L, active1, 0x400000000L, active2, 0L);
      case 117:
         return jjMoveStringLiteralDfa2_2(active0, 0L, active1, 0x200000000L, active2, 0L);
      case 124:
         if ((active2 & 0x80000L) != 0L)
            return jjStopAtPos(1, 147);
         break;
      case 125:
         if ((active1 & 0x800000L) != 0L)
            return jjStopAtPos(1, 87);
         break;
      default :
         break;
   }
   return jjStartNfa_2(0, active0, active1, active2);
}
private int jjMoveStringLiteralDfa2_2(long old0, long active0, long old1, long active1, long old2, long active2){
   if (((active0 &= old0) | (active1 &= old1) | (active2 &= old2)) == 0L)
      return jjStartNfa_2(0, old0, old1, old2);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_2(1, 0L, active1, active2);
      return 2;
   }
   switch(curChar)
   {
      case 100:
         if ((active1 & 0x10000000000000L) != 0L)
            return jjStartNfaWithStates_2(2, 116, 10);
         break;
      case 108:
         return jjMoveStringLiteralDfa3_2(active1, 0xa00000000L, active2, 0L);
      case 114:
         if ((active2 & 0x80L) != 0L)
            return jjStartNfaWithStates_2(2, 135, 10);
         break;
      case 116:
         if ((active2 & 0x1L) != 0L)
            return jjStartNfaWithStates_2(2, 128, 10);
         break;
      case 117:
         return jjMoveStringLiteralDfa3_2(active1, 0x400000000L, active2, 0L);
      default :
         break;
   }
   return jjStartNfa_2(1, 0L, active1, active2);
}
private int jjMoveStringLiteralDfa3_2(long old1, long active1, long old2, long active2){
   if (((active1 &= old1) | (active2 &= old2)) == 0L)
      return jjStartNfa_2(1, 0L, old1, old2);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_2(2, 0L, active1, 0L);
      return 3;
   }
   switch(curChar)
   {
      case 101:
         if ((active1 & 0x400000000L) != 0L)
            return jjStartNfaWithStates_2(3, 98, 10);
         break;
      case 108:
         if ((active1 & 0x200000000L) != 0L)
            return jjStartNfaWithStates_2(3, 97, 10);
         break;
      case 115:
         return jjMoveStringLiteralDfa4_2(active1, 0x800000000L);
      default :
         break;
   }
   return jjStartNfa_2(2, 0L, active1, 0L);
}
private int jjMoveStringLiteralDfa4_2(long old1, long active1){
   if (((active1 &= old1)) == 0L)
      return jjStartNfa_2(2, 0L, old1, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_2(3, 0L, active1, 0L);
      return 4;
   }
   switch(curChar)
   {
      case 101:
         if ((active1 & 0x800000000L) != 0L)
            return jjStartNfaWithStates_2(4, 99, 10);
         break;
      default :
         break;
   }
   return jjStartNfa_2(3, 0L, active1, 0L);
}
private int jjStartNfaWithStates_2(int pos, int kind, int state)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) { return pos + 1; }
   return jjMoveNfa_2(state, pos + 1);
}
private int jjMoveNfa_2(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 26;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 5:
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 100)
                        kind = 100;
                     { jjCheckNAddStates(0, 4); }
                  }
                  else if ((0x100002600L & l) != 0L)
                  {
                     if (kind > 1)
                        kind = 1;
                     { jjCheckNAddTwoStates(0, 2); }
                  }
                  else if (curChar == 36)
                     jjstateSet[jjnewStateCnt++] = 12;
                  else if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 3;
                  if (curChar == 48)
                     jjstateSet[jjnewStateCnt++] = 6;
                  else if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 0:
                  if ((0x100002600L & l) == 0L)
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjCheckNAddTwoStates(0, 2); }
                  break;
               case 1:
                  if (curChar != 10)
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjCheckNAddTwoStates(0, 2); }
                  break;
               case 2:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 3:
                  if (curChar != 47)
                     break;
                  if (kind > 2)
                     kind = 2;
                  { jjCheckNAdd(4); }
                  break;
               case 4:
                  if ((0xffffffffffffdbffL & l) == 0L)
                     break;
                  if (kind > 2)
                     kind = 2;
                  { jjCheckNAdd(4); }
                  break;
               case 7:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 101)
                     kind = 101;
                  jjstateSet[jjnewStateCnt++] = 7;
                  break;
               case 8:
                  if (curChar == 48)
                     jjstateSet[jjnewStateCnt++] = 6;
                  break;
               case 10:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 144)
                     kind = 144;
                  jjstateSet[jjnewStateCnt++] = 10;
                  break;
               case 11:
                  if (curChar == 36)
                     jjstateSet[jjnewStateCnt++] = 12;
                  break;
               case 13:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 145)
                     kind = 145;
                  jjstateSet[jjnewStateCnt++] = 13;
                  break;
               case 14:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 100)
                     kind = 100;
                  { jjCheckNAddStates(0, 4); }
                  break;
               case 15:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 100)
                     kind = 100;
                  { jjCheckNAdd(15); }
                  break;
               case 16:
                  if ((0x3ff000000000000L & l) != 0L)
                     { jjCheckNAddTwoStates(16, 17); }
                  break;
               case 17:
                  if (curChar == 46)
                     { jjCheckNAdd(18); }
                  break;
               case 18:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 102)
                     kind = 102;
                  { jjCheckNAddTwoStates(18, 19); }
                  break;
               case 20:
                  if ((0x280000000000L & l) != 0L)
                     { jjCheckNAdd(21); }
                  break;
               case 21:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 102)
                     kind = 102;
                  { jjCheckNAdd(21); }
                  break;
               case 22:
                  if ((0x3ff000000000000L & l) != 0L)
                     { jjCheckNAddTwoStates(22, 23); }
                  break;
               case 24:
                  if ((0x280000000000L & l) != 0L)
                     { jjCheckNAdd(25); }
                  break;
               case 25:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 102)
                     kind = 102;
                  { jjCheckNAdd(25); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 5:
               case 10:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 144)
                     kind = 144;
                  { jjCheckNAdd(10); }
                  break;
               case 4:
                  if (kind > 2)
                     kind = 2;
                  jjstateSet[jjnewStateCnt++] = 4;
                  break;
               case 6:
                  if (curChar == 120)
                     { jjCheckNAdd(7); }
                  break;
               case 7:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 101)
                     kind = 101;
                  { jjCheckNAdd(7); }
                  break;
               case 12:
               case 13:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 145)
                     kind = 145;
                  { jjCheckNAdd(13); }
                  break;
               case 19:
                  if (curChar == 101)
                     { jjAddStates(5, 6); }
                  break;
               case 23:
                  if (curChar == 101)
                     { jjAddStates(7, 8); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 4:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 2)
                     kind = 2;
                  jjstateSet[jjnewStateCnt++] = 4;
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 26 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private int jjMoveStringLiteralDfa0_8(){
   switch(curChar)
   {
      case 34:
         return jjStopAtPos(0, 24);
      case 92:
         return jjMoveStringLiteralDfa1_8(0x8000000L);
      default :
         return 1;
   }
}
private int jjMoveStringLiteralDfa1_8(long active0){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      return 1;
   }
   switch(curChar)
   {
      case 34:
         if ((active0 & 0x8000000L) != 0L)
            return jjStopAtPos(1, 27);
         break;
      default :
         return 2;
   }
   return 2;
}
private int jjMoveStringLiteralDfa0_7(){
   switch(curChar)
   {
      case 42:
         return jjMoveStringLiteralDfa1_7(0x200L);
      default :
         return 1;
   }
}
private int jjMoveStringLiteralDfa1_7(long active0){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      return 1;
   }
   switch(curChar)
   {
      case 47:
         if ((active0 & 0x200L) != 0L)
            return jjStopAtPos(1, 9);
         break;
      default :
         return 2;
   }
   return 2;
}
static final int[] jjnextStates = {
   15, 16, 17, 22, 23, 20, 21, 24, 25, 3, 5, 8, 9, 11, 3, 5, 
   8, 20, 30, 38, 44, 58, 63, 72, 78, 84, 93, 102, 111, 118, 126, 132, 
   140, 15, 17, 22, 24, 32, 34, 40, 42, 46, 48, 60, 62, 65, 67, 74, 
   76, 80, 82, 86, 88, 95, 97, 104, 106, 113, 115, 120, 122, 128, 130, 134, 
   136, 19, 31, 44, 58, 69, 79, 13, 15, 21, 23, 33, 35, 71, 73, 
};
private static final boolean jjCanMove_0(int hiByte, int i1, int i2, long l1, long l2)
{
   switch(hiByte)
   {
      case 0:
         return ((jjbitVec2[i2] & l2) != 0L);
      default :
         if ((jjbitVec0[i1] & l1) != 0L)
            return true;
         return false;
   }
}

/** Token literal values. */
public static final String[] jjstrLiteralImages = {
null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, };
protected Token jjFillToken()
{
   final Token t;
   final String curTokenImage;
   final int beginLine;
   final int endLine;
   final int beginColumn;
   final int endColumn;
   String im = jjstrLiteralImages[jjmatchedKind];
   curTokenImage = (im == null) ? input_stream.GetImage() : im;
   beginLine = input_stream.getBeginLine();
   beginColumn = input_stream.getBeginColumn();
   endLine = input_stream.getEndLine();
   endColumn = input_stream.getEndColumn();
   t = Token.newToken(jjmatchedKind, curTokenImage);

   t.beginLine = beginLine;
   t.endLine = endLine;
   t.beginColumn = beginColumn;
   t.endColumn = endColumn;

   return t;
}

int curLexState = 0;
int defaultLexState = 0;
int jjnewStateCnt;
int jjround;
int jjmatchedPos;
int jjmatchedKind;

/** Get the next Token. */
public Token getNextToken() 
{
  Token specialToken = null;
  Token matchedToken;
  int curPos = 0;

  EOFLoop :
  for (;;)
  {
   try
   {
      curChar = input_stream.BeginToken();
   }
   catch(Exception e)
   {
      jjmatchedKind = 0;
      jjmatchedPos = -1;
      matchedToken = jjFillToken();
      matchedToken.specialToken = specialToken;
      return matchedToken;
   }
   image = jjimage;
   image.setLength(0);
   jjimageLen = 0;

   for (;;)
   {
     switch(curLexState)
     {
       case 0:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_0();
         if (jjmatchedPos == 0 && jjmatchedKind > 155)
         {
            jjmatchedKind = 155;
         }
         break;
       case 1:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_1();
         if (jjmatchedPos == 0 && jjmatchedKind > 155)
         {
            jjmatchedKind = 155;
         }
         break;
       case 2:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_2();
         if (jjmatchedPos == 0 && jjmatchedKind > 155)
         {
            jjmatchedKind = 155;
         }
         break;
       case 3:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_3();
         if (jjmatchedPos == 0 && jjmatchedKind > 155)
         {
            jjmatchedKind = 155;
         }
         break;
       case 4:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_4();
         if (jjmatchedPos == 0 && jjmatchedKind > 155)
         {
            jjmatchedKind = 155;
         }
         break;
       case 5:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_5();
         break;
       case 6:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_6();
         if (jjmatchedPos == 0 && jjmatchedKind > 5)
         {
            jjmatchedKind = 5;
         }
         break;
       case 7:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_7();
         if (jjmatchedPos == 0 && jjmatchedKind > 8)
         {
            jjmatchedKind = 8;
         }
         break;
       case 8:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_8();
         if (jjmatchedPos == 0 && jjmatchedKind > 26)
         {
            jjmatchedKind = 26;
         }
         break;
       case 9:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_9();
         if (jjmatchedPos == 0 && jjmatchedKind > 28)
         {
            jjmatchedKind = 28;
         }
         break;
       case 10:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_10();
         if (jjmatchedPos == 0 && jjmatchedKind > 93)
         {
            jjmatchedKind = 93;
         }
         break;
       case 11:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_11();
         break;
       case 12:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_12();
         break;
     }
     if (jjmatchedKind != 0x7fffffff)
     {
        if (jjmatchedPos + 1 < curPos)
           input_stream.backup(curPos - jjmatchedPos - 1);
        if ((jjtoToken[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L)
        {
           matchedToken = jjFillToken();
           matchedToken.specialToken = specialToken;
           TokenLexicalActions(matchedToken);
       if (jjnewLexState[jjmatchedKind] != -1)
         curLexState = jjnewLexState[jjmatchedKind];
           return matchedToken;
        }
        else if ((jjtoSkip[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L)
        {
           if ((jjtoSpecial[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L)
           {
              matchedToken = jjFillToken();
              if (specialToken == null)
                 specialToken = matchedToken;
              else
              {
                 matchedToken.specialToken = specialToken;
                 specialToken = (specialToken.next = matchedToken);
              }
              SkipLexicalActions(matchedToken);
           }
           else
              SkipLexicalActions(null);
         if (jjnewLexState[jjmatchedKind] != -1)
           curLexState = jjnewLexState[jjmatchedKind];
           continue EOFLoop;
        }
        MoreLexicalActions();
      if (jjnewLexState[jjmatchedKind] != -1)
        curLexState = jjnewLexState[jjmatchedKind];
        curPos = 0;
        jjmatchedKind = 0x7fffffff;
        try {
           curChar = input_stream.readChar();
           continue;
        }
        catch (java.io.IOException e1) { }
     }
     int error_line = input_stream.getEndLine();
     int error_column = input_stream.getEndColumn();
     String error_after = null;
     boolean EOFSeen = false;
     try { input_stream.readChar(); input_stream.backup(1); }
     catch (java.io.IOException e1) {
        EOFSeen = true;
        error_after = curPos <= 1 ? "" : input_stream.GetImage();
        if (curChar == '\n' || curChar == '\r') {
           error_line++;
           error_column = 0;
        }
        else
           error_column++;
     }
     if (!EOFSeen) {
        input_stream.backup(1);
        error_after = curPos <= 1 ? "" : input_stream.GetImage();
     }
     throw new TokenMgrError(EOFSeen, curLexState, error_line, error_column, error_after, curChar, TokenMgrError.LEXICAL_ERROR);
   }
  }
}

void SkipLexicalActions(Token matchedToken)
{
   switch(jjmatchedKind)
   {
      case 1 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
     maybeAddBlankLines(
         Point.create(input_stream.getBeginLine(),input_stream.getBeginColumn()),
         Point.create(input_stream.getEndLine(),input_stream.getEndColumn()),
         image.toString());
         break;
      case 2 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                       addLineComment(matchedToken);
         break;
      case 3 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
    int startOfLineComment = matchedToken.image.indexOf('/');

    // If the leading whitespace contained a blank line, we need to add it as a "comment" for the
    // formatter.
    if (startOfLineComment > 0) {
      String whitespaceStr = matchedToken.image.substring(0, startOfLineComment);
      Point wsBeginPoint = Point.create(matchedToken.beginLine, matchedToken.beginColumn);
      trimTokenBegin(matchedToken, startOfLineComment - 1);
      Point wsEndPoint =  Point.create(matchedToken.beginLine, matchedToken.beginColumn);

      maybeAddBlankLines(wsBeginPoint, wsEndPoint, whitespaceStr);
    }

   // Now we can add the line comment.
    trimTokenBegin(matchedToken, startOfLineComment == 0 ? 0 : 1);
    addLineComment(matchedToken);
         break;
      case 6 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
    addRangeComment(matchedToken);
    popState();
         break;
      case 9 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
    addRangeComment(matchedToken);
    popState();
         break;
      default :
         break;
   }
}
void MoreLexicalActions()
{
   jjimageLen += (lengthOfMatch = jjmatchedPos + 1);
   switch(jjmatchedKind)
   {
      case 4 :
         image.append(input_stream.GetSuffix(jjimageLen));
         jjimageLen = 0;
             pushState(IN_MULTILINE_COMMENT);
         break;
      case 7 :
         image.append(input_stream.GetSuffix(jjimageLen));
         jjimageLen = 0;
          pushState(IN_SOYDOC);
         break;
      default :
         break;
   }
}
void TokenLexicalActions(Token matchedToken)
{
   switch(jjmatchedKind)
   {
      case 24 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
    {
      // trim off trailing quote, unescape internal quotation marks
      String value = matchedToken.image;
      value = value.substring(0, value.length() - 1);
      value = SoyParseUtils.unescapeCommandAttributeValue(value, QuoteStyle.DOUBLE);

      matchedToken.image = value;
    }
    // Return to previous state
    popState();
         break;
      case 25 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
    {
      // trim off trailing quote, unescape internal quotation marks
      String value = matchedToken.image;
      value = value.substring(0, value.length() - 1);
      value = SoyParseUtils.unescapeCommandAttributeValue(value, QuoteStyle.SINGLE);

      matchedToken.image = value;
    }

    // Return to previous state
    popState();
         break;
      case 30 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                               isInTemplate = true;
         break;
      case 31 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                        isInTemplate = true;
         break;
      case 32 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                      isInTemplate = true;
         break;
      case 33 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                        resetState();
         break;
      case 34 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                        resetState();
         break;
      case 35 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                    resetState();
         break;
      case 86 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                      SwitchTo(isInTemplate ? TEMPLATE_DEFAULT : DEFAULT);
         break;
      case 87 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                              SwitchTo(isInTemplate ? TEMPLATE_DEFAULT : DEFAULT);
         break;
      case 95 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                            maybeAddBlankLines(matchedToken);
         break;
      case 105 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                       popState();
         break;
      case 106 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                        popState();
         break;
      case 111 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                            resetState(); SwitchTo(TEMPLATE_DEFAULT);
         break;
      default :
         break;
   }
}
private void jjCheckNAdd(int state)
{
   if (jjrounds[state] != jjround)
   {
      jjstateSet[jjnewStateCnt++] = state;
      jjrounds[state] = jjround;
   }
}
private void jjAddStates(int start, int end)
{
   do {
      jjstateSet[jjnewStateCnt++] = jjnextStates[start];
   } while (start++ != end);
}
private void jjCheckNAddTwoStates(int state1, int state2)
{
   jjCheckNAdd(state1);
   jjCheckNAdd(state2);
}

private void jjCheckNAddStates(int start, int end)
{
   do {
      jjCheckNAdd(jjnextStates[start]);
   } while (start++ != end);
}

    /** Constructor. */
    public SoyFileParserTokenManager(SimpleCharStream stream){

      if (SimpleCharStream.staticFlag)
            throw new Error("ERROR: Cannot use a static CharStream class with a non-static lexical analyzer.");

    input_stream = stream;
  }

  /** Constructor. */
  public SoyFileParserTokenManager (SimpleCharStream stream, int lexState){
    ReInit(stream);
    SwitchTo(lexState);
  }

  /** Reinitialise parser. */
  public void ReInit(SimpleCharStream stream)
  {
	
    jjmatchedPos = jjnewStateCnt = 0;
    curLexState = defaultLexState;
    input_stream = stream;
    ReInitRounds();
  }

  private void ReInitRounds()
  {
    int i;
    jjround = 0x80000001;
    for (i = 141; i-- > 0;)
      jjrounds[i] = 0x80000000;
  }

  /** Reinitialise parser. */
  public void ReInit( SimpleCharStream stream, int lexState)
  {
  
    ReInit( stream);
    SwitchTo(lexState);
  }

  /** Switch to specified lex state. */
  public void SwitchTo(int lexState)
  {
    if (lexState >= 13 || lexState < 0)
      throw new TokenMgrError("Error: Ignoring invalid lexical state : " + lexState + ". State unchanged.", TokenMgrError.INVALID_LEXICAL_STATE);
    else
      curLexState = lexState;
  }

/** Lexer state names. */
public static final String[] lexStateNames = {
   "DEFAULT",
   "IN_CMD_TAG",
   "EXPR",
   "EXPR_NO_DOUBLE_QUOTE",
   "EXPR_NO_SINGLE_QUOTE",
   "TEMPLATE_DEFAULT",
   "IN_MULTILINE_COMMENT",
   "IN_SOYDOC",
   "IN_DQ_ATTRIBUTE_VALUE",
   "IN_SQ_ATTRIBUTE_VALUE",
   "IN_LITERAL_BLOCK",
   "IN_SQ_STRING",
   "IN_DQ_STRING",
};

/** Lex State array. */
public static final int[] jjnewLexState = {
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2, 1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 1, -1, 
   -1, -1, -1, -1, -1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   10, 2, 1, -1, -1, 2, -1, 1, 1, -1, 2, 2, -1, -1, 2, -1, 2, -1, 2, -1, 2, -1, 2, -1, 2, 
   -1, -1, -1, -1, -1, 2, 2, 2, 2, -1, -1, -1, -1, -1, 2, 2, -1, -1, -1, 5, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, 
};
static final long[] jjtoToken = {
   0xffffffffc3fffc01L, 0xffff87ffdfffffffL, 0x83fffffL, 
};
static final long[] jjtoSkip = {
   0x24eL, 0x0L, 0x0L, 
};
static final long[] jjtoSpecial = {
   0x24cL, 0x0L, 0x0L, 
};
static final long[] jjtoMore = {
   0x3c0001b0L, 0x780020000000L, 0x0L, 
};
    protected SimpleCharStream  input_stream;

    private final int[] jjrounds = new int[141];
    private final int[] jjstateSet = new int[2 * 141];

    private final StringBuilder jjimage = new StringBuilder();
    private StringBuilder image = jjimage;
    private int jjimageLen;
    private int lengthOfMatch;
    
    protected int curChar;
}
