/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.xliffmsgplugin;

import com.google.common.collect.Lists;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.SoyMsgException;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgBundleImpl;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XliffParser {
    private XliffParser() {
    }

    static SoyMsgBundle parseXliffTargetMsgs(String xliffContent) throws SAXException {
        SAXParser saxParser;
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        try {
            saxParserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxParserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            saxParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            saxParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            saxParserFactory.setValidating(false);
            saxParserFactory.setXIncludeAware(false);
            saxParser = saxParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException pce) {
            throw new AssertionError("Could not get SAX parser for XML.", pce);
        }
        XliffSaxHandler xliffSaxHandler = new XliffSaxHandler();
        try {
            saxParser.parse(new InputSource(new StringReader(xliffContent)), (DefaultHandler)xliffSaxHandler);
        }
        catch (IOException e) {
            throw new AssertionError((Object)"Should not fail in reading a string.");
        }
        return new SoyMsgBundleImpl(xliffSaxHandler.getTargetLocaleString(), xliffSaxHandler.getMsgs());
    }

    private static class XliffSaxHandler
    extends DefaultHandler {
        private String targetLocaleString;
        private final List<SoyMsg> msgs = Lists.newArrayList();
        private boolean isInMsg = false;
        private long currMsgId;
        private List<SoyMsgPart> currMsgParts;
        private String currRawTextPart;

        public String getTargetLocaleString() {
            return this.targetLocaleString;
        }

        public List<SoyMsg> getMsgs() {
            return this.msgs;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            if (qName.equals("file")) {
                if (this.targetLocaleString == null) {
                    this.targetLocaleString = atts.getValue("target-language");
                } else if (!atts.getValue("target-language").equals(this.targetLocaleString)) {
                    throw new SoyMsgException("If XLIFF input contains multiple 'file' elements, they must have the same 'target-language'.");
                }
            } else if (qName.equals("trans-unit")) {
                String id = atts.getValue("id");
                try {
                    this.currMsgId = Long.parseLong(id);
                }
                catch (NumberFormatException e) {
                    throw new SoyMsgException("Invalid message id '" + id + "' could not have been generated by the Soy compiler.");
                }
            } else if (qName.equals("target")) {
                this.currMsgParts = Lists.newArrayList();
                this.currRawTextPart = null;
                this.isInMsg = true;
            } else if (this.isInMsg) {
                if (!qName.equals("x")) {
                    throw new SoyMsgException("In messages extracted by the Soy compiler, all placeholders should be element 'x' (found element '" + qName + "' in message).");
                }
                if (this.currRawTextPart != null) {
                    this.currMsgParts.add(SoyMsgRawTextPart.of(this.currRawTextPart));
                    this.currRawTextPart = null;
                }
                this.currMsgParts.add(new SoyMsgPlaceholderPart(atts.getValue("id"), atts.getValue("example")));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (qName.equals("target")) {
                if (this.currRawTextPart != null) {
                    this.currMsgParts.add(SoyMsgRawTextPart.of(this.currRawTextPart));
                    this.currRawTextPart = null;
                }
                this.isInMsg = false;
                if (!this.currMsgParts.isEmpty()) {
                    this.msgs.add(SoyMsg.builder().setId(this.currMsgId).setLocaleString(this.targetLocaleString).setParts(this.currMsgParts).build());
                }
            }
        }

        @Override
        public void characters(char[] buffer, int start, int length) {
            if (!this.isInMsg) {
                return;
            }
            this.currRawTextPart = this.currRawTextPart == null ? new String(buffer, start, length) : this.currRawTextPart + new String(buffer, start, length);
        }
    }
}

