/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.ast;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.DoNotCall;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.types.ErrorType;
import com.google.template.soy.types.RecordType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.ast.GenericTypeNode;
import com.google.template.soy.types.ast.NamedTypeNode;
import com.google.template.soy.types.ast.RecordTypeNode;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.TypeNodeVisitor;
import com.google.template.soy.types.ast.UnionTypeNode;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;

public final class TypeNodeConverter
implements TypeNodeVisitor<SoyType>,
Function<TypeNode, SoyType> {
    private static final SoyErrorKind UNKNOWN_TYPE = SoyErrorKind.of("Unknown type ''{0}''.{1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind DUPLICATE_RECORD_FIELD = SoyErrorKind.of("Duplicate field ''{0}'' in record declaration.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_TYPE_PARAM = SoyErrorKind.of("Unexpected type parameter: ''{0}'' only has {1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind EXPECTED_TYPE_PARAM = SoyErrorKind.of("Expected a type parameter: ''{0}'' has {1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind NOT_A_GENERIC_TYPE = SoyErrorKind.of("''{0}'' is not a generic type, expected ''list'' or ''map''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MISSING_GENERIC_TYPE_PARAMETERS = SoyErrorKind.of("''{0}'' is a generic type, expected {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final ImmutableMap<String, GenericTypeInfo> GENERIC_TYPES = ImmutableMap.of((Object)"list", (Object)new GenericTypeInfo(1){

        @Override
        SoyType create(List<SoyType> types, SoyTypeRegistry registry) {
            return registry.getOrCreateListType(types.get(0));
        }
    }, (Object)"legacy_object_map", (Object)new GenericTypeInfo(2){

        @Override
        SoyType create(List<SoyType> types, SoyTypeRegistry registry) {
            return registry.getOrCreateLegacyObjectMapType(types.get(0), types.get(1));
        }
    }, (Object)"map", (Object)new GenericTypeInfo(2){

        @Override
        SoyType create(List<SoyType> types, SoyTypeRegistry registry) {
            return registry.getOrCreateMapType(types.get(0), types.get(1));
        }
    }, (Object)"ve", (Object)new GenericTypeInfo(1){

        @Override
        SoyType create(List<SoyType> types, SoyTypeRegistry registry) {
            return registry.getOrCreateVeType(types.get(0).toString());
        }
    });
    private final ErrorReporter errorReporter;
    private final SoyTypeRegistry typeRegistry;

    public TypeNodeConverter(ErrorReporter errorReporter, SoyTypeRegistry typeRegistry) {
        this.errorReporter = errorReporter;
        this.typeRegistry = typeRegistry;
    }

    public SoyType getOrCreateType(TypeNode node) {
        return node.accept(this);
    }

    @Override
    public SoyType visit(NamedTypeNode node) {
        String name = node.name();
        SoyType type = this.typeRegistry.getType(name);
        if (type == null) {
            GenericTypeInfo genericType = (GenericTypeInfo)GENERIC_TYPES.get((Object)name);
            if (genericType != null) {
                this.errorReporter.report(node.sourceLocation(), MISSING_GENERIC_TYPE_PARAMETERS, name, genericType.formatNumTypeParams());
            } else {
                this.errorReporter.report(node.sourceLocation(), UNKNOWN_TYPE, name, SoyErrors.getDidYouMeanMessage(this.typeRegistry.getAllSortedTypeNames(), name));
            }
            type = ErrorType.getInstance();
        }
        node.setResolvedType(type);
        return type;
    }

    @Override
    public SoyType visit(GenericTypeNode node) {
        ImmutableList<TypeNode> args = node.arguments();
        String name = node.name();
        GenericTypeInfo genericType = (GenericTypeInfo)GENERIC_TYPES.get((Object)name);
        if (genericType == null) {
            this.errorReporter.report(node.sourceLocation(), NOT_A_GENERIC_TYPE, name);
            return ErrorType.getInstance();
        }
        if (args.size() < genericType.numParams) {
            this.errorReporter.report(node.sourceLocation().getEndLocation(), EXPECTED_TYPE_PARAM, name, genericType.formatNumTypeParams());
            return ErrorType.getInstance();
        }
        if (args.size() > genericType.numParams) {
            this.errorReporter.report(((TypeNode)args.get(genericType.numParams)).sourceLocation(), UNEXPECTED_TYPE_PARAM, name, genericType.formatNumTypeParams());
            return ErrorType.getInstance();
        }
        SoyType type = genericType.create(Lists.transform(args, (Function)this), this.typeRegistry);
        node.setResolvedType(type);
        return type;
    }

    @Override
    public SoyType visit(UnionTypeNode node) {
        SoyType type = this.typeRegistry.getOrCreateUnionType((Collection)node.candidates().stream().map(this).collect(ImmutableList.toImmutableList()));
        node.setResolvedType(type);
        return type;
    }

    @Override
    public SoyType visit(RecordTypeNode node) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (RecordTypeNode.Property property : node.properties()) {
            SoyType oldType = map.put(property.name(), property.type().accept(this));
            if (oldType == null) continue;
            this.errorReporter.report(property.nameLocation(), DUPLICATE_RECORD_FIELD, property.name());
            map.put(property.name(), oldType);
        }
        RecordType type = this.typeRegistry.getOrCreateRecordType(map);
        node.setResolvedType(type);
        return type;
    }

    @DoNotCall
    public SoyType apply(TypeNode node) {
        return node.accept(this);
    }

    private static abstract class GenericTypeInfo {
        final int numParams;

        GenericTypeInfo(int numParams) {
            this.numParams = numParams;
        }

        final String formatNumTypeParams() {
            return this.numParams + " type parameter" + (this.numParams > 1 ? "s" : "");
        }

        abstract SoyType create(List<SoyType> var1, SoyTypeRegistry var2);
    }
}

