/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.template.soy.types.AbstractMapType;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.RecordType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.UnionType;
import com.google.template.soy.types.VeType;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nullable;

class SoyTypeGraphUtils {
    private SoyTypeGraphUtils() {
    }

    static class SoyTypeSuccessorsFunction
    implements SuccessorsFunction<SoyType> {
        private final SoyTypeRegistry typeRegistry;

        public SoyTypeSuccessorsFunction(@Nullable SoyTypeRegistry typeRegistry) {
            this.typeRegistry = typeRegistry;
        }

        @Override
        public Iterable<? extends SoyType> successors(SoyType type) {
            switch (type.getKind()) {
                case UNION: {
                    return ((UnionType)type).getMembers();
                }
                case LIST: {
                    return ImmutableList.of((Object)((ListType)type).getElementType());
                }
                case MAP: 
                case LEGACY_OBJECT_MAP: {
                    AbstractMapType mapType = (AbstractMapType)type;
                    return ImmutableList.of((Object)mapType.getKeyType(), (Object)mapType.getValueType());
                }
                case RECORD: {
                    return ((RecordType)type).getMembers().values();
                }
                case VE: {
                    VeType veType = (VeType)type;
                    if (this.typeRegistry == null || !veType.getDataType().isPresent()) break;
                    return ImmutableList.of((Object)this.typeRegistry.getType(veType.getDataType().get()));
                }
            }
            return ImmutableList.of();
        }
    }

    static final class BreadthFirstIterator<N>
    extends UnmodifiableIterator<N> {
        private final SuccessorsFunction<N> graph;
        private final Queue<N> queue = new ArrayDeque<N>();
        private final Set<N> visited = new HashSet<N>();

        BreadthFirstIterator(Iterable<? extends N> roots, SuccessorsFunction<N> graph) {
            this.graph = graph;
            for (N root : roots) {
                if (!this.visited.add(root)) continue;
                this.queue.add(root);
            }
        }

        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        public N next() {
            N current = this.queue.remove();
            for (N neighbor : this.graph.successors(current)) {
                if (!this.visited.add(neighbor)) continue;
                this.queue.add(neighbor);
            }
            return current;
        }
    }

    public static interface SuccessorsFunction<N> {
        public Iterable<? extends N> successors(N var1);
    }
}

