/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.ForOverride;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.template.soy.soytree.SoyTypeP;
import com.google.template.soy.types.UnionType;

public abstract class SoyType {
    @LazyInit
    private SoyTypeP protoDual;

    SoyType() {
    }

    public abstract Kind getKind();

    public final boolean isAssignableFrom(SoyType srcType) {
        if (srcType instanceof UnionType) {
            UnionType asUnion = (UnionType)srcType;
            for (SoyType member : asUnion.getMembers()) {
                if (this.doIsAssignableFromNonUnionType(member)) continue;
                return false;
            }
            return true;
        }
        return this.doIsAssignableFromNonUnionType(srcType);
    }

    @ForOverride
    abstract boolean doIsAssignableFromNonUnionType(SoyType var1);

    public abstract String toString();

    public final SoyTypeP toProto() {
        SoyTypeP local = this.protoDual;
        if (local == null) {
            SoyTypeP.Builder builder = SoyTypeP.newBuilder();
            this.doToProto(builder);
            this.protoDual = local = builder.build();
        }
        return local;
    }

    @ForOverride
    abstract void doToProto(SoyTypeP.Builder var1);

    public static enum Kind {
        ANY,
        UNKNOWN,
        ERROR,
        NULL,
        BOOL,
        INT,
        FLOAT,
        STRING,
        HTML,
        ATTRIBUTES,
        JS,
        CSS,
        URI,
        TRUSTED_RESOURCE_URI,
        LIST,
        RECORD,
        LEGACY_OBJECT_MAP,
        MAP,
        PROTO,
        PROTO_ENUM,
        UNION,
        VE,
        VE_DATA;

        private static final ImmutableSet<Kind> STRING_KINDS;
        private static final ImmutableSet<Kind> ILLEGAL_OPERAND_KINDS_PLUS_OP;

        public boolean isKnownStringOrSanitizedContent() {
            return STRING_KINDS.contains((Object)this);
        }

        public boolean isKnownSanitizedContent() {
            return this != STRING && STRING_KINDS.contains((Object)this);
        }

        public boolean isIllegalOperandForBinaryOps() {
            return ILLEGAL_OPERAND_KINDS_PLUS_OP.contains((Object)this) || STRING_KINDS.contains((Object)this);
        }

        static {
            STRING_KINDS = Sets.immutableEnumSet((Enum)STRING, (Enum[])new Kind[]{HTML, ATTRIBUTES, JS, CSS, URI, TRUSTED_RESOURCE_URI});
            ILLEGAL_OPERAND_KINDS_PLUS_OP = Sets.immutableEnumSet((Enum)BOOL, (Enum[])new Kind[]{LIST, LEGACY_OBJECT_MAP, MAP, RECORD});
        }
    }
}

