/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree.defn;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.soytree.defn.AbstractVarDefn;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.ast.TypeNode;
import javax.annotation.Nullable;

public final class TemplateParam
extends AbstractVarDefn
implements TemplateHeaderVarDefn {
    private final TypeNode typeNode;
    private final String desc;
    private final boolean isRequired;
    private final boolean isInjected;
    @Nullable
    private final ExprRootNode defaultValue;

    public TemplateParam(String name, SourceLocation nameLocation, @Nullable TypeNode typeNode, boolean isRequired, boolean isInjected, @Nullable String desc, @Nullable ExprNode defaultValue) {
        super(name, nameLocation, null);
        this.typeNode = typeNode;
        this.isRequired = isRequired;
        this.isInjected = isInjected;
        this.desc = desc;
        this.defaultValue = defaultValue == null ? null : new ExprRootNode(defaultValue);
    }

    protected TemplateParam(TemplateParam param) {
        super(param);
        this.typeNode = param.typeNode == null ? null : param.typeNode.copy();
        this.isRequired = param.isRequired;
        this.isInjected = param.isInjected;
        this.desc = param.desc;
        this.defaultValue = param.defaultValue == null ? null : param.defaultValue.copy(new CopyState());
    }

    @Override
    public void setType(SoyType type) {
        Preconditions.checkState((this.type == null ? 1 : 0) != 0, (Object)"type has already been assigned");
        this.type = (SoyType)Preconditions.checkNotNull((Object)type);
    }

    @Override
    public VarDefn.Kind kind() {
        return VarDefn.Kind.PARAM;
    }

    @Override
    @Nullable
    public TypeNode getTypeNode() {
        return this.typeNode;
    }

    @Override
    public boolean isInjected() {
        return this.isInjected;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    @Nullable
    public String desc() {
        return this.desc;
    }

    @Override
    @Nullable
    public ExprRootNode defaultValue() {
        return this.defaultValue;
    }

    public boolean hasDefault() {
        return this.defaultValue != null;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{name = " + this.name() + ", desc = " + this.desc + "}";
    }

    @Override
    public TemplateParam copy(CopyState copyState) {
        return new TemplateParam(this);
    }
}

