/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractBlockCommandNode;
import com.google.template.soy.soytree.AliasDeclaration;
import com.google.template.soy.soytree.HtmlElementMetadataP;
import com.google.template.soy.soytree.NamespaceDeclaration;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.WhitespaceMode;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class TemplateNode
extends AbstractBlockCommandNode
implements SoyNode.RenderUnitNode,
SoyNode.ExprHolderNode {
    private static final SoyErrorKind INVALID_ALIAS_FOR_LAST_PART_OF_NAMESPACE = SoyErrorKind.of("Not allowed to alias the last part of the file''s namespace ({0}) to another namespace ({1}).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_ALIAS = SoyErrorKind.of("Duplicate alias definition ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private final SoyFileHeaderInfo soyFileHeaderInfo;
    private final String templateName;
    private final String partialTemplateName;
    private final Visibility visibility;
    private final WhitespaceMode whitespaceMode;
    private final SanitizedContentKind contentKind;
    private final ImmutableList<String> requiredCssNamespaces;
    private final String cssBaseNamespace;
    private String soyDoc;
    private String soyDocDesc;
    private final boolean strictHtml;
    private HtmlElementMetadataP templateMetadata = null;
    private final String commandText;
    private final SourceLocation openTagLocation;
    private ImmutableList<TemplateHeaderVarDefn> headerParams;

    TemplateNode(TemplateNodeBuilder<?> nodeBuilder, String cmdName, SoyFileHeaderInfo soyFileHeaderInfo, Visibility visibility, ImmutableList<TemplateHeaderVarDefn> params) {
        super(nodeBuilder.getId(), nodeBuilder.sourceLocation, cmdName);
        Preconditions.checkNotNull(params);
        this.headerParams = params == null ? ImmutableList.of() : params;
        this.soyFileHeaderInfo = soyFileHeaderInfo;
        this.templateName = nodeBuilder.getTemplateName();
        this.partialTemplateName = nodeBuilder.getPartialTemplateName();
        this.visibility = visibility;
        this.whitespaceMode = nodeBuilder.getWhitespaceMode();
        this.contentKind = (SanitizedContentKind)((Object)Preconditions.checkNotNull((Object)((Object)nodeBuilder.getContentKind())));
        this.requiredCssNamespaces = nodeBuilder.getRequiredCssNamespaces();
        this.cssBaseNamespace = nodeBuilder.getCssBaseNamespace();
        this.soyDoc = nodeBuilder.getSoyDoc();
        this.soyDocDesc = nodeBuilder.getSoyDocDesc();
        this.strictHtml = this.computeStrictHtmlMode(nodeBuilder.getStrictHtmlDisabled());
        this.commandText = nodeBuilder.getCmdText().trim();
        this.openTagLocation = nodeBuilder.openTagLocation;
    }

    protected TemplateNode(TemplateNode orig, CopyState copyState) {
        super(orig, copyState);
        this.headerParams = TemplateNode.copyParams(orig.headerParams, copyState);
        this.soyFileHeaderInfo = orig.soyFileHeaderInfo.copy();
        this.templateName = orig.templateName;
        this.partialTemplateName = orig.partialTemplateName;
        this.visibility = orig.visibility;
        this.whitespaceMode = orig.whitespaceMode;
        this.contentKind = orig.contentKind;
        this.requiredCssNamespaces = orig.requiredCssNamespaces;
        this.cssBaseNamespace = orig.cssBaseNamespace;
        this.soyDoc = orig.soyDoc;
        this.soyDocDesc = orig.soyDocDesc;
        this.strictHtml = orig.strictHtml;
        this.commandText = orig.commandText;
        this.openTagLocation = orig.openTagLocation;
    }

    private static ImmutableList<TemplateHeaderVarDefn> copyParams(ImmutableList<TemplateHeaderVarDefn> orig, CopyState copyState) {
        ImmutableList.Builder newParams = ImmutableList.builder();
        for (TemplateHeaderVarDefn prev : orig) {
            TemplateHeaderVarDefn next = prev.copy(copyState);
            newParams.add((Object)next);
            copyState.updateRefs(prev, next);
        }
        return newParams.build();
    }

    public SoyFileHeaderInfo getSoyFileHeaderInfo() {
        return this.soyFileHeaderInfo;
    }

    public String getDelPackageName() {
        return this.soyFileHeaderInfo.delPackageName;
    }

    public abstract String getTemplateNameForUserMsgs();

    public String getTemplateName() {
        return this.templateName;
    }

    public void clearStateVars() {
        this.headerParams = (ImmutableList)this.headerParams.stream().filter(p -> !(p instanceof TemplateStateVar)).collect(ImmutableList.toImmutableList());
    }

    public String getPartialTemplateName() {
        return this.partialTemplateName;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public SourceLocation getOpenTagLocation() {
        return this.openTagLocation;
    }

    public WhitespaceMode getWhitespaceMode() {
        return this.whitespaceMode;
    }

    private String getDeclName(TemplateHeaderVarDefn headerVar) {
        if (headerVar instanceof TemplateStateVar) {
            return "@state";
        }
        if (headerVar.isInjected()) {
            return "@inject";
        }
        return "@param";
    }

    private boolean computeStrictHtmlMode(boolean strictHtmlDisabled) {
        if (strictHtmlDisabled) {
            return false;
        }
        return this.contentKind == SanitizedContentKind.HTML;
    }

    public boolean isStrictHtml() {
        return this.strictHtml;
    }

    @Override
    public SanitizedContentKind getContentKind() {
        return this.contentKind;
    }

    public ImmutableList<String> getRequiredCssNamespaces() {
        return this.requiredCssNamespaces;
    }

    public String getCssBaseNamespace() {
        return this.cssBaseNamespace;
    }

    public void clearSoyDocStrings() {
        this.soyDoc = null;
        this.soyDocDesc = null;
    }

    @Nullable
    public String getSoyDoc() {
        return this.soyDoc;
    }

    @Nullable
    public String getSoyDocDesc() {
        return this.soyDocDesc;
    }

    public ImmutableList<TemplateParam> getParams() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TemplateHeaderVarDefn header : this.getHeaderParams()) {
            if (!(header instanceof TemplateParam) || header.isInjected()) continue;
            builder.add((Object)((TemplateParam)header));
        }
        return builder.build();
    }

    public void setHtmlElementMetadata(HtmlElementMetadataP metadata) {
        this.templateMetadata = metadata;
    }

    public HtmlElementMetadataP getHtmlElementMetadata() {
        return this.templateMetadata;
    }

    public ImmutableList<TemplateParam> getInjectedParams() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TemplateHeaderVarDefn header : this.getHeaderParams()) {
            if (!(header instanceof TemplateParam) || !header.isInjected()) continue;
            builder.add((Object)((TemplateParam)header));
        }
        return builder.build();
    }

    public Iterable<TemplateParam> getAllParams() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TemplateHeaderVarDefn header : this.getHeaderParams()) {
            if (!(header instanceof TemplateParam)) continue;
            builder.add((Object)((TemplateParam)header));
        }
        return builder.build();
    }

    @Override
    public SoyFileNode getParent() {
        return (SoyFileNode)super.getParent();
    }

    @Override
    public String getCommandText() {
        return this.commandText;
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        ImmutableList.Builder exprs = ImmutableList.builder();
        for (TemplateHeaderVarDefn param : this.getParams()) {
            ExprRootNode defaultValue = param.defaultValue();
            if (defaultValue == null) continue;
            exprs.add((Object)defaultValue);
        }
        return exprs.build();
    }

    public void addCspNonceParam(TemplateParam cspNonce) {
        this.headerParams = ImmutableList.builder().addAll(this.headerParams).add((Object)cspNonce).build();
    }

    public ImmutableList<TemplateHeaderVarDefn> getHeaderParams() {
        return this.headerParams;
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        if (this.soyDoc != null) {
            sb.append(this.soyDoc).append("\n");
        }
        sb.append(this.getTagString()).append("\n");
        this.appendHeaderVarDecl(this.getHeaderParams(), sb);
        StringBuilder bodySb = new StringBuilder();
        this.appendSourceStringForChildren(bodySb);
        int bodyLen = bodySb.length();
        if (bodyLen != 0) {
            if (bodyLen != 1 && bodySb.charAt(bodyLen - 1) == ' ') {
                bodySb.replace(bodyLen - 1, bodyLen, "{sp}");
            }
            if (bodySb.charAt(0) == ' ') {
                bodySb.replace(0, 1, "{sp}");
            }
        }
        sb.append((CharSequence)bodySb);
        sb.append("\n");
        sb.append("{/").append(this.getCommandName()).append("}\n");
        return sb.toString();
    }

    protected void appendHeaderVarDecl(ImmutableList<? extends TemplateHeaderVarDefn> headerVars, StringBuilder sb) {
        for (TemplateHeaderVarDefn headerVar : headerVars) {
            sb.append("  {").append(this.getDeclName(headerVar));
            if (!headerVar.isRequired()) {
                sb.append("?");
            }
            sb.append(" ").append(headerVar.name()).append(": ").append(headerVar.hasType() ? headerVar.type() : headerVar.getTypeNode()).append("}");
            if (headerVar.desc() != null) {
                sb.append("  /** ").append(headerVar.desc()).append(" */");
            }
            sb.append("\n");
        }
    }

    public StackTraceElement createStackTraceElement(SourceLocation srcLocation) {
        return new StackTraceElement(this.soyFileHeaderInfo.namespace, this.partialTemplateName.substring(1), srcLocation.getFileName(), srcLocation.getBeginLine());
    }

    public static class SoyFileHeaderInfo {
        public static final SoyFileHeaderInfo EMPTY = new SoyFileHeaderInfo("sample.ns");
        private final ImmutableMap<String, String> aliasToNamespaceMap;
        private final ImmutableList<AliasDeclaration> aliasDeclarations;
        @Nullable
        private final String delPackageName;
        private final Priority priority;
        @Nullable
        private final String namespace;
        private final Set<String> usedAliases;

        public SoyFileHeaderInfo(ErrorReporter errorReporter, @Nullable Identifier delpackageName, NamespaceDeclaration namespaceDeclaration, Collection<AliasDeclaration> aliases) {
            this(delpackageName == null ? null : delpackageName.identifier(), namespaceDeclaration.getNamespace(), SoyFileHeaderInfo.createAliasMap(errorReporter, namespaceDeclaration, aliases), (ImmutableList<AliasDeclaration>)ImmutableList.copyOf(aliases));
        }

        @VisibleForTesting
        public SoyFileHeaderInfo(String namespace) {
            this(null, namespace, (ImmutableMap<String, String>)ImmutableMap.of(), (ImmutableList<AliasDeclaration>)ImmutableList.of());
        }

        private SoyFileHeaderInfo(@Nullable String delPackageName, String namespace, ImmutableMap<String, String> aliasToNamespaceMap, ImmutableList<AliasDeclaration> aliasDeclarations) {
            this.delPackageName = delPackageName;
            this.priority = delPackageName == null ? Priority.STANDARD : Priority.HIGH_PRIORITY;
            this.namespace = namespace;
            this.aliasToNamespaceMap = aliasToNamespaceMap;
            this.aliasDeclarations = aliasDeclarations;
            this.usedAliases = new HashSet<String>();
        }

        private SoyFileHeaderInfo(SoyFileHeaderInfo orig) {
            this.delPackageName = orig.delPackageName;
            this.priority = orig.priority;
            this.namespace = orig.namespace;
            this.aliasToNamespaceMap = orig.aliasToNamespaceMap;
            this.aliasDeclarations = orig.aliasDeclarations;
            this.usedAliases = new HashSet<String>(orig.usedAliases);
        }

        public String resolveAlias(String fullName) {
            String remainder;
            String firstIdent;
            int i = fullName.indexOf(46);
            if (i > 0) {
                firstIdent = fullName.substring(0, i);
                remainder = fullName.substring(i);
            } else {
                firstIdent = fullName;
                remainder = "";
            }
            String alias = (String)this.aliasToNamespaceMap.get((Object)firstIdent);
            if (alias != null) {
                this.usedAliases.add(firstIdent);
            }
            return alias == null ? fullName : alias + remainder;
        }

        public boolean hasAlias(String alias) {
            return this.aliasToNamespaceMap.containsKey((Object)alias);
        }

        public boolean aliasUsed(String alias) {
            return this.usedAliases.contains(alias);
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getDelPackageName() {
            return this.delPackageName;
        }

        public ImmutableList<AliasDeclaration> getAliases() {
            return this.aliasDeclarations;
        }

        public Priority getPriority() {
            return this.priority;
        }

        private static ImmutableMap<String, String> createAliasMap(ErrorReporter errorReporter, NamespaceDeclaration namespaceDeclaration, Collection<AliasDeclaration> aliases) {
            LinkedHashMap map = Maps.newLinkedHashMap();
            String aliasForFileNamespace = BaseUtils.extractPartAfterLastDot(namespaceDeclaration.getNamespace());
            for (AliasDeclaration aliasDeclaration : aliases) {
                String aliasNamespace = aliasDeclaration.namespace().identifier();
                String alias = aliasDeclaration.alias().identifier();
                if (alias.equals(aliasForFileNamespace) && !aliasNamespace.equals(namespaceDeclaration.getNamespace())) {
                    errorReporter.report(aliasDeclaration.alias().location(), INVALID_ALIAS_FOR_LAST_PART_OF_NAMESPACE, namespaceDeclaration.getNamespace(), aliasNamespace);
                }
                if (map.containsKey(alias)) {
                    errorReporter.report(aliasDeclaration.alias().location(), DUPLICATE_ALIAS, alias);
                }
                map.put(alias, aliasNamespace);
            }
            return ImmutableMap.copyOf((Map)map);
        }

        public SoyFileHeaderInfo copy() {
            return new SoyFileHeaderInfo(this);
        }
    }

    public static enum Priority {
        STANDARD(0),
        HIGH_PRIORITY(1);

        private final int value;

        private Priority(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }
}

