/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.TemplateElementNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import java.util.List;

public final class TemplateElementNodeBuilder
extends TemplateNodeBuilder<TemplateElementNodeBuilder> {
    protected static final ImmutableSet<String> BANNED_ATTRIBUTE_NAMES = ImmutableSet.of((Object)"autoescape", (Object)"kind", (Object)"stricthtml", (Object)"visibility");
    private static final SoyErrorKind BANNED_ATTRIBUTE_NAMES_ERROR = SoyErrorKind.of("Attribute ''{0}'' is not allowed on Soy elements.", new SoyErrorKind.StyleAllowance[0]);
    private List<CommandTagAttribute> attrs = ImmutableList.of();

    public TemplateElementNodeBuilder(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, ErrorReporter errorReporter) {
        super(soyFileHeaderInfo, errorReporter);
        this.setContentKind(SanitizedContentKind.HTML);
    }

    @Override
    public TemplateElementNodeBuilder setCommandValues(Identifier templateName, List<CommandTagAttribute> attrs) {
        this.attrs = attrs;
        this.cmdText = templateName.identifier() + " " + Joiner.on((char)' ').join(attrs);
        this.setCommonCommandValues(attrs);
        this.setTemplateNames(this.soyFileHeaderInfo.getNamespace() + templateName.identifier(), templateName.identifier());
        return this;
    }

    @Override
    public TemplateElementNode build() {
        Preconditions.checkState((this.id != null && this.cmdText != null ? 1 : 0) != 0);
        for (CommandTagAttribute attr : this.attrs) {
            if (!BANNED_ATTRIBUTE_NAMES.contains((Object)attr.getName().identifier())) continue;
            this.errorReporter.report(this.sourceLocation, BANNED_ATTRIBUTE_NAMES_ERROR, attr.getName().identifier());
        }
        return new TemplateElementNode(this, this.soyFileHeaderInfo, (ImmutableList<TemplateHeaderVarDefn>)this.params);
    }

    @Override
    protected TemplateElementNodeBuilder self() {
        return this;
    }
}

