/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.soytree.CommandTagAttribute;
import java.util.List;
import javax.annotation.Nullable;

public final class NamespaceDeclaration {
    private final Identifier namespace;
    private final ImmutableList<String> requiredCssNamespaces;
    private final String cssBaseNamespace;
    final ImmutableList<CommandTagAttribute> attrs;

    public NamespaceDeclaration(Identifier namespace, List<CommandTagAttribute> attrs, ErrorReporter errorReporter) {
        ImmutableList<String> requiredCssNamespaces = ImmutableList.of();
        String cssBaseNamespace = null;
        block10: for (CommandTagAttribute attr : attrs) {
            switch (attr.getName().identifier()) {
                case "requirecss": {
                    requiredCssNamespaces = attr.valueAsRequireCss(errorReporter);
                    continue block10;
                }
                case "cssbase": {
                    cssBaseNamespace = attr.getValue();
                    continue block10;
                }
                case "stricthtml": {
                    errorReporter.report(attr.getName().location(), CommandTagAttribute.NAMESPACE_STRICTHTML_ATTRIBUTE, new Object[0]);
                    continue block10;
                }
            }
            errorReporter.report(attr.getName().location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY, attr.getName().identifier(), "namespace", ImmutableList.of((Object)"cssbase", (Object)"requirecss"));
        }
        this.namespace = namespace;
        this.requiredCssNamespaces = requiredCssNamespaces;
        this.cssBaseNamespace = cssBaseNamespace;
        this.attrs = ImmutableList.copyOf(attrs);
    }

    public NamespaceDeclaration copy(CopyState copyState) {
        return new NamespaceDeclaration(this.namespace, (List)this.attrs.stream().map(attr -> attr.copy(copyState)).collect(ImmutableList.toImmutableList()), ErrorReporter.exploding());
    }

    public String getNamespace() {
        return this.namespace.identifier();
    }

    ImmutableList<String> getRequiredCssNamespaces() {
        return this.requiredCssNamespaces;
    }

    @Nullable
    String getCssBaseNamespace() {
        return this.cssBaseNamespace;
    }

    public String toSourceString() {
        return "{namespace " + this.namespace.identifier() + (this.attrs.isEmpty() ? "" : " " + Joiner.on((char)' ').join(this.attrs)) + "}\n";
    }
}

