/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.auto.value.AutoValue;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractBlockCommandNode;
import com.google.template.soy.soytree.AutoValue_MsgNode_PlaceholderInfo;
import com.google.template.soy.soytree.AutoValue_MsgNode_RepresentativeNodes;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.EscapingMode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.VeLogNode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class MsgNode
extends AbstractBlockCommandNode
implements SoyNode.ExprHolderNode,
SoyNode.MsgBlockNode {
    private static final SoyErrorKind WRONG_NUMBER_OF_GENDER_EXPRS = SoyErrorKind.of("Attribute ''genders'' should contain 1-3 expressions.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INCOMPATIBLE_PLACEHOLDER_EXAMPLES = SoyErrorKind.of("The example set on this placeholder is incompatible with other examples for the same placeholder. If a placeholder occurs multiple times in a msg, then all examples must be the same.", new SoyErrorKind.StyleAllowance[0]);
    private static final Pattern LINE_BOUNDARY_PATTERN = Pattern.compile("\\s*?(\\n|\\r)\\s*");
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    @Nullable
    private ImmutableList<ExprRootNode> genderExprs;
    @Nullable
    private final String meaning;
    private final String desc;
    private final boolean isHidden;
    @Nullable
    private final String genderExprsString;
    @Nullable
    private SubstUnitInfo substUnitInfo = null;
    @Nullable
    private EscapingMode escapingMode = null;

    public MsgNode(int id, SourceLocation location, String commandName, List<CommandTagAttribute> attributes, ErrorReporter errorReporter) {
        super(id, location, commandName);
        String meaning = null;
        String desc = null;
        boolean hidden = false;
        ImmutableList<ExprRootNode> genders = null;
        block12: for (CommandTagAttribute attr : attributes) {
            String name = attr.getName().identifier();
            switch (attr.getName().identifier()) {
                case "meaning": {
                    meaning = attr.getValue();
                    meaning = LINE_BOUNDARY_PATTERN.matcher(meaning).replaceAll(" ");
                    continue block12;
                }
                case "desc": {
                    desc = attr.getValue();
                    desc = LINE_BOUNDARY_PATTERN.matcher(desc).replaceAll(" ");
                    continue block12;
                }
                case "hidden": {
                    hidden = attr.valueAsEnabled(errorReporter);
                    continue block12;
                }
                case "genders": {
                    genders = ExprRootNode.wrap(attr.valueAsExprList());
                    if (!genders.isEmpty() && genders.size() <= 3) continue block12;
                    errorReporter.report(attr.getValueLocation(), WRONG_NUMBER_OF_GENDER_EXPRS, new Object[0]);
                    continue block12;
                }
            }
            errorReporter.report(attr.getName().location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY, name, commandName, ImmutableList.of((Object)"meaning", (Object)"desc", (Object)"hidden", (Object)"genders"));
        }
        if (desc == null) {
            errorReporter.report(location, CommandTagAttribute.MISSING_ATTRIBUTE, "desc", commandName);
            desc = "";
        }
        this.meaning = meaning;
        this.desc = desc;
        this.isHidden = hidden;
        this.genderExprs = genders;
        this.genderExprsString = genders != null ? SoyTreeUtils.toSourceString(genders) : null;
    }

    private MsgNode(MsgNode orig, CopyState copyState) {
        super(orig, copyState);
        if (orig.genderExprs != null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ExprRootNode node : orig.genderExprs) {
                builder.add((Object)node.copy(copyState));
            }
            this.genderExprs = builder.build();
        } else {
            this.genderExprs = null;
        }
        this.meaning = orig.meaning;
        this.desc = orig.desc;
        this.isHidden = orig.isHidden;
        if (orig.substUnitInfo != null) {
            final IdentityHashMap<SoyNode.MsgSubstUnitNode, SoyNode.MsgSubstUnitNode> oldToNew = new IdentityHashMap<SoyNode.MsgSubstUnitNode, SoyNode.MsgSubstUnitNode>();
            for (final SoyNode.MsgSubstUnitNode old : orig.substUnitInfo.nodeToVarNameMap.keySet()) {
                copyState.registerRefListener(old, new CopyState.Listener<SoyNode.MsgSubstUnitNode>(){

                    @Override
                    public void newVersion(SoyNode.MsgSubstUnitNode newObject) {
                        oldToNew.put(old, newObject);
                    }
                });
            }
            this.substUnitInfo = orig.substUnitInfo.copy(oldToNew);
        }
        this.genderExprsString = orig.genderExprsString;
        this.escapingMode = orig.escapingMode;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_NODE;
    }

    @Nullable
    public List<ExprRootNode> getAndRemoveGenderExprs() {
        ImmutableList<ExprRootNode> genderExprs = this.genderExprs;
        this.genderExprs = null;
        return genderExprs;
    }

    public void calculateSubstitutionInfo(ErrorReporter reporter) {
        if (this.substUnitInfo != null) {
            throw new IllegalStateException("calculateSubstitutionInfo has already been called.");
        }
        this.substUnitInfo = MsgNode.genSubstUnitInfo(this, reporter);
    }

    private SubstUnitInfo getSubstUnitInfo() {
        if (this.substUnitInfo == null) {
            throw new IllegalStateException("calculateSubstitutionInfo hasn't been called yet.");
        }
        return this.substUnitInfo;
    }

    public EscapingMode getEscapingMode() {
        return this.escapingMode;
    }

    public void setEscapingMode(EscapingMode escapingMode) {
        this.escapingMode = escapingMode;
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        if (this.genderExprs != null) {
            return ImmutableList.copyOf(this.genderExprs);
        }
        return ImmutableList.of();
    }

    @Nullable
    public String getMeaning() {
        return this.meaning;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public String getContentType() {
        return DEFAULT_CONTENT_TYPE;
    }

    public boolean isPlrselMsg() {
        return this.isSelectMsg() || this.isPluralMsg();
    }

    public boolean isSelectMsg() {
        Preconditions.checkState((this.numChildren() > 0 ? 1 : 0) != 0);
        return this.numChildren() == 1 && this.getChild(0) instanceof MsgSelectNode;
    }

    public boolean isPluralMsg() {
        Preconditions.checkState((this.numChildren() > 0 ? 1 : 0) != 0);
        return this.numChildren() == 1 && this.getChild(0) instanceof MsgPluralNode;
    }

    public boolean isRawTextMsg() {
        Preconditions.checkState((this.numChildren() > 0 ? 1 : 0) != 0);
        return this.numChildren() == 1 && this.getChild(0) instanceof RawTextNode;
    }

    public void ensureSubstUnitInfoHasNotBeenAccessed() {
        if (this.substUnitInfo != null) {
            throw new IllegalStateException("Substitution info has already been accessed.");
        }
    }

    public MsgPlaceholderNode getRepPlaceholderNode(String placeholderName) {
        return (MsgPlaceholderNode)this.getSubstUnitInfo().varNameToRepNodeMap.get((Object)placeholderName);
    }

    public PlaceholderInfo getPlaceholder(MsgPlaceholderNode placeholderNode) {
        return (PlaceholderInfo)this.getSubstUnitInfo().nodeToVarNameMap.get((Object)placeholderNode);
    }

    public MsgPluralNode getRepPluralNode(String pluralVarName) {
        return (MsgPluralNode)this.getSubstUnitInfo().varNameToRepNodeMap.get((Object)pluralVarName);
    }

    public String getPluralVarName(MsgPluralNode pluralNode) {
        return ((PlaceholderInfo)this.getSubstUnitInfo().nodeToVarNameMap.get((Object)pluralNode)).name();
    }

    public MsgSelectNode getRepSelectNode(String selectVarName) {
        return (MsgSelectNode)this.getSubstUnitInfo().varNameToRepNodeMap.get((Object)selectVarName);
    }

    public String getSelectVarName(MsgSelectNode selectNode) {
        return ((PlaceholderInfo)this.getSubstUnitInfo().nodeToVarNameMap.get((Object)selectNode)).name();
    }

    public ImmutableMap<String, SoyNode.MsgSubstUnitNode> getVarNameToRepNodeMap() {
        return this.getSubstUnitInfo().varNameToRepNodeMap;
    }

    @Override
    public String getCommandText() {
        StringBuilder commandText = new StringBuilder();
        if (this.meaning != null) {
            commandText.append(" meaning=\"").append(this.meaning).append('\"');
        }
        if (this.desc != null) {
            commandText.append(" desc=\"").append(this.desc).append('\"');
        }
        if (this.isHidden) {
            commandText.append(" hidden=\"").append(this.isHidden).append('\"');
        }
        if (this.genderExprsString != null) {
            commandText.append(" genders=\"").append(this.genderExprsString).append('\"');
        }
        return commandText.toString().trim();
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTagString());
        this.appendSourceStringForChildren(sb);
        return sb.toString();
    }

    @Override
    public MsgNode copy(CopyState copyState) {
        return new MsgNode(this, copyState);
    }

    private static SubstUnitInfo genSubstUnitInfo(MsgNode msgNode, ErrorReporter errorReporter) {
        return MsgNode.genFinalSubstUnitInfoMapsHelper(RepresentativeNodes.createFromNode(msgNode, errorReporter));
    }

    private static SubstUnitInfo genFinalSubstUnitInfoMapsHelper(RepresentativeNodes representativeNodes) {
        LinkedHashMap<String, SoyNode.MsgSubstUnitNode> substUnitVarNameToRepNodeMap = new LinkedHashMap<String, SoyNode.MsgSubstUnitNode>();
        for (String baseName : representativeNodes.baseNameToRepNodesMap().keys()) {
            ImmutableList immutableList = representativeNodes.baseNameToRepNodesMap().get((Object)baseName);
            if (immutableList.size() == 1) {
                substUnitVarNameToRepNodeMap.put(baseName, (SoyNode.MsgSubstUnitNode)immutableList.get(0));
                continue;
            }
            int nextSuffix = 1;
            for (SoyNode.MsgSubstUnitNode repNode : immutableList) {
                String newName;
                do {
                    newName = baseName + "_" + nextSuffix;
                    ++nextSuffix;
                } while (representativeNodes.baseNameToRepNodesMap().containsKey((Object)newName));
                substUnitVarNameToRepNodeMap.put(newName, repNode);
            }
        }
        LinkedHashMap<SoyNode.MsgSubstUnitNode, PlaceholderInfo> substUnitNodeToVarNameMap = new LinkedHashMap<SoyNode.MsgSubstUnitNode, PlaceholderInfo>();
        for (Map.Entry entry : substUnitVarNameToRepNodeMap.entrySet()) {
            substUnitNodeToVarNameMap.put((SoyNode.MsgSubstUnitNode)entry.getValue(), PlaceholderInfo.create((String)entry.getKey(), (String)representativeNodes.repNodeToPhExample().get(entry.getValue())));
        }
        for (Map.Entry entry : representativeNodes.nonRepNodeToRepNodeMap().entrySet()) {
            SoyNode.MsgSubstUnitNode nonRepNode = (SoyNode.MsgSubstUnitNode)entry.getKey();
            SoyNode.MsgSubstUnitNode repNode = (SoyNode.MsgSubstUnitNode)entry.getValue();
            substUnitNodeToVarNameMap.put(nonRepNode, (PlaceholderInfo)substUnitNodeToVarNameMap.get(repNode));
        }
        return new SubstUnitInfo((Map<String, SoyNode.MsgSubstUnitNode>)ImmutableMap.copyOf(substUnitVarNameToRepNodeMap), (Map<SoyNode.MsgSubstUnitNode, PlaceholderInfo>)ImmutableMap.copyOf(substUnitNodeToVarNameMap));
    }

    private static String getPhExample(SoyNode.MsgSubstUnitNode node) {
        if (node instanceof MsgPlaceholderNode) {
            return ((MsgPlaceholderNode)node).getPhExample();
        }
        return null;
    }

    @AutoValue
    static abstract class RepresentativeNodes {
        RepresentativeNodes() {
        }

        static RepresentativeNodes createFromNode(MsgNode msgNode, ErrorReporter reporter) {
            LinkedListMultimap baseNameToRepNodesMap = LinkedListMultimap.create();
            HashMap<SoyNode.MsgSubstUnitNode, SoyNode.MsgSubstUnitNode> nonRepNodeToRepNodeMap = new HashMap<SoyNode.MsgSubstUnitNode, SoyNode.MsgSubstUnitNode>();
            HashMap<SoyNode.MsgSubstUnitNode, String> repNodeToExample = new HashMap<SoyNode.MsgSubstUnitNode, String>();
            ArrayDeque<SoyNode> traversalQueue = new ArrayDeque<SoyNode>();
            for (SoyNode child : msgNode.getChildren()) {
                RepresentativeNodes.maybeEnqueue(traversalQueue, child);
            }
            while (!traversalQueue.isEmpty()) {
                SoyNode node = (SoyNode)traversalQueue.remove();
                if (node instanceof MsgSelectNode) {
                    RepresentativeNodes.maybeEnqueueMsgNode(traversalQueue, (MsgSelectNode)node);
                } else if (node instanceof MsgPluralNode) {
                    RepresentativeNodes.maybeEnqueueMsgNode(traversalQueue, (MsgPluralNode)node);
                } else if (node instanceof VeLogNode) {
                    VeLogNode velogNode = (VeLogNode)node;
                    for (SoyNode grandchild : velogNode.getChildren()) {
                        RepresentativeNodes.maybeEnqueue(traversalQueue, grandchild);
                    }
                }
                if (!(node instanceof SoyNode.MsgSubstUnitNode)) continue;
                SoyNode.MsgSubstUnitNode substUnit = (SoyNode.MsgSubstUnitNode)node;
                String baseName = substUnit.getBaseVarName();
                if (!baseNameToRepNodesMap.containsKey((Object)baseName)) {
                    baseNameToRepNodesMap.put((Object)baseName, (Object)substUnit);
                    String example = MsgNode.getPhExample(substUnit);
                    if (example == null) continue;
                    repNodeToExample.put(substUnit, example);
                    continue;
                }
                boolean isNew = true;
                for (SoyNode.MsgSubstUnitNode other : baseNameToRepNodesMap.get((Object)baseName)) {
                    if (!substUnit.shouldUseSameVarNameAs(other)) continue;
                    nonRepNodeToRepNodeMap.put(substUnit, other);
                    String example = RepresentativeNodes.checkCompatibleExamples(substUnit, other, reporter);
                    if (example != null) {
                        repNodeToExample.put(other, example);
                    }
                    isNew = false;
                    break;
                }
                if (!isNew) continue;
                baseNameToRepNodesMap.put((Object)baseName, (Object)substUnit);
                String example = MsgNode.getPhExample(substUnit);
                if (example == null) continue;
                repNodeToExample.put(substUnit, example);
            }
            return new AutoValue_MsgNode_RepresentativeNodes((ImmutableListMultimap<String, SoyNode.MsgSubstUnitNode>)ImmutableListMultimap.copyOf((Multimap)baseNameToRepNodesMap), (ImmutableMap<SoyNode.MsgSubstUnitNode, SoyNode.MsgSubstUnitNode>)ImmutableMap.copyOf(nonRepNodeToRepNodeMap), (ImmutableMap<SoyNode.MsgSubstUnitNode, String>)ImmutableMap.copyOf((Map)Maps.filterValues(repNodeToExample, Objects::nonNull)));
        }

        private static void maybeEnqueue(Deque<SoyNode> traversalQueue, SoyNode child) {
            if (child instanceof SoyNode.MsgSubstUnitNode || child instanceof VeLogNode) {
                traversalQueue.add(child);
            }
        }

        private static void maybeEnqueueMsgNode(Deque<SoyNode> traversalQueue, SoyNode.ParentSoyNode<CaseOrDefaultNode> node) {
            for (CaseOrDefaultNode child : node.getChildren()) {
                for (SoyNode grandchild : child.getChildren()) {
                    RepresentativeNodes.maybeEnqueue(traversalQueue, grandchild);
                }
            }
        }

        private static String checkCompatibleExamples(SoyNode.MsgSubstUnitNode left, SoyNode.MsgSubstUnitNode right, ErrorReporter reporter) {
            String leftExample = MsgNode.getPhExample(left);
            String rightExample = MsgNode.getPhExample(right);
            if (leftExample == null) {
                return rightExample;
            }
            if (rightExample == null) {
                return leftExample;
            }
            if (leftExample.equals(rightExample)) {
                return leftExample;
            }
            reporter.report(left.getSourceLocation(), INCOMPATIBLE_PLACEHOLDER_EXAMPLES, new Object[0]);
            return null;
        }

        abstract ImmutableListMultimap<String, SoyNode.MsgSubstUnitNode> baseNameToRepNodesMap();

        abstract ImmutableMap<SoyNode.MsgSubstUnitNode, SoyNode.MsgSubstUnitNode> nonRepNodeToRepNodeMap();

        abstract ImmutableMap<SoyNode.MsgSubstUnitNode, String> repNodeToPhExample();
    }

    private static final class SubstUnitInfo {
        public final ImmutableMap<String, SoyNode.MsgSubstUnitNode> varNameToRepNodeMap;
        public final ImmutableMap<SoyNode.MsgSubstUnitNode, PlaceholderInfo> nodeToVarNameMap;

        public SubstUnitInfo(Map<String, SoyNode.MsgSubstUnitNode> varNameToRepNodeMap, Map<SoyNode.MsgSubstUnitNode, PlaceholderInfo> nodeToVarNameMap) {
            this.varNameToRepNodeMap = ImmutableMap.copyOf(varNameToRepNodeMap);
            this.nodeToVarNameMap = ImmutableMap.copyOf(nodeToVarNameMap);
        }

        public SubstUnitInfo copy(Map<SoyNode.MsgSubstUnitNode, SoyNode.MsgSubstUnitNode> oldToNew) {
            Function oldToNewFunction = Functions.forMap(oldToNew);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : this.nodeToVarNameMap.entrySet()) {
                builder.put((Object)oldToNew.get(entry.getKey()), (Object)((PlaceholderInfo)entry.getValue()));
            }
            return new SubstUnitInfo(Maps.transformValues(this.varNameToRepNodeMap, (Function)oldToNewFunction), (Map<SoyNode.MsgSubstUnitNode, PlaceholderInfo>)builder.build());
        }
    }

    @AutoValue
    public static abstract class PlaceholderInfo {
        static PlaceholderInfo create(String name, @Nullable String example) {
            return new AutoValue_MsgNode_PlaceholderInfo(name, example);
        }

        public abstract String name();

        @Nullable
        public abstract String example();
    }
}

