/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basetree.MixinParentNode;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.types.SanitizedType;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

public final class LetContentNode
extends LetNode
implements SoyNode.RenderUnitNode {
    private final MixinParentNode<SoyNode.StandaloneNode> parentMixin;
    private final SanitizedContentKind contentKind;

    public static LetContentNode forVariable(int id, SourceLocation sourceLocation, String varName, SourceLocation varNameLocation, SanitizedContentKind contentKind) {
        LetContentNode node = new LetContentNode(id, sourceLocation, varName, varNameLocation, contentKind);
        node.getVar().setType(SanitizedType.getTypeForContentKind(contentKind));
        return node;
    }

    public LetContentNode(int id, SourceLocation location, String varName, SourceLocation varNameLocation, CommandTagAttribute kindAttr, ErrorReporter errorReporter) {
        super(id, location, varName, varNameLocation);
        this.parentMixin = new MixinParentNode<SoyNode.StandaloneNode>(this);
        Optional<Object> parsedKind = Optional.empty();
        if (!kindAttr.hasName("kind")) {
            errorReporter.report(kindAttr.getName().location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY_SINGLE, kindAttr.getName().identifier(), "let", "kind");
        } else {
            parsedKind = kindAttr.valueAsContentKind(errorReporter);
        }
        this.contentKind = parsedKind.orElse((Object)SanitizedContentKind.HTML);
    }

    private LetContentNode(int id, SourceLocation location, String varName, SourceLocation varNameLocation, @Nullable SanitizedContentKind contentKind) {
        super(id, location, varName, varNameLocation);
        this.parentMixin = new MixinParentNode<SoyNode.StandaloneNode>(this);
        this.contentKind = contentKind;
    }

    private LetContentNode(LetContentNode orig, CopyState copyState) {
        super(orig, copyState);
        this.parentMixin = new MixinParentNode<SoyNode.StandaloneNode>(orig.parentMixin, this, copyState);
        this.contentKind = orig.contentKind;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.LET_CONTENT_NODE;
    }

    @Override
    public SanitizedContentKind getContentKind() {
        return this.contentKind;
    }

    @Override
    public String getCommandText() {
        return this.contentKind == null ? "$" + this.getVarName() : "$" + this.getVarName() + " kind=\"" + this.contentKind.asAttributeValue() + "\"";
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTagString());
        this.appendSourceStringForChildren(sb);
        sb.append("{/").append(this.getCommandName()).append("}");
        return sb.toString();
    }

    @Override
    public LetContentNode copy(CopyState copyState) {
        return new LetContentNode(this, copyState);
    }

    @Override
    public int numChildren() {
        return this.parentMixin.numChildren();
    }

    @Override
    public SoyNode.StandaloneNode getChild(int index) {
        return this.parentMixin.getChild(index);
    }

    @Override
    public int getChildIndex(Node child) {
        return this.parentMixin.getChildIndex(child);
    }

    @Override
    public List<SoyNode.StandaloneNode> getChildren() {
        return this.parentMixin.getChildren();
    }

    @Override
    public void addChild(SoyNode.StandaloneNode child) {
        this.parentMixin.addChild(child);
    }

    @Override
    public void addChild(int index, SoyNode.StandaloneNode child) {
        this.parentMixin.addChild(index, child);
    }

    @Override
    public void removeChild(int index) {
        this.parentMixin.removeChild(index);
    }

    @Override
    public void removeChild(SoyNode.StandaloneNode child) {
        this.parentMixin.removeChild(child);
    }

    @Override
    public void replaceChild(int index, SoyNode.StandaloneNode newChild) {
        this.parentMixin.replaceChild((SoyNode.StandaloneNode)index, newChild);
    }

    @Override
    public void replaceChild(SoyNode.StandaloneNode currChild, SoyNode.StandaloneNode newChild) {
        this.parentMixin.replaceChild(currChild, newChild);
    }

    @Override
    public void clearChildren() {
        this.parentMixin.clearChildren();
    }

    @Override
    public void addChildren(List<? extends SoyNode.StandaloneNode> children) {
        this.parentMixin.addChildren(children);
    }

    @Override
    public void addChildren(int index, List<? extends SoyNode.StandaloneNode> children) {
        this.parentMixin.addChildren(index, children);
    }

    @Override
    public void appendSourceStringForChildren(StringBuilder sb) {
        this.parentMixin.appendSourceStringForChildren(sb);
    }
}

