/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.SoyNode;

public final class HtmlOpenTagNode
extends HtmlTagNode {
    private final boolean selfClosing;
    private boolean isElementRoot;

    public HtmlOpenTagNode(int id, SoyNode.StandaloneNode node, SourceLocation sourceLocation, boolean selfClosing, HtmlTagNode.TagExistence tagExistence) {
        super(id, node, sourceLocation, tagExistence);
        this.selfClosing = selfClosing;
    }

    private HtmlOpenTagNode(HtmlOpenTagNode orig, CopyState copyState) {
        super(orig, copyState);
        this.selfClosing = orig.selfClosing;
        this.isElementRoot = orig.isElementRoot;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.HTML_OPEN_TAG_NODE;
    }

    public boolean isSelfClosing() {
        return this.selfClosing;
    }

    public boolean isElementRoot() {
        return this.isElementRoot;
    }

    public void setElementRoot() {
        this.isElementRoot = true;
    }

    public KeyNode getKeyNode() {
        for (SoyNode child : this.getChildren()) {
            if (!(child instanceof KeyNode)) continue;
            return (KeyNode)child;
        }
        return null;
    }

    @Override
    public HtmlOpenTagNode copy(CopyState copyState) {
        return new HtmlOpenTagNode(this, copyState);
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        for (int i = 0; i < this.numChildren(); ++i) {
            SoyNode.StandaloneNode child = (SoyNode.StandaloneNode)this.getChild(i);
            if (i != 0) {
                sb.append(' ');
            }
            sb.append(child.toSourceString());
        }
        sb.append(this.selfClosing ? "/>" : ">");
        return sb.toString();
    }
}

